/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterListener;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.StringListParameterImpl;
import com.biglybt.pifimpl.local.ui.config.StringParameterImpl;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.util.ArrayList;
import java.util.List;

public class ConfigSectionSharing
extends ConfigSectionImpl {
    public static final String SECTION_ID = "sharing";

    public ConfigSectionSharing() {
        super(SECTION_ID, "root");
    }

    @Override
    public void build() {
        String[] protocols = new String[]{"HTTP", "HTTPS", "UDP", "DHT"};
        String[] descs = new String[]{"HTTP", "HTTPS (SSL)", "UDP", "Decentralised"};
        StringListParameterImpl protocol = new StringListParameterImpl("Sharing Protocol", "ConfigView.section.sharing.protocol", protocols, descs);
        this.add(protocol, new List[0]);
        BooleanParameterImpl private_torrent = new BooleanParameterImpl("Sharing Torrent Private", "ConfigView.section.sharing.privatetorrent");
        this.add(private_torrent, new List[0]);
        BooleanParameterImpl permit_dht_backup = new BooleanParameterImpl("Sharing Permit DHT", "ConfigView.section.sharing.permitdht");
        this.add(permit_dht_backup, new List[0]);
        ParameterListener protocol_cl = p -> {
            boolean not_dht = !protocol.getValue().equals("DHT");
            private_torrent.setEnabled(not_dht);
            permit_dht_backup.setEnabled(not_dht && !private_torrent.getValue());
            if (private_torrent.getValue()) {
                permit_dht_backup.setValue(false);
            }
        };
        protocol_cl.parameterChanged(protocol);
        protocol.addListener(protocol_cl);
        private_torrent.addListener(protocol_cl);
        String[] tt_versions = new String[]{String.valueOf(1), String.valueOf(2), String.valueOf(3)};
        String[] tt_descs = new String[]{MessageText.getString("torrent.version.type.1"), MessageText.getString("torrent.version.type.2"), MessageText.getString("torrent.version.type.3")};
        StringListParameterImpl torrent_version = new StringListParameterImpl("Sharing Torrent Version", "label.torrent.version", tt_versions, tt_descs);
        this.add(torrent_version, new List[0]);
        this.add(new BooleanParameterImpl("Sharing Add Hashes", "wizard.createtorrent.extrahashes"), new List[0]);
        this.add(new BooleanParameterImpl("Sharing Disable RCM", "ConfigView.section.sharing.disable_rcm"), new List[0]);
        BooleanParameterImpl rescan_enable = new BooleanParameterImpl("Sharing Rescan Enable", "ConfigView.section.sharing.rescanenable");
        this.add(rescan_enable, new List[0]);
        IntParameterImpl rescan_period = new IntParameterImpl("Sharing Rescan Period", "ConfigView.section.sharing.rescanperiod");
        this.add(rescan_period, new List[0]);
        rescan_period.setMinValue(1);
        rescan_period.setIndent(1, true);
        rescan_enable.addEnabledOnSelection((Parameter)rescan_period);
        StringParameterImpl torrent_comment = new StringParameterImpl("Sharing Torrent Comment", "ConfigView.section.sharing.torrentcomment");
        this.add(torrent_comment, new List[0]);
        torrent_comment.setMultiLine(2);
        this.add(new BooleanParameterImpl("Sharing Is Persistent", "ConfigView.section.sharing.persistentshares"), new List[0]);
        ArrayList listNetworks = new ArrayList();
        BooleanParameterImpl network_global = new BooleanParameterImpl("Sharing Network Selection Global", "label.use.global.defaults");
        this.add(network_global, listNetworks);
        ArrayList<BooleanParameterImpl> net_params = new ArrayList<BooleanParameterImpl>();
        String[] stringArray = AENetworkClassifier.AT_NETWORKS;
        int n = AENetworkClassifier.AT_NETWORKS.length;
        int n2 = 0;
        while (n2 < n) {
            String net = stringArray[n2];
            String config_name = "Sharing Network Selection Default." + net;
            String msg_text = "ConfigView.section.connection.networks." + net;
            BooleanParameterImpl network = new BooleanParameterImpl(config_name, msg_text);
            this.add(network, listNetworks);
            network.setIndent(1, false);
            net_params.add(network);
            ++n2;
        }
        network_global.addDisabledOnSelection(net_params.toArray(new Parameter[0]));
        this.add("sharing.pgNetworks", new ParameterGroupImpl("ConfigView.section.connection.group.networks", listNetworks), new List[0]);
    }
}

