/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.util.AEJavaManagement;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.platform.PlatformManagerException;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterListener;
import com.biglybt.pifimpl.local.ui.config.ActionParameterImpl;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.DateTimeParameterImpl;
import com.biglybt.pifimpl.local.ui.config.FileParameterImpl;
import com.biglybt.pifimpl.local.ui.config.HyperlinkParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.StringListParameterImpl;
import com.biglybt.pifimpl.local.ui.config.StringParameterImpl;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerCapabilities;
import com.biglybt.platform.PlatformManagerFactory;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UIFunctionsUserPrompter;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ConfigSectionStartShutdown
extends ConfigSectionImpl {
    public static final String SECTION_ID = "startstop";

    public ConfigSectionStartShutdown() {
        super(SECTION_ID, "root");
    }

    @Override
    public void build() {
        PlatformManager platform = PlatformManagerFactory.getPlatformManager();
        boolean can_ral = platform.hasCapability(PlatformManagerCapabilities.RunAtLogin);
        if (can_ral) {
            ArrayList listStartup = new ArrayList();
            BooleanParameterImpl start_on_login = new BooleanParameterImpl("Start On Login", "ConfigView.label.start.onlogin");
            this.add(start_on_login, listStartup);
            try {
                start_on_login.setValue(platform.getRunAtLogin());
                start_on_login.addListener(p -> {
                    try {
                        platform.setRunAtLogin(((BooleanParameter)p).getValue());
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                });
            }
            catch (Throwable e) {
                start_on_login.setEnabled(false);
                Debug.out(e);
            }
            BooleanParameterImpl start_in_lr_mode = new BooleanParameterImpl("Start In Low Resource Mode", "ConfigView.label.start.inlrm");
            this.add(start_in_lr_mode, 1, listStartup);
            BooleanParameterImpl lr_ui = new BooleanParameterImpl("LRMS UI", "lrms.deactivate.ui");
            this.add(lr_ui, 1, listStartup);
            lr_ui.setIndent(1, false);
            BooleanParameterImpl lr_udp_net = new BooleanParameterImpl("LRMS UDP Peers", "lrms.udp.peers");
            this.add(lr_udp_net, 1, listStartup);
            lr_udp_net.setIndent(1, false);
            BooleanParameterImpl lr_dht_sleep = new BooleanParameterImpl("LRMS DHT Sleep", "lrms.dht.sleep");
            this.add(lr_dht_sleep, 1, listStartup);
            lr_dht_sleep.setIndent(1, false);
            lr_ui.setEnabled(false);
            start_in_lr_mode.addEnabledOnSelection(lr_udp_net, lr_dht_sleep);
            this.add("pgStartup", new ParameterGroupImpl("ConfigView.label.start", listStartup), new List[0]);
        }
        if (platform.hasCapability(PlatformManagerCapabilities.PreventComputerSleep)) {
            ArrayList listSleep = new ArrayList();
            this.add(new LabelParameterImpl("ConfigView.label.sleep.info"), listSleep);
            this.add(new BooleanParameterImpl("Prevent Sleep Downloading", "ConfigView.label.sleep.download"), listSleep);
            this.add(new BooleanParameterImpl("Prevent Sleep FP Seeding", "ConfigView.label.sleep.fpseed"), listSleep);
            TagManager tm = TagManagerFactory.getTagManager();
            if (tm.isEnabled()) {
                List<Tag> tag_list = tm.getTagType(3).getTags();
                String[] tags = new String[tag_list.size() + 1];
                tags[0] = "";
                int i = 0;
                while (i < tag_list.size()) {
                    tags[i + 1] = tag_list.get(i).getTagName(true);
                    ++i;
                }
                this.add(new StringListParameterImpl("Prevent Sleep Tag", "ConfigView.label.sleep.tag", tags, tags), listSleep);
            }
            this.add("pgSleep", new ParameterGroupImpl("ConfigView.label.sleep", listSleep), new List[0]);
        }
        ArrayList listPR = new ArrayList();
        this.add(new BooleanParameterImpl("Pause Downloads On Exit", "ConfigView.label.pause.downloads.on.exit"), 1, listPR);
        this.add(new BooleanParameterImpl("Resume Downloads On Start", "ConfigView.label.resume.downloads.on.start"), 1, listPR);
        this.add("pgPR", new ParameterGroupImpl("ConfigView.label.pauseresume", listPR), new List[0]);
        ArrayList<Parameter> listStop = new ArrayList<Parameter>();
        this.addDoneDownloadingOption(listStop, true);
        this.addDoneSeedingOption(listStop, true);
        BooleanParameterImpl resetOnTrigger = new BooleanParameterImpl("Stop Triggers Auto Reset", "");
        this.add(resetOnTrigger, 1, listStop);
        resetOnTrigger.setLabelText(MessageText.getString("ConfigView.label.stop.autoreset", new String[]{MessageText.getString("ConfigView.label.stop.Nothing")}));
        DateTimeParameterImpl stopTime = new DateTimeParameterImpl("Stop Explicit Date Time", "ConfigView.label.shutdown.explicit.time");
        this.add(stopTime, 1, listStop);
        this.addTimedCloseOption(stopTime, listStop);
        BooleanParameterImpl enablePrompt = new BooleanParameterImpl("Prompt To Abort Shutdown", "ConfigView.label.prompt.abort");
        enablePrompt.setAllowedUiTypes("swt");
        this.add(enablePrompt, 1, listStop);
        IntParameterImpl paramTerminateAfter = new IntParameterImpl("Force Terminate After Mins", "ConfigView.label.stop.term.after", 2, 100000);
        paramTerminateAfter.setSuffixLabelKey("ConfigView.text.minutes");
        this.add(paramTerminateAfter, 1, listStop);
        this.add("pgStop", new ParameterGroupImpl("ConfigView.label.stop", listStop), new List[0]);
        IntParameterImpl paramRestartWhenIdle = new IntParameterImpl("Auto Restart When Idle", "ConfigView.label.restart.auto", 0, 100000);
        paramRestartWhenIdle.setSuffixLabelKey("ConfigView.text.minutes");
        this.add(paramRestartWhenIdle, new List[0]);
        paramRestartWhenIdle.setMinimumRequiredUserMode(1);
        BooleanParameterImpl paramRestartWhenIdlePrompt = new BooleanParameterImpl("Auto Restart When Idle Prompt", "label.prompt.when.restart");
        paramRestartWhenIdlePrompt.setMinimumRequiredUserMode(1);
        paramRestartWhenIdlePrompt.setAllowedUiTypes("swt");
        paramRestartWhenIdlePrompt.setIndent(1, true);
        this.add(paramRestartWhenIdlePrompt, new List[0]);
        paramRestartWhenIdle.addAndFireListener(n -> paramRestartWhenIdlePrompt.setEnabled(paramRestartWhenIdle.getValue() > 0));
        this.add("pgRestart", new ParameterGroupImpl("label.restart", paramRestartWhenIdle, paramRestartWhenIdlePrompt), new List[0]);
        ArrayList<Parameter> listJVM = new ArrayList<Parameter>();
        if (platform.hasCapability(PlatformManagerCapabilities.AccessExplicitVMOptions)) {
            this.add(new HyperlinkParameterImpl("ConfigView.label.please.visit.here", "https://wiki.biglybt.com/w/JAVA_VM_MEMORY_USAGE"), 1, listJVM);
            this.add(new LabelParameterImpl("jvm.info"), 1, listJVM);
            try {
                File option_file = platform.getVMOptionFile();
                this.buildOptions(platform, listJVM);
                ActionParameterImpl show_folder_button = new ActionParameterImpl("jvm.show.file", "!" + option_file.getAbsolutePath() + "!");
                this.add(show_folder_button, 1, listJVM);
                show_folder_button.setAllowedUiTypes("swt");
                show_folder_button.setStyle(2);
                show_folder_button.addListener(param -> UIFunctionsManager.getUIFunctions().showInExplorer(option_file));
                ActionParameterImpl reset_button = new ActionParameterImpl("jvm.reset", "Button.reset");
                this.add(reset_button, 1, listJVM);
                reset_button.addListener(param -> {
                    try {
                        platform.setExplicitVMOptions(new String[0]);
                        this.requestRebuild();
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                });
            }
            catch (Throwable e) {
                Debug.out(e);
                LabelParameterImpl paramErr = new LabelParameterImpl("");
                this.add(paramErr, 1, listJVM);
                paramErr.setLabelText(MessageText.getString("jvm.error", new String[]{Debug.getNestedExceptionMessage(e)}));
            }
        }
        ActionParameterImpl history_button = new ActionParameterImpl("jvm.mem.history", "label.view");
        history_button.setAllowedUiTypes("swt");
        this.add(history_button, 1, listJVM);
        history_button.addListener(param -> {
            try {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif == null) {
                    Debug.out("No UI Functions!");
                } else {
                    List<String> lines = AEJavaManagement.getMemoryHistory();
                    String content = "";
                    for (String line : lines) {
                        content = String.valueOf(content) + line + "\n";
                    }
                    uif.showText(MessageText.getString("GeneralView.section.info"), content);
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        });
        this.add("pgJVM", new ParameterGroupImpl("ConfigView.label.jvm", listJVM), new List[0]);
    }

    private void buildOptions(PlatformManager platform, List<Parameter> list) throws PlatformManagerException {
        String[] options = platform.getExplicitVMOptions();
        long max_mem = AEJavaManagement.getJVMLongOption(options, "-Xmx");
        int MIN_MAX_JVM = 0x2000000;
        StringParameterImpl max_vm = new StringParameterImpl("jvm.max.mem", "");
        this.add(max_vm, 1, list);
        max_vm.setWidthInCharacters(10);
        max_vm.setLabelText(MessageText.getString("jvm.max.mem", new String[]{ConfigSectionStartShutdown.encodeDisplayLong(0x2000000L)}));
        long max_heap_mb = AEJavaManagement.getMaxHeapMB();
        if (max_heap_mb > 0L) {
            max_vm.setSuffixLabelText(MessageText.getString("jvm.max.mem.current", new String[]{DisplayFormatters.formatByteCountToKiBEtc(max_heap_mb * 1024L * 1024L, true)}));
        }
        max_vm.setValue(max_mem == -1L ? "" : ConfigSectionStartShutdown.encodeDisplayLong(max_mem));
        max_vm.addListener(param -> {
            String val = max_vm.getValue();
            try {
                long cur_max_mem = ConfigSectionStartShutdown.decodeDisplayLong(val);
                String[] cur_options = platform.getExplicitVMOptions();
                if (cur_max_mem < 0x2000000L) {
                    if (cur_max_mem > 0L) throw new Exception("Min=" + ConfigSectionStartShutdown.encodeDisplayLong(0x2000000L));
                    cur_options = AEJavaManagement.removeJVMOption(cur_options, "-Xmx");
                } else {
                    long min_mem = AEJavaManagement.getJVMLongOption(cur_options = AEJavaManagement.setJVMLongOption(cur_options, "-Xmx", cur_max_mem), "-Xms");
                    if (min_mem > cur_max_mem) {
                        cur_options = AEJavaManagement.setJVMLongOption(cur_options, "-Xms", cur_max_mem);
                    }
                }
                platform.setExplicitVMOptions(cur_options);
                this.requestRebuild();
                return;
            }
            catch (Throwable e) {
                UIFunctions uif;
                String param_name = MessageText.getString("jvm.max.mem");
                int pos = param_name.indexOf(91);
                if (pos != -1) {
                    param_name = param_name.substring(0, pos).trim();
                }
                if ((uif = UIFunctionsManager.getUIFunctions()) == null) {
                    Debug.out(param_name, e);
                    return;
                }
                UIFunctionsUserPrompter userPrompter = uif.getUserPrompter(MessageText.getString("ConfigView.section.invalid.value.title"), MessageText.getString("ConfigView.section.invalid.value", new String[]{val, param_name, Debug.getNestedExceptionMessage(e)}), new String[]{MessageText.getString("Button.ok")}, 0);
                userPrompter.setIconResource("error");
                userPrompter.open(null);
            }
        });
        int MIN_MIN_JVM = 0x800000;
        long min_mem = AEJavaManagement.getJVMLongOption(options, "-Xms");
        StringParameterImpl min_vm = new StringParameterImpl("jvm.min.mem", "");
        this.add(min_vm, 1, list);
        min_vm.setWidthInCharacters(10);
        min_vm.setLabelText(MessageText.getString("jvm.min.mem", new String[]{ConfigSectionStartShutdown.encodeDisplayLong(0x800000L)}));
        min_vm.setValue(min_mem == -1L ? "" : ConfigSectionStartShutdown.encodeDisplayLong(min_mem));
        min_vm.addListener(param -> {
            String val = min_vm.getValue();
            try {
                long cur_min_mem = ConfigSectionStartShutdown.decodeDisplayLong(val);
                String[] cur_options = platform.getExplicitVMOptions();
                if (cur_min_mem < 0x800000L) {
                    if (cur_min_mem > 0L) throw new Exception("Min=" + ConfigSectionStartShutdown.encodeDisplayLong(0x800000L));
                    cur_options = AEJavaManagement.removeJVMOption(cur_options, "-Xms");
                } else {
                    long max_mem = AEJavaManagement.getJVMLongOption(cur_options = AEJavaManagement.setJVMLongOption(cur_options, "-Xms", cur_min_mem), "-Xmx");
                    if (max_mem == -1L || max_mem < cur_min_mem) {
                        cur_options = AEJavaManagement.setJVMLongOption(cur_options, "-Xmx", cur_min_mem);
                    }
                }
                platform.setExplicitVMOptions(cur_options);
                this.requestRebuild();
                return;
            }
            catch (Throwable e) {
                UIFunctions uif;
                String param_name = MessageText.getString("jvm.min.mem");
                int pos = param_name.indexOf(91);
                if (pos != -1) {
                    param_name = param_name.substring(0, pos).trim();
                }
                if ((uif = UIFunctionsManager.getUIFunctions()) == null) {
                    Debug.out(param_name, e);
                    return;
                }
                UIFunctionsUserPrompter userPrompter = uif.getUserPrompter(MessageText.getString("ConfigView.section.invalid.value.title"), MessageText.getString("ConfigView.section.invalid.value", new String[]{val, param_name, Debug.getNestedExceptionMessage(e)}), new String[]{MessageText.getString("Button.ok")}, 0);
                userPrompter.setIconResource("error");
                userPrompter.open(null);
            }
        });
        int MIN_DIRECT_JVM = 0x2000000;
        String OPTION_KEY = "-XX:MaxDirectMemorySize=";
        long max_direct = AEJavaManagement.getJVMLongOption(options, "-XX:MaxDirectMemorySize=");
        StringParameterImpl max_direct_vm = new StringParameterImpl("jvm.max.direct.mem", "");
        this.add(max_direct_vm, 1, list);
        max_direct_vm.setWidthInCharacters(10);
        max_direct_vm.setLabelText(MessageText.getString("jvm.max.direct.mem", new String[]{ConfigSectionStartShutdown.encodeDisplayLong(0x2000000L)}));
        max_direct_vm.setSuffixLabelKey("jvm.max.direct.mem.info");
        max_direct_vm.setValue(max_direct == -1L ? "" : ConfigSectionStartShutdown.encodeDisplayLong(max_direct));
        max_direct_vm.addListener(param -> {
            String val = max_direct_vm.getValue();
            try {
                long cur_max_direct = ConfigSectionStartShutdown.decodeDisplayLong(val);
                String[] cur_options = platform.getExplicitVMOptions();
                if (cur_max_direct < 0x2000000L) {
                    if (cur_max_direct > 0L) throw new Exception("Min=" + ConfigSectionStartShutdown.encodeDisplayLong(0x2000000L));
                    cur_options = AEJavaManagement.removeJVMOption(cur_options, "-XX:MaxDirectMemorySize=");
                } else {
                    cur_options = AEJavaManagement.setJVMLongOption(cur_options, "-XX:MaxDirectMemorySize=", cur_max_direct);
                }
                platform.setExplicitVMOptions(cur_options);
                this.requestRebuild();
                return;
            }
            catch (Throwable e) {
                UIFunctions uif;
                String param_name = MessageText.getString("jvm.max.direct.mem");
                int pos = param_name.indexOf(91);
                if (pos != -1) {
                    param_name = param_name.substring(0, pos).trim();
                }
                if ((uif = UIFunctionsManager.getUIFunctions()) == null) {
                    Debug.out(param_name, e);
                    return;
                }
                UIFunctionsUserPrompter userPrompter = uif.getUserPrompter(MessageText.getString("ConfigView.section.invalid.value.title"), MessageText.getString("ConfigView.section.invalid.value", new String[]{val, param_name, Debug.getNestedExceptionMessage(e)}), new String[]{MessageText.getString("Button.ok")}, 0);
                userPrompter.setIconResource("error");
                userPrompter.open(null);
            }
        });
        this.add(new LabelParameterImpl("jvm.options.summary"), 1, list);
        if (options.length == 0) {
            LabelParameterImpl paramSummaryValue = new LabelParameterImpl("label.none");
            this.add(paramSummaryValue, 1, list);
            paramSummaryValue.setIndent(1, false);
        } else {
            String[] stringArray = options;
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                LabelParameterImpl paramSummaryValue = new LabelParameterImpl("!" + option + "!");
                this.add(paramSummaryValue, 1, list);
                paramSummaryValue.setIndent(1, false);
                ++n2;
            }
        }
    }

    private static String encodeDisplayLong(long val) {
        if (val < 1024L) {
            return String.valueOf(val);
        }
        if ((val /= 1024L) < 1024L) {
            return String.valueOf(val) + " KB";
        }
        if ((val /= 1024L) < 1024L) {
            return String.valueOf(val) + " MB";
        }
        if (val % 1024L == 0L) {
            return String.valueOf(val /= 1024L) + " GB";
        }
        return String.valueOf(val) + " MB";
    }

    private static long decodeDisplayLong(String val) throws Exception {
        if ((val = val.trim()).isEmpty()) {
            return 0L;
        }
        char[] chars = val.toCharArray();
        String digits = "";
        String units = "";
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isDigit(c)) {
                if (units.length() > 0) {
                    throw new Exception("Invalid unit");
                }
                digits = String.valueOf(digits) + c;
            } else {
                if (digits.length() == 0) {
                    throw new Exception("Missing digits");
                }
                if (units.length() != 0 || !Character.isWhitespace(c)) {
                    units = String.valueOf(units) + c;
                }
            }
            ++n2;
        }
        long value = Long.parseLong(digits);
        if (units.length() == 0) {
            units = "m";
        }
        if (units.length() > 0) {
            char c = Character.toLowerCase(units.charAt(0));
            if (c == 'k') {
                value *= 1024L;
            } else if (c == 'm') {
                value = value * 1024L * 1024L;
            } else if (c == 'g') {
                value = value * 1024L * 1024L * 1024L;
            } else {
                throw new Exception("Invalid size unit '" + units + "'");
            }
        }
        return value;
    }

    public static String[][] getActionDetails(boolean for_timed_stop) {
        String[] action_values;
        PlatformManager platform = PlatformManagerFactory.getPlatformManager();
        int shutdown_types = platform.getShutdownTypes();
        ArrayList<String> l_action_values = new ArrayList<String>();
        ArrayList<String> l_action_descs = new ArrayList<String>();
        if (!for_timed_stop) {
            l_action_values.add("Nothing");
        }
        l_action_values.add("QuitVuze");
        if ((shutdown_types & 4) != 0) {
            l_action_values.add("Sleep");
        }
        if ((shutdown_types & 2) != 0) {
            l_action_values.add("Hibernate");
        }
        if ((shutdown_types & 1) != 0) {
            l_action_values.add("Shutdown");
        }
        l_action_values.add("RunScript");
        l_action_values.add("RunScriptAndClose");
        String[] stringArray = action_values = l_action_values.toArray(new String[l_action_values.size()]);
        int n = action_values.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            l_action_descs.add(MessageText.getString("ConfigView.label.stop." + s));
            ++n2;
        }
        String[] action_descs = l_action_descs.toArray(new String[l_action_descs.size()]);
        return new String[][]{action_descs, action_values};
    }

    public void addDoneDownloadingOption(List<Parameter> listStop, boolean include_script_setting) {
        String[][] action_details = ConfigSectionStartShutdown.getActionDetails(false);
        StringListParameterImpl dc = new StringListParameterImpl("On Downloading Complete Do", "ConfigView.label.stop.downcomp", action_details[1], action_details[0]);
        this.add(dc, 1, listStop);
        if (include_script_setting) {
            FileParameterImpl dc_script = new FileParameterImpl("On Downloading Complete Script", "label.script.to.run", new String[0]);
            this.add(dc_script, 1, listStop);
            dc_script.setIndent(1, true);
            boolean is_script = dc.getValue().startsWith("RunScript");
            dc_script.setEnabled(is_script);
            dc.addListener(p -> dc_script.setEnabled(dc.getValue().startsWith("RunScript")));
        }
    }

    private void addDoneSeedingOption(List<Parameter> listStop, boolean include_script_setting) {
        String[][] action_details = ConfigSectionStartShutdown.getActionDetails(false);
        StringListParameterImpl sc = new StringListParameterImpl("On Seeding Complete Do", "ConfigView.label.stop.seedcomp", action_details[1], action_details[0]);
        this.add(sc, 1, listStop);
        if (include_script_setting) {
            FileParameterImpl sc_script = new FileParameterImpl("On Seeding Complete Script", "label.script.to.run", new String[0]);
            this.add(sc_script, 1, listStop);
            sc_script.setIndent(1, true);
            boolean is_script = sc.getValue().startsWith("RunScript");
            sc_script.setEnabled(is_script);
            sc.addListener(p -> sc_script.setEnabled(sc.getValue().startsWith("RunScript")));
        }
    }

    private void addTimedCloseOption(DateTimeParameterImpl param, List<Parameter> listStop) {
        String[][] action_details = ConfigSectionStartShutdown.getActionDetails(true);
        StringListParameterImpl sc = new StringListParameterImpl("Stop Explicit Do", "label.do.the.following", action_details[1], action_details[0]);
        this.add(sc, 1, listStop);
        sc.setIndent(1, true);
        FileParameterImpl sc_script = new FileParameterImpl("Stop Explicit Script", "label.script.to.run", new String[0]);
        this.add(sc_script, 1, listStop);
        sc_script.setIndent(2, true);
        ParameterListener pl = p -> {
            long time = param.getValue();
            boolean is_script = sc.getValue().startsWith("RunScript");
            sc.setEnabled(time > 0L);
            sc_script.setEnabled(time > 0L && is_script);
        };
        pl.parameterChanged(null);
        param.addListener(pl);
        sc.addListener(pl);
    }
}

