/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.impl.TransferSpeedValidator;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterListener;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.HyperlinkParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntListParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.StringParameterImpl;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.util.ArrayList;
import java.util.List;

public class ConfigSectionTransfer
extends ConfigSectionImpl {
    public ConfigSectionTransfer() {
        super("transfer", "root");
    }

    @Override
    public void build() {
        int[] manual_max_download_speed = new int[]{COConfigurationManager.getIntParameter("Max Download Speed KBs")};
        IntParameterImpl paramMaxUploadSpeed = new IntParameterImpl("Max Upload Speed KBs", "ConfigView.label.maxuploadspeed", 0, Integer.MAX_VALUE);
        this.add(paramMaxUploadSpeed, new List[0]);
        BooleanParameterImpl enable_seeding_rate = new BooleanParameterImpl("enable.seedingonly.upload.rate", "ConfigView.label.maxuploadspeedseeding");
        this.add(enable_seeding_rate, new List[0]);
        IntParameterImpl paramMaxUploadSpeedSeeding = new IntParameterImpl("Max Upload Speed Seeding KBs", null, 0, Integer.MAX_VALUE);
        this.add(paramMaxUploadSpeedSeeding, new List[0]);
        enable_seeding_rate.addEnabledOnSelection((Parameter)paramMaxUploadSpeedSeeding);
        this.add("cMaxUploadSpeedOptionsArea", new ParameterGroupImpl(null, enable_seeding_rate, paramMaxUploadSpeedSeeding).setNumberOfColumns2(2), new List[0]);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode < 2) {
            this.add(new HyperlinkParameterImpl("ConfigView.section.transfer.speeds.wiki", "Utils.link.visit", "https://wiki.biglybt.com/w/Good_settings"), new List[0]);
        }
        this.add(new IntParameterImpl("max.uploads.when.busy.inc.min.secs", "ConfigView.label.maxuploadswhenbusymin", 0, Integer.MAX_VALUE), 2, new List[0]);
        IntParameterImpl paramMaxDownSpeed = new IntParameterImpl("Max Download Speed KBs", "ConfigView.label.maxdownloadspeed", 0, Integer.MAX_VALUE);
        this.add(paramMaxDownSpeed, new List[0]);
        ParameterListener l = param -> {
            boolean disableAuto;
            boolean disableAutoSeeding;
            if (enable_seeding_rate.getValue()) {
                disableAutoSeeding = param == paramMaxUploadSpeedSeeding;
                disableAuto = param == paramMaxDownSpeed || param == paramMaxUploadSpeed;
            } else {
                disableAuto = true;
                disableAutoSeeding = true;
            }
            if (disableAuto) {
                COConfigurationManager.setParameter("Auto Upload Speed Enabled", false);
            }
            if (disableAutoSeeding) {
                COConfigurationManager.setParameter("Auto Upload Speed Seeding Enabled", false);
            }
        };
        paramMaxDownSpeed.addListener(l);
        paramMaxUploadSpeed.addListener(l);
        paramMaxUploadSpeedSeeding.addListener(l);
        paramMaxUploadSpeed.addListener(param -> CoreFactory.addCoreRunningListener(core -> {
            if (TransferSpeedValidator.isAutoSpeedActive(core.getGlobalManager())) {
                return;
            }
            int up_val = paramMaxUploadSpeed.getValue();
            int down_val = paramMaxDownSpeed.getValue();
            if (up_val != 0 && up_val < 5) {
                if (down_val == 0 || down_val > up_val * 2) {
                    paramMaxDownSpeed.setValue(up_val * 2);
                }
            } else if (down_val != manual_max_download_speed[0]) {
                paramMaxDownSpeed.setValue(manual_max_download_speed[0]);
            }
        }));
        paramMaxDownSpeed.addListener(param -> CoreFactory.addCoreRunningListener(core -> {
            int down_val;
            if (TransferSpeedValidator.isAutoSpeedActive(core.getGlobalManager())) {
                return;
            }
            int up_val = paramMaxUploadSpeed.getValue();
            nArray[0] = down_val = paramMaxDownSpeed.getValue();
            if (up_val < 5) {
                if (up_val != 0 && up_val < down_val * 2) {
                    paramMaxUploadSpeed.setValue((down_val + 1) / 2);
                } else if (down_val == 0) {
                    paramMaxUploadSpeed.setValue(0);
                }
            }
        }));
        BooleanParameterImpl bias_upload = new BooleanParameterImpl("Bias Upload Enable", "ConfigView.label.xfer.bias_up");
        this.add(bias_upload, 1, new List[0]);
        IntParameterImpl bias_slack = new IntParameterImpl("Bias Upload Slack KBs", "ConfigView.label.xfer.bias_slack", 1, Integer.MAX_VALUE);
        this.add(bias_slack, 1, new List[0]);
        bias_slack.setIndent(1, true);
        BooleanParameterImpl bias_no_limit = new BooleanParameterImpl("Bias Upload Handle No Limit", "ConfigView.label.xfer.bias_no_limit");
        this.add(bias_no_limit, 1, new List[0]);
        bias_no_limit.setIndent(1, true);
        bias_upload.addEnabledOnSelection(bias_slack, bias_no_limit);
        ArrayList<BooleanParameterImpl> listAuto = new ArrayList<BooleanParameterImpl>();
        BooleanParameterImpl auto_adjust = new BooleanParameterImpl("Auto Adjust Transfer Defaults", "ConfigView.label.autoadjust");
        this.add(auto_adjust, 1, new List[0]);
        IntParameterImpl paramMaxUploads = new IntParameterImpl("Max Uploads", "ConfigView.label.maxuploads", 2, Integer.MAX_VALUE);
        this.add(paramMaxUploads, 1, listAuto);
        BooleanParameterImpl enable_seeding_uploads = new BooleanParameterImpl("enable.seedingonly.maxuploads", "ConfigView.label.maxuploadsseeding");
        this.add(enable_seeding_uploads, 1, new List[0]);
        IntParameterImpl paramMaxUploadsSeeding = new IntParameterImpl("Max Uploads Seeding", null, 2, Integer.MAX_VALUE);
        this.add(paramMaxUploadsSeeding, 1, new List[0]);
        this.add("Transfer.pgMaxUpSeeding", new ParameterGroupImpl(null, enable_seeding_uploads, paramMaxUploadsSeeding).setNumberOfColumns2(2), listAuto);
        IntParameterImpl paramMaxClients = new IntParameterImpl("Max.Peer.Connections.Per.Torrent", "ConfigView.label.max_peers_per_torrent");
        this.add(paramMaxClients, 1, listAuto);
        BooleanParameterImpl enable_max_peers_seeding = new BooleanParameterImpl("Max.Peer.Connections.Per.Torrent.When.Seeding.Enable", "ConfigView.label.maxuploadsseeding");
        this.add(enable_max_peers_seeding, 1, new List[0]);
        IntParameterImpl paramMaxPeersSeeding = new IntParameterImpl("Max.Peer.Connections.Per.Torrent.When.Seeding", null, 0, Integer.MAX_VALUE);
        this.add(paramMaxPeersSeeding, 1, new List[0]);
        this.add("Transfer.pgMaxPeersSeeding", new ParameterGroupImpl(null, enable_max_peers_seeding, paramMaxPeersSeeding).setNumberOfColumns2(2), listAuto);
        IntParameterImpl paramMaxClientsTotal = new IntParameterImpl("Max.Peer.Connections.Total", "ConfigView.label.max_peers_total");
        this.add(paramMaxClientsTotal, 1, listAuto);
        IntParameterImpl max_seeds_per_torrent = new IntParameterImpl("Max Seeds Per Torrent", "ConfigView.label.maxseedspertorrent");
        this.add(max_seeds_per_torrent, 1, listAuto);
        auto_adjust.addDisabledOnSelection(listAuto.toArray(new Parameter[0]));
        enable_seeding_uploads.addEnabledOnSelection((Parameter)paramMaxUploadsSeeding);
        enable_max_peers_seeding.addEnabledOnSelection((Parameter)paramMaxPeersSeeding);
        listAuto.add(0, auto_adjust);
        this.add("Transfer.gAuto", new ParameterGroupImpl("group.auto", listAuto), new List[0]);
        ArrayList listNPP = new ArrayList();
        this.add(new IntParameterImpl("Non-Public Peer Extra Slots Per Torrent", "ConfigView.label.npp.slots", 0, Integer.MAX_VALUE), 1, listNPP);
        this.add(new IntParameterImpl("Non-Public Peer Extra Connections Per Torrent", "ConfigView.label.npp.connections", 0, Integer.MAX_VALUE), 1, listNPP);
        this.add("Transfer.NPP", new ParameterGroupImpl("label.non.public.peers", listNPP), new List[0]);
        BooleanParameterImpl useReqLimiting = new BooleanParameterImpl("Use Request Limiting", "ConfigView.label.userequestlimiting");
        this.add(useReqLimiting, 1, new List[0]);
        BooleanParameterImpl useReqLimitingPrios = new BooleanParameterImpl("Use Request Limiting Priorities", "ConfigView.label.userequestlimitingpriorities");
        this.add(useReqLimitingPrios, 1, new List[0]);
        useReqLimitingPrios.setIndent(1, true);
        useReqLimiting.addEnabledOnSelection((Parameter)useReqLimitingPrios);
        BooleanParameterImpl upIncludesProt = new BooleanParameterImpl("Up Rate Limits Include Protocol", "ConfigView.label.up.includes.prot");
        this.add(upIncludesProt, 1, new List[0]);
        BooleanParameterImpl downIncludesProt = new BooleanParameterImpl("Down Rate Limits Include Protocol", "ConfigView.label.down.includes.prot");
        this.add(downIncludesProt, 1, new List[0]);
        BooleanParameterImpl allowSameIP = new BooleanParameterImpl("Allow Same IP Peers", "ConfigView.label.allowsameip");
        this.add(allowSameIP, 1, new List[0]);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] values = nArray;
        String[] labels = new String[]{MessageText.getString("label.allow.both"), MessageText.getString("label.ban.ipv4"), MessageText.getString("label.ban.ipv6")};
        IntListParameterImpl paramDualIPAction = new IntListParameterImpl("Dual IPV4 IPV6 Connection Action", "ConfigView.label.dual.con.behaviour", values, labels);
        this.add(paramDualIPAction, 1, new List[0]);
        BooleanParameterImpl lazybf = new BooleanParameterImpl("Use Lazy Bitfield", "ConfigView.label.lazybitfield");
        this.add(lazybf, 1, new List[0]);
        BooleanParameterImpl hap = new BooleanParameterImpl("peercontrol.hide.piece", "ConfigView.label.hap");
        this.add(hap, 2, new List[0]);
        BooleanParameterImpl hapds = new BooleanParameterImpl("peercontrol.hide.piece.ds", "ConfigView.label.hapds");
        this.add(hapds, 2, new List[0]);
        hapds.setIndent(1, true);
        hap.addEnabledOnSelection((Parameter)hapds);
        BooleanParameterImpl pfp = new BooleanParameterImpl("Prioritize First Piece", "ConfigView.label.prioritizefirstpiece");
        this.add(pfp, 1, new List[0]);
        IntParameterImpl pMB = new IntParameterImpl("Prioritize First MB", "", 0, Integer.MAX_VALUE);
        String[] units = new String[]{DisplayFormatters.getUnit(2)};
        pMB.setLabelText(MessageText.getString("ConfigView.label.prioritizefirstmb", units));
        pMB.setIndent(1, true);
        this.add(pMB, 1, new List[0]);
        BooleanParameterImpl pfpf = new BooleanParameterImpl("Prioritize First Piece Force", "ConfigView.label.prioritizefirstpiece.force");
        pfpf.setIndent(1, true);
        this.add(pfpf, 1, new List[0]);
        pfp.addEnabledOnSelection((Parameter)pfpf);
        pfp.addEnabledOnSelection((Parameter)pMB);
        this.add(new BooleanParameterImpl("Prioritize Most Completed Files", "ConfigView.label.prioritizemostcompletedfiles"), 1, new List[0]);
        IntParameterImpl sfp = new IntParameterImpl("Set File Priority Remaining Pieces", "ConfigView.label.set.file.pri.pieces.rem", 0, Integer.MAX_VALUE);
        sfp.setGenerateIntermediateEvents(false);
        this.add(sfp, 1, new List[0]);
        StringParameterImpl paramIgnorePeerPorts = new StringParameterImpl("Ignore.peer.ports", "ConfigView.label.transfer.ignorepeerports");
        this.add(paramIgnorePeerPorts, 1, new List[0]);
        this.add("gIgnore.peer.ports", new ParameterGroupImpl(null, paramIgnorePeerPorts), new List[0]);
    }
}

