/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.console;

import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pifimpl.local.ui.config.ConfigSectionRepository;
import com.biglybt.pifimpl.local.ui.config.ParameterImpl;
import com.biglybt.ui.config.BaseConfigSection;
import com.biglybt.ui.config.ConfigSectionBackupRestore;
import com.biglybt.ui.config.ConfigSectionConnection;
import com.biglybt.ui.config.ConfigSectionConnectionAdvanced;
import com.biglybt.ui.config.ConfigSectionConnectionDNS;
import com.biglybt.ui.config.ConfigSectionConnectionEncryption;
import com.biglybt.ui.config.ConfigSectionConnectionProxy;
import com.biglybt.ui.config.ConfigSectionFile;
import com.biglybt.ui.config.ConfigSectionFileMove;
import com.biglybt.ui.config.ConfigSectionFilePerformance;
import com.biglybt.ui.config.ConfigSectionFileTorrents;
import com.biglybt.ui.config.ConfigSectionFileTorrentsDecoding;
import com.biglybt.ui.config.ConfigSectionIPFilter;
import com.biglybt.ui.config.ConfigSectionInterfaceLanguage;
import com.biglybt.ui.config.ConfigSectionInterfaceTags;
import com.biglybt.ui.config.ConfigSectionLogging;
import com.biglybt.ui.config.ConfigSectionMode;
import com.biglybt.ui.config.ConfigSectionPlugins;
import com.biglybt.ui.config.ConfigSectionSecurity;
import com.biglybt.ui.config.ConfigSectionSharing;
import com.biglybt.ui.config.ConfigSectionStartShutdown;
import com.biglybt.ui.config.ConfigSectionStats;
import com.biglybt.ui.config.ConfigSectionTracker;
import com.biglybt.ui.config.ConfigSectionTrackerClient;
import com.biglybt.ui.config.ConfigSectionTrackerServer;
import com.biglybt.ui.config.ConfigSectionTransfer;
import com.biglybt.ui.config.ConfigSectionTransferAutoSpeedClassic;
import com.biglybt.ui.config.ConfigSectionTransferAutoSpeedSelect;
import com.biglybt.ui.config.ConfigSectionTransferAutoSpeedV2;
import com.biglybt.ui.config.ConfigSectionTransferLAN;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ConsoleConfigSections {
    private static ConsoleConfigSections instance;
    private final BaseConfigSection[] internalSections = new BaseConfigSection[]{new ConfigSectionMode(), new ConfigSectionStartShutdown(), new ConfigSectionBackupRestore(), new ConfigSectionConnection(), new ConfigSectionConnectionProxy(), new ConfigSectionConnectionAdvanced(), new ConfigSectionConnectionEncryption(), new ConfigSectionConnectionDNS(), new ConfigSectionTransfer(), new ConfigSectionTransferAutoSpeedSelect(), new ConfigSectionTransferAutoSpeedClassic(), new ConfigSectionTransferAutoSpeedV2(), new ConfigSectionTransferLAN(), new ConfigSectionFile(), new ConfigSectionFileMove(), new ConfigSectionFileTorrents(), new ConfigSectionFileTorrentsDecoding(), new ConfigSectionFilePerformance(), new ConfigSectionInterfaceLanguage(), new ConfigSectionInterfaceTags(), new ConfigSectionIPFilter(), new ConfigSectionPlugins(), new ConfigSectionStats(), new ConfigSectionTracker(), new ConfigSectionTrackerClient(), new ConfigSectionTrackerServer(), new ConfigSectionSecurity(), new ConfigSectionSharing(), new ConfigSectionLogging()};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConsoleConfigSections getInstance() {
        Class<ConsoleConfigSections> clazz = ConsoleConfigSections.class;
        synchronized (ConsoleConfigSections.class) {
            if (instance == null) {
                instance = new ConsoleConfigSections();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<BaseConfigSection> getAllConfigSections(boolean sort) {
        ArrayList<BaseConfigSection> repoList = ConfigSectionRepository.getInstance().getList();
        if (!sort) {
            repoList.addAll(0, Arrays.asList(this.internalSections));
            return repoList;
        }
        ArrayList<BaseConfigSection> configSections = new ArrayList<BaseConfigSection>(Arrays.asList(this.internalSections));
        for (BaseConfigSection repoConfigSection : repoList) {
            int size;
            String repoParentID = repoConfigSection.getParentSectionID();
            int insertAt = size = configSections.size();
            int i = 0;
            while (i < size) {
                BaseConfigSection configSection = configSections.get(i);
                if (insertAt == i) {
                    if (!repoParentID.equals(configSection.getParentSectionID())) break;
                    ++insertAt;
                } else if (configSection.getConfigSectionID().equals(repoParentID)) {
                    insertAt = i + 1;
                }
                ++i;
            }
            if (insertAt >= size) {
                configSections.add(repoConfigSection);
                continue;
            }
            configSections.add(insertAt, repoConfigSection);
        }
        return configSections;
    }

    public ParameterWithConfigSection getParameter(String configKey) {
        List<BaseConfigSection> sections = this.getAllConfigSections(false);
        for (BaseConfigSection section : sections) {
            boolean needsBuild = !section.isBuilt();
            try {
                ParameterImpl pluginParam;
                if (needsBuild) {
                    section.build();
                    section.postBuild();
                }
                if ((pluginParam = section.getPluginParam(configKey)) == null) continue;
                ParameterWithConfigSection parameterWithConfigSection = new ParameterWithConfigSection(section, pluginParam);
                return parameterWithConfigSection;
            }
            finally {
                if (needsBuild) {
                    section.deleteConfigSection();
                }
            }
        }
        return null;
    }

    public static final class ParameterWithConfigSection {
        public BaseConfigSection configSection;
        public Parameter parameter;

        public ParameterWithConfigSection(BaseConfigSection configSection, Parameter parameter) {
            this.configSection = configSection;
            this.parameter = parameter;
        }
    }
}

