/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.console.commands;

import com.biglybt.core.pairing.PairingManager;
import com.biglybt.core.pairing.PairingManagerFactory;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.console.ConsoleInput;
import com.biglybt.ui.console.commands.IConsoleCommand;
import java.io.PrintStream;
import java.util.List;

public class Pairing
extends IConsoleCommand {
    public Pairing() {
        super("pairing", "pair");
    }

    @Override
    public String getCommandDescriptions() {
        return "pairing\t\tpair\tShows and modified the current Vuze remote pairing state.";
    }

    public void printHelpExtra(PrintStream out, List args) {
        out.println("> -----");
        out.println("Subcommands:");
        out.println("enable\tEnable remote pairing");
        out.println("disable\tDisable remote pairing");
        out.println("> -----");
    }

    @Override
    public void execute(String commandName, ConsoleInput ci, List<String> args) {
        PairingManager pm = PairingManagerFactory.getSingleton();
        if (args.size() > 0) {
            String sub = args.get(0);
            if (sub.equals("enable")) {
                pm.setEnabled(true);
            } else if (sub.equals("disable")) {
                pm.setEnabled(false);
            } else {
                ci.out.println("Unsupported sub-command: " + sub);
                return;
            }
        }
        ci.out.println("Current pairing state:");
        if (pm.isEnabled()) {
            ci.out.println("\tStatus:      " + pm.getStatus());
            try {
                ci.out.println("\tAccess code: " + pm.getAccessCode());
            }
            catch (Throwable e) {
                ci.out.println("Failed to get access code: " + Debug.getNestedExceptionMessage(e));
            }
        } else {
            ci.out.println("\tdisabled");
        }
    }
}

