/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.console.commands;

import com.biglybt.core.category.Category;
import com.biglybt.core.dht.DHT;
import com.biglybt.core.dht.control.DHTControlStats;
import com.biglybt.core.dht.db.DHTDBStats;
import com.biglybt.core.dht.netcoords.DHTNetworkPosition;
import com.biglybt.core.dht.router.DHTRouterStats;
import com.biglybt.core.dht.transport.DHTTransport;
import com.biglybt.core.dht.transport.DHTTransportStats;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogRelation;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPeerManagerStats;
import com.biglybt.core.peer.PEPeerStats;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.peermanager.piecepicker.PiecePicker;
import com.biglybt.core.stats.CoreStats;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.tracker.client.TRTrackerAnnouncer;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.PluginInterface;
import com.biglybt.plugin.dht.DHTPlugin;
import com.biglybt.ui.console.ConsoleInput;
import com.biglybt.ui.console.commands.IConsoleCommand;
import com.biglybt.ui.console.commands.TorrentFilter;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class Show
extends IConsoleCommand {
    public Show() {
        super("show", "sh");
    }

    @Override
    public String getCommandDescriptions() {
        return "show [<various options>]\tsh\tShow info. Use without parameter to get a list of available options.";
    }

    public void printHelpExtra(PrintStream out, List args) {
        out.println("> -----");
        out.println("'show' options: ");
        out.println("<#>\t\t\t\tFurther info on a single torrent - args from [peers|pieces]+. Run 'show torrents' first for the number.");
        out.println("options\t\t\to\tShow list of options for 'set' (also available by 'set' without parameters).");
        out.println("files\t\t\tf\tShow list of files found from the 'add -f' command (also available by 'add -l')");
        out.println("dht\t\t\td\tShow distributed database statistics");
        out.println("nat\t\t\tn\tShow NAT status");
        out.println("stats [pattern] [on|off]\ts\tShow stats [with a given pattern] [turn averages on/off]");
        out.println("torrents [opts] [expr]\tt\tShow list of torrents. torrent options may be any (or none) of:");
        out.println("\t\ttransferring\tx\tShow only transferring torrents.");
        out.println("\t\tactive\t\ta\tShow only active torrents.");
        out.println("\t\tcomplete\tc\tShow only complete torrents.");
        out.println("\t\tincomplete\ti\tShow only incomplete torrents.");
        out.println("\t\tdead [days]\td [days]Show only dead torrents (complete and not uploaded for [days] (default 7) uptime (NOT elapsed)).");
        out.println("\te.g. show t a *Az* - shows all active torrents with 'Az' occurring in their name.");
        out.println("> -----");
    }

    public void execute(String commandName, ConsoleInput ci, List args) {
        if (args.isEmpty()) {
            this.printHelp(ci.out, args);
            return;
        }
        String subCommand = (String)args.remove(0);
        if (subCommand.equalsIgnoreCase("options") || subCommand.equalsIgnoreCase("o")) {
            ci.invokeCommand("set", null);
        } else if (subCommand.equalsIgnoreCase("files") || subCommand.equalsIgnoreCase("f")) {
            ci.invokeCommand("add", Collections.singletonList("--list"));
        } else if (subCommand.equalsIgnoreCase("torrents") || subCommand.equalsIgnoreCase("t")) {
            Iterator<DownloadManager> torrent;
            ci.out.println("> -----");
            ci.torrents.clear();
            ci.torrents.addAll(ci.getGlobalManager().getDownloadManagers());
            Collections.sort(ci.torrents, new IConsoleCommand.TorrentComparator());
            if (ci.torrents.isEmpty()) {
                ci.out.println("No Torrents");
                ci.out.println("> -----");
                return;
            }
            long totalReceived = 0L;
            long totalSent = 0L;
            long totalDiscarded = 0L;
            int connectedSeeds = 0;
            int connectedPeers = 0;
            boolean bShowOnlyActive = false;
            boolean bShowOnlyComplete = false;
            boolean bShowOnlyIncomplete = false;
            boolean bShowOnlyTransferring = false;
            int bShowDeadForDays = 0;
            ListIterator iter = args.listIterator();
            while (iter.hasNext()) {
                String arg = (String)iter.next();
                if ("active".equalsIgnoreCase(arg) || "a".equalsIgnoreCase(arg)) {
                    bShowOnlyActive = true;
                    iter.remove();
                    continue;
                }
                if ("complete".equalsIgnoreCase(arg) || "c".equalsIgnoreCase(arg)) {
                    bShowOnlyComplete = true;
                    iter.remove();
                    continue;
                }
                if ("incomplete".equalsIgnoreCase(arg) || "i".equalsIgnoreCase(arg)) {
                    bShowOnlyIncomplete = true;
                    iter.remove();
                    continue;
                }
                if ("transferring".equalsIgnoreCase(arg) || "x".equalsIgnoreCase(arg)) {
                    bShowOnlyTransferring = true;
                    bShowOnlyActive = true;
                    iter.remove();
                    continue;
                }
                if (!"dead".equalsIgnoreCase(arg) && !"d".equalsIgnoreCase(arg)) continue;
                iter.remove();
                bShowDeadForDays = 7;
                if (!iter.hasNext()) continue;
                String days = (String)iter.next();
                try {
                    bShowDeadForDays = Integer.parseInt(days);
                    iter.remove();
                }
                catch (Throwable e) {
                    iter.previous();
                }
            }
            if (args.size() > 0) {
                List matchedTorrents = new TorrentFilter().getTorrents(ci.torrents, args);
                torrent = matchedTorrents.iterator();
            } else {
                torrent = ci.torrents.iterator();
            }
            ArrayList<DownloadManager> shown_torrents = new ArrayList<DownloadManager>();
            while (torrent.hasNext()) {
                PEPeerManagerStats ps;
                int dmstate2;
                boolean bCanShow;
                DownloadManager dm = torrent.next();
                DownloadManagerStats stats2 = dm.getStats();
                boolean bDownloadCompleted = dm.isDownloadComplete(false);
                boolean bl = bCanShow = bShowOnlyComplete == bShowOnlyIncomplete || bDownloadCompleted && bShowOnlyComplete || !bDownloadCompleted && bShowOnlyIncomplete;
                if (bCanShow && bShowOnlyActive) {
                    dmstate2 = dm.getState();
                    boolean bl2 = bCanShow = dmstate2 == 60 || dmstate2 == 50 || dmstate2 == 30 || dmstate2 == 5 || dmstate2 == 20;
                }
                if (bCanShow && bShowOnlyTransferring) {
                    try {
                        ps = dm.getPeerManager().getStats();
                        bCanShow = ps.getDataSendRate() > 0L || ps.getDataReceiveRate() > 0L;
                    }
                    catch (Exception dmstate2) {
                        // empty catch block
                    }
                }
                if (bCanShow && bShowDeadForDays > 0) {
                    long seeding_secs;
                    long seeding_days;
                    dmstate2 = dm.getState();
                    bCanShow = false;
                    if ((dmstate2 == 60 || bDownloadCompleted && (dmstate2 == 75 || dmstate2 == 70)) && (seeding_days = (seeding_secs = stats2.getSecondsOnlySeeding()) / 86400L) >= (long)bShowDeadForDays) {
                        int secs_since_last_up = stats2.getTimeSinceLastDataSentInSeconds();
                        if (secs_since_last_up == -1) {
                            bCanShow = true;
                        } else {
                            int days_since_last_up = secs_since_last_up / 86400;
                            if (days_since_last_up >= bShowDeadForDays) {
                                bCanShow = true;
                            }
                        }
                    }
                }
                if (!bCanShow) continue;
                shown_torrents.add(dm);
                try {
                    PEPeerManager pm = dm.getPeerManager();
                    ps = pm == null ? null : pm.getStats();
                }
                catch (Exception e) {
                    ps = null;
                }
                if (ps != null) {
                    totalReceived += dm.getStats().getTotalDataBytesReceived();
                    totalSent += dm.getStats().getTotalDataBytesSent();
                    totalDiscarded += ps.getTotalDiscarded();
                    connectedSeeds += dm.getNbSeeds();
                    connectedPeers += dm.getNbPeers();
                }
                ci.out.print(String.valueOf(shown_torrents.size() < 10 ? " " : "") + shown_torrents.size() + " ");
                ci.out.println(this.getTorrentSummary(dm));
                ci.out.println();
            }
            ci.torrents.clear();
            ci.torrents.addAll(shown_torrents);
            GlobalManager gm = ci.getGlobalManager();
            ci.out.println("Total Speed (down/up): " + DisplayFormatters.formatByteCountToKiBEtcPerSec(gm.getStats().getDataReceiveRate() + gm.getStats().getProtocolReceiveRate()) + " / " + DisplayFormatters.formatByteCountToKiBEtcPerSec(gm.getStats().getDataSendRate() + gm.getStats().getProtocolSendRate()));
            ci.out.println("Transferred Volume (down/up/discarded): " + DisplayFormatters.formatByteCountToKiBEtc(totalReceived) + " / " + DisplayFormatters.formatByteCountToKiBEtc(totalSent) + " / " + DisplayFormatters.formatByteCountToKiBEtc(totalDiscarded));
            ci.out.println("Total Connected Peers (seeds/peers): " + Integer.toString(connectedSeeds) + " / " + Integer.toString(connectedPeers));
            ci.out.println("> -----");
        } else if (subCommand.equalsIgnoreCase("dht") || subCommand.equalsIgnoreCase("d")) {
            this.showDHTStats(ci);
        } else if (subCommand.equalsIgnoreCase("nat") || subCommand.equalsIgnoreCase("n")) {
            IndentWriter iw = new IndentWriter(new PrintWriter(ci.out));
            iw.setForce(true);
            NetworkAdmin.getSingleton().logNATStatus(iw);
        } else if (subCommand.equalsIgnoreCase("stats") || subCommand.equalsIgnoreCase("s")) {
            String pattern = ".*";
            if (args.size() > 0 && (pattern = (String)args.get(0)).equals("*")) {
                pattern = ".*";
            }
            if (args.size() > 1) {
                CoreStats.setEnableAverages(((String)args.get(1)).equalsIgnoreCase("on"));
            }
            HashSet<String> types = new HashSet<String>();
            types.add(pattern);
            Map<String, Object> reply = CoreStats.getStats(types);
            Iterator<Map.Entry<String, Object>> it = reply.entrySet().iterator();
            ArrayList<String> lines = new ArrayList<String>();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                lines.add(entry.getKey() + " -> " + entry.getValue());
            }
            Collections.sort(lines);
            int i = 0;
            while (i < lines.size()) {
                ci.out.println(lines.get(i));
                ++i;
            }
        } else if (subCommand.equalsIgnoreCase("diag") || subCommand.equalsIgnoreCase("z")) {
            try {
                ci.out.println("Writing diagnostics to file 'az.diag'");
                FileWriter fw = new FileWriter("az.diag");
                PrintWriter pw = new PrintWriter(fw);
                AEDiagnostics.generateEvidence(pw);
                pw.flush();
                fw.close();
            }
            catch (Throwable e) {
                ci.out.println(e);
            }
        } else if (subCommand.equalsIgnoreCase("errors")) {
            List<LogEvent> errorLogEvents = ci.getErrorLogEvents();
            if (errorLogEvents.size() == 0) {
                System.out.println("No error logs since last time.");
            }
            for (LogEvent event2 : errorLogEvents) {
                StringBuffer buf = new StringBuffer();
                buf.append(String.valueOf(DisplayFormatters.formatDate(event2.timeStamp.getTime())) + "] ");
                buf.append("{").append(event2.logID).append("} ");
                buf.append(event2.text);
                if (event2.relatedTo != null) {
                    buf.append("; \t| ");
                    int j = 0;
                    while (j < event2.relatedTo.length) {
                        Object obj = event2.relatedTo[j];
                        if (j > 0) {
                            buf.append("; ");
                        }
                        if (obj instanceof LogRelation) {
                            buf.append(((LogRelation)obj).getRelationText());
                        } else if (obj != null) {
                            buf.append(obj.getClass().getName()).append(": '").append(obj.toString()).append("'");
                        }
                        ++j;
                    }
                }
                System.out.println(buf);
            }
        } else {
            if (ci.torrents == null || ci.torrents != null && ci.torrents.isEmpty()) {
                ci.out.println("> Command 'show': No torrents in list (try 'show torrents' first).");
                return;
            }
            try {
                int number = Integer.parseInt(subCommand);
                if (number == 0 || number > ci.torrents.size()) {
                    ci.out.println("> Command 'show': Torrent #" + number + " unknown.");
                    return;
                }
                DownloadManager dm = ci.torrents.get(number - 1);
                Show.printTorrentDetails(ci.out, dm, number, args);
            }
            catch (Exception e) {
                ci.out.println("> Command 'show': Subcommand '" + subCommand + "' unknown.");
                return;
            }
        }
    }

    private static void printTorrentDetails(PrintStream out, DownloadManager dm, int torrentNum, List<String> args) {
        String tags_str;
        List<Tag> tags;
        String name = dm.getDisplayName();
        if (name == null) {
            name = "?";
        }
        out.println("> -----");
        out.println("Info on Torrent #" + torrentNum + " (" + name + ")");
        out.println("- General Info -");
        String[] health = new String[]{"- no info -", "stopped", "no remote connections", "no tracker", "OK", "ko"};
        try {
            out.println("Health: " + health[dm.getHealthStatus()]);
        }
        catch (Exception e) {
            out.println("Health: " + health[0]);
        }
        out.println("State: " + Integer.toString(dm.getState()));
        if (dm.getState() == 100) {
            out.println("Error: " + dm.getErrorDetails());
        }
        out.println("Hash: " + TorrentUtils.nicePrintTorrentHash(dm.getTorrent(), true));
        out.println("- Torrent file -");
        out.println("Torrent Filename: " + dm.getTorrentFileName());
        out.println("Saving to: " + dm.getSaveLocation());
        out.println("Created By: " + dm.getTorrentCreatedBy());
        out.println("Comment: " + dm.getTorrentComment());
        Category cat = dm.getDownloadState().getCategory();
        if (cat != null) {
            out.println("Category: " + cat.getName());
        }
        if ((tags = TagManagerFactory.getTagManager().getTagsForTaggable(3, (Taggable)dm)).size() == 0) {
            tags_str = "None";
        } else {
            tags_str = "";
            for (Tag t : tags) {
                tags_str = String.valueOf(tags_str) + (tags_str.length() == 0 ? "" : ",") + t.getTagName(true);
            }
        }
        out.println("Tags: " + tags_str);
        out.println("Networks: " + Show.getString(dm.getDownloadState().getNetworks()));
        out.println("Peer Sources: " + Show.getString(dm.getDownloadState().getPeerSources()));
        out.println("- Tracker Info -");
        TRTrackerAnnouncer trackerclient = dm.getTrackerClient();
        if (trackerclient != null) {
            String timestr;
            out.println("URL: " + trackerclient.getTrackerURL());
            try {
                int time = trackerclient.getTimeUntilNextUpdate();
                if (time < 0) {
                    timestr = MessageText.getString("GeneralView.label.updatein.querying");
                } else {
                    int minutes = time / 60;
                    int seconds = time % 60;
                    String strSeconds = "" + seconds;
                    if (seconds < 10) {
                        strSeconds = "0" + seconds;
                    }
                    timestr = String.valueOf(minutes) + ":" + strSeconds;
                }
            }
            catch (Exception e) {
                timestr = "unknown";
            }
            out.println("Time till next Update: " + timestr);
            out.println("Status: " + trackerclient.getStatusString());
        } else {
            out.println("  Not available");
        }
        out.println("- Files Info -");
        DiskManagerFileInfo[] files = dm.getDiskManagerFileInfo();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                out.print(String.valueOf(i < 9 ? "   " : "  ") + Integer.toString(i + 1) + " (");
                String tmp = ">";
                if (files[i].getPriority() > 0) {
                    tmp = "+";
                }
                if (files[i].isSkipped()) {
                    tmp = "!";
                }
                out.print(String.valueOf(tmp) + ") ");
                if (files[i] != null) {
                    long fLen = files[i].getLength();
                    if (fLen > 0L) {
                        DecimalFormat df = new DecimalFormat("000.0%");
                        out.print(df.format((double)files[i].getDownloaded() * 1.0 / (double)fLen));
                        out.println("\t" + files[i].getFile(true).getName());
                    } else {
                        out.println("Info not available.");
                    }
                } else {
                    out.println("Info not available.");
                }
                ++i;
            }
        } else {
            out.println("  Info not available.");
        }
        for (String arg : args) {
            if ((arg = arg.toLowerCase()).startsWith("pie")) {
                out.println("Pieces");
                PEPeerManager pm = dm.getPeerManager();
                if (pm == null) continue;
                PiecePicker picker = pm.getPiecePicker();
                PEPiece[] pieces = pm.getPieces();
                String line = "";
                int i = 0;
                while (i < pieces.length) {
                    String str = picker.getPieceString(i);
                    line = String.valueOf(line) + (line.length() == 0 ? String.valueOf(i) + " " : ",") + str;
                    PEPiece piece = pieces[i];
                    if (piece != null) {
                        line = String.valueOf(line) + ":" + piece.getString();
                    }
                    if ((i + 1) % 10 == 0) {
                        out.println(line);
                        line = "";
                    }
                    ++i;
                }
                if (line.length() <= 0) continue;
                out.println(line);
                continue;
            }
            if (!arg.startsWith("pee")) continue;
            out.println("Peers");
            PEPeerManager pm = dm.getPeerManager();
            if (pm == null) continue;
            List<PEPeer> peers = pm.getPeers();
            out.println("\tConnected to " + peers.size() + " peers");
            for (PEPeer peer : peers) {
                PEPeerStats stats2 = peer.getStats();
                System.out.println("\t\t" + peer.getIp() + ", in=" + (peer.isIncoming() ? "Y" : "N") + ", prot=" + peer.getProtocol() + ", choked=" + (peer.isChokingMe() ? "Y" : "N") + ", up=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(stats2.getDataSendRate() + stats2.getProtocolSendRate()) + ", down=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(stats2.getDataReceiveRate() + stats2.getProtocolReceiveRate()) + ", in_req=" + peer.getIncomingRequestCount() + ", out_req=" + peer.getOutgoingRequestCount());
            }
        }
        out.println("> -----");
    }

    protected void showDHTStats(ConsoleInput ci) {
        try {
            PluginInterface def = ci.core.getPluginManager().getDefaultPluginInterface();
            PluginInterface dht_pi = def.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (dht_pi == null) {
                ci.out.println("\tDHT isn't present");
                return;
            }
            DHTPlugin dht_plugin = (DHTPlugin)dht_pi.getPlugin();
            if (dht_plugin.getStatus() != 3) {
                ci.out.println("\tDHT isn't running yet (disabled or initialising)");
                return;
            }
            DHT[] dhts = dht_plugin.getDHTs();
            int i = 0;
            while (i < dhts.length) {
                if (i > 0) {
                    ci.out.println("");
                }
                DHT dht = dhts[i];
                DHTTransport transport = dht.getTransport();
                DHTTransportStats t_stats = transport.getStats();
                DHTDBStats d_stats = dht.getDataBase().getStats();
                DHTControlStats c_stats = dht.getControl().getStats();
                DHTRouterStats r_stats = dht.getRouter().getStats();
                long[] rs = r_stats.getStats();
                DHTNetworkPosition[] nps = transport.getLocalContact().getNetworkPositions();
                String np_str = "";
                int j = 0;
                while (j < nps.length) {
                    np_str = String.valueOf(np_str) + (j == 0 ? "" : ",") + nps[j];
                    ++j;
                }
                ci.out.println("DHT:ip=" + transport.getLocalContact().getAddress() + ",net=" + transport.getNetwork() + ",prot=V" + transport.getProtocolVersion() + ",np=" + np_str + ",sleeping=" + dht.isSleeping());
                ci.out.println("Router:nodes=" + rs[0] + ",leaves=" + rs[1] + ",contacts=" + rs[2] + ",replacement=" + rs[3] + ",live=" + rs[4] + ",unknown=" + rs[5] + ",failing=" + rs[6]);
                ci.out.println("Transport:" + t_stats.getString());
                int[] dbv_details = d_stats.getValueDetails();
                ci.out.println("Control:dht=" + c_stats.getEstimatedDHTSize() + ", Database:keys=" + d_stats.getKeyCount() + ",vals=" + dbv_details[0] + ",loc=" + dbv_details[1] + ",dir=" + dbv_details[2] + ",ind=" + dbv_details[3] + ",div_f=" + dbv_details[4] + ",div_s=" + dbv_details[5]);
                dht.getRouter().print();
                ++i;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(ci.out);
        }
    }

    private static String getString(String[] strs) {
        String res = "";
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            res = String.valueOf(res) + (res.isEmpty() ? "" : ",") + str;
            ++n2;
        }
        return res;
    }
}

