/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.none.internat;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuildMessageBundleNone {
    private static final String zeros = "000";
    public static final boolean COMPACT = true;
    public static final boolean doUTF8 = false;
    private static final Pattern PAT_PARAM_ALPHA = Pattern.compile("\\{([^0-9].+?)\\}");

    public static String toEscape(String str) {
        StringBuffer sb = new StringBuffer();
        char[] charArr = str.toCharArray();
        int i = 0;
        while (i < charArr.length) {
            if (charArr[i] == '\n') {
                sb.append("\\n");
            } else if (charArr[i] == '\t') {
                sb.append("\\t");
            } else if (charArr[i] >= '\u0000' && charArr[i] < '\u0080' && charArr[i] != '\\') {
                sb.append(charArr[i]);
            } else {
                sb.append(BuildMessageBundleNone.toEscape(charArr[i]));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String toEscape(char c) {
        char n = c;
        String body = Integer.toHexString(n);
        return "\\u" + zeros.substring(0, 4 - body.length()) + body;
    }

    public static String expandValue(String value, Properties properties, Map<String, String> defaultProps) {
        if (value != null && value.indexOf(125) > 0) {
            Matcher matcher = PAT_PARAM_ALPHA.matcher(value);
            while (matcher.find()) {
                String text;
                String key;
                block5: {
                    key = matcher.group(1);
                    text = properties.getProperty(key);
                    if (text != null || (text = defaultProps.get(key)) != null) break block5;
                    return null;
                }
                try {
                    value = value.replaceAll("\\Q{" + key + "}\\E", Matcher.quoteReplacement(text));
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
        }
        return value;
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        File[] files;
        System.setProperty("SKIP_SETRB", "1");
        File dirRoot = new File(args.length > 0 ? args[0] : "").getAbsoluteFile();
        String dest = args.length > 1 ? args[1] : "uis/src/com/biglybt/ui/none/internat";
        File dirNone = new File(dirRoot, dest);
        System.out.println(dirNone);
        System.out.println(dirRoot);
        File dirFullMB = new File(dirRoot, "core/src/com/biglybt/internat");
        System.out.println(dirFullMB);
        File fileNoneDefault = new File(dirNone, "MessagesBundle.properties");
        File fileFullDefault = new File(dirFullMB, "MessagesBundle.properties");
        FileInputStream fisFullDefault = new FileInputStream(fileFullDefault);
        Properties defaultFullProperties = new Properties();
        defaultFullProperties.load(fisFullDefault);
        fisFullDefault.close();
        String s = FileUtil.readFileAsString(fileNoneDefault, -1);
        String[] lines = s.split("\r?\n");
        s = "";
        File[] fileArray = files = dirFullMB.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".properties");
            }
        });
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            FileInputStream fisFullMB = new FileInputStream(file);
            Properties fullCurrentProperties = new Properties();
            fullCurrentProperties.load(fisFullMB);
            fisFullMB.close();
            File fileOut = new File(dirNone, file.getName());
            boolean isCurrentFileDefaultLang = !file.getName().contains("_");
            System.out.println("Process " + file.getName() + " to " + fileOut);
            BufferedWriter bw = new BufferedWriter(new FileWriter(fileOut));
            String[] stringArray = lines;
            int n3 = lines.length;
            int n4 = 0;
            while (n4 < n3) {
                block7: {
                    String line;
                    block4: {
                        block8: {
                            String expandedValue;
                            String[] key_val;
                            block10: {
                                String fullCurrentVal;
                                block5: {
                                    String expandedValue2;
                                    block9: {
                                        String defaultFullVal;
                                        block6: {
                                            line = stringArray[n4];
                                            key_val = line.split("=", 2);
                                            if (key_val.length != 2 || line.startsWith("#") || line.length() == 0) break block4;
                                            fullCurrentVal = fullCurrentProperties.getProperty(key_val[0]);
                                            if (fullCurrentVal != null) break block5;
                                            defaultFullVal = defaultFullProperties.getProperty(key_val[0]);
                                            if (defaultFullVal != null && defaultFullVal.contains("}")) break block6;
                                            if (!isCurrentFileDefaultLang) break block7;
                                            bw.write(line);
                                            break block8;
                                        }
                                        expandedValue2 = BuildMessageBundleNone.expandValue(defaultFullVal, fullCurrentProperties, MessageText.CONSTANTS);
                                        if (expandedValue2 != null) break block9;
                                        bw.write("# No expansion for " + defaultFullVal.replace("\n", "\\n"));
                                        bw.newLine();
                                        if (!isCurrentFileDefaultLang) break block7;
                                        bw.write(line);
                                        break block8;
                                    }
                                    bw.write(String.valueOf(key_val[0]) + "=" + BuildMessageBundleNone.toEscape(expandedValue2));
                                    break block8;
                                }
                                expandedValue = BuildMessageBundleNone.expandValue(fullCurrentVal, fullCurrentProperties, MessageText.CONSTANTS);
                                if (expandedValue != null) break block10;
                                if (!isCurrentFileDefaultLang) break block7;
                                bw.write("# No expansion for " + fullCurrentVal.replace("\n", "\\n"));
                                bw.newLine();
                                if (isCurrentFileDefaultLang) {
                                    bw.write(line);
                                }
                                break block8;
                            }
                            bw.write(String.valueOf(key_val[0]) + "=" + BuildMessageBundleNone.toEscape(expandedValue));
                        }
                        bw.newLine();
                        break block7;
                    }
                    if (isCurrentFileDefaultLang) {
                        bw.write(line);
                        bw.newLine();
                    }
                }
                ++n4;
            }
            bw.close();
            ++n2;
        }
    }
}

