/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.selectedcontent;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.ui.selectedcontent.DownloadUrlInfo;
import com.biglybt.ui.selectedcontent.ISelectedContent;

public class SelectedContent
implements ISelectedContent {
    private String hash;
    private DownloadManager dm;
    private int file_index = -1;
    private TOTorrent torrent;
    private String displayName;
    private DownloadUrlInfo downloadInfo;

    public SelectedContent(DownloadManager dm) {
        this.setDownloadManager(dm);
    }

    public SelectedContent(DownloadManager dm, int _file_index) {
        this.setDownloadManager(dm);
        this.file_index = _file_index;
    }

    public SelectedContent(String hash, String displayName) {
        this.hash = hash;
        this.displayName = displayName;
    }

    public SelectedContent() {
    }

    public SelectedContent(String dn) {
        this.displayName = dn;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public void setHash(String hash) {
        this.hash = hash;
    }

    @Override
    public DownloadManager getDownloadManager() {
        if (this.dm == null && this.hash != null) {
            try {
                GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                return gm.getDownloadManager(new HashWrapper(Base32.decode(this.hash)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.dm;
    }

    @Override
    public void setDownloadManager(DownloadManager _dm) {
        this.dm = _dm;
        if (this.dm != null) {
            this.setTorrent(this.dm.getTorrent());
            this.setDisplayName(this.dm.getDisplayName());
        }
    }

    @Override
    public int getFileIndex() {
        return this.file_index;
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public void setTorrent(TOTorrent _torrent) {
        this.torrent = _torrent;
        if (this.torrent != null) {
            try {
                this.hash = this.torrent.getHashWrapper().toBase32String();
            }
            catch (Exception e) {
                this.hash = null;
            }
        }
    }

    @Override
    public String getDisplayName() {
        String str = this.displayName;
        if (this.displayName == null || this.displayName.isEmpty()) {
            if (this.dm != null) {
                str = this.dm.getDisplayName();
            } else if (this.torrent != null) {
                str = new String(this.torrent.getName());
            } else if (this.downloadInfo != null) {
                str = this.downloadInfo.getDownloadURL();
            }
            if (this.file_index >= 0) {
                str = String.valueOf(str) + " (file=" + this.file_index + ")";
            }
        }
        return str;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public DownloadUrlInfo getDownloadInfo() {
        return this.downloadInfo;
    }

    public void setDownloadInfo(DownloadUrlInfo info) {
        this.downloadInfo = info;
    }

    @Override
    public boolean sameAs(ISelectedContent _other) {
        if (_other instanceof SelectedContent) {
            SelectedContent other = (SelectedContent)_other;
            if (!(this.hash == other.hash || this.hash != null && other.hash != null && this.hash.equals(other.hash))) {
                return false;
            }
            if (this.dm != other.dm || this.torrent != other.torrent || this.file_index != other.file_index) {
                return false;
            }
            if (!(this.displayName == other.displayName || this.displayName != null && other.displayName != null && this.displayName.equals(other.displayName))) {
                return false;
            }
            return this.downloadInfo == other.downloadInfo || this.downloadInfo != null && other.downloadInfo != null && this.downloadInfo.sameAs(other.downloadInfo);
        }
        return false;
    }
}

