/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.internat.MessageText;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import java.util.GregorianCalendar;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class DateWindow {
    private Shell shell = ShellFactory.createMainShell(3184);

    public DateWindow(String sTitleID, long current, boolean doTime, final DateReceiver receiver) {
        DateTime time;
        if (sTitleID != null) {
            this.shell.setText(MessageText.keyExists(sTitleID) ? MessageText.getString(sTitleID) : sTitleID);
        }
        Utils.setShellIcon(this.shell);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.shell.setLayout((Layout)layout);
        final DateTime calendar = new DateTime((Composite)this.shell, 0x10000400);
        GridData gridData = new GridData(1808);
        calendar.setLayoutData((Object)gridData);
        if (doTime) {
            time = new DateTime((Composite)this.shell, 0x10000080);
            gridData = new GridData(768);
            time.setLayoutData((Object)gridData);
        } else {
            time = null;
        }
        if (current >= 0L) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(current);
            calendar.setDate(cal.get(1), cal.get(2), cal.get(5));
            if (time != null) {
                time.setTime(cal.get(11), cal.get(12), cal.get(13));
            }
        }
        Composite panel = new Composite((Composite)this.shell, 0);
        RowLayout rLayout = new RowLayout();
        rLayout.marginTop = 0;
        rLayout.marginLeft = 0;
        rLayout.marginBottom = 0;
        rLayout.marginRight = 0;
        rLayout.fill = true;
        rLayout.spacing = Utils.BUTTON_MARGIN;
        panel.setLayout((Layout)rLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000008;
        panel.setLayoutData((Object)gridData);
        Button[] buttons = Utils.createOKCancelButtons(panel);
        final Button ok = buttons[0];
        Button cancel = buttons[1];
        ok.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                GregorianCalendar cal = new GregorianCalendar(calendar.getYear(), calendar.getMonth(), calendar.getDay());
                long millis = cal.getTimeInMillis();
                if (time != null) {
                    millis += (long)((time.getHours() * 60 * 60 + time.getMinutes() * 60 + time.getSeconds()) * 1000);
                }
                receiver.dateSelected(millis);
                DateWindow.this.shell.dispose();
            }
        });
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                DateWindow.this.shell.dispose();
            }
        });
        this.shell.setDefaultButton(ok);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b' && ok.isEnabled()) {
                    DateWindow.this.shell.dispose();
                }
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
            }
        });
        this.shell.pack();
        Utils.centreWindow(this.shell);
        this.shell.open();
    }

    public static interface DateReceiver {
        public void dateSelected(long var1);
    }
}

