/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.HostNameToIPResolver;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.utils.LocationProvider;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.ui.skin.SkinProperties;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImageRepository {
    private static final String[] noCacheExtList = new String[]{".exe"};
    private static final boolean forceNoAWT = Constants.isOSX || Constants.isWindows;
    private static volatile Set<String> ignore_icon_exts;
    private static LocationProvider flag_provider;
    private static long flag_provider_last_check;
    private static org.eclipse.swt.graphics.Image flag_none;
    private static Object flag_small_key;
    private static Object flag_big_key;
    private static Map<String, org.eclipse.swt.graphics.Image> flag_cache;
    private static Map<String, org.eclipse.swt.graphics.Image> net_images;

    static {
        COConfigurationManager.addWeakParameterListener(n -> {
            String val = COConfigurationManager.getStringParameter(n);
            val = val.replace(';', ' ');
            val = val.replace(',', ' ');
            val = val.toLowerCase(Locale.US);
            String[] bits = val.split(" ");
            HashSet<String> exts = new HashSet<String>();
            String[] stringArray = bits;
            int n2 = bits.length;
            int n3 = 0;
            while (n3 < n2) {
                String b = stringArray[n3];
                if (!(b = b.trim()).isEmpty()) {
                    if (!b.startsWith(".")) {
                        b = "." + b;
                    }
                    exts.add(b);
                }
                ++n3;
            }
            ignore_icon_exts = exts;
        }, true, "Ignore Icon Exts");
        flag_none = ImageLoader.getNoImage();
        flag_small_key = new Object();
        flag_big_key = new Object();
        flag_cache = new HashMap<String, org.eclipse.swt.graphics.Image>();
        net_images = new HashMap<String, org.eclipse.swt.graphics.Image>();
    }

    static void addPath(String path, String id) {
        SkinProperties[] skinProperties = ImageLoader.getInstance().getSkinProperties();
        if (skinProperties != null && skinProperties.length > 0) {
            skinProperties[0].addProperty(id, path);
        }
    }

    public static org.eclipse.swt.graphics.Image getIconFromExtension(File file, String ext, boolean bBig, boolean minifolder) {
        org.eclipse.swt.graphics.Image image;
        block24: {
            image = null;
            try {
                Program program;
                Class<?> enhancerClass;
                String key = "osicon" + ext;
                if (bBig) {
                    key = String.valueOf(key) + "-big";
                }
                if (minifolder) {
                    key = String.valueOf(key) + "-fold";
                }
                if (ImageLoader.isRealImage(image = ImageLoader.getInstance().getImage(key))) {
                    return image;
                }
                ImageLoader.getInstance().releaseImage(key);
                image = null;
                if (!Utils.isFileResponding(file)) break block24;
                ImageData imageData = null;
                if (Constants.isWindows) {
                    if (ignore_icon_exts.contains(ext.toLowerCase(Locale.US))) {
                        return ImageLoader.getInstance().getImage(minifolder ? "folder" : "transparent");
                    }
                    try {
                        enhancerClass = Class.forName("com.biglybt.ui.swt.win32.Win32UIEnhancer");
                        Method method = enhancerClass.getMethod("getFileIcon", File.class, Boolean.TYPE);
                        image = (org.eclipse.swt.graphics.Image)method.invoke(null, file, bBig);
                        if (image != null) {
                            if (!bBig) {
                                image = ImageRepository.force16height(image);
                            }
                            if (minifolder) {
                                image = ImageRepository.minifolderize(file.getParent(), image, bBig);
                            }
                            ImageLoader.getInstance().addImageNoDipose(key, image);
                            return image;
                        }
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                    }
                } else if (Constants.isOSX) {
                    try {
                        enhancerClass = Class.forName("com.biglybt.ui.swt.osx.CocoaUIEnhancer");
                        Method method = enhancerClass.getMethod("getFileIcon", String.class, Integer.TYPE);
                        image = (org.eclipse.swt.graphics.Image)method.invoke(null, file.getAbsolutePath(), bBig ? 128 : 16);
                        if (image != null) {
                            if (!bBig) {
                                image = ImageRepository.force16height(image);
                            }
                            if (minifolder) {
                                image = ImageRepository.minifolderize(file.getParent(), image, bBig);
                            }
                            ImageLoader.getInstance().addImageNoDipose(key, image);
                            return image;
                        }
                    }
                    catch (Throwable t) {
                        Debug.printStackTrace(t);
                    }
                }
                if (imageData == null && (program = Program.findProgram((String)ext)) != null) {
                    imageData = program.getImageData();
                }
                if (imageData != null) {
                    image = new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), imageData);
                    if (!bBig) {
                        image = ImageRepository.force16height(image);
                    }
                    if (minifolder) {
                        image = ImageRepository.minifolderize(file.getParent(), image, bBig);
                    }
                    ImageLoader.getInstance().addImageNoDipose(key, image);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (image == null) {
            return ImageLoader.getInstance().getImage(minifolder ? "folder" : "transparent");
        }
        return image;
    }

    private static org.eclipse.swt.graphics.Image minifolderize(String path, org.eclipse.swt.graphics.Image img, boolean big) {
        org.eclipse.swt.graphics.Image imgFolder = ImageLoader.getInstance().getImage(big ? "folder" : "foldersmall");
        Rectangle folderBounds = imgFolder.getBounds();
        Rectangle dstBounds = img.getBounds();
        org.eclipse.swt.graphics.Image tempImg = Utils.renderTransparency(Display.getCurrent(), img, imgFolder, new Point(dstBounds.width - folderBounds.width, dstBounds.height - folderBounds.height), 204);
        if (tempImg != null) {
            img.dispose();
            img = tempImg;
        }
        return img;
    }

    private static org.eclipse.swt.graphics.Image force16height(org.eclipse.swt.graphics.Image image) {
        if (image == null) {
            return image;
        }
        Rectangle bounds = image.getBounds();
        if (bounds.height != 16) {
            org.eclipse.swt.graphics.Image newImage = new org.eclipse.swt.graphics.Image(image.getDevice(), 16, 16);
            GC gc = new GC((Drawable)newImage);
            try {
                if (!Constants.isUnix) {
                    gc.setAdvanced(true);
                }
                gc.drawImage(image, 0, 0, bounds.width, bounds.height, 0, 0, 16, 16);
            }
            finally {
                gc.dispose();
            }
            image.dispose();
            image = newImage;
        }
        return image;
    }

    public static org.eclipse.swt.graphics.Image getPathIcon(String path, boolean bBig, boolean minifolder) {
        String ext;
        if (path == null) {
            return null;
        }
        File file = null;
        boolean bDeleteFile = false;
        boolean noAWT = forceNoAWT || !bBig;
        try {
            String key;
            file = new File(path);
            if (Utils.isDirectoryWithTimeout(file)) {
                if (noAWT) {
                    if (Constants.isWindows || Constants.isOSX) {
                        return ImageRepository.getIconFromExtension(file, "-folder", bBig, false);
                    }
                    return ImageLoader.getInstance().getImage("folder");
                }
                key = file.getPath();
            } else {
                int idxDot = file.getName().lastIndexOf(".");
                if (idxDot == -1) {
                    if (noAWT) {
                        return ImageRepository.getIconFromExtension(file, "", bBig, false);
                    }
                    key = "?!blank";
                } else {
                    String ext2;
                    key = ext2 = file.getName().substring(idxDot);
                    if (noAWT) {
                        return ImageRepository.getIconFromExtension(file, ext2, bBig, minifolder);
                    }
                    int i = 0;
                    while (i < noCacheExtList.length) {
                        if (noCacheExtList[i].equalsIgnoreCase(ext2)) {
                            key = file.getPath();
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (bBig) {
                key = String.valueOf(key) + "-big";
            }
            if (minifolder) {
                key = String.valueOf(key) + "-fold";
            }
            key = "osicon" + key;
            org.eclipse.swt.graphics.Image image = ImageLoader.getInstance().getImage(key);
            if (ImageLoader.isRealImage(image)) {
                return image;
            }
            ImageLoader.getInstance().releaseImage(key);
            image = null;
            boolean bl = bDeleteFile = !Utils.fileExistsWithTimeout(file);
            if (bDeleteFile) {
                file = File.createTempFile("AZ_", FileUtil.getExtension(path));
            }
            Image awtImage = null;
            try {
                Object sfInstance;
                Method method;
                Class<?> sfClass = Class.forName("sun.awt.shell.ShellFolder");
                if (sfClass != null && file != null && (method = sfClass.getMethod("getShellFolder", File.class)) != null && (sfInstance = method.invoke(null, file)) != null && (method = sfClass.getMethod("getIcon", Boolean.TYPE)) != null) {
                    awtImage = (Image)method.invoke(sfInstance, bBig);
                }
            }
            catch (Throwable sfClass) {
                // empty catch block
            }
            if (awtImage != null) {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)((BufferedImage)awtImage), "png", outStream);
                ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
                image = new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), (InputStream)inStream);
                if (!bBig) {
                    image = ImageRepository.force16height(image);
                }
                if (minifolder) {
                    image = ImageRepository.minifolderize(file.getParent(), image, bBig);
                }
                ImageLoader.getInstance().addImageNoDipose(key, image);
                if (bDeleteFile && file != null && Utils.fileExistsWithTimeout(file)) {
                    file.delete();
                }
                return image;
            }
        }
        catch (Exception key) {
            // empty catch block
        }
        if (bDeleteFile && file != null && Utils.fileExistsWithTimeout(file)) {
            file.delete();
        }
        if ((ext = FileUtil.getExtension(path)).length() == 0) {
            return ImageLoader.getInstance().getImage("folder");
        }
        return ImageRepository.getIconFromExtension(file, ext, bBig, minifolder);
    }

    private static LocationProvider getFlagProvider() {
        if (flag_provider != null && flag_provider.isDestroyed()) {
            flag_provider = null;
            flag_provider_last_check = 0L;
        }
        if (flag_provider == null) {
            long now = SystemTime.getMonotonousTime();
            if (flag_provider_last_check == 0L || now - flag_provider_last_check > 20000L) {
                flag_provider_last_check = now;
                List<LocationProvider> providers = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getUtilities().getLocationProviders();
                for (LocationProvider provider : providers) {
                    if (!provider.hasCapabilities(6L)) continue;
                    flag_provider = provider;
                }
            }
        }
        return flag_provider;
    }

    public static boolean hasCountryFlags(boolean small) {
        if (!Utils.isSWTThread()) {
            Debug.out("Needs to be swt thread...");
            return false;
        }
        LocationProvider fp = ImageRepository.getFlagProvider();
        return fp != null;
    }

    public static org.eclipse.swt.graphics.Image getCountryFlag(Peer peer, boolean small) {
        return ImageRepository.getCountryFlag(PluginCoreUtils.unwrap(peer), small);
    }

    public static org.eclipse.swt.graphics.Image getCountryFlag(PEPeer peer, boolean small) {
        LocationProvider fp;
        if (peer == null) {
            return null;
        }
        Object peer_key = small ? flag_small_key : flag_big_key;
        org.eclipse.swt.graphics.Image flag = (org.eclipse.swt.graphics.Image)peer.getUserData(peer_key);
        if (flag == null && (fp = ImageRepository.getFlagProvider()) != null) {
            try {
                String ip = peer.getIp();
                if (HostNameToIPResolver.isDNSName(ip)) {
                    InetAddress peer_address = HostNameToIPResolver.syncResolve(ip);
                    String cc_key = String.valueOf(fp.getISO3166CodeForIP(peer_address)) + (small ? ".s" : ".l");
                    flag = flag_cache.get(cc_key);
                    if (flag != null) {
                        peer.setUserData(peer_key, flag);
                    } else {
                        InputStream is = fp.getCountryFlagForIP(peer_address, small ? 0 : 1);
                        if (is != null) {
                            try {
                                Display display = Display.getDefault();
                                flag = new org.eclipse.swt.graphics.Image((Device)display, is);
                            }
                            finally {
                                is.close();
                            }
                        } else {
                            flag = flag_none;
                        }
                        flag_cache.put(cc_key, flag);
                        peer.setUserData(peer_key, flag);
                    }
                } else {
                    String cat = AENetworkClassifier.categoriseAddress(ip);
                    if (cat != "Public") {
                        final String key = "net_" + cat + (small ? "_s" : "_b");
                        org.eclipse.swt.graphics.Image i = net_images.get(key);
                        if (i == null) {
                            Utils.execSWTThread(new Runnable(){

                                @Override
                                public void run() {
                                    org.eclipse.swt.graphics.Image i = ImageLoader.getInstance().getImage(key);
                                    net_images.put(key, i);
                                }
                            }, false);
                            i = net_images.get(key);
                        }
                        if (ImageLoader.isRealImage(i)) {
                            return i;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (flag == flag_none) {
            return null;
        }
        return flag;
    }

    public static org.eclipse.swt.graphics.Image getCountryFlag(InetAddress address, boolean small) {
        if (address == null) {
            return null;
        }
        org.eclipse.swt.graphics.Image flag = null;
        LocationProvider fp = ImageRepository.getFlagProvider();
        if (fp != null) {
            try {
                String cc_key = String.valueOf(fp.getISO3166CodeForIP(address)) + (small ? ".s" : ".l");
                flag = flag_cache.get(cc_key);
                if (flag == null) {
                    InputStream is = fp.getCountryFlagForIP(address, small ? 0 : 1);
                    if (is != null) {
                        try {
                            Display display = Display.getDefault();
                            flag = new org.eclipse.swt.graphics.Image((Device)display, is);
                        }
                        finally {
                            is.close();
                        }
                    } else {
                        flag = flag_none;
                    }
                    flag_cache.put(cc_key, flag);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (flag == flag_none) {
            return null;
        }
        return flag;
    }

    public static org.eclipse.swt.graphics.Image getCountryFlag(String cc, boolean small) {
        if (cc == null) {
            return null;
        }
        if (AENetworkClassifier.internalise(cc) == cc) {
            final String key = "net_" + cc + (small ? "_s" : "_b");
            org.eclipse.swt.graphics.Image i = net_images.get(key);
            if (i == null) {
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        org.eclipse.swt.graphics.Image i = ImageLoader.getInstance().getImage(key);
                        net_images.put(key, i);
                    }
                }, false);
                i = net_images.get(key);
            }
            if (ImageLoader.isRealImage(i)) {
                return i;
            }
        }
        org.eclipse.swt.graphics.Image flag = null;
        LocationProvider fp = ImageRepository.getFlagProvider();
        if (fp != null) {
            try {
                String cc_key = String.valueOf(cc) + (small ? ".s" : ".l");
                flag = flag_cache.get(cc_key);
                if (flag == null) {
                    InputStream is = fp.getCountryFlagForISO3166Code(cc, small ? 0 : 1);
                    if (is != null) {
                        try {
                            Display display = Display.getDefault();
                            flag = new org.eclipse.swt.graphics.Image((Device)display, is);
                        }
                        finally {
                            is.close();
                        }
                    } else {
                        flag = flag_none;
                    }
                    flag_cache.put(cc_key, flag);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (flag == flag_none) {
            return null;
        }
        return flag;
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display, 1264);
        shell.setLayout((Layout)new FillLayout(512));
        final Label label = new Label((Composite)shell, 2048);
        final Text text = new Text((Composite)shell, 2048);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                org.eclipse.swt.graphics.Image pathIcon = ImageRepository.getPathIcon(text.getText(), false, false);
                label.setImage(pathIcon);
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

