/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.Core;
import com.biglybt.core.CoreComponent;
import com.biglybt.core.CoreException;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreLifecycleAdapter;
import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.messenger.ClientMessageContext;
import com.biglybt.core.messenger.PlatformMessenger;
import com.biglybt.core.security.SESecurityManager;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DelayedEvent;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.installer.InstallablePlugin;
import com.biglybt.pif.installer.PluginInstallerListener;
import com.biglybt.pif.installer.StandardPlugin;
import com.biglybt.pif.utils.DelayedTask;
import com.biglybt.pifimpl.local.utils.UtilitiesImpl;
import com.biglybt.ui.IUIIntializer;
import com.biglybt.ui.InitializerListener;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.common.StartServer;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.Alerts;
import com.biglybt.ui.swt.LocaleUtilSWT;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.UISwitcherUtil;
import com.biglybt.ui.swt.UserAlerts;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.auth.AuthenticatorWindow;
import com.biglybt.ui.swt.auth.CertificateTrustWindow;
import com.biglybt.ui.swt.auth.CryptoWindow;
import com.biglybt.ui.swt.browser.listener.ConfigListener;
import com.biglybt.ui.swt.browser.listener.DisplayListener;
import com.biglybt.ui.swt.browser.listener.TorrentListener;
import com.biglybt.ui.swt.browser.listener.VuzeListener;
import com.biglybt.ui.swt.browser.msg.MessageDispatcherSWT;
import com.biglybt.ui.swt.devices.DeviceManagerUI;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mainwindow.SWTThread;
import com.biglybt.ui.swt.mainwindow.SWTThreadAlreadyInstanciatedException;
import com.biglybt.ui.swt.mainwindow.SplashWindow;
import com.biglybt.ui.swt.networks.SWTNetworkSelection;
import com.biglybt.ui.swt.pifimpl.UIToolBarManagerImpl;
import com.biglybt.ui.swt.progress.ProgressReportingManager;
import com.biglybt.ui.swt.progress.ProgressWindow;
import com.biglybt.ui.swt.search.SearchUI;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.shells.PopOutManager;
import com.biglybt.ui.swt.shells.main.MainWindowFactory;
import com.biglybt.ui.swt.shells.opentorrent.OpenTorrentOptionsWindow;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinPropertiesImpl;
import com.biglybt.ui.swt.subscriptions.SubscriptionManagerUI;
import com.biglybt.ui.swt.uiupdater.UIUpdaterSWT;
import com.biglybt.ui.swt.update.UpdateMonitor;
import com.biglybt.ui.swt.updater2.SWTUpdateChecker;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.utils.ColorCache2;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.utils.TorrentUIUtilsV3;
import com.biglybt.ui.swt.utils.UIMagnetHandler;
import com.biglybt.util.InitialisationFunctions;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.widgets.Display;

public class Initializer
implements IUIIntializer {
    private static boolean STARTUP_UIFIRST = System.getProperty("ui.startfirst", "1").equals("1");
    public static final long startTime = System.currentTimeMillis();
    private final CoreLifecycleAdapter coreLifecycleAdapter;
    private StartServer startServer;
    private final Core core;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private AEMonitor listeners_mon = new AEMonitor("Initializer:l");
    private int curPercent = 0;
    private AESemaphore semFilterLoader = new AESemaphore("filter loader");
    private AESemaphore init_task = new AESemaphore("delayed init");
    private MainWindowFactory.MainWindowInitStub windowInitStub;
    private static Initializer lastInitializer;
    private DeviceManagerUI deviceManagerUI;
    private SubscriptionManagerUI subscriptionManagerUI;

    public Initializer(final Core core, StartServer startServer) {
        this.core = core;
        this.startServer = startServer;
        lastInitializer = this;
        AEThread filterLoaderThread = new AEThread("filter loader", true){

            @Override
            public void runSupport() {
                try {
                    core.getIpFilterManager().getIPFilter();
                }
                finally {
                    Initializer.this.semFilterLoader.releaseForever();
                }
            }
        };
        filterLoaderThread.setPriority(1);
        filterLoaderThread.start();
        this.coreLifecycleAdapter = new CoreLifecycleAdapter(){

            @Override
            public void stopped(Core core) {
                SWTThread instance = SWTThread.getInstance();
                if (instance != null) {
                    instance.terminate();
                }
            }
        };
        core.addLifecycleListener(this.coreLifecycleAdapter);
        Utils.initStatic(core);
        try {
            SWTThread.createInstance(this);
        }
        catch (SWTThreadAlreadyInstanciatedException e) {
            Debug.printStackTrace(e);
        }
    }

    private void cleanupOldStuff() {
        File dirMedia;
        File dirFriends;
        File v3Shares = new File(SystemProperties.getUserPath(), "v3shares");
        if (v3Shares.isDirectory()) {
            FileUtil.recursiveDeleteNoCheck(v3Shares);
        }
        if ((dirFriends = new File(SystemProperties.getUserPath(), "friends")).isDirectory()) {
            FileUtil.recursiveDeleteNoCheck(dirFriends);
        }
        if ((dirMedia = new File(SystemProperties.getUserPath(), "media")).isDirectory()) {
            FileUtil.recursiveDeleteNoCheck(dirMedia);
        }
        this.deleteConfig("v3.Friends.dat");
        this.deleteConfig("unsentdata.config");
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(final Core core) {
                new AEThread2("cleanupOldStuff", true){

                    @Override
                    public void run() {
                        GlobalManager gm = core.getGlobalManager();
                        List<DownloadManager> dms = gm.getDownloadManagers();
                        for (DownloadManager o : dms) {
                            String val;
                            DownloadManager dm = o;
                            if (dm == null || (val = PlatformTorrentUtils.getContentMapString(dm.getTorrent(), "Ad ID")) == null) continue;
                            try {
                                gm.removeDownloadManager(dm, true, true);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }.start();
            }
        });
    }

    private void deleteConfig(String name) {
        File file2;
        try {
            file2 = new File(SystemProperties.getUserPath(), name);
            if (file2.exists()) {
                file2.delete();
            }
        }
        catch (Exception file2) {
            // empty catch block
        }
        try {
            file2 = new File(SystemProperties.getUserPath(), String.valueOf(name) + ".bak");
            if (file2.exists()) {
                file2.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void runInSWTThread() {
        UISwitcherUtil.calcUIMode();
        try {
            this.initializePlatformClientMessageContext();
        }
        catch (Exception e) {
            Debug.out(e);
        }
        new AEThread2("cleanupOldStuff", true){

            @Override
            public void run() {
                Initializer.this.cleanupOldStuff();
            }
        }.start();
        COConfigurationManager.setBooleanDefault("ui.startfirst", true);
        boolean bl = STARTUP_UIFIRST = STARTUP_UIFIRST && COConfigurationManager.getBooleanParameter("ui.startfirst", true);
        if (!STARTUP_UIFIRST) {
            return;
        }
        Colors.getInstance();
        this.checkInstallID();
        this.windowInitStub = MainWindowFactory.createAsync(Display.getDefault(), this);
    }

    @Override
    public void shutdownUIOnly() {
        if (this.coreLifecycleAdapter != null) {
            this.core.removeLifecycleListener(this.coreLifecycleAdapter);
        }
        if (this.deviceManagerUI != null) {
            this.deviceManagerUI.dispose();
            this.deviceManagerUI = null;
        }
        if (this.subscriptionManagerUI != null) {
            this.subscriptionManagerUI = null;
        }
        if (this.windowInitStub != null) {
            this.windowInitStub.dispose();
            this.windowInitStub = null;
        }
        UpdateMonitor.destroySingleton();
        UserAlerts.destroySingleton();
        UIUpdaterSWT.destroyInstance();
        ProgressReportingManager.destroyInstance();
        UIToolBarManagerImpl.destroyInstance();
        SelectedContentManager.destroyStatic();
        UIFunctionsManager.setUIFunctions(null);
        SWTSkin.disposeDefault();
        Utils.dispose();
        ImageLoader.disposeInstance();
        TorrentUIUtilsV3.disposeStatic();
        Colors.disposeInstance();
        ColorCache.dispose();
        ColorCache2.dispose();
        FontUtils.dispose();
        SWTSkinPropertiesImpl.destroyStatics();
        ProgressWindow.unregister();
        OpenTorrentOptionsWindow.close();
    }

    private void checkInstallID() {
        String storedInstallID = COConfigurationManager.getStringParameter("install.id", null);
        String installID = "";
        File file = FileUtil.getApplicationFile("installer.log");
        if (file != null) {
            try {
                String s = FileUtil.readFileAsString(file, 1024);
                String[] split = s.split("[\r\n]");
                int i = 0;
                while (i < split.length) {
                    int posEquals = split[i].indexOf(61);
                    if (posEquals > 0 && split[i].length() > posEquals + 1) {
                        installID = split[i].substring(posEquals + 1);
                    }
                    ++i;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (storedInstallID == null || !storedInstallID.equals(installID)) {
            COConfigurationManager.setParameter("install.id", installID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        DelayedTask delayed_task = UtilitiesImpl.addDelayedTask("SWT Initialisation", new Runnable(){

            @Override
            public void run() {
                Initializer.this.init_task.reserve();
            }
        });
        delayed_task.queueFirst();
        long startTime = SystemTime.getCurrentTime();
        new LocaleUtilSWT(this.core);
        final Display display = Utils.getDisplay();
        new UIMagnetHandler(this.core);
        if (!STARTUP_UIFIRST) {
            Colors.getInstance();
        } else {
            COConfigurationManager.setBooleanDefault("Show Splash", false);
        }
        if (COConfigurationManager.getBooleanParameter("Show Splash")) {
            display.asyncExec((Runnable)new AERunnable(){

                @Override
                public void runSupport() {
                    new SplashWindow(display, Initializer.this);
                }
            });
        }
        System.out.println("Locale Initializing took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        this.core.addLifecycleListener(new CoreLifecycleAdapter(){

            @Override
            public void componentCreated(Core core, CoreComponent component) {
                Initializer.this.reportPercent(Initializer.this.curPercent + 1);
                if (component instanceof GlobalManager) {
                    Initializer.this.reportCurrentTaskByKey("splash.initializePlugins");
                    InitialisationFunctions.earlyInitialisation(core);
                } else if (component instanceof PluginInterface) {
                    PluginInterface pi = (PluginInterface)((Object)component);
                    String name = pi.getPluginName();
                    String version = pi.getPluginVersion();
                    String s = String.valueOf(MessageText.getString("splash.plugin.init")) + " " + name + (version == null ? "" : " v" + version);
                    Initializer.this.reportCurrentTask(s);
                }
            }

            @Override
            public void started(Core core) {
                Initializer.this.handleCoreStarted(core);
            }

            @Override
            public void stopping(Core core) {
                Initializer.this.handleCoreStopping();
            }

            @Override
            public void stopped(Core core) {
            }

            @Override
            public boolean syncInvokeRequired() {
                return true;
            }

            @Override
            public boolean requiresPluginInitCompleteBeforeStartedEvent() {
                return false;
            }

            @Override
            public boolean stopRequested(Core _core) throws CoreException {
                return Initializer.handleStopRestart(false);
            }

            @Override
            public boolean restartRequested(Core core) {
                return Initializer.handleStopRestart(true);
            }
        });
        this.reportCurrentTaskByKey("splash.initializeCore");
        boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
        try {
            new SearchUI();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        try {
            this.subscriptionManagerUI = new SubscriptionManagerUI();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        if (!uiClassic) {
            try {
                this.deviceManagerUI = new DeviceManagerUI(this.core);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        int wait = 15;
        MessageBoxShell[] wait_shell = new MessageBoxShell[1];
        boolean[] abandon = new boolean[1];
        while (!this.core.canStart(wait)) {
            Object sem;
            boolean[] blArray = abandon;
            // MONITORENTER : abandon
            if (abandon[0]) {
                CoreWaiterSWT.startupAbandoned();
                sem = new AESemaphore("waiter");
                Utils.execSWTThread(new Runnable((AESemaphore)sem){
                    private final /* synthetic */ AESemaphore val$sem;
                    {
                        this.val$sem = aESemaphore;
                    }

                    @Override
                    public void run() {
                        MessageBoxShell mb = new MessageBoxShell(MessageText.getString("msgbox.force.close.title"), MessageText.getString("msgbox.force.close.text", new String[]{Initializer.this.core.getLockFile().getAbsolutePath()}), new String[]{MessageText.getString("Button.ok")}, 0);
                        mb.setIconResource("error");
                        mb.setModal(true);
                        mb.open(new UserPrompterResultListener(){

                            @Override
                            public void prompterClosed(int result) {
                                val$sem.releaseForever();
                            }
                        });
                    }
                });
                ((AESemaphore)sem).reserve();
                SESecurityManager.exitVM(1);
            }
            // MONITOREXIT : blArray
            wait = 3;
            boolean show_wait = false;
            sem = wait_shell;
            // MONITORENTER : wait_shell
            show_wait = wait_shell[0] == null;
            // MONITOREXIT : sem
            if (!show_wait) continue;
            sem = new AESemaphore("wait");
            Utils.execSWTThread(() -> Initializer.lambda$0((AESemaphore)sem, wait_shell, abandon));
            ((AESemaphore)sem).reserve();
        }
        MessageBoxShell[] messageBoxShellArray = wait_shell;
        // MONITORENTER : wait_shell
        if (wait_shell[0] != null) {
            Utils.execSWTThread(() -> wait_shell[0].close());
        }
        // MONITOREXIT : messageBoxShellArray
        if (!this.core.isStarted()) {
            this.core.start();
        } else {
            this.handleCoreStarted(this.core);
        }
        this.reportPercent(50);
        System.out.println("Core Initializing took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        this.reportCurrentTaskByKey("splash.initializeUIElements");
        Colors.getInstance();
        this.reportPercent(this.curPercent + 1);
        Alerts.init();
        this.reportPercent(this.curPercent + 1);
        ProgressWindow.register(this.core);
        this.reportPercent(this.curPercent + 1);
        new SWTNetworkSelection();
        this.reportPercent(this.curPercent + 1);
        new AuthenticatorWindow();
        new CryptoWindow();
        this.reportPercent(this.curPercent + 1);
        new CertificateTrustWindow();
        this.core.getPluginManager().getPluginInstaller().addListener(new PluginInstallerListener(){

            @Override
            public boolean installRequest(String reason, InstallablePlugin plugin) throws PluginException {
                if (plugin instanceof StandardPlugin) {
                    HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
                    properties.put(6, reason);
                    plugin.install(false, false, false, properties);
                    return true;
                }
                return false;
            }
        });
    }

    void handleCoreStarted(Core core) {
        boolean main_window_will_report_complete = false;
        try {
            GlobalManager gm = core.getGlobalManager();
            InitialisationFunctions.lateInitialisation(core);
            if (gm == null) {
                return;
            }
            Colors.getInstance();
            this.reportPercent(this.curPercent + 1);
            new UserAlerts(gm);
            this.reportCurrentTaskByKey("splash.initializeGui");
            this.reportPercent(this.curPercent + 1);
            main_window_will_report_complete = true;
            if (STARTUP_UIFIRST) {
                this.windowInitStub.init(core);
            } else {
                MainWindowFactory.create(core, Display.getDefault(), this);
            }
            this.reportCurrentTaskByKey("splash.openViews");
            SWTUpdateChecker.initialize();
            UpdateMonitor.getSingleton(core);
            Alerts.initComplete();
            OpenTorrentOptionsWindow.initialise();
            PopOutManager.initialise(core);
        }
        finally {
            if (!main_window_will_report_complete) {
                this.init_task.release();
            }
        }
    }

    void handleCoreStopping() {
        Alerts.stopInitiated();
        OpenTorrentOptionsWindow.close();
    }

    @Override
    public void stopIt(final boolean isForRestart) throws CoreException {
        SWTThread instance;
        block16: {
            if (this.core != null && isForRestart) {
                this.core.checkRestartSupported();
            }
            try {
                if (this.core == null) break block16;
                try {
                    long lStopStarted = System.currentTimeMillis();
                    System.out.println("core.stop");
                    final AESemaphore stop_sem = new AESemaphore("stop");
                    final CoreOperationTask.ProgressCallbackAdapter prog = new CoreOperationTask.ProgressCallbackAdapter(){

                        @Override
                        public int getStyle() {
                            return 7;
                        }

                        @Override
                        public int getDelay() {
                            return 3000;
                        }

                        @Override
                        public int getSupportedTaskStates() {
                            return 40;
                        }

                        @Override
                        public void setTaskState(int state) {
                            UIFunctionsSWT functionsSWT;
                            if (state == 32 && (functionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT()) != null) {
                                functionsSWT.getMainWindow().setVisible(100, false);
                            }
                        }
                    };
                    boolean show_progress = COConfigurationManager.getBooleanParameter("Tidy Close With Progress");
                    if (show_progress) {
                        if (Utils.isSWTThread()) {
                            Debug.out("Can't run closedown progress window as already on SWT thread");
                        } else {
                            Utils.execSWTThread(() -> FileUtil.runAsTask(3, new CoreOperationTask(){

                                @Override
                                public String getName() {
                                    return MessageText.getString(isForRestart ? "label.restarting.app" : "label.closing.app");
                                }

                                @Override
                                public DownloadManager getDownload() {
                                    return null;
                                }

                                @Override
                                public boolean runOperation(CoreOperation operation) {
                                    try {
                                        stop_sem.reserve();
                                    }
                                    catch (Throwable e) {
                                        throw new RuntimeException(e);
                                    }
                                    return true;
                                }

                                @Override
                                public CoreOperationTask.ProgressCallback getProgressCallback() {
                                    return prog;
                                }
                            }));
                        }
                    }
                    try {
                        if (isForRestart) {
                            this.core.restart(prog);
                        } else {
                            this.core.stop(prog);
                        }
                    }
                    finally {
                        stop_sem.release();
                    }
                    System.out.println("core.stop done in " + (System.currentTimeMillis() - lStopStarted));
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            finally {
                UIUpdaterSWT.destroyInstance();
                if (this.startServer != null) {
                    this.startServer.stopIt();
                }
            }
        }
        if ((instance = SWTThread.getInstance()) != null) {
            instance.terminate();
        }
    }

    @Override
    public void addListener(InitializerListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.add(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public void removeListener(InitializerListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.remove(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public void reportCurrentTask(String currentTaskString) {
        try {
            this.listeners_mon.enter();
            for (InitializerListener listener : this.listeners) {
                try {
                    listener.reportCurrentTask(currentTaskString);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    private void reportCurrentTaskByKey(String key) {
        this.reportCurrentTask(MessageText.getString(key));
    }

    @Override
    public void increaseProgress() {
        if (this.curPercent < 100) {
            this.reportPercent(this.curPercent + 1);
        }
    }

    @Override
    public void abortProgress() {
        this.reportPercent(101);
    }

    @Override
    public void reportPercent(int percent) {
        if (this.curPercent > percent) {
            return;
        }
        this.curPercent = percent;
        try {
            this.listeners_mon.enter();
            for (InitializerListener listener : this.listeners) {
                try {
                    listener.reportPercent(percent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (percent > 100) {
                this.listeners.clear();
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public void initializationComplete() {
        this.core.getPluginManager().firePluginEvent(6);
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                new DelayedEvent("SWTInitComplete:delay", 500L, new AERunnable(){

                    @Override
                    public void runSupport() {
                        Initializer.this.init_task.release();
                    }
                });
            }
        });
    }

    private void initializePlatformClientMessageContext() {
        ClientMessageContext clientMsgContext = PlatformMessenger.getClientMessageContext();
        if (clientMsgContext != null) {
            clientMsgContext.setMessageDispatcher(new MessageDispatcherSWT(clientMsgContext));
            clientMsgContext.addMessageListener(new TorrentListener());
            clientMsgContext.addMessageListener(new VuzeListener());
            clientMsgContext.addMessageListener(new DisplayListener(null));
            clientMsgContext.addMessageListener(new ConfigListener(null));
        }
    }

    public static boolean handleStopRestart(boolean restart) {
        UIFunctionsSWT functionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (functionsSWT != null) {
            return functionsSWT.dispose(restart);
        }
        return false;
    }

    public static Initializer getLastInitializer() {
        return lastInitializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$0(AESemaphore aESemaphore, MessageBoxShell[] messageBoxShellArray, boolean[] blArray) {
        MessageBoxShell mb;
        try {
            mb = new MessageBoxShell(MessageText.getString("msgbox.startup.stall.title"), MessageText.getString("msgbox.startup.stall.text"), new String[]{MessageText.getString("Button.abort")}, 0);
            MessageBoxShell[] messageBoxShellArray2 = messageBoxShellArray;
            synchronized (messageBoxShellArray) {
                messageBoxShellArray[0] = mb;
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        finally {
            aESemaphore.release();
        }
        {
            mb.setIconResource("warning");
            mb.setModal(true);
            mb.open(result -> {
                boolean[] blArray2 = blArray;
                synchronized (blArray) {
                    blArray[0] = true;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            });
            return;
        }
    }
}

