/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.ui.Graphic;
import com.biglybt.pif.ui.GraphicURI;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.pifimpl.local.ui.menus.MenuItemImpl;
import com.biglybt.pifimpl.local.ui.tables.TableContextMenuItemImpl;
import com.biglybt.pifimpl.local.utils.FormattersImpl;
import com.biglybt.plugin.I2PHelpers;
import com.biglybt.plugin.net.buddy.BuddyPluginBeta;
import com.biglybt.plugin.net.buddy.BuddyPluginUtils;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.swt.ConfigKeysSWT;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.pif.UISWTGraphic;
import com.biglybt.ui.swt.plugin.net.buddy.swt.BuddyUIUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class MenuBuildUtils {
    public static final PluginMenuController BASIC_MENU_ITEM_CONTROLLER = new MenuItemPluginMenuControllerImpl(null);
    private static AtomicBoolean pub_chat_pending = new AtomicBoolean();
    private static AtomicBoolean anon_chat_pending = new AtomicBoolean();

    public static void addMaintenanceListenerForMenu(Menu menu, MenuBuilder builder) {
        MenuBuildUtils.addMaintenanceListenerForMenu(menu, builder, false);
    }

    public static void addMaintenanceListenerForMenu(final Menu menu, final MenuBuilder builder, final boolean alwaysBuilt) {
        MenuListener menuListener = new MenuListener(){
            boolean bShown = false;

            public void menuHidden(MenuEvent e) {
                this.bShown = false;
                if (Constants.isOSX || alwaysBuilt) {
                    return;
                }
                e.widget.getDisplay().asyncExec((Runnable)new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (bShown || menu.isDisposed()) {
                            return;
                        }
                        Utils.disposeSWTObjects(menu.getItems());
                        if (Constants.isLinux) {
                            new MenuItem(menu, 2);
                        }
                    }
                });
            }

            public void menuShown(MenuEvent e) {
                Utils.disposeSWTObjects(menu.getItems());
                this.bShown = true;
                builder.buildMenu(menu, e);
                if (Constants.isLinux && menu.getItemCount() == 0) {
                    new MenuItem(menu, 2);
                }
            }
        };
        menu.addMenuListener(menuListener);
        if (alwaysBuilt) {
            Event e = new Event();
            e.type = 22;
            e.display = menu.getDisplay();
            e.widget = menu;
            menuListener.menuShown(new MenuEvent(e));
        } else if (Constants.isLinux) {
            new MenuItem(menu, 2);
        }
    }

    public static void addPluginMenuItems(com.biglybt.pif.ui.menus.MenuItem[] items, Menu parent, boolean prev_was_separator, final boolean enable_items, final PluginMenuController controller) {
        controller.buildStarts(parent);
        int i = 0;
        while (i < items.length) {
            final MenuItemImpl az_menuitem = (MenuItemImpl)items[i];
            controller.notifyFillListeners(az_menuitem);
            if (az_menuitem.isVisible()) {
                int swt_style;
                int style = az_menuitem.getStyle();
                boolean this_is_separator = false;
                boolean is_container = false;
                if (style == 5) {
                    swt_style = 64;
                    is_container = true;
                } else if (style == 1) {
                    swt_style = 8;
                } else if (style == 2) {
                    swt_style = 32;
                } else if (style == 3) {
                    swt_style = 16;
                } else if (style == 4) {
                    this_is_separator = true;
                    swt_style = 2;
                } else {
                    swt_style = 8;
                }
                if (!(prev_was_separator && this_is_separator || this_is_separator && i == items.length - 1)) {
                    prev_was_separator = this_is_separator;
                    if (this_is_separator) {
                        MenuBuildUtils.addSeparator(parent);
                    } else {
                        final MenuItem menuItem = new MenuItem(parent, swt_style);
                        if (enable_items && (style == 2 || style == 3)) {
                            Boolean selection_value = (Boolean)az_menuitem.getData();
                            if (selection_value == null) {
                                throw new RuntimeException("MenuItem with resource name \"" + az_menuitem.getResourceKey() + "\" needs to have a boolean value entered via setData before being used!");
                            }
                            menuItem.setSelection(selection_value.booleanValue());
                        }
                        final Listener main_listener = controller.makeSelectionListener(az_menuitem);
                        menuItem.addListener(13, new Listener(){

                            public void handleEvent(Event e) {
                                if (!(az_menuitem.getStyle() != 2 && az_menuitem.getStyle() != 3 || menuItem.isDisposed())) {
                                    az_menuitem.setData(menuItem.getSelection());
                                }
                                main_listener.handleEvent(e);
                            }
                        });
                        if (is_container) {
                            Menu this_menu = new Menu(parent);
                            menuItem.setMenu(this_menu);
                            MenuBuildUtils.addMaintenanceListenerForMenu(this_menu, new MenuBuilder(){

                                @Override
                                public void buildMenu(Menu root_menu, MenuEvent menuEvent) {
                                    controller.buildSubmenu(az_menuitem);
                                    MenuBuildUtils.addPluginMenuItems(az_menuitem.getItems(), root_menu, false, enable_items, controller);
                                }
                            });
                        }
                        String custom_title = az_menuitem.getText();
                        menuItem.setText(custom_title);
                        Graphic g = az_menuitem.getGraphic();
                        if (g instanceof UISWTGraphic) {
                            Utils.setMenuItemImage(menuItem, ((UISWTGraphic)g).getImage());
                        } else if (g instanceof GraphicURI) {
                            Utils.setMenuItemImage(menuItem, ((GraphicURI)g).getURI().toString());
                        }
                        menuItem.setEnabled(enable_items && az_menuitem.isEnabled());
                    }
                }
            }
            ++i;
        }
        controller.buildComplete(parent);
    }

    public static List<Object> splitLongMenuListIntoHierarchy(List<String> flat_entries, int split_after) {
        ArrayList<Object> result = new ArrayList<Object>();
        int flat_entry_count = flat_entries.size();
        if (flat_entry_count == 0) {
            return result;
        }
        flat_entries.sort(new FormattersImpl().getAlphanumericComparator(true));
        int[] buckets = new int[split_after];
        int i = 0;
        while (i < flat_entry_count) {
            int n = i % buckets.length;
            buckets[n] = buckets[n] + 1;
            ++i;
        }
        ArrayList<char[]> edges = new ArrayList<char[]>();
        int pos = 0;
        int i2 = 0;
        while (i2 < buckets.length) {
            int entries = buckets[i2];
            edges.add(flat_entries.get(pos).toCharArray());
            if (entries <= 1) break;
            edges.add(flat_entries.get(pos + entries - 1).toCharArray());
            pos += entries;
            ++i2;
        }
        int[] edge_lens = new int[edges.size()];
        int i3 = 0;
        while (i3 < edges.size() - 1) {
            int e2;
            char[] c1 = (char[])edges.get(i3);
            char[] c2 = (char[])edges.get(i3 + 1);
            int j = 0;
            while (j < Math.min(Math.min(c1.length, c2.length), 5)) {
                if (c1[j] != c2[j]) {
                    String label = new String(c1, 0, j + 1);
                    boolean clash = false;
                    int k = 0;
                    while (k < i3) {
                        if (label.equals(new String((char[])edges.get(k), 0, edge_lens[k]))) {
                            clash = true;
                        }
                        ++k;
                    }
                    if (!clash) break;
                }
                ++j;
            }
            int e1 = edge_lens[i3] = Math.min(c1.length, Math.max(edge_lens[i3], ++j));
            if (e1 > 0 && e1 < c1.length && Character.isHighSurrogate(c1[e1 - 1])) {
                int n = i3;
                edge_lens[n] = edge_lens[n] + 1;
            }
            if ((e2 = (edge_lens[i3 + 1] = Math.min(c2.length, j))) > 0 && e2 < c2.length && Character.isHighSurrogate(c2[e2 - 1])) {
                int n = i3 + 1;
                edge_lens[n] = edge_lens[n] + 1;
            }
            ++i3;
        }
        int bucket_pos = 0;
        int edge_pos = 0;
        Iterator<String> tag_it = flat_entries.iterator();
        while (tag_it.hasNext()) {
            int bucket_entries = buckets[bucket_pos++];
            ArrayList<String> bucket_tags = new ArrayList<String>();
            int i4 = 0;
            while (i4 < bucket_entries) {
                bucket_tags.add(tag_it.next());
                ++i4;
            }
            if (bucket_entries == 1) {
                result.add(bucket_tags.get(0));
                continue;
            }
            String level_name = String.valueOf(new String((char[])edges.get(edge_pos), 0, edge_lens[edge_pos++])) + " - " + new String((char[])edges.get(edge_pos), 0, edge_lens[edge_pos++]);
            result.add(new Object[]{level_name, bucket_tags});
        }
        return result;
    }

    public static void addCommunityChatMenu(Menu menu) {
        final Menu chat_menu = new Menu((Decorations)menu.getShell(), 4);
        MenuItem chat_item = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)chat_item, "MainWindow.menu.community.chat");
        chat_item.setMenu(chat_menu);
        chat_menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                String cc_text;
                MenuItem chat_priv;
                MenuItem[] menuItemArray = chat_menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem mi = menuItemArray[n2];
                    mi.dispose();
                    ++n2;
                }
                if (!BuddyPluginUtils.isBetaChatAvailable()) {
                    return;
                }
                MenuItem chat_pub = new MenuItem(chat_menu, 8);
                Messages.setLanguageText((Widget)chat_pub, "label.public");
                chat_pub.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        pub_chat_pending.set(true);
                        BuddyPluginUtils.createBetaChat("Public", BuddyPluginBeta.COMMUNITY_CHAT_KEY, new BuddyPluginUtils.CreateChatCallback(){

                            @Override
                            public void complete(BuddyPluginBeta.ChatInstance chat) {
                                pub_chat_pending.set(false);
                            }
                        });
                    }
                });
                if (pub_chat_pending.get()) {
                    chat_pub.setEnabled(false);
                    chat_pub.setText(String.valueOf(chat_pub.getText()) + " (" + MessageText.getString("PeersView.state.pending") + ")");
                }
                if (BuddyPluginUtils.isBetaChatAnonAvailable()) {
                    chat_priv = new MenuItem(chat_menu, 8);
                    Messages.setLanguageText((Widget)chat_priv, "label.anon");
                    chat_priv.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            anon_chat_pending.set(true);
                            BuddyPluginUtils.createBetaChat("I2P", BuddyPluginBeta.COMMUNITY_CHAT_KEY, new BuddyPluginUtils.CreateChatCallback(){

                                @Override
                                public void complete(BuddyPluginBeta.ChatInstance chat) {
                                    anon_chat_pending.set(false);
                                }
                            });
                        }
                    });
                    if (anon_chat_pending.get()) {
                        chat_priv.setEnabled(false);
                        chat_priv.setText(String.valueOf(chat_priv.getText()) + " (" + MessageText.getString("PeersView.state.pending") + ")");
                    }
                } else {
                    chat_priv = new MenuItem(chat_menu, 8);
                    chat_priv.setText(String.valueOf(MessageText.getString("label.anon")) + "...");
                    chat_priv.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            I2PHelpers.installI2PHelper(null, null, null);
                        }
                    });
                    if (I2PHelpers.isInstallingI2PHelper()) {
                        chat_priv.setEnabled(false);
                        chat_priv.setText(String.valueOf(chat_priv.getText()) + " (" + MessageText.getString("PeersView.state.pending") + ")");
                    }
                }
                final BuddyPluginBeta.ChatInstance cc = BuddyPluginUtils.getCountryChat();
                MenuItem chat_cc = new MenuItem(chat_menu, 8);
                if (cc != null) {
                    cc_text = MessageText.getString("menu.your.country", new String[]{(String)cc.getUserData("BuddyPluginUtils::CC")});
                    chat_cc.setText(cc_text);
                    chat_cc.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            try {
                                BuddyPluginUtils.getBetaPlugin().showChat(cc);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    });
                } else {
                    cc_text = MessageText.getString("menu.your.country", new String[]{"..."});
                    chat_cc.setText(cc_text);
                    chat_cc.setEnabled(false);
                }
                final BuddyPluginBeta.ChatInstance lang = BuddyPluginUtils.getLanguageChat();
                MenuItem chat_lang = new MenuItem(chat_menu, 8);
                if (lang != null) {
                    String lang_text = MessageText.getString("menu.your.language", new String[]{(String)lang.getUserData("BuddyPluginUtils::Lang")});
                    chat_lang.setText(lang_text);
                    chat_lang.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            try {
                                BuddyPluginUtils.getBetaPlugin().showChat(lang);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    });
                } else {
                    String lang_text = MessageText.getString("menu.your.language", new String[]{"..."});
                    chat_lang.setText(lang_text);
                    chat_lang.setEnabled(false);
                }
                new MenuItem(chat_menu, 2);
                chat_pub = new MenuItem(chat_menu, 8);
                chat_pub.setText(String.valueOf(MessageText.getString("ConfigView.section.interface.legacy")) + " " + MessageText.getString("label.public"));
                chat_pub.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        pub_chat_pending.set(true);
                        BuddyPluginUtils.createBetaChat("Public", "General: Help", new BuddyPluginUtils.CreateChatCallback(){

                            @Override
                            public void complete(BuddyPluginBeta.ChatInstance chat) {
                                pub_chat_pending.set(false);
                            }
                        });
                    }
                });
                if (pub_chat_pending.get()) {
                    chat_pub.setEnabled(false);
                    chat_pub.setText(String.valueOf(chat_pub.getText()) + " (" + MessageText.getString("PeersView.state.pending") + ")");
                }
                if (BuddyPluginUtils.isBetaChatAnonAvailable()) {
                    chat_priv = new MenuItem(chat_menu, 8);
                    chat_priv.setText(String.valueOf(MessageText.getString("ConfigView.section.interface.legacy")) + " " + MessageText.getString("label.anon"));
                    chat_priv.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            anon_chat_pending.set(true);
                            BuddyPluginUtils.createBetaChat("I2P", "General: Help", new BuddyPluginUtils.CreateChatCallback(){

                                @Override
                                public void complete(BuddyPluginBeta.ChatInstance chat) {
                                    anon_chat_pending.set(false);
                                }
                            });
                        }
                    });
                    if (anon_chat_pending.get()) {
                        chat_priv.setEnabled(false);
                        chat_priv.setText(String.valueOf(chat_priv.getText()) + " (" + MessageText.getString("PeersView.state.pending") + ")");
                    }
                } else {
                    chat_priv = new MenuItem(chat_menu, 8);
                    chat_priv.setText(String.valueOf(MessageText.getString("label.anon")) + "...");
                    chat_priv.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            I2PHelpers.installI2PHelper(null, null, null);
                        }
                    });
                    if (I2PHelpers.isInstallingI2PHelper()) {
                        chat_priv.setEnabled(false);
                        chat_priv.setText(String.valueOf(chat_priv.getText()) + " (" + MessageText.getString("PeersView.state.pending") + ")");
                    }
                }
            }
        });
    }

    public static void addChatMenu(Menu menu, String chat_resource, final String chat_key) {
        Menu top_menu = new Menu((Decorations)menu.getShell(), 4);
        top_menu.setEnabled(chat_key != null);
        MenuItem top_item = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)top_item, "label.chat");
        top_item.setMenu(top_menu);
        final Menu chat_menu = new Menu((Decorations)menu.getShell(), 4);
        MenuItem chat_item = new MenuItem(top_menu, 64);
        Messages.setLanguageText((Widget)chat_item, chat_resource);
        chat_item.setMenu(chat_menu);
        chat_menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] menuItemArray = chat_menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem mi = menuItemArray[n2];
                    mi.dispose();
                    ++n2;
                }
                if (!BuddyPluginUtils.isBetaChatAvailable()) {
                    return;
                }
                MenuItem chat_pub = new MenuItem(chat_menu, 8);
                Messages.setLanguageText((Widget)chat_pub, "label.public");
                chat_pub.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        pub_chat_pending.set(true);
                        BuddyPluginUtils.createBetaChat("Public", chat_key, new BuddyPluginUtils.CreateChatCallback(){

                            @Override
                            public void complete(BuddyPluginBeta.ChatInstance chat) {
                                pub_chat_pending.set(false);
                            }
                        });
                    }
                });
                if (pub_chat_pending.get()) {
                    chat_pub.setEnabled(false);
                    chat_pub.setText(String.valueOf(chat_pub.getText()) + " (" + MessageText.getString("PeersView.state.pending") + ")");
                }
                if (BuddyPluginUtils.isBetaChatAnonAvailable()) {
                    MenuItem chat_priv = new MenuItem(chat_menu, 8);
                    Messages.setLanguageText((Widget)chat_priv, "label.anon");
                    chat_priv.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            anon_chat_pending.set(true);
                            BuddyPluginUtils.createBetaChat("I2P", chat_key, new BuddyPluginUtils.CreateChatCallback(){

                                @Override
                                public void complete(BuddyPluginBeta.ChatInstance chat) {
                                    anon_chat_pending.set(false);
                                }
                            });
                        }
                    });
                    if (anon_chat_pending.get()) {
                        chat_priv.setEnabled(false);
                        chat_priv.setText(String.valueOf(chat_priv.getText()) + " (" + MessageText.getString("PeersView.state.pending") + ")");
                    }
                } else {
                    MenuItem chat_priv = new MenuItem(chat_menu, 8);
                    chat_priv.setText(String.valueOf(MessageText.getString("label.anon")) + "...");
                    chat_priv.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            I2PHelpers.installI2PHelper(null, null, null);
                        }
                    });
                    if (I2PHelpers.isInstallingI2PHelper()) {
                        chat_priv.setEnabled(false);
                        chat_priv.setText(String.valueOf(chat_priv.getText()) + " (" + MessageText.getString("PeersView.state.pending") + ")");
                    }
                }
            }
        });
    }

    public static com.biglybt.pif.ui.menus.MenuItem addChatMenu(final MenuManager menu_manager, final com.biglybt.pif.ui.menus.MenuItem chat_item, final ChatKeyResolver chat_key_resolver) {
        chat_item.setStyle(5);
        chat_item.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                com.biglybt.pif.ui.menus.MenuItem chat_priv;
                menu.removeAllChildItems();
                if (chat_key_resolver.canShareMessage()) {
                    com.biglybt.pif.ui.menus.MenuItem chat_share = menu_manager.addMenuItem(chat_item, "menu.share.download");
                    MenuBuildUtils.addChatSelectionMenu(menu_manager, chat_share, null, new ChatSelectionListener(){

                        @Override
                        public void chatSelected(Object target, String chat) {
                        }

                        @Override
                        public void chatAvailable(Object target, BuddyPluginBeta.ChatInstance chat) {
                            chat_key_resolver.shareMessage(target, chat);
                        }
                    });
                    com.biglybt.pif.ui.menus.MenuItem mi = menu_manager.addMenuItem(chat_item, "sep");
                    mi.setStyle(4);
                }
                com.biglybt.pif.ui.menus.MenuItem discuss_menu = menu_manager.addMenuItem(chat_item, chat_key_resolver.getResourceKey());
                discuss_menu.setStyle(5);
                com.biglybt.pif.ui.menus.MenuItem chat_pub = menu_manager.addMenuItem(discuss_menu, "label.public");
                chat_pub.addMultiListener(new MenuItemListener(){

                    @Override
                    public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                        Object[] rows = (Object[])target;
                        if (rows.length > 0) {
                            final AtomicInteger count = new AtomicInteger(rows.length);
                            pub_chat_pending.set(true);
                            Object[] objectArray = rows;
                            int n = rows.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object obj = objectArray[n2];
                                String chat_key = chat_key_resolver.getChatKey(obj);
                                if (chat_key != null) {
                                    BuddyPluginUtils.createBetaChat("Public", chat_key, new BuddyPluginUtils.CreateChatCallback(){

                                        @Override
                                        public void complete(BuddyPluginBeta.ChatInstance chat) {
                                            if (count.decrementAndGet() == 0) {
                                                pub_chat_pending.set(false);
                                            }
                                        }
                                    });
                                }
                                ++n2;
                            }
                        }
                    }
                });
                if (pub_chat_pending.get()) {
                    chat_pub.setEnabled(false);
                    chat_pub.setText(String.valueOf(chat_pub.getText()) + " (" + MessageText.getString("PeersView.state.pending") + ")");
                }
                if (BuddyPluginUtils.isBetaChatAnonAvailable()) {
                    chat_priv = menu_manager.addMenuItem(discuss_menu, "label.anon");
                    chat_priv.addMultiListener(new MenuItemListener(){

                        @Override
                        public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                            Object[] rows = (Object[])target;
                            if (rows.length > 0) {
                                final AtomicInteger count = new AtomicInteger(rows.length);
                                anon_chat_pending.set(true);
                                Object[] objectArray = rows;
                                int n = rows.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object obj = objectArray[n2];
                                    String chat_key = chat_key_resolver.getChatKey(obj);
                                    if (chat_key != null) {
                                        BuddyPluginUtils.createBetaChat("I2P", chat_key, new BuddyPluginUtils.CreateChatCallback(){

                                            @Override
                                            public void complete(BuddyPluginBeta.ChatInstance chat) {
                                                if (count.decrementAndGet() == 0) {
                                                    anon_chat_pending.set(false);
                                                }
                                            }
                                        });
                                    }
                                    ++n2;
                                }
                            }
                        }
                    });
                    if (anon_chat_pending.get()) {
                        chat_priv.setEnabled(false);
                        chat_priv.setText(String.valueOf(chat_priv.getText()) + " (" + MessageText.getString("PeersView.state.pending") + ")");
                    }
                } else {
                    chat_priv = menu_manager.addMenuItem(chat_item, "label.anon");
                    chat_priv.setText(String.valueOf(MessageText.getString("label.anon")) + "...");
                    chat_priv.addMultiListener(new MenuItemListener(){

                        @Override
                        public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                            I2PHelpers.installI2PHelper(null, null, null);
                        }
                    });
                    if (I2PHelpers.isInstallingI2PHelper()) {
                        chat_priv.setEnabled(false);
                        chat_priv.setText(String.valueOf(chat_priv.getText()) + " (" + MessageText.getString("PeersView.state.pending") + ")");
                    }
                }
            }
        });
        return chat_item;
    }

    private static List<BuddyPluginBeta.ChatInstance> sortChats(List<BuddyPluginBeta.ChatInstance> chats) {
        chats = new ArrayList<BuddyPluginBeta.ChatInstance>(chats);
        Comparator<String> comp2 = new FormattersImpl().getAlphanumericComparator(true);
        Collections.sort(chats, (c1, c2) -> comp2.compare(c1.getDisplayNameEx(), c2.getDisplayNameEx()));
        return chats;
    }

    public static void addChatSelectionMenu(final MenuManager menu_manager, final com.biglybt.pif.ui.menus.MenuItem chat_item, String existing_chat, ChatSelectionListener _listener) {
        final ChatSelectionDelegator listener = new ChatSelectionDelegator(_listener);
        chat_item.setStyle(5);
        chat_item.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                menu.removeAllChildItems();
                com.biglybt.pif.ui.menus.MenuItem create_menu = menu_manager.addMenuItem(chat_item, "chat.view.create.chat");
                create_menu.setStyle(5);
                BuddyUIUtils.createChat(menu_manager, create_menu, true, new BuddyUIUtils.ChatCreationListener(){

                    @Override
                    public void chatCreated(Object target, String name) {
                        listener.chatSelected(target, name);
                    }

                    @Override
                    public void chatAvailable(Object target, BuddyPluginBeta.ChatInstance chat) {
                        listener.chatAvailable(target, chat);
                    }
                });
                com.biglybt.pif.ui.menus.MenuItem mi = menu_manager.addMenuItem(chat_item, "sep");
                mi.setStyle(4);
                List chats = BuddyPluginUtils.getChats();
                chats = MenuBuildUtils.sortChats(chats);
                int i = 0;
                while (i < 2) {
                    com.biglybt.pif.ui.menus.MenuItem chat_menu = menu_manager.addMenuItem(chat_item, i == 0 ? "label.public" : "label.anon");
                    chat_menu.setStyle(5);
                    String net = i == 0 ? "Public" : "I2P";
                    for (final BuddyPluginBeta.ChatInstance chat : chats) {
                        if (chat.getNetwork() != net) continue;
                        mi = menu_manager.addMenuItem(chat_menu, "!" + chat.getDisplayNameEx() + "!");
                        mi.addMultiListener(new MenuItemListener(){

                            @Override
                            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                                listener.chatSelected(target, chat.getNetAndKey());
                                listener.chatAvailable(target, chat);
                                try {
                                    BuddyPluginUtils.getBetaPlugin().showChat(chat);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        });
                    }
                    ++i;
                }
            }
        });
    }

    public static void addChatSelectionMenu(Menu menu, String resource_key, final String existing_chat, ChatSelectionListener _listener) {
        final ChatSelectionDelegator listener = new ChatSelectionDelegator(_listener);
        final Menu chat_menu = new Menu((Decorations)menu.getShell(), 4);
        MenuItem chat_item = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)chat_item, resource_key);
        chat_item.setMenu(chat_menu);
        chat_menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem mi;
                MenuItem[] menuItemArray = chat_menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    mi = menuItemArray[n2];
                    mi.dispose();
                    ++n2;
                }
                if (!BuddyPluginUtils.isBetaChatAvailable()) {
                    mi = new MenuItem(chat_menu, 8);
                    Messages.setLanguageText((Widget)mi, "tps.status.unavailable");
                    mi.setEnabled(false);
                    return;
                }
                BuddyUIUtils.createChat(chat_menu, new BuddyUIUtils.ChatCreationListener(){

                    @Override
                    public void chatCreated(Object target, String name) {
                        listener.chatSelected(target, name);
                    }

                    @Override
                    public void chatAvailable(Object target, BuddyPluginBeta.ChatInstance chat) {
                        listener.chatAvailable(target, chat);
                    }
                });
                new MenuItem(chat_menu, 2);
                MenuItem mi_none = new MenuItem(chat_menu, 16);
                Messages.setLanguageText((Widget)mi_none, "label.none");
                mi_none.setSelection(existing_chat == null || existing_chat.trim().isEmpty());
                mi_none.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        listener.chatSelected(null, "");
                    }
                });
                int i = 0;
                while (i < 2) {
                    final Menu sub_menu = new Menu((Decorations)chat_menu.getShell(), 4);
                    MenuItem sub_item = new MenuItem(chat_menu, 64);
                    Messages.setLanguageText((Widget)sub_item, i == 0 ? "label.public" : "label.anon");
                    sub_item.setMenu(sub_menu);
                    final String net = i == 0 ? "Public" : "I2P";
                    sub_menu.addMenuListener((MenuListener)new MenuAdapter(){

                        public void menuShown(MenuEvent e) {
                            MenuItem[] menuItemArray = sub_menu.getItems();
                            int n = menuItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                MenuItem mi = menuItemArray[n2];
                                mi.dispose();
                                ++n2;
                            }
                            List chats = BuddyPluginUtils.getChats();
                            chats = MenuBuildUtils.sortChats(chats);
                            for (final BuddyPluginBeta.ChatInstance chat : chats) {
                                if (chat.getNetwork() != net) continue;
                                MenuItem mi = new MenuItem(sub_menu, 16);
                                mi.setText(chat.getDisplayNameEx());
                                mi.setSelection(existing_chat != null && existing_chat.equals(chat.getNetAndKey()));
                                mi.addListener(13, new Listener(){

                                    public void handleEvent(Event event2) {
                                        listener.chatSelected(null, chat.getNetAndKey());
                                        listener.chatAvailable(null, chat);
                                    }
                                });
                            }
                        }
                    });
                    ++i;
                }
            }
        });
    }

    public static void addSeparator(Menu menu) {
        if (menu.isDisposed() || menu.getItemCount() == 0) {
            return;
        }
        MenuItem[] items = menu.getItems();
        if (items[items.length - 1].getStyle() != 2) {
            new MenuItem(menu, 2);
        }
    }

    public static void addColourChooser(Menu menu, String item_resource, boolean can_clear, List<RGB> existing, Consumer<RGB> receiver) {
        Menu sel_menu = new Menu((Decorations)menu.getShell(), 4);
        MenuItem sel_item = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)sel_item, item_resource);
        sel_item.setMenu(sel_menu);
        MenuItem itemSetColor = new MenuItem(sel_menu, 8);
        Messages.setLanguageText((Widget)itemSetColor, "label.set");
        itemSetColor.addListener(13, event2 -> {
            RGB rgbChosen;
            ColorDialog cd = new ColorDialog(menu.getShell());
            List<RGB> customColors = Utils.getCustomColors();
            HashMap<RGB, Long> mapDupCount = new HashMap<RGB, Long>();
            for (RGB rgb : existing) {
                if (!customColors.contains(rgb)) {
                    customColors.add(0, rgb);
                    continue;
                }
                Long count = (Long)mapDupCount.get(rgb);
                mapDupCount.put(rgb, count == null ? 1L : count + 1L);
            }
            long maxCount = 0L;
            RGB selectRGB = null;
            for (RGB rgb : mapDupCount.keySet()) {
                Long count = (Long)mapDupCount.get(rgb);
                if (count == null || count <= maxCount) continue;
                maxCount = count;
                selectRGB = rgb;
            }
            cd.setRGBs(customColors.toArray(new RGB[0]));
            if (selectRGB != null) {
                cd.setRGB(selectRGB);
            }
            if ((rgbChosen = cd.open()) != null) {
                receiver.accept(rgbChosen);
            }
        });
        MenuItem clear_item = new MenuItem(sel_menu, 8);
        Messages.setLanguageText((Widget)clear_item, "Button.clear");
        clear_item.addListener(13, event2 -> receiver.accept(null));
        clear_item.setEnabled(can_clear);
    }

    public static boolean hasOpenWithMenu(Object target, boolean torrent) {
        block7: {
            block6: {
                boolean ok = false;
                int i = 0;
                while (i < ConfigKeysSWT.getLaunchHelperEntryCount()) {
                    String exe = ConfigKeysSWT.getLaunchHelpersProg(i).trim();
                    if (exe.length() > 0 && Utils.fileExistsWithTimeout(exe)) {
                        ok = true;
                        break;
                    }
                    ++i;
                }
                if (!ok) {
                    return false;
                }
                if (!(target instanceof DownloadManager[])) break block6;
                DownloadManager[] downloadManagerArray = (DownloadManager[])target;
                int n = downloadManagerArray.length;
                int exe = 0;
                while (exe < n) {
                    DiskManagerFileInfo[] files;
                    File tf;
                    DownloadManager dm = downloadManagerArray[exe];
                    if (torrent ? Utils.fileExistsWithTimeout(tf = new File(dm.getTorrentFileName())) : (files = dm.getDiskManagerFileInfoSet().getFiles()).length == 1 && Utils.fileExistsWithTimeout(files[0].getFile(true))) {
                        return true;
                    }
                    ++exe;
                }
                break block7;
            }
            if (!(target instanceof List)) break block7;
            List files = (List)target;
            for (DiskManagerFileInfo file : files) {
                if (!Utils.fileExistsWithTimeout(file.getFile(true))) continue;
                return true;
            }
        }
        return false;
    }

    public static MenuItem addOpenWithMenu(Menu menu, boolean has_menu, Object target, boolean torrent) {
        MenuItem openWithItem;
        Menu openWithMenu;
        if (has_menu) {
            openWithMenu = menu;
            openWithItem = null;
        } else {
            openWithMenu = new Menu((Decorations)menu.getShell(), 4);
            openWithItem = new MenuItem(menu, 64);
            Messages.setLanguageText((Widget)openWithItem, "menu.open.with");
            openWithItem.setMenu(openWithMenu);
        }
        int i = 0;
        while (i < ConfigKeysSWT.getLaunchHelperEntryCount()) {
            String exe = ConfigKeysSWT.getLaunchHelpersProg(i).trim();
            if (exe.length() > 0 && Utils.fileExistsWithTimeout(exe)) {
                MenuItem mi = new MenuItem(openWithMenu, 8);
                mi.setText(exe);
                mi.addListener(13, ev -> {
                    block7: {
                        block6: {
                            if (!(target instanceof DownloadManager[])) break block6;
                            DownloadManager[] downloadManagerArray = (DownloadManager[])target;
                            int n = downloadManagerArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                DownloadManager dm = downloadManagerArray[n2];
                                if (torrent) {
                                    File tf = new File(dm.getTorrentFileName());
                                    if (Utils.fileExistsWithTimeout(tf)) {
                                        Utils.launchFileExplicit(tf.getAbsolutePath(), exe);
                                    }
                                } else {
                                    DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                                    if (files.length == 1 && Utils.fileExistsWithTimeout(files[0].getFile(true))) {
                                        Utils.launchFileExplicit(files[0], exe);
                                    }
                                }
                                ++n2;
                            }
                            break block7;
                        }
                        if (!(target instanceof List)) break block7;
                        List files = (List)target;
                        for (DiskManagerFileInfo file : files) {
                            if (!Utils.fileExistsWithTimeout(file.getFile(true))) continue;
                            Utils.launchFileExplicit(file, exe);
                        }
                    }
                });
            }
            ++i;
        }
        return openWithItem;
    }

    public static void addMOCHistory(Menu moc_menu, Consumer<String> moc_setter) {
        List<String> moc_hist = COConfigurationManager.getStringListParameter("open.torrent.window.moc.history");
        if (!moc_hist.isEmpty()) {
            new MenuItem(moc_menu, 2);
            for (String hist : moc_hist) {
                MenuItem hist_item = new MenuItem(moc_menu, 8);
                hist_item.setText(hist);
                hist_item.addListener(13, ev -> moc_setter.accept(hist));
            }
        }
    }

    public static void addToMOCHistory(String path) {
        List<String> moc_hist = COConfigurationManager.getStringListParameter("open.torrent.window.moc.history");
        moc_hist.remove(path);
        moc_hist.add(0, path);
        if (moc_hist.size() > 50) {
            moc_hist.remove(moc_hist.size() - 1);
        }
        COConfigurationManager.setParameter("open.torrent.window.moc.history", moc_hist);
    }

    public static interface ChatKeyResolver {
        public String getResourceKey();

        public String getChatKey(Object var1);

        default public boolean canShareMessage() {
            return false;
        }

        default public void shareMessage(Object target, BuddyPluginBeta.ChatInstance chat) {
        }
    }

    private static class ChatSelectionDelegator
    implements ChatSelectionListener {
        private ChatSelectionListener delegate;
        private TimerEventPeriodic timer;

        protected ChatSelectionDelegator(ChatSelectionListener _delegate) {
            this.delegate = _delegate;
        }

        @Override
        public void chatSelected(Object target, String name) {
            this.delegate.chatSelected(target, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void chatAvailable(Object target, BuddyPluginBeta.ChatInstance chat) {
            ChatSelectionDelegator chatSelectionDelegator = this;
            synchronized (chatSelectionDelegator) {
                if (this.timer != null) {
                    return;
                }
                long start = SystemTime.getMonotonousTime();
                this.timer = SimpleTimer.addPeriodicEvent("availcheck", 1000L, ev -> {
                    ChatSelectionDelegator chatSelectionDelegator;
                    if (chat.isAvailable()) {
                        if (!chat.isDestroyed()) {
                            this.delegate.chatAvailable(target, chat);
                        }
                        chatSelectionDelegator = this;
                        synchronized (chatSelectionDelegator) {
                            this.timer.cancel();
                        }
                    }
                    if (SystemTime.getMonotonousTime() - start > 180000L) {
                        Debug.out("Gave up waiting for " + chat.getNetAndKey() + " to become available");
                        chatSelectionDelegator = this;
                        synchronized (chatSelectionDelegator) {
                            this.timer.cancel();
                        }
                    }
                });
            }
        }
    }

    public static interface ChatSelectionListener {
        public void chatSelected(Object var1, String var2);

        public void chatAvailable(Object var1, BuddyPluginBeta.ChatInstance var2);
    }

    public static interface MenuBuilder {
        public void buildMenu(Menu var1, MenuEvent var2);
    }

    public static class MenuItemPluginMenuControllerImpl
    implements PluginMenuController {
        private Menu parentMenu;
        private Object[] objects;

        public MenuItemPluginMenuControllerImpl(Object[] o) {
            this.objects = o;
        }

        @Override
        public Listener makeSelectionListener(com.biglybt.pif.ui.menus.MenuItem menu_item) {
            final MenuItemImpl mii = (MenuItemImpl)menu_item;
            return new Listener(){

                public void handleEvent(Event e) {
                    if (mii instanceof TableContextMenuItemImpl) {
                        TableView tv = (TableView)parentMenu.getData("table-view");
                        ((TableContextMenuItemImpl)mii).setTable(tv);
                    }
                    mii.invokeListenersMulti(objects);
                }
            };
        }

        @Override
        public void notifyFillListeners(com.biglybt.pif.ui.menus.MenuItem menu_item) {
            MenuItemImpl mii = (MenuItemImpl)menu_item;
            if (mii instanceof TableContextMenuItemImpl) {
                TableView tv = (TableView)this.parentMenu.getData("table-view");
                ((TableContextMenuItemImpl)mii).setTable(tv);
            }
            mii.invokeMenuWillBeShownListeners(this.objects);
        }

        @Override
        public void buildSubmenu(com.biglybt.pif.ui.menus.MenuItem parent) {
            com.biglybt.pif.ui.menus.MenuBuilder submenuBuilder = ((MenuItemImpl)parent).getSubmenuBuilder();
            if (submenuBuilder != null) {
                try {
                    parent.removeAllChildItems();
                    submenuBuilder.buildSubmenu(parent, this.objects);
                }
                catch (Throwable t) {
                    Debug.out(t);
                }
            }
        }

        @Override
        public void buildStarts(Menu menu) {
            this.parentMenu = menu;
        }

        @Override
        public void buildComplete(Menu menu) {
            this.parentMenu = menu;
        }
    }

    public static interface PluginMenuController {
        public void buildStarts(Menu var1);

        public Listener makeSelectionListener(com.biglybt.pif.ui.menus.MenuItem var1);

        public void notifyFillListeners(com.biglybt.pif.ui.menus.MenuItem var1);

        public void buildSubmenu(com.biglybt.pif.ui.menus.MenuItem var1);

        public void buildComplete(Menu var1);
    }
}

