/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.ui.UIInputValidator;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.LinkLabel;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.pifimpl.AbstractUISWTInputReceiver;
import com.biglybt.ui.swt.utils.DragDropUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class SimpleTextEntryWindow
extends AbstractUISWTInputReceiver {
    private Display display;
    private Shell parent_shell;
    private Shell shell;
    private int textLimit;
    private boolean resizeable;
    private String loc_size_config_key;
    private Combo text_entry_combo;
    private StyledText text_entry_text;
    private Label link_label;
    private boolean detect_urls;
    private boolean special_escape_handling;
    private boolean user_hit_escape;
    private List<VerifyListener> verify_listeners = new ArrayList<VerifyListener>();

    public SimpleTextEntryWindow() {
    }

    public SimpleTextEntryWindow(String sTitleKey, String sLabelKey) {
        this.setTitle(sTitleKey);
        this.setMessage(sLabelKey);
    }

    public SimpleTextEntryWindow(String sTitleKey, String sLabelKey, boolean bMultiLine) {
        this.setTitle(sTitleKey);
        this.setMessage(sLabelKey);
        this.setMultiLine(bMultiLine);
    }

    public void initTexts(String sTitleKey, String[] p0, String sLabelKey, String[] p1) {
        this.setLocalisedTitle(MessageText.getString(sTitleKey, p0));
        this.setLocalisedMessage(MessageText.getString(sLabelKey, p1));
    }

    public void addVerifyListener(VerifyListener l) {
        this.verify_listeners.add(l);
    }

    @Override
    protected void promptForInput() {
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                SimpleTextEntryWindow.this.promptForInput0();
                if (SimpleTextEntryWindow.this.receiver_listener == null) {
                    Utils.readAndDispatchLoop((Control)SimpleTextEntryWindow.this.shell);
                }
            }
        }, this.receiver_listener != null);
    }

    private void promptForInput0() {
        StyledText text_entry;
        int text_entry_flags;
        int height_hint;
        int width_hint;
        Shell parent = this.parent_shell;
        if (this.parent_shell == null && (parent = Display.getDefault().getActiveShell()) != null && parent.getData("ShellFactory.NOT_A_GOOD_PARENT") != null) {
            parent = null;
        }
        if (parent == null) {
            parent = Utils.findAnyShell();
        }
        this.shell = ShellFactory.createShell(parent, 0x860 | (this.resizeable ? 16 : 0));
        this.display = this.shell.getDisplay();
        if (this.title != null) {
            String str = this.title;
            if (this.textLimit > 0) {
                str = String.valueOf(str) + " (" + MessageText.getString("label.limit") + " " + this.textLimit + ")";
            }
            this.shell.setText(str);
        }
        Utils.setShellIcon(this.shell);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        this.shell.setLayout((Layout)layout);
        if (this.loc_size_config_key != null && Utils.hasShellMetricsConfig(this.loc_size_config_key)) {
            width_hint = -1;
            height_hint = -1;
        } else {
            width_hint = this.width_hint == -1 ? 330 : this.width_hint;
            height_hint = this.height_hint == -1 ? -1 : this.height_hint;
        }
        GridData gridData = null;
        int i = 0;
        while (i < this.messages.length) {
            String msg = this.messages[i];
            gridData = this.resizeable ? new GridData(768) : new GridData();
            gridData.widthHint = width_hint;
            if (msg.toLowerCase(Locale.US).contains("<a href")) {
                StyledText text = new StyledText((Composite)this.shell, 0);
                text.setEditable(false);
                text.setBackground(this.shell.getBackground());
                Utils.setTextWithURLs(text, msg, false);
                text.setLayoutData((Object)gridData);
            } else {
                Label label = new Label((Composite)this.shell, 64);
                label.setText(msg);
                label.setLayoutData((Object)gridData);
            }
            ++i;
        }
        if (this.choices != null) {
            text_entry_flags = 4;
            if (!this.choices_allow_edit) {
                text_entry_flags |= 8;
            }
            this.text_entry_combo = new Combo((Composite)this.shell, text_entry_flags);
            this.text_entry_combo.setItems(this.choices);
            if (this.textLimit > 0) {
                this.text_entry_combo.setTextLimit(this.textLimit);
            }
            this.text_entry_text = null;
            text_entry = this.text_entry_combo;
        } else {
            text_entry_flags = 2048;
            text_entry_flags = this.multiline_mode ? (text_entry_flags |= 0x242) : (text_entry_flags |= 4);
            this.text_entry_text = new StyledText((Composite)this.shell, text_entry_flags);
            if (this.textLimit > 0) {
                this.text_entry_text.setTextLimit(this.textLimit);
            }
            this.text_entry_combo = null;
            text_entry = this.text_entry_text;
        }
        if (this.preentered_text != null) {
            if (this.text_entry_text != null) {
                this.text_entry_text.setText(this.preentered_text);
                if (this.select_preentered_text) {
                    int[] range = this.select_preentered_text_range;
                    if (range == null || range.length != 2) {
                        this.text_entry_text.selectAll();
                    } else {
                        try {
                            this.text_entry_text.setSelection(range[0], range[1]);
                        }
                        catch (Throwable e) {
                            this.text_entry_text.selectAll();
                        }
                    }
                }
            } else if (this.text_entry_combo != null) {
                this.text_entry_combo.setText(this.preentered_text);
            }
        }
        text_entry.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
        text_entry.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                int key = e.character;
                if (key <= 26 && key > 0) {
                    key += 96;
                }
                if (key == 97 && e.stateMask == SWT.MOD1 && SimpleTextEntryWindow.this.text_entry_text != null) {
                    SimpleTextEntryWindow.this.text_entry_text.selectAll();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        for (VerifyListener l : this.verify_listeners) {
            if (this.text_entry_text != null) {
                this.text_entry_text.addVerifyListener(l);
                continue;
            }
            if (this.text_entry_combo == null) continue;
            this.text_entry_combo.addVerifyListener(l);
        }
        int line_height = this.line_height;
        if (line_height == -1) {
            line_height = this.multiline_mode ? 3 : 1;
        }
        gridData = this.resizeable ? new GridData(1808) : new GridData();
        gridData.widthHint = width_hint;
        if (height_hint == -1) {
            if (this.text_entry_text != null) {
                gridData.heightHint = gridData.minimumHeight = this.text_entry_text.getLineHeight() * line_height;
            }
        } else {
            gridData.heightHint = height_hint;
        }
        text_entry.setLayoutData((Object)gridData);
        Composite bottom_panel = new Composite((Composite)this.shell, 0);
        gridData = new GridData(768);
        bottom_panel.setLayoutData((Object)gridData);
        GridLayout gLayout = new GridLayout(2, false);
        gLayout.marginTop = 0;
        gLayout.marginLeft = 0;
        gLayout.marginBottom = 0;
        gLayout.marginRight = 0;
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        bottom_panel.setLayout((Layout)gLayout);
        this.link_label = new Label(bottom_panel, 0);
        gridData = new GridData(768);
        this.link_label.setLayoutData((Object)gridData);
        Composite button_panel = new Composite(bottom_panel, 0);
        RowLayout rLayout = new RowLayout();
        rLayout.marginTop = 0;
        rLayout.marginLeft = 0;
        rLayout.marginBottom = 0;
        rLayout.marginRight = 0;
        rLayout.fill = true;
        rLayout.spacing = Utils.BUTTON_MARGIN;
        button_panel.setLayout((Layout)rLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000008;
        button_panel.setLayoutData((Object)gridData);
        Button[] buttons = Utils.createOKCancelButtons(button_panel);
        Button ok = buttons[0];
        final Button cancel = buttons[1];
        ok.addListener(13, new Listener(){

            private void showError(String text) {
                String error_title = SimpleTextEntryWindow.this.title;
                if (error_title == null) {
                    error_title = "";
                }
                MessageBox mb = new MessageBox(SimpleTextEntryWindow.this.shell, 33);
                mb.setText(error_title);
                mb.setMessage(text);
                mb.open();
            }

            public void handleEvent(Event event2) {
                try {
                    String validate_result;
                    String entered_data = "";
                    if (SimpleTextEntryWindow.this.text_entry_text != null) {
                        entered_data = SimpleTextEntryWindow.this.text_entry_text.getText();
                    } else if (SimpleTextEntryWindow.this.text_entry_combo != null) {
                        entered_data = SimpleTextEntryWindow.this.text_entry_combo.getText();
                    }
                    if (!SimpleTextEntryWindow.this.maintain_whitespace) {
                        entered_data = entered_data.trim();
                    }
                    if (SimpleTextEntryWindow.this.textLimit > 0 && entered_data.length() > SimpleTextEntryWindow.this.textLimit) {
                        entered_data = entered_data.substring(0, SimpleTextEntryWindow.this.textLimit);
                    }
                    if (!SimpleTextEntryWindow.this.allow_empty_input && entered_data.length() == 0) {
                        this.showError(MessageText.getString("UI.cannot_submit_blank_text"));
                        return;
                    }
                    UIInputValidator validator = SimpleTextEntryWindow.this.validator;
                    if (validator != null && (validate_result = validator.validate(entered_data)) != null) {
                        this.showError(MessageText.getString(validate_result));
                        return;
                    }
                    SimpleTextEntryWindow.this.recordUserInput(entered_data);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                    SimpleTextEntryWindow.this.recordUserAbort();
                }
                SimpleTextEntryWindow.this.shell.dispose();
            }
        });
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                SimpleTextEntryWindow.this.recordUserAbort();
                SimpleTextEntryWindow.this.shell.dispose();
            }
        });
        if (this.special_escape_handling) {
            cancel.setToolTipText(MessageText.getString("long.press.cancel.tt"));
            cancel.addListener(3, new Listener(){
                boolean mouseDown = false;
                TimerEvent timerEvent = null;

                public void handleEvent(Event event2) {
                    if (event2.button != 1) {
                        return;
                    }
                    if (this.timerEvent == null) {
                        this.timerEvent = SimpleTimer.addEvent("MouseHold", SystemTime.getOffsetTime(1000L), te -> {
                            this.timerEvent = null;
                            if (!this.mouseDown) {
                                return;
                            }
                            Utils.execSWTThread(() -> {
                                if (!this.mouseDown) {
                                    return;
                                }
                                if (event2.display.getCursorControl() != cancel) {
                                    return;
                                }
                                this.mouseDown = false;
                                SimpleTextEntryWindow.this.user_hit_escape = true;
                                SimpleTextEntryWindow.this.shell.dispose();
                            });
                        });
                    }
                    this.mouseDown = true;
                }
            });
        }
        if (this.text_entry_text != null) {
            this.text_entry_text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    SimpleTextEntryWindow.this.checkText();
                }
            });
            this.checkText();
        }
        this.shell.setDefaultButton(ok);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    SimpleTextEntryWindow.this.user_hit_escape = true;
                    SimpleTextEntryWindow.this.recordUserAbort();
                    SimpleTextEntryWindow.this.shell.dispose();
                }
            }
        });
        this.shell.addListener(12, event2 -> {
            if (!this.isResultRecorded()) {
                this.recordUserAbort();
            }
            Utils.execSWTThreadLater(0, this::triggerReceiverListener);
        });
        this.shell.pack();
        if (this.text_entry_text != null) {
            DragDropUtils.createURLDropTarget((Composite)this.shell, this.text_entry_text);
        }
        boolean centre = true;
        if (this.loc_size_config_key != null && Utils.linkShellMetricsToConfig(this.shell, this.loc_size_config_key)) {
            centre = false;
        }
        if (centre) {
            Utils.centreWindow(this.shell, false);
        }
        this.shell.open();
    }

    private void checkText() {
        if (this.detect_urls) {
            String url = UrlUtils.parseTextForURL(this.text_entry_text.getText(), true);
            if (url != null) {
                this.link_label.setText(url);
                LinkLabel.makeLinkedLabel(this.link_label, url);
            } else {
                this.link_label.setText("");
                LinkLabel.removeLinkedLabel(this.link_label);
            }
        }
    }

    @Override
    public void setTextLimit(int limit) {
        this.textLimit = limit;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SimpleTextEntryWindow.this.text_entry_combo != null && !SimpleTextEntryWindow.this.text_entry_combo.isDisposed()) {
                    SimpleTextEntryWindow.this.text_entry_combo.setTextLimit(SimpleTextEntryWindow.this.textLimit);
                }
                if (SimpleTextEntryWindow.this.text_entry_text != null && !SimpleTextEntryWindow.this.text_entry_text.isDisposed()) {
                    SimpleTextEntryWindow.this.text_entry_text.setTextLimit(SimpleTextEntryWindow.this.textLimit);
                }
            }
        });
    }

    public void setResizeable(boolean b) {
        this.resizeable = b;
    }

    public void setRememberLocationSize(String config_key) {
        this.loc_size_config_key = config_key;
        this.resizeable = true;
    }

    public void setDetectURLs(boolean b) {
        this.detect_urls = b;
    }

    public void setParentShell(Shell shell) {
        this.parent_shell = shell;
    }

    @Override
    public void setEnableSpecialEscapeHandling(boolean b) {
        this.special_escape_handling = b;
    }

    @Override
    public boolean userHitEscape() {
        return this.user_hit_escape;
    }
}

