/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.html.HTMLUtils;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.speedmanager.SpeedLimitHandler;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AEDiagnosticsLogger;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AERunnableBoolean;
import com.biglybt.core.util.AERunnableObject;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DebugLight;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.LaunchManager;
import com.biglybt.core.util.RARTOCDecoder;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.ThreadPool;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginManager;
import com.biglybt.pif.disk.DiskManagerEvent;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.disk.DiskManagerListener;
import com.biglybt.pif.platform.PlatformManagerException;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.utils.PooledByteBuffer;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerCapabilities;
import com.biglybt.platform.PlatformManagerFactory;
import com.biglybt.plugin.I2PHelpers;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UIFunctionsUserPrompter;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.swt.BrowserWrapper;
import com.biglybt.ui.swt.ConfigKeysSWT;
import com.biglybt.ui.swt.DelayedListenerMultiCombiner;
import com.biglybt.ui.swt.ImageViewerWindow;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.TextViewerWindow;
import com.biglybt.ui.swt.UI;
import com.biglybt.ui.swt.UIConfigDefaultsSWT;
import com.biglybt.ui.swt.UIConfigDefaultsSWTv3;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.components.BufferedTruncatedLabel;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mainwindow.SWTThread;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.pif.UISWTStatusEntry;
import com.biglybt.ui.swt.pifimpl.UISWTGraphicImpl;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.systray.TrayItemDelegate;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.utils.SWTRunnable;
import com.biglybt.ui.swt.views.table.painted.TablePaintedUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class Utils {
    static final Method method_DPIUTIL_getDeviceZoom;
    static final Method method_DPIUTIL_getNativeDeviceZoom;
    public static final String GOOD_STRING = "(/|,jI~`gy";
    public static final boolean isGTK;
    public static boolean isGTK3;
    public static final boolean LAST_TABLECOLUMN_EXPANDS;
    public static final boolean TABLE_GRIDLINE_IS_ALTERNATING_COLOR;
    public static int BUTTON_MARGIN;
    public static int BUTTON_MINWIDTH;
    public static final int SCT_SKINNING_DISABLED = -1;
    public static final int SCT_NONE = 0;
    public static final int SCT_BUBBLE_TEXT_BOX = 1;
    public static final int SCT_MENU_ITEM = 2;
    private static final boolean DEBUG_SWTEXEC;
    private static ArrayList<Runnable> queue;
    private static AEDiagnosticsLogger diag_logger;
    private static org.eclipse.swt.graphics.Image[] shellIcons;
    private static org.eclipse.swt.graphics.Image icon128;
    public static final Rectangle EMPTY_RECT;
    private static int userMode;
    private static boolean isAZ2;
    private static boolean isAZ3;
    private static AEDiagnosticsEvidenceGenerator evidenceGenerator;
    private static ParameterListener configUserModeListener;
    private static ParameterListener configUIListener;
    private static ParameterListener configOtherListener;
    private static boolean terminated;
    private static final int SWT_VERSION;
    private static final int SWT_REVISION;
    private static final String SWT_PLATFORM;
    private static Boolean is_dark_appearance;
    private static boolean force_dark_appearance;
    private static Skinner skinner;
    private static int skinning_enabled;
    private static volatile boolean dark_misc_things;
    private static volatile boolean gradient_fill;
    private static volatile boolean gui_refresh_disable_when_min;
    private static volatile boolean gui_is_minimized;
    private static volatile boolean gui_refresh_enable;
    private static String SHELL_METRICS_DISABLED_KEY;
    private static Display display;
    private static Set<com.biglybt.core.disk.DiskManagerFileInfo> quick_view_active;
    private static TimerEventPeriodic quick_view_event;
    private static volatile int dragDetectMask;
    private static CopyOnWriteList<TerminateListener> listeners;
    static final boolean USE_ASYNC_EXEC_QUEUE = false;
    static AtomicInteger async_seq;
    static ConcurrentLinkedQueue<Object[]> async_exec_q;
    static Runnable async_runner;
    private static Set<String> pending_ext_urls;
    private static AsyncDispatcher ext_url_dispatcher;
    private static boolean i2p_install_active_for_url;
    private static boolean browser_install_active_for_url;
    private static boolean tb_installing;
    public static final String PL_SHOW_FILE = "<showfile>";
    private static Map truncatedTextCache;
    public static final String THREAD_NAME_OFFSWT = "GetOffSWT";
    private static ThreadPool<AERunnable> tp;
    private static Set<String> qv_exts;
    private static int qv_max_bytes;
    private static ParameterListener pconfigQuickViewListeners;
    public static final String RELAYOUT_UP_STOP_HERE = "com.biglybt.ui.swt.Utils.RELAYOUT_UP_STOP_HERE";
    private static boolean tt_enabled;
    private static Pattern a_pattern;
    private static Pattern href_pattern;
    private static AtomicInteger dl_depth;

    static {
        Method m2;
        Method m1;
        block16: {
            m1 = null;
            m2 = null;
            try {
                try {
                    Class<?> claDPIUtil;
                    block15: {
                        claDPIUtil = Class.forName("org.eclipse.swt.internal.DPIUtil");
                        try {
                            m1 = claDPIUtil.getMethod("getDeviceZoom", new Class[0]);
                        }
                        catch (Throwable e) {
                            if (!Constants.IS_CVS_VERSION) break block15;
                            Debug.out("DPIUtil::getDeviceZoom unavailable");
                        }
                    }
                    if (SWT.getVersion() < 4968) break block16;
                    try {
                        m2 = claDPIUtil.getMethod("getNativeDeviceZoom", new Class[0]);
                    }
                    catch (Throwable e) {
                        if (Constants.IS_CVS_VERSION) {
                            Debug.out("DPIUtil::getNativeDeviceZoom unavailable");
                        }
                    }
                }
                catch (Throwable claDPIUtil) {}
            }
            catch (Throwable claDPIUtil) {
                // empty catch block
            }
        }
        method_DPIUTIL_getDeviceZoom = m1;
        method_DPIUTIL_getNativeDeviceZoom = m2;
        isGTK = SWT.getPlatform().equals("gtk");
        isGTK3 = isGTK && System.getProperty("org.eclipse.swt.internal.gtk.version", "2").startsWith("3");
        LAST_TABLECOLUMN_EXPANDS = isGTK;
        TABLE_GRIDLINE_IS_ALTERNATING_COLOR = isGTK || Constants.isOSX;
        BUTTON_MINWIDTH = Constants.isOSX ? 90 : 70;
        DEBUG_SWTEXEC = System.getProperty("debug.swtexec", "0").equals("1");
        shellIcons = null;
        EMPTY_RECT = new Rectangle(0, 0, 0, 0);
        SWT_VERSION = SWT.getVersion();
        SWT_PLATFORM = SWT.getPlatform();
        int rev = 0;
        try {
            Class<?> lib = Class.forName("org.eclipse.swt.internal.Library");
            Field f_rev = lib.getDeclaredField("REVISION");
            if (f_rev != null) {
                f_rev.setAccessible(true);
                rev = f_rev.getInt(null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SWT_REVISION = rev;
        skinning_enabled = 1;
        dark_misc_things = false;
        gradient_fill = true;
        gui_refresh_disable_when_min = false;
        gui_is_minimized = false;
        gui_refresh_enable = true;
        SHELL_METRICS_DISABLED_KEY = "utils:shmd";
        quick_view_active = new HashSet<com.biglybt.core.disk.DiskManagerFileInfo>();
        dragDetectMask = 0;
        listeners = new CopyOnWriteList();
        async_seq = new AtomicInteger();
        async_exec_q = new ConcurrentLinkedQueue();
        async_runner = new Runnable(){

            @Override
            public void run() {
                int spins = 0;
                Integer last = -1;
                while (true) {
                    Object[] r;
                    if ((r = async_exec_q.poll()) == null) {
                        if (async_seq.compareAndSet(last + 1, 0)) break;
                        if (++spins < 10) continue;
                        try {
                            Thread.sleep(1L);
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    spins = 0;
                    try {
                        ((Runnable)r[0]).run();
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    last = (Integer)r[1];
                }
            }
        };
        pending_ext_urls = new HashSet<String>();
        ext_url_dispatcher = new AsyncDispatcher("Ext Urls");
        i2p_install_active_for_url = false;
        browser_install_active_for_url = false;
        tb_installing = false;
        truncatedTextCache = new HashMap();
        tp = new ThreadPool(THREAD_NAME_OFFSWT, 10, true);
        if (Constants.isCVSVersion()) {
            tp.setWarnWhenFull();
        }
        qv_exts = new HashSet<String>();
        pconfigQuickViewListeners = new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                String exts_str = COConfigurationManager.getStringParameter("quick.view.exts");
                int max_bytes = COConfigurationManager.getIntParameter("quick.view.maxkb") * 1024;
                String[] bits = exts_str.split("[;, ]");
                HashSet<String> exts = new HashSet<String>();
                String[] stringArray = bits;
                int n = bits.length;
                int n2 = 0;
                while (n2 < n) {
                    String bit = stringArray[n2];
                    if ((bit = bit.trim()).startsWith(".")) {
                        bit = bit.substring(1);
                    }
                    if (bit.length() > 0) {
                        exts.add(bit.toLowerCase());
                    }
                    ++n2;
                }
                qv_exts = exts;
                qv_max_bytes = max_bytes;
            }
        };
        COConfigurationManager.addAndFireParameterListeners(new String[]{"quick.view.exts", "quick.view.maxkb"}, pconfigQuickViewListeners);
        tt_enabled = false;
        COConfigurationManager.addAndFireParameterListener("Disable All Tooltips", new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                tt_enabled = !COConfigurationManager.getBooleanParameter(name);
            }
        });
        try {
            a_pattern = Pattern.compile("(?i)<a([^>]+)>(.+?)</a>");
            href_pattern = Pattern.compile("(?i)href\\s*=\\s*(\"([^\"]*\")|'[^']*'|([^'\">\\s]+))");
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        dl_depth = new AtomicInteger();
    }

    static void initStatic(Core core) {
        if (DEBUG_SWTEXEC) {
            System.out.println("==== debug.swtexec=1, performance may be affected ====");
            queue = new ArrayList();
            diag_logger = AEDiagnostics.getLogger("swt");
            diag_logger.log("\n\nSWT Logging Starts");
            evidenceGenerator = new AEDiagnosticsEvidenceGenerator(){

                @Override
                public void generate(IndentWriter writer) {
                    writer.println("SWT Queue:");
                    writer.indent();
                    for (Runnable r : queue) {
                        if (r == null) {
                            writer.println("NULL");
                            continue;
                        }
                        writer.println(r.toString());
                    }
                    writer.exdent();
                }
            };
            AEDiagnostics.addEvidenceGenerator(evidenceGenerator);
        } else {
            queue = null;
            diag_logger = null;
        }
        configUserModeListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                userMode = COConfigurationManager.getIntParameter("User Mode");
            }
        };
        configUIListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                String ui = COConfigurationManager.getStringParameter("ui");
                isAZ2 = ui.equals("az2");
                isAZ3 = ui.equals("az3");
            }
        };
        COConfigurationManager.addAndFireParameterListener("User Mode", configUserModeListener);
        COConfigurationManager.addAndFireParameterListener("ui", configUIListener);
        UIConfigDefaultsSWT.initialize();
        UIConfigDefaultsSWTv3.initialize(core);
        boolean smallOSXControl = COConfigurationManager.getBooleanParameter("enable_small_osx_fonts");
        BUTTON_MARGIN = Constants.isOSX ? (smallOSXControl ? 10 : 12) : 6;
        configOtherListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                dark_misc_things = COConfigurationManager.getBooleanParameter("Dark Misc Colors");
                gradient_fill = COConfigurationManager.getBooleanParameter("Gradient Fill Selection");
                gui_refresh_disable_when_min = COConfigurationManager.getBooleanParameter("GUI Refresh Disable When Minimized");
                gui_refresh_enable = !gui_is_minimized || !gui_refresh_disable_when_min;
            }
        };
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Dark Misc Colors", "Gradient Fill Selection", "GUI Refresh Disable When Minimized"}, configOtherListener);
    }

    public static void initialize(Display _display) {
        display = _display;
        if (UI.useSystemTheme() && Constants.isWindows) {
            try {
                try {
                    Class<?> OS = Class.forName("org.eclipse.swt.internal.win32.OS");
                    Method setTheme = OS.getMethod("setTheme", Boolean.TYPE);
                    setTheme.invoke(null, true);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
                force_dark_appearance = true;
                skinner = new Skinner(display);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        isGTK3 = isGTK && System.getProperty("org.eclipse.swt.internal.gtk.version", "2").startsWith("3");
        Utils.execSWTThread(() -> display.addFilter(29, ev -> {
            dragDetectMask = ev.stateMask;
        }));
    }

    public static void setSkinningEnabled(boolean enabled) {
        if (!Utils.isSWTThread()) {
            Debug.out("This probably won't work...");
        }
        skinning_enabled = enabled ? ++skinning_enabled : --skinning_enabled;
    }

    public static void setSkinnedControlType(Control control, int type) {
        control.setData("utils:skinned-ct", (Object)type);
    }

    private static void setSkinnedForegroundDefault(Control control, Color color) {
        Boolean forced = (Boolean)control.getData("utils:skinned-fg-forced");
        if (forced == null || !forced.booleanValue()) {
            control.setForeground(color);
        }
        control.setData("utils:skinned-fg", (Object)color);
    }

    private static void setSkinnedBackgroundDefault(Control control, Color color) {
        Boolean forced = (Boolean)control.getData("utils:skinned-bg-forced");
        if (forced == null || !forced.booleanValue()) {
            control.setBackground(color);
        }
        control.setData("utils:skinned-bg", (Object)color);
    }

    private static void setSkinnedForegroundDefault(CTabItem control, Color color) {
        try {
            Method m = CTabItem.class.getMethod("setForeground", Color.class);
            m.invoke((Object)control, color);
            control.setData("utils:skinned-fg", (Object)color);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static boolean hasSkinnedForeground(Control control) {
        return control.getData("utils:skinned-fg") != null;
    }

    public static void setSkinnedForeground(Control control, Color color) {
        Utils.setSkinnedForeground(control, color, false);
    }

    public static void setSkinnedForeground(Control control, Color color, boolean force) {
        if (force) {
            if (color == null) {
                control.setData("utils:skinned-fg-forced", null);
                Color def = (Color)control.getData("utils:skinned-fg");
                control.setForeground(def);
            } else {
                control.setData("utils:skinned-fg-forced", (Object)true);
                control.setForeground(color);
            }
        } else {
            Color def = (Color)control.getData("utils:skinned-fg");
            if (def != null) {
                control.setForeground(color == null ? def : color);
            } else {
                control.setForeground(color);
            }
        }
    }

    public static Color getSkinnedForeground(Control c) {
        if (skinner != null) {
            Color bg = c.getForeground();
            c.setForeground(null);
            skinner.handleSkinning((Widget)c);
            Color skinned = c.getForeground();
            c.setForeground(bg);
            return skinned;
        }
        return c.getForeground();
    }

    public static boolean hasSkinnedBackground(Control control) {
        return control.getData("utils:skinned-bg") != null;
    }

    public static Color getSkinnedBackground(Control c) {
        if (skinner != null) {
            Color bg = c.getBackground();
            c.setBackground(null);
            skinner.handleSkinning((Widget)c);
            Color skinned = c.getBackground();
            c.setBackground(bg);
            return skinned;
        }
        return c.getBackground();
    }

    public static void setSkinnedBackground(Control control, Color color) {
        Utils.setSkinnedBackground(control, color, false);
    }

    public static void setSkinnedBackground(Control control, Color color, boolean force) {
        if (force) {
            if (color == null) {
                control.setData("utils:skinned-bg-forced", null);
                Color def = (Color)control.getData("utils:skinned-bg");
                control.setBackground(def);
            } else {
                control.setData("utils:skinned-bg-forced", (Object)true);
                control.setBackground(color);
            }
        } else {
            Color def = (Color)control.getData("utils:skinned-bg");
            if (def != null) {
                control.setBackground(color == null ? def : color);
            } else {
                control.setBackground(color);
            }
        }
    }

    public static void setSkinnedBackground(Control control, Control from) {
        control.setBackground(from.getBackground());
        control.setData("utils:skinned-bg-forced", from.getData("utils:skinned-bg-forced"));
    }

    public static Control createSkinnedLabelSeparator(Composite parent, int style) {
        return Utils.createSkinnedLabelSeparator(parent, style, Colors.getSystemColor((Device)display, 23));
    }

    public static Control createSkinnedLabelSeparator(Composite parent, final int style, Color color) {
        if (Utils.isDarkAppearanceNativeWindows()) {
            Composite comp2 = new Composite(parent, 0){

                public Point computeSize(int wHint, int hHint, boolean changed) {
                    Point size = super.computeSize(wHint, hHint, changed);
                    if ((style & 0x100) != 0) {
                        size.y = 2;
                    } else {
                        size.x = 2;
                    }
                    return size;
                }
            };
            comp2.addListener(9, ev -> {
                Rectangle bounds = comp2.getBounds();
                ev.gc.setBackground(color);
                ev.gc.fillRectangle(0, 0, bounds.width, bounds.height);
            });
            return comp2;
        }
        return new Label(parent, 2 | style);
    }

    public static Composite createSkinnedComposite(Composite parent, int style, Object parentLayoutData) {
        return Utils.createSkinnedCompositeEx(parent, style, parentLayoutData)[1];
    }

    public static Composite[] createSkinnedCompositeEx(Composite parent, int style, Object parentLayoutData) {
        if ((style | 0x800) != 0 && Utils.isDarkAppearanceNativeWindows()) {
            GridLayout layout;
            Layout parentLayout;
            Composite bc = new Composite(parent, 0);
            if (parentLayoutData != null) {
                if (parentLayoutData instanceof GridData) {
                    GridData gd = (GridData)parentLayoutData;
                    if (gd.widthHint != -1) {
                        gd.widthHint += 4;
                    }
                    if (gd.heightHint != -1) {
                        gd.heightHint += 4;
                    }
                }
                bc.setLayoutData(parentLayoutData);
            }
            if ((parentLayout = parent.getLayout()) instanceof FormLayout) {
                layout = new FormLayout();
                layout.marginRight = 2;
                layout.marginLeft = 2;
                layout.marginTop = 2;
                layout.marginBottom = 2;
                bc.setLayout((Layout)layout);
            } else {
                layout = Utils.getSimpleGridLayout(1);
                layout.marginRight = 2;
                layout.marginLeft = 2;
                layout.marginTop = 2;
                layout.marginBottom = 2;
                bc.setLayout((Layout)layout);
            }
            bc.addListener(9, ev -> {
                Rectangle bounds = bc.getBounds();
                ev.gc.setForeground(Colors.getSystemColor((Device)display, 23));
                ev.gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
            });
            Composite comp2 = new Composite(bc, style & 0xFFFFF7FF);
            comp2.addListener(12, ev -> {
                if (!bc.isDisposed()) {
                    bc.dispose();
                }
            });
            if (parentLayout instanceof FormLayout) {
                comp2.setLayoutData((Object)Utils.getFilledFormData());
            } else {
                comp2.setLayoutData((Object)new GridData(1808));
            }
            return new Composite[]{bc, comp2};
        }
        Composite comp3 = new Composite(parent, style);
        if (parentLayoutData != null) {
            comp3.setLayoutData(parentLayoutData);
        }
        return new Composite[]{comp3, comp3};
    }

    public static Group createSkinnedGroup(Composite parent, int style) {
        if (Utils.isDarkAppearanceNativeWindows()) {
            Group comp2 = new Group(parent, style);
            comp2.addListener(9, ev -> {
                Rectangle bounds = comp2.getBounds();
                GC gc = ev.gc;
                int height = gc.getFontMetrics().getHeight();
                int y_offset = height / 2;
                gc.setBackground(parent.getBackground());
                gc.setForeground(Colors.getSystemColor((Device)display, 23));
                gc.fillRectangle(0, 0, bounds.width, bounds.height);
                gc.drawRectangle(0, y_offset, bounds.width - 1, bounds.height - 1 - y_offset);
            });
            return comp2;
        }
        Group comp3 = new Group(parent, style);
        return comp3;
    }

    public static void setLinkForeground(Control label) {
        Utils.setSkinnedForeground(label, Colors.getSystemColor((Device)label.getDisplay(), 36), true);
    }

    public static int getDragDetectModifiers() {
        return dragDetectMask;
    }

    public static int getSWTVersion() {
        return SWT_VERSION;
    }

    public static int getSWTRevision() {
        return SWT_REVISION;
    }

    public static String getSWTPlatform() {
        return SWT_PLATFORM;
    }

    public static String getSWTVersionAndRevision() {
        return SWT_REVISION == 0 ? String.valueOf(SWT_VERSION) : String.valueOf(SWT_VERSION) + "r" + SWT_REVISION;
    }

    public static int getDeviceZoom() {
        if (method_DPIUTIL_getDeviceZoom != null) {
            try {
                Integer res = (Integer)method_DPIUTIL_getDeviceZoom.invoke(null, new Object[0]);
                return res;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 100;
    }

    public static int getNativeDeviceZoom() {
        if (method_DPIUTIL_getNativeDeviceZoom != null) {
            try {
                Integer res = (Integer)method_DPIUTIL_getNativeDeviceZoom.invoke(null, new Object[0]);
                return res;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 100;
    }

    public static void setUIVisible(boolean visible) {
        gui_is_minimized = !visible;
        gui_refresh_enable = !gui_is_minimized || !gui_refresh_disable_when_min;
    }

    public static boolean isUIUpdateEnabled() {
        return gui_refresh_enable;
    }

    public static void addTerminateListener(TerminateListener l) {
        listeners.add(l);
    }

    public static void setTerminated() {
        terminated = true;
        for (TerminateListener l : listeners) {
            try {
                l.terminated();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public static boolean isTerminated() {
        return terminated;
    }

    public static boolean isAZ2UI() {
        if (configUIListener == null) {
            Debug.out("hmm");
        }
        return isAZ2;
    }

    public static boolean isAZ3UI() {
        if (configUIListener == null) {
            Debug.out("hmm");
        }
        return isAZ3;
    }

    public static int getUserMode() {
        if (configUserModeListener == null) {
            Debug.out("hmm");
        }
        return userMode;
    }

    public static void setEnabled(Composite composite, boolean enabled) {
        if (composite == null || composite.isDisposed()) {
            return;
        }
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control != null && !control.isDisposed()) {
                if (control instanceof Composite) {
                    Utils.setEnabled((Composite)control, enabled);
                } else {
                    control.setEnabled(enabled);
                }
            }
            ++n2;
        }
        composite.setEnabled(enabled);
    }

    public static void disposeComposite(Composite composite, boolean disposeSelf) {
        if (composite == null || composite.isDisposed()) {
            return;
        }
        Control[] controls = composite.getChildren();
        int i = 0;
        while (i < controls.length) {
            Control control = controls[i];
            if (control != null && !control.isDisposed()) {
                if (control instanceof Composite) {
                    Utils.disposeComposite((Composite)control, true);
                }
                try {
                    control.dispose();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            ++i;
        }
        if (!composite.isDisposed() && disposeSelf) {
            try {
                composite.dispose();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public static void disposeComposite(Composite composite) {
        Utils.disposeComposite(composite, true);
    }

    public static void disposeSWTObjects(List disposeList) {
        Utils.disposeSWTObjects(disposeList.toArray());
        disposeList.clear();
    }

    public static void disposeSWTObjects(Object ... disposeList) {
        if (disposeList == null) {
            return;
        }
        Object[] objectArray = disposeList;
        int n = disposeList.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != null) {
                try {
                    if (o instanceof Widget) {
                        Widget w = (Widget)o;
                        if (!w.isDisposed()) {
                            w.dispose();
                        }
                    } else if (o instanceof Resource) {
                        Resource r = (Resource)o;
                        if (!r.isDisposed()) {
                            r.dispose();
                        }
                    } else {
                        Debug.out("No dispose action for " + o.getClass());
                    }
                }
                catch (Exception e) {
                    Debug.out("Warning: Disposal failed " + Debug.getCompressedStackTrace(e, 0, -1, true));
                }
            }
            ++n2;
        }
    }

    public static String getLinkFromClipboard(Display display) {
        Clipboard cb = new Clipboard(display);
        TextTransfer transfer = TextTransfer.getInstance();
        String data = (String)cb.getContents((Transfer)transfer);
        String text = UrlUtils.parseTextForURL(data, false);
        if (text == null) {
            return "http://";
        }
        return text;
    }

    public static void centreWindow(Shell shell) {
        Utils.centreWindow(shell, true);
    }

    public static void centreWindow(Shell shell, boolean shrink_if_needed) {
        Rectangle displayArea;
        try {
            displayArea = shell.getMonitor().getClientArea();
        }
        catch (NoSuchMethodError e) {
            displayArea = shell.getDisplay().getClientArea();
        }
        Rectangle centerInArea = shell.getParent() != null ? shell.getParent().getBounds() : displayArea;
        Rectangle shellRect = shell.getBounds();
        if (shrink_if_needed) {
            if (shellRect.height > displayArea.height) {
                shellRect.height = displayArea.height;
            }
            if (shellRect.width > displayArea.width - 50) {
                shellRect.width = displayArea.width;
            }
        }
        shellRect.x = centerInArea.x + (centerInArea.width - shellRect.width) / 2;
        shellRect.y = centerInArea.y + (centerInArea.height - shellRect.height) / 2;
        shell.setBounds(shellRect);
    }

    public static void centerWindowRelativeTo(Shell window, Control control) {
        if (control == null || control.isDisposed() || window == null || window.isDisposed()) {
            return;
        }
        Rectangle bounds = control.getBounds();
        Point shellSize = window.getSize();
        window.setLocation(bounds.x + bounds.width / 2 - shellSize.x / 2, bounds.y + bounds.height / 2 - shellSize.y / 2);
    }

    public static List<RGB> getCustomColors() {
        String custom_colours_str = COConfigurationManager.getStringParameter("color.parameter.custom.colors", "");
        String[] bits = custom_colours_str.split(";");
        ArrayList<RGB> custom_colours = new ArrayList<RGB>();
        String[] stringArray = bits;
        int n = bits.length;
        int n2 = 0;
        while (n2 < n) {
            String bit = stringArray[n2];
            String[] x = bit.split(",");
            if (x.length == 3) {
                try {
                    custom_colours.add(new RGB(Integer.parseInt(x[0]), Integer.parseInt(x[1]), Integer.parseInt(x[2])));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return custom_colours;
    }

    public static void updateCustomColors(RGB[] new_cc) {
        if (new_cc != null) {
            String custom_colours_str = "";
            RGB[] rGBArray = new_cc;
            int n = new_cc.length;
            int n2 = 0;
            while (n2 < n) {
                RGB colour = rGBArray[n2];
                custom_colours_str = String.valueOf(custom_colours_str) + (custom_colours_str.isEmpty() ? "" : ";") + colour.red + "," + colour.green + "," + colour.blue;
                ++n2;
            }
            COConfigurationManager.setParameter("color.parameter.custom.colors", custom_colours_str);
        }
    }

    public static Color getConfigColor(String name, Color def) {
        String str = COConfigurationManager.getStringParameter(name, null);
        if (str != null) {
            String[] bits = str.split(",");
            if (bits.length == 3) {
                try {
                    int r = Integer.parseInt(bits[0].trim());
                    int g = Integer.parseInt(bits[1].trim());
                    int b = Integer.parseInt(bits[2].trim());
                    return ColorCache.getColor((Device)Utils.getDisplay(), r, g, b);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return null;
        }
        return def;
    }

    public static void setConfigColor(String name, Color c) {
        if (c == null) {
            COConfigurationManager.setParameter(name, "");
        } else {
            RGB rgb = c.getRGB();
            COConfigurationManager.setParameter(name, String.valueOf(rgb.red) + "," + rgb.green + "," + rgb.blue);
        }
    }

    public static ColorButton createColorButton(Composite composite, Point size, boolean isForeground, int[] existingColor, int[] defaultColor, Consumer<int[]> listener) {
        final int[][] currentColor = new int[][]{existingColor};
        final Button colorChooser = new Button(composite, 8);
        Messages.setLanguageTooltip((Widget)colorChooser, isForeground ? "label.foreground.color" : "label.background.color");
        org.eclipse.swt.graphics.Image[] img = new org.eclipse.swt.graphics.Image[1];
        Runnable imageDisposer = () -> {
            org.eclipse.swt.graphics.Image old = img[0];
            if (old != null && !old.isDisposed()) {
                old.dispose();
            }
            imageArray[0] = null;
        };
        final Runnable imageUpdater = () -> {
            imageDisposer.run();
            int w = point.x;
            int h = point.y;
            int offset = 5;
            org.eclipse.swt.graphics.Image newImage = new org.eclipse.swt.graphics.Image((Device)display, w, h);
            GC gc = new GC((Drawable)newImage);
            try {
                int[] rgb = currentColor[0];
                Color bg = Colors.getSystemColor((Device)display, 22);
                Color fg = Colors.getSystemColor((Device)display, 21);
                Color border = Colors.getSystemColor((Device)display, 23);
                gc.setBackground(bg);
                gc.fillRectangle(0, 0, w, h);
                Rectangle fg_rect = new Rectangle(0, 0, w - offset - 1, h - offset - 1);
                Rectangle bg_rect = new Rectangle(offset, offset, w - offset - 1, h - offset - 1);
                Color color = null;
                if (rgb != null) {
                    color = ColorCache.getColor((Device)display, rgb[0], rgb[1], rgb[2]);
                }
                boolean stripe = false;
                if (color == null) {
                    color = Colors.getSystemColor((Device)display, 18);
                    stripe = true;
                }
                if (isForeground) {
                    gc.setBackground(bg);
                    gc.fillRectangle(bg_rect);
                    gc.setBackground(border);
                    gc.drawRectangle(bg_rect);
                    gc.setBackground(color);
                    gc.fillRectangle(fg_rect);
                    if (stripe) {
                        Utils.drawStriped(gc, fg_rect.x, fg_rect.y, fg_rect.width, fg_rect.height, 1, 1, false);
                    }
                    gc.setBackground(border);
                    gc.drawRectangle(fg_rect);
                } else {
                    gc.setBackground(color);
                    gc.fillRectangle(bg_rect);
                    if (stripe) {
                        Utils.drawStriped(gc, bg_rect.x, bg_rect.y, bg_rect.width, bg_rect.height, 1, 1, false);
                    }
                    gc.setBackground(border);
                    gc.drawRectangle(bg_rect);
                    gc.setBackground(fg);
                    gc.fillRectangle(fg_rect);
                    gc.setBackground(border);
                    gc.drawRectangle(fg_rect);
                }
            }
            finally {
                gc.dispose();
            }
            ImageData id = newImage.getImageData();
            newImage.dispose();
            int i = 0;
            while (i < w) {
                int j = 0;
                while (j < h) {
                    id.setAlpha(i, j, 255);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < offset) {
                int j = h - offset;
                while (j < h) {
                    id.setAlpha(i, j, 0);
                    ++j;
                }
                ++i;
            }
            i = w - offset;
            while (i < w) {
                int j = 0;
                while (j < offset) {
                    id.setAlpha(i, j, 0);
                    ++j;
                }
                ++i;
            }
            imageArray[0] = newImage = new org.eclipse.swt.graphics.Image((Device)display, id);
            colorChooser.setImage(newImage);
        };
        imageUpdater.run();
        Menu menu = new Menu((Control)colorChooser);
        colorChooser.setMenu(menu);
        final MenuItem mi = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)mi, "ConfigView.section.style.colorOverrides.reset");
        mi.addListener(13, e -> {
            nArray[0] = defaultColor;
            listener.accept(defaultColor);
            imageUpdater.run();
        });
        final Supplier<Boolean> isDefaultValue = () -> {
            if (defaultColor == null && currentColor[0] == null) {
                return true;
            }
            if (defaultColor == null || currentColor[0] == null) {
                return false;
            }
            return Arrays.equals(defaultColor, currentColor[0]);
        };
        try {
            menu.addMenuListener(MenuListener.menuShownAdapter(e -> mi.setEnabled((Boolean)isDefaultValue.get() == false)));
        }
        catch (Throwable e2) {
            menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    mi.setEnabled((Boolean)isDefaultValue.get() == false);
                }
            });
        }
        colorChooser.addListener(12, e -> imageDisposer.run());
        colorChooser.addListener(13, e -> {
            ColorDialog cd = new ColorDialog(composite.getShell());
            List<RGB> custom_colours = Utils.getCustomColors();
            int[] rgb = currentColor[0];
            if (rgb != null && rgb.length == 3) {
                RGB colour = new RGB(rgb[0], rgb[1], rgb[2]);
                custom_colours.remove(colour);
                custom_colours.add(0, colour);
                cd.setRGB(colour);
            }
            cd.setRGBs(custom_colours.toArray(new RGB[0]));
            RGB newColor = cd.open();
            if (newColor != null) {
                Utils.updateCustomColors(cd.getRGBs());
                nArray[0] = new int[]{newColor.red, newColor.green, newColor.blue};
                listener.accept(currentColor[0]);
                imageUpdater.run();
            }
        });
        return new ColorButton(){

            @Override
            public Button getButton() {
                return colorChooser;
            }

            @Override
            public void setColor(int[] rgb) {
                currentColor[0] = rgb;
                imageUpdater.run();
            }
        };
    }

    public static RGB showColorDialog(Control parent, RGB existing) {
        Shell parent_shell = parent.getShell();
        return Utils.showColorDialog(parent_shell, existing);
    }

    public static RGB showColorDialog(Shell parent_shell, RGB existing) {
        Shell centerShell = new Shell(parent_shell, 8);
        try {
            Rectangle displayArea;
            try {
                displayArea = parent_shell.getMonitor().getClientArea();
            }
            catch (NoSuchMethodError e) {
                displayArea = parent_shell.getDisplay().getClientArea();
            }
            int x = displayArea.x + displayArea.width / 2 - 120;
            int y = displayArea.y + displayArea.height / 2 - 170;
            centerShell.setLocation(x, y);
            ColorDialog cd = new ColorDialog(centerShell);
            cd.setRGB(existing);
            List<RGB> custom_colours = Utils.getCustomColors();
            if (existing != null) {
                custom_colours.remove(existing);
                custom_colours.add(0, existing);
            }
            cd.setRGBs(custom_colours.toArray(new RGB[0]));
            RGB rgb = cd.open();
            if (rgb != null) {
                Utils.updateCustomColors(cd.getRGBs());
            }
            RGB rGB = rgb;
            return rGB;
        }
        finally {
            centerShell.dispose();
        }
    }

    public static boolean isDisplayDisposed() {
        SWTThread swt = SWTThread.getInstance();
        return swt == null || swt.isTerminated() ? true : swt.getDisplay() == null;
    }

    public static Display getDisplayIfNotDisposing() {
        SWTThread swt = SWTThread.getInstance();
        return swt == null || swt.isTerminated() ? null : swt.getDisplay();
    }

    public static RowLayout getSimpleRowLayout(boolean fill) {
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginBottom = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginLeft = 0;
        rowLayout.fill = fill;
        return rowLayout;
    }

    public static GridLayout getSimpleGridLayout(int cols) {
        GridLayout gridLayout = new GridLayout(cols, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginWidth = 0;
        return gridLayout;
    }

    public static void alternateRowBackground(TableItem item) {
        if (Utils.isDarkAppearanceNativeWindows()) {
            return;
        }
        if (TABLE_GRIDLINE_IS_ALTERNATING_COLOR) {
            if (!item.getParent().getLinesVisible()) {
                item.getParent().setLinesVisible(true);
            }
            return;
        }
        if (item == null || item.isDisposed()) {
            return;
        }
        Color[] colors = new Color[]{Colors.getSystemColor((Device)item.getDisplay(), 25), TablePaintedUtils.isDark() ? Colors.colorAltRowDefault : Colors.colorAltRow};
        Color newColor = colors[item.getParent().indexOf(item) % colors.length];
        if (!item.getBackground().equals((Object)newColor)) {
            item.setBackground(newColor);
        }
    }

    public static void alternateTableBackground(Table table) {
        if (table == null || table.isDisposed()) {
            return;
        }
        if (TABLE_GRIDLINE_IS_ALTERNATING_COLOR) {
            if (!table.getLinesVisible()) {
                table.setLinesVisible(true);
            }
            return;
        }
        int iTopIndex = table.getTopIndex();
        if (iTopIndex < 0 || iTopIndex == 0 && table.getItemCount() == 0) {
            return;
        }
        int iBottomIndex = Utils.getTableBottomIndex(table, iTopIndex);
        Color[] colors = new Color[]{Colors.getSystemColor((Device)table.getDisplay(), 25), TablePaintedUtils.isDark() ? Colors.colorAltRowDefault : Colors.colorAltRow};
        int iFixedIndex = iTopIndex;
        int i = iTopIndex;
        while (i <= iBottomIndex) {
            TableItem row = table.getItem(i);
            if (!row.isDisposed()) {
                Color newColor = colors[iFixedIndex % colors.length];
                ++iFixedIndex;
                if (!row.getBackground().equals((Object)newColor)) {
                    row.setBackground(newColor);
                }
            }
            ++i;
        }
    }

    public static void setMenuItemImage(MenuItem item, final String repoKey) {
        if (Constants.isOSX || repoKey == null) {
            return;
        }
        ImageLoader imageLoader = ImageLoader.getInstance();
        item.setImage(imageLoader.getImage(repoKey));
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageLoader imageLoader = ImageLoader.getInstance();
                imageLoader.releaseImage(repoKey);
            }
        });
    }

    public static void setMenuItemImage(final com.biglybt.pif.ui.menus.MenuItem item, final String repoKey) {
        if (Constants.isOSX || repoKey == null) {
            return;
        }
        if (Utils.isSWTThread()) {
            ImageLoader imageLoader = ImageLoader.getInstance();
            UISWTGraphicImpl graphic = new UISWTGraphicImpl(imageLoader.getImage(repoKey));
            item.setGraphic(graphic);
        } else {
            Utils.execSWTThread(new Runnable(){

                @Override
                public void run() {
                    ImageLoader imageLoader = ImageLoader.getInstance();
                    UISWTGraphicImpl graphic = new UISWTGraphicImpl(imageLoader.getImage(repoKey));
                    item.setGraphic(graphic);
                }
            });
        }
    }

    public static void setMenuItemImage(CLabel item, final String repoKey) {
        if (Constants.isOSX || repoKey == null) {
            return;
        }
        ImageLoader imageLoader = ImageLoader.getInstance();
        item.setImage(imageLoader.getImage(repoKey));
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageLoader imageLoader = ImageLoader.getInstance();
                imageLoader.releaseImage(repoKey);
            }
        });
    }

    public static void setMenuItemImage(MenuItem item, org.eclipse.swt.graphics.Image image) {
        if (!Constants.isOSX) {
            item.setImage(image);
        }
    }

    public static void setShellIcon(Shell shell) {
        if (Constants.isOSX) {
            return;
        }
        try {
            if (shellIcons == null) {
                String[] shellIconNames = new String[]{"logo16", "logo32", "logo64", "logo128"};
                ArrayList<org.eclipse.swt.graphics.Image> listShellIcons = new ArrayList<org.eclipse.swt.graphics.Image>(shellIconNames.length);
                ImageLoader imageLoader = ImageLoader.getInstance();
                int i = 0;
                while (i < shellIconNames.length) {
                    org.eclipse.swt.graphics.Image image = imageLoader.getImage(shellIconNames[i]);
                    if (ImageLoader.isRealImage(image)) {
                        listShellIcons.add(image);
                    }
                    ++i;
                }
                shellIcons = listShellIcons.toArray(new org.eclipse.swt.graphics.Image[listShellIcons.size()]);
            }
            shell.setImages(shellIcons);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static Display getDisplay() {
        return Utils.getDisplay(true);
    }

    private static Display getDisplay(boolean warn) {
        Display display;
        block7: {
            SWTThread swt = SWTThread.getInstance();
            if (swt == null) {
                try {
                    display = Display.getCurrent();
                    if (display == null && warn) {
                        System.err.println("SWT null " + Debug.getCompressedStackTrace());
                        return null;
                    }
                    break block7;
                }
                catch (Throwable t) {
                    return null;
                }
            }
            if (swt.isTerminated()) {
                return null;
            }
            display = swt.getDisplay();
        }
        if (display == null || display.isDisposed()) {
            if (warn) {
                System.err.println("SWT disposed " + Debug.getCompressedStackTrace());
            }
            return null;
        }
        return display;
    }

    public static boolean execSWTThread(Runnable code, boolean async) {
        return Utils.execSWTThread(code, async ? -1 : -2);
    }

    public static boolean execSWTThreadLater(int msLater, Runnable code) {
        return Utils.execSWTThread(code, msLater);
    }

    public static boolean isSWTThread() {
        Display display = Utils.getDisplay();
        if (display == null) {
            return false;
        }
        return display.getThread() == Thread.currentThread();
    }

    private static boolean execSWTThread(final Runnable code, final int msLater) {
        boolean isSWTThread;
        final Display display = Utils.getDisplay(false);
        if (display == null) {
            if (code == null) {
                return false;
            }
            if (code instanceof SWTRunnable) {
                code.run();
                return true;
            }
            if (Constants.isCVSVersion() && !terminated) {
                System.out.println("Skipping, SWT null " + Debug.getCompressedStackTrace());
            }
            return false;
        }
        boolean bl = isSWTThread = display.getThread() == Thread.currentThread();
        if (msLater < 0 && isSWTThread) {
            try {
                if (queue == null) {
                    code.run();
                } else {
                    long lStartTimeRun = SystemTime.getCurrentTime();
                    code.run();
                    long wait = SystemTime.getCurrentTime() - lStartTimeRun;
                    if (wait > 700L) {
                        diag_logger.log(String.valueOf(SystemTime.getCurrentTime()) + "] took " + wait + "ms to run " + Debug.getCompressedStackTrace(new Throwable(), 2, -2, false));
                    }
                }
            }
            catch (Throwable t) {
                DebugLight.printStackTrace(t);
            }
        } else if (msLater >= -1) {
            try {
                if (queue == null) {
                    if (msLater <= 0) {
                        display.asyncExec(Utils.makeRunnableSafe(code));
                    }
                    if (isSWTThread) {
                        display.timerExec(msLater, Utils.makeRunnableSafe(code));
                    }
                    SimpleTimer.addEvent("execSWTThreadLater", SystemTime.getOffsetTime(msLater), new TimerEventPerformer(){

                        @Override
                        public void perform(TimerEvent event2) {
                            if (!display.isDisposed()) {
                                display.asyncExec(Utils.makeRunnableSafe(code));
                            }
                        }
                    });
                }
                queue.add(code);
                diag_logger.log(String.valueOf(SystemTime.getCurrentTime()) + "] + Q. size= " + queue.size() + ";in=" + msLater + "; add " + code + " via " + Debug.getCompressedStackTrace(new Throwable(), 2, -2, false));
                final long lStart = SystemTime.getCurrentTime();
                final Display fDisplay = display;
                final AERunnable runnableWrapper = new AERunnable(){

                    @Override
                    public void runSupport() {
                        long wait = SystemTime.getCurrentTime() - lStart - (long)msLater;
                        if (wait > 700L) {
                            diag_logger.log(String.valueOf(SystemTime.getCurrentTime()) + "] took " + wait + "ms before SWT ran async code " + code);
                        }
                        long lStartTimeRun = SystemTime.getCurrentTime();
                        try {
                            if (fDisplay.isDisposed()) {
                                Debug.out("Display disposed while trying to execSWTThread " + code);
                                try {
                                    code.run();
                                }
                                catch (SWTException e) {
                                    Debug.out("Error while execSWTThread w/disposed Display", e);
                                }
                            } else {
                                try {
                                    code.run();
                                }
                                catch (Throwable t) {
                                    Debug.out("execSWTThread " + code, t);
                                }
                            }
                        }
                        finally {
                            long runTIme = SystemTime.getCurrentTime() - lStartTimeRun;
                            if (runTIme > 500L) {
                                diag_logger.log(String.valueOf(SystemTime.getCurrentTime()) + "] took " + runTIme + "ms to run " + code);
                            }
                            queue.remove(code);
                            if (runTIme > 10L) {
                                diag_logger.log(String.valueOf(SystemTime.getCurrentTime()) + "] - Q. size=" + queue.size() + ";wait:" + wait + "ms;run:" + runTIme + "ms " + code);
                            } else {
                                diag_logger.log(String.valueOf(SystemTime.getCurrentTime()) + "] - Q. size=" + queue.size() + ";wait:" + wait + "ms;run:" + runTIme + "ms");
                            }
                        }
                    }
                };
                if (msLater <= 0) {
                    display.asyncExec((Runnable)runnableWrapper);
                }
                if (isSWTThread) {
                    display.timerExec(msLater, (Runnable)runnableWrapper);
                }
                SimpleTimer.addEvent("execSWTThreadLater", SystemTime.getOffsetTime(msLater), new TimerEventPerformer(){

                    @Override
                    public void perform(TimerEvent event2) {
                        if (!display.isDisposed()) {
                            display.asyncExec((Runnable)runnableWrapper);
                        }
                    }
                });
            }
            catch (NullPointerException e) {
                if (Constants.isCVSVersion()) {
                    Debug.out(e);
                }
                return false;
            }
        } else {
            display.syncExec(Utils.makeRunnableSafe(code));
        }
        return true;
    }

    private static Runnable makeRunnableSafe(final Runnable code) {
        if (!(code instanceof AERunnable) && !(code instanceof SWTRunnable)) {
            return new AERunnable(){

                @Override
                public void runSupport() {
                    code.run();
                }
            };
        }
        return code;
    }

    public static boolean execSWTThread(Runnable code) {
        return Utils.execSWTThread(code, -1);
    }

    public static boolean isThisThreadSWT() {
        Display display;
        SWTThread swt = SWTThread.getInstance();
        Display display2 = display = swt == null ? Display.getCurrent() : swt.getDisplay();
        if (display == null) {
            return false;
        }
        try {
            display.getWarnings();
        }
        catch (SWTException e) {
            return false;
        }
        return display.getThread() == Thread.currentThread();
    }

    public static int getTableBottomIndex(Table table, int iTopIndex) {
        Object lastBottomIndex = table.getData("lastBottomIndex");
        if (lastBottomIndex instanceof Number) {
            return ((Number)lastBottomIndex).intValue();
        }
        int columnCount = table.getColumnCount();
        if (columnCount == 0) {
            return -1;
        }
        int xPos = table.getColumn(0).getWidth() - 1;
        if (columnCount > 1) {
            xPos += table.getColumn(1).getWidth();
        }
        Rectangle clientArea = table.getClientArea();
        TableItem bottomItem = table.getItem(new Point(xPos, clientArea.y + clientArea.height - 2));
        if (bottomItem != null) {
            return table.indexOf(bottomItem);
        }
        return table.getItemCount() - 1;
    }

    public static void launch(final com.biglybt.core.disk.DiskManagerFileInfo fileInfo2) {
        LaunchManager launch_manager = LaunchManager.getManager();
        LaunchManager.LaunchTarget target = launch_manager.createTarget(fileInfo2);
        launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

            @Override
            public void actionAllowed() {
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        PlatformTorrentUtils.setHasBeenOpened(fileInfo2.getDownloadManager(), fileInfo2.getIndex(), true);
                        Utils.launch(fileInfo2.getFile(true).toString());
                    }
                });
            }

            @Override
            public void actionDenied(Throwable reason) {
                Debug.out("Launch request denied", reason);
            }
        });
    }

    public static void launch(URL url) {
        Utils.launch(url.toExternalForm());
    }

    public static void launch(Object urlOrFile) {
        Utils.launch(String.valueOf(urlOrFile));
    }

    public static void launch(String sFile) {
        Utils.launch(sFile, false);
    }

    public static void launch(String sFileOriginal, boolean sync) {
        Utils.launch(sFileOriginal, sync, false);
    }

    public static void launch(String sFileOriginal, boolean sync, boolean force_url) {
        Utils.launch(sFileOriginal, sync, force_url, false);
    }

    public static void launch(String sFileOriginal, boolean sync, boolean force_url, boolean force_anon) {
        boolean launched;
        String lc_sFile;
        String sFileModified = sFileOriginal;
        if (sFileModified == null || sFileModified.trim().length() == 0) {
            return;
        }
        if (!force_url) {
            String exe;
            PlatformManager mgr;
            if (!Constants.isWindows && new File(sFileModified).isDirectory() && (mgr = PlatformManagerFactory.getPlatformManager()).hasCapability(PlatformManagerCapabilities.ShowFileInBrowser)) {
                try {
                    PlatformManagerFactory.getPlatformManager().showFile(sFileModified);
                    return;
                }
                catch (PlatformManagerException platformManagerException) {
                    // empty catch block
                }
            }
            if ((exe = Utils.getExplicitLauncher(sFileModified = sFileModified.replaceAll("&vzemb=1", ""))) != null) {
                Utils.launchFileExplicit(sFileModified, exe);
                return;
            }
        }
        if ((lc_sFile = sFileModified.toLowerCase(Locale.US)).startsWith("tor:") || lc_sFile.startsWith("i2p:")) {
            force_anon = true;
            sFileModified = lc_sFile = lc_sFile.substring(4);
        }
        if (lc_sFile.startsWith("http:") || lc_sFile.startsWith("https:")) {
            boolean use_plugins;
            String eb_choice;
            String net_type;
            if (force_anon) {
                net_type = "Tor";
                eb_choice = "plugin";
                use_plugins = true;
            } else {
                net_type = "Public";
                try {
                    net_type = AENetworkClassifier.categoriseAddress(new URL(sFileModified).getHost());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                eb_choice = COConfigurationManager.getStringParameter("browser.external.id");
                use_plugins = COConfigurationManager.getBooleanParameter("browser.external.non.pub");
                if (net_type != "Public" && use_plugins) {
                    eb_choice = "plugin";
                }
            }
            if (!eb_choice.equals("system")) {
                if (eb_choice.equals("manual")) {
                    block32: {
                        String browser_cmd_str = COConfigurationManager.getStringParameter("browser.external.prog", "");
                        File bf = new File(browser_cmd_str = browser_cmd_str.trim());
                        String[] browser_cmd = bf.exists() ? new String[]{browser_cmd_str} : (browser_cmd_str.contains(" ") ? GeneralUtils.decomposeArgs(browser_cmd_str) : new String[]{browser_cmd_str});
                        String browser_exe = browser_cmd[0];
                        bf = new File(browser_exe);
                        if (bf.exists()) {
                            try {
                                if (Constants.isOSX && browser_exe.endsWith(".app")) {
                                    String[] args = new String[3 + browser_cmd.length];
                                    args[0] = "open";
                                    args[1] = "-a";
                                    int i = 0;
                                    while (i < browser_cmd.length) {
                                        args[2 + i] = browser_cmd[i];
                                        ++i;
                                    }
                                    args[args.length - 1] = sFileModified;
                                    ProcessBuilder pb = GeneralUtils.createProcessBuilder(bf.getParentFile(), args, null);
                                    pb.start();
                                    break block32;
                                }
                                String[] args = new String[1 + browser_cmd.length];
                                args[0] = bf.getAbsolutePath();
                                int i = 1;
                                while (i < browser_cmd.length) {
                                    args[i] = browser_cmd[i];
                                    ++i;
                                }
                                args[args.length - 1] = sFileModified;
                                Process process = Runtime.getRuntime().exec(args);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        } else {
                            Debug.out("Can't launch '" + sFileModified + "' as manual browser '" + bf + " ' doesn't exist");
                        }
                    }
                    return;
                }
                Utils.handlePluginLaunch(eb_choice, net_type, use_plugins, sFileOriginal, sFileModified, sync, force_url, force_anon);
                return;
            }
        } else {
            String plug_uri;
            if (lc_sFile.startsWith("magnet:")) {
                TorrentOpener.openTorrent(sFileOriginal);
                return;
            }
            if (lc_sFile.startsWith("azplug:?")) {
                plug_uri = sFileOriginal;
                try {
                    URLConnection connection = new URL(plug_uri).openConnection();
                    connection.connect();
                    String res = FileUtil.readInputStreamAsString(connection.getInputStream(), 2048);
                    return;
                }
                catch (Throwable connection) {}
            } else if (lc_sFile.startsWith("chat:")) {
                plug_uri = "azplug:?id=azbuddy&arg=" + UrlUtils.encode(sFileModified);
                try {
                    URLConnection connection = new URL(plug_uri).openConnection();
                    connection.connect();
                    String res = FileUtil.readInputStreamAsString(connection.getInputStream(), 2048);
                    return;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (!(launched = Program.launch((String)sFileModified)) && Constants.isUnix && !Utils.fallbackLaunch("xdg-open", sFileModified)) {
            Debug.out("Failed to launch '" + sFileModified + "'");
        }
    }

    public static void launchFileExplicit(com.biglybt.core.disk.DiskManagerFileInfo file, String exe) {
        Utils.launchFileExplicit(file.getFile(true).toString(), exe);
    }

    public static void launchFileExplicit(String sfile, String ... cmd_args) {
        File file = new File(sfile);
        try {
            String cmd = "";
            String[] stringArray = cmd_args;
            int n = cmd_args.length;
            int n2 = 0;
            while (n2 < n) {
                String ca = stringArray[n2];
                cmd = String.valueOf(cmd) + (cmd.isEmpty() ? "" : " ") + ca;
                ++n2;
            }
            System.out.println("Launching " + sfile + " with " + cmd);
            if (Constants.isWindows) {
                if (!cmd.endsWith(",")) {
                    cmd = String.valueOf(cmd) + " ";
                }
                try {
                    PlatformManagerFactory.getPlatformManager().createProcess(String.valueOf(cmd) + "\"" + sfile + "\"", false);
                    return;
                }
                catch (Throwable ca) {}
            } else if (Constants.isOSX && cmd.endsWith(".app")) {
                ProcessBuilder pb = GeneralUtils.createProcessBuilder(file.getParentFile(), new String[]{"open", "-a", cmd, file.getName()}, null);
                pb.start();
                return;
            }
            String[] args = new String[cmd_args.length + 1];
            System.arraycopy(cmd_args, 0, args, 0, cmd_args.length);
            args[args.length - 1] = file.getName();
            ProcessBuilder pb = GeneralUtils.createProcessBuilder(file.getParentFile(), args, null);
            pb.start();
            return;
        }
        catch (Throwable e) {
            Debug.out("Launch failed", e);
            return;
        }
    }

    private static boolean fallbackLaunch(String command, String ... args) {
        try {
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add(command);
            cmdList.addAll(Arrays.asList(args));
            String[] cmdArray = cmdList.toArray(new String[0]);
            Runtime.getRuntime().exec(cmdArray);
            return true;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handlePluginLaunch(String eb_choice, String net_type, boolean use_plugins, final String sFileOriginal, final String sFileModified, final boolean sync, final boolean force_url, final boolean force_anon) {
        PluginManager pm = CoreFactory.getSingleton().getPluginManager();
        if (net_type == "I2P" && pm.getPluginInterfaceByID("azneti2phelper") == null) {
            boolean try_it;
            Set<String> set = pending_ext_urls;
            synchronized (set) {
                try_it = !i2p_install_active_for_url;
                i2p_install_active_for_url = true;
            }
            if (try_it) {
                ext_url_dispatcher.dispatch(new AERunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void runSupport() {
                        boolean installing = false;
                        try {
                            final boolean[] install_outcome = new boolean[1];
                            installing = I2PHelpers.installI2PHelper("azneti2phelper.install", install_outcome, new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    try {
                                        if (install_outcome[0]) {
                                            Utils.launch(sFileOriginal, sync, force_url, force_anon);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Set set = pending_ext_urls;
                                        synchronized (set) {
                                            i2p_install_active_for_url = false;
                                        }
                                        throw throwable;
                                    }
                                    Set set = pending_ext_urls;
                                    synchronized (set) {
                                        i2p_install_active_for_url = false;
                                    }
                                }
                            });
                        }
                        catch (Throwable throwable) {
                            if (!installing) {
                                Set set = pending_ext_urls;
                                synchronized (set) {
                                    i2p_install_active_for_url = false;
                                }
                            }
                            throw throwable;
                        }
                        if (!installing) {
                            Set set = pending_ext_urls;
                            synchronized (set) {
                                i2p_install_active_for_url = false;
                            }
                        }
                    }
                });
            } else {
                Debug.out("I2P installation already active");
            }
            return;
        }
        List<PluginInterface> pis = pm.getPluginsWithMethod("launchURL", new Class[]{URL.class, Boolean.TYPE, Runnable.class});
        boolean found = false;
        for (final PluginInterface pi : pis) {
            String id = "plugin:" + pi.getPluginID();
            if (!eb_choice.equals("plugin") && !id.equals(eb_choice)) continue;
            found = true;
            Set<String> set = pending_ext_urls;
            synchronized (set) {
                if (pending_ext_urls.contains(sFileModified)) {
                    Debug.outNoStack("Already queued browser request for '" + sFileModified + "' - ignoring");
                    return;
                }
                pending_ext_urls.add(sFileModified);
            }
            AERunnable launch = new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    block14: {
                        try {
                            try {
                                final AESemaphore sem = new AESemaphore("wait");
                                pi.getIPC().invoke("launchURL", new Object[]{new URL(sFileModified), false, new Runnable(){

                                    @Override
                                    public void run() {
                                        sem.release();
                                    }
                                }});
                                sem.reserve(30000L);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                                Set set = pending_ext_urls;
                                synchronized (set) {
                                    pending_ext_urls.remove(sFileModified);
                                    break block14;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Set set = pending_ext_urls;
                            synchronized (set) {
                                pending_ext_urls.remove(sFileModified);
                            }
                            throw throwable;
                        }
                        Set set = pending_ext_urls;
                        synchronized (set) {
                            pending_ext_urls.remove(sFileModified);
                        }
                    }
                }
            };
            if (sync) {
                launch.runSupport();
                continue;
            }
            ext_url_dispatcher.dispatch(launch);
        }
        if (!found && net_type != "Public" && use_plugins) {
            boolean try_it;
            Set<String> set = pending_ext_urls;
            synchronized (set) {
                try_it = !browser_install_active_for_url;
                browser_install_active_for_url = true;
            }
            if (try_it) {
                ext_url_dispatcher.dispatch(new AERunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void runSupport() {
                        block16: {
                            boolean installing = false;
                            try {
                                try {
                                    final boolean[] install_outcome = new boolean[1];
                                    installing = Utils.installTorBrowser("aznettorbrowser.install", install_outcome, new Runnable(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void run() {
                                            try {
                                                if (install_outcome[0]) {
                                                    Utils.launch(sFileOriginal, sync, force_url, force_anon);
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                Set set = pending_ext_urls;
                                                synchronized (set) {
                                                    browser_install_active_for_url = false;
                                                }
                                                throw throwable;
                                            }
                                            Set set = pending_ext_urls;
                                            synchronized (set) {
                                                browser_install_active_for_url = false;
                                            }
                                        }
                                    });
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                    if (installing) break block16;
                                    Set set = pending_ext_urls;
                                    synchronized (set) {
                                        browser_install_active_for_url = false;
                                        break block16;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                if (!installing) {
                                    Set set = pending_ext_urls;
                                    synchronized (set) {
                                        browser_install_active_for_url = false;
                                    }
                                }
                                throw throwable;
                            }
                            if (!installing) {
                                Set set = pending_ext_urls;
                                synchronized (set) {
                                    browser_install_active_for_url = false;
                                }
                            }
                        }
                    }
                });
            } else {
                Debug.out("Browser installation already active");
            }
            return;
        }
        if (!found && !eb_choice.equals("plugin")) {
            Debug.out("Failed to find external URL launcher plugin with id '" + eb_choice + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInstallingTorBrowser() {
        Set<String> set = pending_ext_urls;
        synchronized (set) {
            return tb_installing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean installTorBrowser(String remember_id, final boolean[] install_outcome, final Runnable callback) {
        boolean bl;
        block23: {
            boolean install;
            UIFunctions uif;
            boolean installing;
            block21: {
                block22: {
                    Set<String> set;
                    Set<String> set2 = pending_ext_urls;
                    synchronized (set2) {
                        block20: {
                            if (!tb_installing) break block20;
                            Debug.out("Tor Browser already installing");
                            return false;
                        }
                        tb_installing = true;
                    }
                    installing = false;
                    try {
                        uif = UIFunctionsManager.getUIFunctions();
                        if (uif != null) break block21;
                        Debug.out("UIFunctions unavailable - can't install plugin");
                        if (installing) break block22;
                        set = pending_ext_urls;
                    }
                    catch (Throwable throwable) {
                        if (!installing) {
                            Set<String> set3 = pending_ext_urls;
                            synchronized (set3) {
                                tb_installing = false;
                            }
                        }
                        throw throwable;
                    }
                    synchronized (set) {
                        tb_installing = false;
                    }
                }
                return false;
            }
            String title = MessageText.getString("aznettorbrowser.install");
            String text = MessageText.getString("aznettorbrowser.install.text");
            UIFunctionsUserPrompter prompter = uif.getUserPrompter(title, text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 0);
            if (remember_id != null) {
                prompter.setRemember(remember_id, false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
            }
            prompter.setAutoCloseInMS(0);
            prompter.open(null);
            boolean bl2 = install = prompter.waitUntilClosed() == 0;
            if (install) {
                uif.installPlugin("aznettorbrowser", "aznettorbrowser.install", new UIFunctions.actionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionComplete(Object result) {
                        try {
                            if (callback != null) {
                                if (result instanceof Boolean) {
                                    install_outcome[0] = (Boolean)result;
                                }
                                callback.run();
                            }
                        }
                        catch (Throwable throwable) {
                            Set set = pending_ext_urls;
                            synchronized (set) {
                                tb_installing = false;
                            }
                            throw throwable;
                        }
                        Set set = pending_ext_urls;
                        synchronized (set) {
                            tb_installing = false;
                        }
                    }
                });
                installing = true;
            } else {
                Debug.out("Tor Browser install declined (either user reply or auto-remembered)");
            }
            bl = install;
            if (installing) break block23;
            Set<String> set = pending_ext_urls;
            synchronized (set) {
                tb_installing = false;
            }
        }
        return bl;
    }

    private static String getExplicitLauncher(String file) {
        int pos = file.lastIndexOf(".");
        if (pos >= 0) {
            String ext = file.substring(pos + 1).toLowerCase().trim();
            int q_pos = ext.indexOf("?");
            if (q_pos > 0) {
                ext = ext.substring(0, q_pos);
            }
            int i = 0;
            while (i < ConfigKeysSWT.getLaunchHelperEntryCount()) {
                String exts = ConfigKeysSWT.getLaunchHelpersExts(i).trim();
                String exe = ConfigKeysSWT.getLaunchHelpersProg(i).trim();
                if (exts.length() > 0 && exe.length() > 0 && new File(exe).exists()) {
                    exts = "," + exts.toLowerCase();
                    exts = exts.replaceAll("\\.", ",");
                    exts = exts.replaceAll(";", ",");
                    exts = exts.replaceAll(" ", ",");
                    if ((exts = exts.replaceAll("[,]+", ",")).contains("," + ext)) {
                        return exe;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static String getPredefinedExplicitLauncher(String type) {
        int i = 0;
        while (i < ConfigKeysSWT.getLaunchHelperEntryCount()) {
            String exts = ConfigKeysSWT.getLaunchHelpersExts(i).trim();
            String exe = ConfigKeysSWT.getLaunchHelpersProg(i).trim();
            if (exts.length() > 0 && exe.length() > 0) {
                exts = "," + exts.toLowerCase();
                exts = exts.replaceAll("\\.", ",");
                exts = exts.replaceAll(";", ",");
                exts = exts.replaceAll(" ", ",");
                if ((exts = exts.replaceAll("[,]+", ",")).contains(type)) {
                    return exe;
                }
            }
            ++i;
        }
        return null;
    }

    public static void setCheckedInSetData(TableItem item, boolean checked) {
        item.setChecked(checked);
        if (Constants.isWindowsXP || isGTK) {
            Rectangle r = item.getBounds(0);
            Table table = item.getParent();
            Rectangle rTable = table.getClientArea();
            table.redraw(0, r.y, rTable.width, r.height, true);
        }
    }

    public static boolean linkShellMetricsToConfig(Shell shell, String sConfigPrefix) {
        boolean isMaximized = COConfigurationManager.getBooleanParameter(String.valueOf(sConfigPrefix) + ".maximized");
        if (!isMaximized) {
            shell.setMaximized(false);
        }
        String windowRectangle = COConfigurationManager.getStringParameter(String.valueOf(sConfigPrefix) + ".rectangle", null);
        boolean bDidResize = false;
        if (windowRectangle != null) {
            int i = 0;
            int[] values = new int[4];
            StringTokenizer st = new StringTokenizer(windowRectangle, ",");
            try {
                while (st.hasMoreTokens() && i < 4) {
                    values[i++] = Integer.valueOf(st.nextToken());
                }
                if (i == 4) {
                    Rectangle shellBounds = new Rectangle(values[0], values[1], values[2], values[3]);
                    if (shellBounds.width > 100 && shellBounds.height > 50) {
                        shell.setBounds(shellBounds);
                        Utils.verifyShellRect(shell, true);
                        bDidResize = true;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (isMaximized) {
            shell.setMaximized(isMaximized);
        }
        new ShellMetricsResizeListener(shell, sConfigPrefix);
        return bDidResize;
    }

    public static void setShellMetricsConfigEnabled(Shell shell, boolean enabled) {
        int[] disabled_count = (int[])shell.getData(SHELL_METRICS_DISABLED_KEY);
        if (enabled) {
            if (disabled_count == null || disabled_count[0] <= 0) {
                Debug.out("eh");
            } else {
                disabled_count[0] = disabled_count[0] - 1;
                if (disabled_count[0] == 0) {
                    shell.setData(SHELL_METRICS_DISABLED_KEY, null);
                }
            }
        } else if (disabled_count == null) {
            disabled_count = new int[]{1};
            shell.setData(SHELL_METRICS_DISABLED_KEY, (Object)disabled_count);
        } else {
            disabled_count[0] = disabled_count[0] + 1;
        }
    }

    public static boolean hasShellMetricsConfig(String sConfigPrefix) {
        if (COConfigurationManager.doesParameterNonDefaultExist(String.valueOf(sConfigPrefix) + ".maximized")) {
            return true;
        }
        return COConfigurationManager.doesParameterNonDefaultExist(String.valueOf(sConfigPrefix) + ".rectangle");
    }

    public static GridData setGridData(Composite composite, int gridStyle, Control ctrlBestSize, int maxHeight) {
        GridData gridData = new GridData(gridStyle);
        gridData.heightHint = ctrlBestSize.computeSize((int)-1, (int)-1).y;
        if (gridData.heightHint > maxHeight && maxHeight > 0) {
            gridData.heightHint = maxHeight;
        }
        composite.setLayoutData((Object)gridData);
        return gridData;
    }

    public static FormData getFilledFormData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        return formData;
    }

    public static void drawImageCenterScaleDown(GC gc, org.eclipse.swt.graphics.Image imgSrc, Rectangle area) {
        Rectangle imgSrcBounds = imgSrc.getBounds();
        if (area.width < imgSrcBounds.width || area.height < imgSrcBounds.height) {
            float dx = (float)area.width / (float)imgSrcBounds.width;
            float dy = (float)area.height / (float)imgSrcBounds.height;
            float d = Math.min(dx, dy);
            int newX = (int)((float)imgSrcBounds.width * d);
            int newY = (int)((float)imgSrcBounds.height * d);
            gc.drawImage(imgSrc, 0, 0, imgSrcBounds.width, imgSrcBounds.height, area.x + (area.width - newX) / 2, area.y + (area.height - newY) / 2, newX, newY);
        } else {
            int x = (area.width - imgSrcBounds.width) / 2;
            int y = (area.height - imgSrcBounds.height) / 2;
            gc.drawImage(imgSrc, 0, 0, imgSrcBounds.width, imgSrcBounds.height, area.x + x, area.y + y, imgSrcBounds.width, imgSrcBounds.height);
        }
    }

    public static boolean hasAlpha(org.eclipse.swt.graphics.Image image) {
        ImageData data = image.getImageData();
        int tt = data.getTransparencyType();
        if (tt == 0) {
            return false;
        }
        if (tt == 4) {
            return data.transparentPixel != -1;
        }
        if (tt == 2) {
            ImageData tm = data.getTransparencyMask();
            if (tm == null) {
                return false;
            }
            int x = 0;
            while (x < tm.width) {
                int y = 0;
                while (y < tm.height) {
                    if (tm.getPixel(x, y) == 0) {
                        return true;
                    }
                    ++y;
                }
                ++x;
            }
            return false;
        }
        int x = 0;
        while (x < data.width) {
            int y = 0;
            while (y < data.height) {
                if (data.getAlpha(x, y) != 255) {
                    return true;
                }
                ++y;
            }
            ++x;
        }
        return false;
    }

    public static void drawResizedImage(GC gc, org.eclipse.swt.graphics.Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (srcWidth == destWidth && srcHeight == destHeight) {
            gc.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight);
            return;
        }
        if (srcWidth <= 128 || Utils.hasAlpha(image)) {
            gc.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight);
            return;
        }
        org.eclipse.swt.graphics.Image tempImage = Utils.getResizedImage(image, srcX, srcY, srcWidth, srcHeight, destWidth, destHeight);
        try {
            gc.drawImage(tempImage, destX, destY);
        }
        finally {
            if (tempImage != null) {
                tempImage.dispose();
            }
        }
    }

    public static org.eclipse.swt.graphics.Image getResizedImage(org.eclipse.swt.graphics.Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destWidth, int destHeight) {
        GC tempGC = null;
        try {
            org.eclipse.swt.graphics.Image tempImage;
            if (destWidth > 100) {
                tempImage = Utils.resizeImage(image, destWidth, destHeight);
            } else {
                tempImage = new org.eclipse.swt.graphics.Image(image.getDevice(), destWidth, destHeight);
                tempGC = new GC((Drawable)tempImage);
                tempGC.drawImage(image, srcX, srcY, srcWidth, srcHeight, 0, 0, destWidth, destHeight);
            }
            org.eclipse.swt.graphics.Image image2 = tempImage;
            return image2;
        }
        finally {
            if (tempGC != null) {
                tempGC.dispose();
            }
        }
    }

    public static boolean drawImage(GC gc, org.eclipse.swt.graphics.Image image, Point srcStart, Rectangle dstRect, Rectangle clipping, int hOffset, int vOffset, boolean clearArea) {
        Rectangle srcRect;
        Point dstAdj;
        if (clipping == null) {
            dstAdj = new Point(0, 0);
            srcRect = new Rectangle(srcStart.x, srcStart.y, dstRect.width, dstRect.height);
        } else {
            if (!dstRect.intersects(clipping)) {
                return false;
            }
            dstAdj = new Point(Math.max(0, clipping.x - dstRect.x), Math.max(0, clipping.y - dstRect.y));
            srcRect = new Rectangle(0, 0, 0, 0);
            srcRect.x = srcStart.x + dstAdj.x;
            srcRect.y = srcStart.y + dstAdj.y;
            srcRect.width = Math.min(dstRect.width - dstAdj.x, clipping.x + clipping.width - dstRect.x);
            srcRect.height = Math.min(dstRect.height - dstAdj.y, clipping.y + clipping.height - dstRect.y);
        }
        if (!srcRect.isEmpty()) {
            try {
                if (clearArea) {
                    gc.fillRectangle(dstRect.x + dstAdj.x + hOffset, dstRect.y + dstAdj.y + vOffset, srcRect.width, srcRect.height);
                }
                gc.drawImage(image, srcRect.x, srcRect.y, srcRect.width, srcRect.height, dstRect.x + dstAdj.x + hOffset, dstRect.y + dstAdj.y + vOffset, srcRect.width, srcRect.height);
            }
            catch (Exception e) {
                System.out.println("drawImage: " + e.getMessage() + ": " + image + ", " + srcRect + ", " + (dstRect.x + dstAdj.y + hOffset) + "," + (dstRect.y + dstAdj.y + vOffset) + "," + srcRect.width + "," + srcRect.height + "; imageBounds = " + image.getBounds());
            }
        }
        return true;
    }

    public static Control findChild(Composite comp2, int x, int y) {
        Rectangle comp_bounds = comp2.getBounds();
        if (comp2.isVisible() && comp_bounds.contains(x, y)) {
            x -= comp_bounds.x;
            y -= comp_bounds.y;
            Control[] children = comp2.getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (child.isVisible()) {
                    if (child instanceof Composite) {
                        Control res = Utils.findChild((Composite)child, x, y);
                        if (res != null) {
                            return res;
                        }
                    } else {
                        return child;
                    }
                }
                ++i;
            }
            return comp2;
        }
        return null;
    }

    public static void dump(Control comp2) {
        File file = new File(AEDiagnostics.getLogDir(), "ui_dump.log");
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(file));
            IndentWriter iw = new IndentWriter(pw);
            Utils.dump(iw, comp2, new HashSet<Object>());
            pw.flush();
            System.out.println("Dump written to " + file);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private static void dump(IndentWriter iw, Control comp2, Set<Object> done) {
        block11: {
            if (done.contains(comp2)) {
                iw.println("<RECURSIVE!>");
                return;
            }
            done.add(comp2);
            String str = comp2.getClass().getName();
            int pos = str.lastIndexOf(".");
            if (pos != -1) {
                str = str.substring(pos + 1);
            }
            try {
                int n;
                int n2;
                Object[] objectArray;
                Field f = Widget.class.getDeclaredField("data");
                f.setAccessible(true);
                Object data = f.get(comp2);
                if (data instanceof Object[]) {
                    Object[] temp = (Object[])data;
                    String s = "";
                    objectArray = temp;
                    n2 = temp.length;
                    n = 0;
                    while (n < n2) {
                        Object t = objectArray[n];
                        s = String.valueOf(s) + (s == "" ? "" : ",") + t;
                        ++n;
                    }
                    data = s;
                }
                String lay = "" + comp2.getLayoutData();
                if (comp2 instanceof Composite) {
                    lay = String.valueOf(lay) + "/" + ((Composite)comp2).getLayoutData();
                }
                iw.println(String.valueOf(str) + ",vis=" + comp2.isVisible() + ",data=" + data + ",layout=" + lay + ",size=" + comp2.getBounds());
                if (!(comp2 instanceof Composite)) break block11;
                try {
                    iw.indent();
                    Control[] children = ((Composite)comp2).getChildren();
                    objectArray = children;
                    n2 = children.length;
                    n = 0;
                    while (n < n2) {
                        Object kid = objectArray[n];
                        Utils.dump(iw, (Control)kid, done);
                        ++n;
                    }
                }
                finally {
                    iw.exdent();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void addListenerAndChildren(Composite area, int event2, Listener listener) {
        area.addListener(event2, listener);
        Control[] children = area.getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child instanceof Composite) {
                Utils.addListenerAndChildren((Composite)child, event2, listener);
            } else {
                child.addListener(event2, listener);
            }
            ++i;
        }
    }

    public static Shell getActiveShell() {
        Display current = Display.getCurrent();
        if (current == null) {
            return null;
        }
        Shell shell = current.getActiveShell();
        if (shell != null && !shell.isDisposed()) {
            return shell;
        }
        return null;
    }

    public static Shell findAnyShell() {
        return Utils.findAnyShell(true);
    }

    public static Shell findAnyShell(boolean preferMainShell) {
        Display current;
        Shell shell;
        Shell fallBackShell = null;
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null && (shell = uiFunctions.getMainShell()) != null && !shell.isDisposed()) {
            if (preferMainShell) {
                return shell;
            }
            fallBackShell = shell;
        }
        if ((current = Display.getCurrent()) == null) {
            return fallBackShell;
        }
        Shell shell2 = current.getActiveShell();
        if (shell2 != null && !shell2.isDisposed()) {
            return shell2;
        }
        Shell[] shells = current.getShells();
        if (shells.length == 0) {
            return fallBackShell;
        }
        if (shells[0] != null && !shells[0].isDisposed()) {
            return shells[0];
        }
        return fallBackShell;
    }

    public static boolean verifyShellRect(Shell shell, boolean bAdjustIfInvalid) {
        return Utils.verifyShellRect(shell, bAdjustIfInvalid, true);
    }

    private static boolean verifyShellRect(Shell shell, boolean bAdjustIfInvalid, boolean reverifyOnChange) {
        boolean bMetricsOk;
        block21: {
            if (!shell.getMaximized()) break block21;
            return true;
        }
        try {
            Rectangle bounds;
            bMetricsOk = false;
            Point ptTopLeft = shell.getLocation();
            Point size = shell.getSize();
            Point ptBottomRight = shell.getLocation();
            ptBottomRight.x += size.x - 1;
            ptBottomRight.y += size.y - 1;
            Rectangle boundsMonitorTopLeft = null;
            Rectangle boundsMonitorBottomRight = null;
            Rectangle boundsMonitorContained = null;
            Monitor[] monitors = shell.getDisplay().getMonitors();
            int j = 0;
            while (j < monitors.length && !bMetricsOk) {
                Rectangle monitorBounds = monitors[j].getClientArea();
                Rectangle testBounds = Constants.isWindows ? new Rectangle(monitorBounds.x - 10, monitorBounds.y - 10, monitorBounds.width + 20, monitorBounds.height + 20) : monitorBounds;
                boolean hasTopLeft = testBounds.contains(ptTopLeft);
                boolean hasBottomRight = testBounds.contains(ptBottomRight);
                boolean bl = bMetricsOk = hasTopLeft && hasBottomRight;
                if (hasTopLeft) {
                    boundsMonitorTopLeft = monitorBounds;
                }
                if (hasBottomRight) {
                    boundsMonitorBottomRight = monitorBounds;
                }
                if (boundsMonitorContained == null && testBounds.intersects(ptTopLeft.x, ptTopLeft.y, ptBottomRight.x - ptTopLeft.x + 1, ptBottomRight.y - ptTopLeft.y + 1)) {
                    boundsMonitorContained = monitorBounds;
                }
                ++j;
            }
            Rectangle rectangle = boundsMonitorTopLeft != null ? boundsMonitorTopLeft : (bounds = boundsMonitorBottomRight != null ? boundsMonitorBottomRight : boundsMonitorContained);
            if (!bMetricsOk && bAdjustIfInvalid && bounds != null) {
                int xDiff = ptBottomRight.x - (bounds.x + bounds.width);
                int yDiff = ptBottomRight.y - (bounds.y + bounds.height);
                boolean needsResize = false;
                boolean needsMove = false;
                if (xDiff > 0) {
                    ptTopLeft.x -= xDiff;
                    needsMove = true;
                }
                if (yDiff > 0) {
                    ptTopLeft.y -= yDiff;
                    needsMove = true;
                }
                if (ptTopLeft.x < bounds.x) {
                    ptTopLeft.x = bounds.x;
                    needsMove = true;
                }
                if (ptTopLeft.y < bounds.y) {
                    ptTopLeft.y = bounds.y;
                    needsMove = true;
                }
                if (ptTopLeft.y < bounds.y) {
                    ptBottomRight.y -= bounds.y - ptTopLeft.y;
                    ptTopLeft.y = bounds.y;
                    needsResize = true;
                }
                if (ptTopLeft.x < bounds.x) {
                    ptBottomRight.x -= bounds.x - ptTopLeft.x;
                    ptTopLeft.x = bounds.x;
                    needsResize = true;
                }
                if (ptBottomRight.y >= bounds.y + bounds.height) {
                    ptBottomRight.y = bounds.y + bounds.height - 1;
                    needsResize = true;
                }
                if (ptBottomRight.x >= bounds.x + bounds.width) {
                    ptBottomRight.x = bounds.x + bounds.width - 1;
                    needsResize = true;
                }
                if (needsMove) {
                    shell.setLocation(ptTopLeft);
                }
                if (needsResize) {
                    shell.setSize(ptBottomRight.x - ptTopLeft.x + 1, ptBottomRight.y - ptTopLeft.y + 1);
                }
                if (reverifyOnChange && (needsMove || needsResize)) {
                    return Utils.verifyShellRect(shell, bAdjustIfInvalid, false);
                }
                return true;
            }
        }
        catch (NoSuchMethodError e) {
            Rectangle bounds = shell.getDisplay().getClientArea();
            bMetricsOk = shell.getBounds().intersects(bounds);
        }
        catch (Throwable t) {
            bMetricsOk = true;
        }
        if (!bMetricsOk && bAdjustIfInvalid) {
            Utils.centreWindow(shell);
        }
        return bMetricsOk;
    }

    public static void relayout(Control control) {
        long diff;
        long startOn = DEBUG_SWTEXEC ? System.currentTimeMillis() : 0L;
        Utils.relayout(control, false);
        if (DEBUG_SWTEXEC && (diff = System.currentTimeMillis() - startOn) > 100L) {
            String s = "Long relayout of " + diff + "ms " + Debug.getCompressedStackTrace();
            if (diag_logger != null) {
                diag_logger.log(s);
            }
            System.out.println(s);
        }
    }

    public static void relayout(Control control, boolean expandOnly) {
        ScrolledComposite sc;
        Control content;
        if (control == null || control.isDisposed() || !control.isVisible()) {
            return;
        }
        if (control instanceof ScrolledComposite && (content = (sc = (ScrolledComposite)control).getContent()) != null && !content.isDisposed()) {
            Rectangle r = sc.getClientArea();
            sc.setMinSize(content.computeSize(r.width, -1));
        }
        Composite parent = control.getParent();
        Point targetSize = control.computeSize(-1, -1, true);
        Point size = control.getSize();
        if (size.y == targetSize.y && size.x == targetSize.x) {
            return;
        }
        int fixedWidth = -1;
        int fixedHeight = -1;
        Object layoutData = control.getLayoutData();
        if (layoutData instanceof FormData) {
            FormData fd = (FormData)layoutData;
            fixedHeight = fd.height;
            fixedWidth = fd.width;
            if (fd.width != -1 && fd.height != -1) {
                parent.layout();
                return;
            }
        }
        if (expandOnly && size.y >= targetSize.y && size.x >= targetSize.x) {
            parent.layout();
            return;
        }
        Control previous = control;
        while (parent != null) {
            ScrolledComposite sc2;
            Control content2;
            if (SWT.getVersion() < 3600) {
                parent.layout(new Control[]{previous});
            } else {
                parent.layout(new Control[]{previous}, 5);
            }
            if (parent instanceof ScrolledComposite && (content2 = (sc2 = (ScrolledComposite)parent).getContent()) != null && !content2.isDisposed()) {
                Rectangle r = sc2.getClientArea();
                sc2.setMinSize(content2.computeSize(r.width, -1));
            }
            Point newSize = control.getSize();
            if (!(fixedHeight <= -1 && newSize.y < targetSize.y || fixedWidth <= -1 && newSize.x < targetSize.x)) break;
            previous = parent;
            parent = parent.getParent();
        }
        if (parent != null) {
            parent.layout();
        }
    }

    public static void beep() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                Display display = Display.getDefault();
                if (display != null) {
                    display.beep();
                }
            }
        });
    }

    public static Boolean execSWTThreadWithBool(String ID, AERunnableBoolean code, long millis) {
        if (code == null) {
            Logger.log(new LogEvent(LogIDs.CORE, "code null"));
            return null;
        }
        Boolean[] returnValueObject = new Boolean[1];
        Display display = Utils.getDisplay();
        AESemaphore sem = null;
        if (display == null || display.getThread() != Thread.currentThread()) {
            sem = new AESemaphore(ID);
        }
        try {
            code.setupReturn(ID, returnValueObject, sem);
            if (!Utils.execSWTThread(code)) {
                return null;
            }
        }
        catch (Throwable e) {
            if (sem != null) {
                sem.release();
            }
            Debug.out(ID, e);
        }
        if (sem != null) {
            sem.reserve(millis);
        }
        return returnValueObject[0];
    }

    public static Object execSWTThreadWithObject(String ID, AERunnableObject code, long millis) {
        if (code == null) {
            return null;
        }
        Object[] returnValueObject = new Object[1];
        Display display = Utils.getDisplay();
        AESemaphore sem = null;
        if (display == null || display.getThread() != Thread.currentThread()) {
            sem = new AESemaphore(ID);
        }
        try {
            code.setupReturn(ID, returnValueObject, sem);
            if (!Utils.execSWTThread(code)) {
                return null;
            }
        }
        catch (Throwable e) {
            if (sem != null) {
                sem.releaseForever();
            }
            Debug.out(ID, e);
        }
        if (sem != null && !sem.reserve(millis) && DEBUG_SWTEXEC) {
            System.out.println("Timeout in execSWTThreadWithObject(" + ID + ", " + code + ", " + millis + ") via " + Debug.getCompressedStackTrace());
        }
        return returnValueObject[0];
    }

    public static void waitForModals() {
        Display display;
        SWTThread swt = SWTThread.getInstance();
        if (swt == null) {
            display = Display.getDefault();
            if (display == null) {
                System.err.println("SWT Thread not started yet!");
                return;
            }
        } else {
            if (swt.isTerminated()) {
                return;
            }
            display = swt.getDisplay();
        }
        if (display == null || display.isDisposed()) {
            return;
        }
        Shell[] shells = display.getShells();
        Shell modalShell = null;
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if ((shell.getStyle() & 0x10000) != 0) {
                modalShell = shell;
                break;
            }
            ++i;
        }
        if (modalShell != null) {
            Utils.readAndDispatchLoop(modalShell);
        }
    }

    public static GridData getWrappableLabelGridData(int hspan, int styles) {
        GridData gridData = new GridData(0x100 | styles);
        gridData.horizontalSpan = hspan;
        gridData.widthHint = 0;
        return gridData;
    }

    public static GridData getHSpanGridData(int hspan, int styles) {
        GridData gridData = new GridData(styles);
        gridData.horizontalSpan = hspan;
        return gridData;
    }

    public static org.eclipse.swt.graphics.Image createAlphaImage(Device device, int width, int height) {
        return Utils.createAlphaImage(device, width, height, (byte)0);
    }

    public static org.eclipse.swt.graphics.Image createAlphaImage(Device device, int width, int height, byte defaultAlpha) {
        byte[] alphaData = new byte[width * height];
        if (Constants.isOSX && defaultAlpha == 0) {
            defaultAlpha = 1;
        }
        Arrays.fill(alphaData, 0, alphaData.length, defaultAlpha);
        ImageData imageData = new ImageData(width, height, 24, new PaletteData(255, 65280, 0xFF0000));
        Arrays.fill(imageData.data, 0, imageData.data.length, (byte)0);
        imageData.alphaData = alphaData;
        if (device == null) {
            device = Display.getDefault();
        }
        org.eclipse.swt.graphics.Image image = new org.eclipse.swt.graphics.Image(device, imageData);
        return image;
    }

    public static org.eclipse.swt.graphics.Image blitImage(Device device, org.eclipse.swt.graphics.Image srcImage, Rectangle srcArea, org.eclipse.swt.graphics.Image dstImage, Point dstPos) {
        if (srcArea == null) {
            srcArea = srcImage.getBounds();
        }
        Rectangle dstBounds = dstImage.getBounds();
        if (dstPos == null) {
            dstPos = new Point(dstBounds.x, dstBounds.y);
        } else {
            dstBounds.x = dstPos.x;
            dstBounds.y = dstPos.y;
        }
        ImageData dstImageData = dstImage.getImageData();
        ImageData srcImageData = srcImage.getImageData();
        int yPos = dstPos.y;
        int[] pixels = new int[srcArea.width];
        byte[] alphas = new byte[srcArea.width];
        int y = 0;
        while (y < srcArea.height) {
            srcImageData.getPixels(srcArea.x, y + srcArea.y, srcArea.width, pixels, 0);
            dstImageData.setPixels(dstPos.x, yPos, srcArea.width, pixels, 0);
            srcImageData.getAlphas(srcArea.x, y + srcArea.y, srcArea.width, alphas, 0);
            dstImageData.setAlphas(dstPos.x, yPos, srcArea.width, alphas, 0);
            ++yPos;
            ++y;
        }
        return new org.eclipse.swt.graphics.Image(device, dstImageData);
    }

    public static void drawStriped(GC gcImg, int x, int y, int width, int height, int lineDist, int leftshift, boolean fallingLines) {
        lineDist += 2;
        int xm = x + width;
        int ym = y + height;
        int i = x;
        while (i < xm) {
            int j = y;
            while (j < ym) {
                if ((i + leftshift + (fallingLines ? -j : j)) % lineDist == 0) {
                    gcImg.drawPoint(i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public static org.eclipse.swt.graphics.Image renderTransparency(Display display, org.eclipse.swt.graphics.Image background, org.eclipse.swt.graphics.Image foreground, Point foregroundOffsetOnBg, int modifyForegroundAlpha) {
        if (display == null || display.isDisposed() || background == null || background.isDisposed() || foreground == null || foreground.isDisposed()) {
            return null;
        }
        Rectangle backgroundArea = background.getBounds();
        Rectangle foregroundDrawArea = foreground.getBounds();
        foregroundDrawArea.x += foregroundOffsetOnBg.x;
        foregroundDrawArea.y += foregroundOffsetOnBg.y;
        foregroundDrawArea.intersect(backgroundArea);
        if (foregroundDrawArea.isEmpty()) {
            return null;
        }
        org.eclipse.swt.graphics.Image image = new org.eclipse.swt.graphics.Image((Device)display, backgroundArea);
        ImageData backData = background.getImageData();
        ImageData foreData = foreground.getImageData();
        ImageData imgData = image.getImageData();
        PaletteData backPalette = backData.palette;
        ImageData backMask = backData.getTransparencyType() != 1 ? backData.getTransparencyMask() : null;
        PaletteData forePalette = foreData.palette;
        ImageData foreMask = foreData.getTransparencyType() != 1 ? foreData.getTransparencyMask() : null;
        PaletteData imgPalette = imgData.palette;
        image.dispose();
        int x = 0;
        while (x < backgroundArea.width) {
            int y = 0;
            while (y < backgroundArea.height) {
                RGB cBack = backPalette.getRGB(backData.getPixel(x, y));
                int aBack = backData.getAlpha(x, y);
                if (backMask != null && backMask.getPixel(x, y) == 0) {
                    aBack = 0;
                }
                int aFore = 0;
                if (foregroundDrawArea.contains(x, y)) {
                    int fx = x - foregroundDrawArea.x;
                    int fy = y - foregroundDrawArea.y;
                    RGB cFore = forePalette.getRGB(foreData.getPixel(fx, fy));
                    aFore = foreData.getAlpha(fx, fy);
                    if (foreMask != null && foreMask.getPixel(fx, fy) == 0) {
                        aFore = 0;
                    }
                    aFore = aFore * modifyForegroundAlpha / 255;
                    cBack.red *= aBack * (255 - aFore);
                    cBack.red /= 255;
                    cBack.red += aFore * cFore.red;
                    cBack.red /= 255;
                    cBack.green *= aBack * (255 - aFore);
                    cBack.green /= 255;
                    cBack.green += aFore * cFore.green;
                    cBack.green /= 255;
                    cBack.blue *= aBack * (255 - aFore);
                    cBack.blue /= 255;
                    cBack.blue += aFore * cFore.blue;
                    cBack.blue /= 255;
                }
                imgData.setAlpha(x, y, aFore + aBack * (255 - aFore) / 255);
                imgData.setPixel(x, y, imgPalette.getPixel(cBack));
                ++y;
            }
            ++x;
        }
        return new org.eclipse.swt.graphics.Image((Device)display, imgData);
    }

    public static Control findBackgroundImageControl(Control control) {
        Composite parent;
        org.eclipse.swt.graphics.Image image = control.getBackgroundImage();
        if (image == null) {
            return control;
        }
        Composite lastParent = parent = control.getParent();
        while (parent != null) {
            org.eclipse.swt.graphics.Image parentImage = parent.getBackgroundImage();
            if (!image.equals((Object)parentImage)) {
                return lastParent;
            }
            lastParent = parent;
            parent = parent.getParent();
        }
        return control;
    }

    public static boolean anyShellHaveStyle(int styles) {
        Display display = Display.getCurrent();
        if (display != null) {
            Shell[] shells = display.getShells();
            int i = 0;
            while (i < shells.length) {
                Shell shell = shells[i];
                int style = shell.getStyle();
                if ((style & styles) == styles) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static Shell findFirstShellWithStyle(int styles) {
        Display display = Display.getCurrent();
        if (display != null) {
            Shell[] shells = display.getShells();
            int i = 0;
            while (i < shells.length) {
                Shell shell = shells[i];
                int style = shell.getStyle();
                if ((style & styles) == styles && !shell.isDisposed()) {
                    return shell;
                }
                ++i;
            }
        }
        return null;
    }

    public static int[] colorToIntArray(Color color) {
        if (color == null || color.isDisposed()) {
            return null;
        }
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    public static void centerRelativeTo(Rectangle target, Rectangle reference) {
        target.x = reference.x + reference.width / 2 - target.width / 2;
        target.y = reference.y + reference.height / 2 - target.height / 2;
    }

    public static void makeVisibleOnCursor(Rectangle rect) {
        if (rect == null) {
            return;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            Debug.out("No current display detected.  This method [Utils.makeVisibleOnCursor()] must be called from a display thread.");
            return;
        }
        try {
            Point cursorLocation = display.getCursorLocation();
            Utils.makeVisibleOnMonitor(rect, Utils.getMonitor(cursorLocation));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void makeVisibleOnMonitor(Rectangle rect, Monitor monitor) {
        if (rect == null || monitor == null) {
            return;
        }
        try {
            int rightDiff;
            Rectangle monitorBounds = monitor.getClientArea();
            int bottomDiff = monitorBounds.y + monitorBounds.height - (rect.y + rect.height);
            if (bottomDiff < 0) {
                rect.y += bottomDiff;
            }
            if ((rightDiff = monitorBounds.x + monitorBounds.width - (rect.x + rect.width)) < 0) {
                rect.x += rightDiff;
            }
            if (rect.x < monitorBounds.x) {
                rect.x = monitorBounds.x;
            }
            if (rect.y < monitorBounds.y) {
                rect.y = monitorBounds.y;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Monitor getMonitor(int x, int y) {
        return Utils.getMonitor(new Point(x, y));
    }

    public static Monitor getMonitor(Point location) {
        Display display = Display.getCurrent();
        if (display == null) {
            Debug.out("No current display detected.  This method [Utils.makeVisibleOnCursor()] must be called from a display thread.");
            return null;
        }
        try {
            Monitor[] monitors = display.getMonitors();
            Rectangle monitorBounds = null;
            int i = 0;
            while (i < monitors.length) {
                monitorBounds = monitors[i].getClientArea();
                if (monitorBounds.contains(location)) {
                    return monitors[i];
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static void makeButtonsEqualWidth(Button ... buttons) {
        Utils.makeButtonsEqualWidth(Arrays.asList(buttons));
    }

    public static void makeButtonsEqualWidth(List<Button> buttons) {
        Utils.makeButtonsEqualWidth(buttons, 75);
    }

    public static void makeButtonsEqualWidth(List<Button> buttons, int min) {
        int width = min;
        for (Button button : buttons) {
            if (button == null) continue;
            width = Math.max(width, button.computeSize((int)-1, (int)-1).x);
        }
        for (Button button : buttons) {
            if (button == null) continue;
            Object data = button.getLayoutData();
            if (data != null) {
                if (data instanceof GridData) {
                    ((GridData)data).widthHint = width;
                    continue;
                }
                if (data instanceof FormData) {
                    ((FormData)data).width = width;
                    continue;
                }
                if (data instanceof RowData) {
                    ((RowData)data).width = width;
                    continue;
                }
                Debug.out("Expected GridData/FormData");
                continue;
            }
            data = new GridData();
            ((GridData)data).widthHint = width;
            button.setLayoutData(data);
        }
    }

    public static Button[] createOKCancelButtons(Composite panel) {
        Button ok;
        Button cancel;
        if (Constants.isOSX) {
            cancel = Utils.createAlertButton(panel, "Button.cancel");
            ok = Utils.createAlertButton(panel, "Button.ok");
        } else {
            ok = Utils.createAlertButton(panel, "Button.ok");
            cancel = Utils.createAlertButton(panel, "Button.cancel");
        }
        return new Button[]{ok, cancel};
    }

    public static Button createAlertButton(Composite panel, String localizationKey) {
        Button button = new Button(panel, 8);
        button.setText(MessageText.getString(localizationKey));
        RowData rData = new RowData();
        rData.width = Math.max(BUTTON_MINWIDTH, button.computeSize((int)-1, (int)-1).x);
        button.setLayoutData((Object)rData);
        return button;
    }

    public static synchronized String truncateText(GC gc, String text, int maxWidth, boolean cache) {
        TruncatedTextResult result;
        if (cache && (result = (TruncatedTextResult)truncatedTextCache.get(text)) != null && result.maxWidth == maxWidth) {
            return result.text;
        }
        StringBuilder sb = new StringBuilder(text);
        String append = "...";
        int appendWidth = gc.textExtent((String)append).x;
        boolean needsAppend = false;
        while (gc.textExtent((String)sb.toString()).x > maxWidth) {
            sb.deleteCharAt(sb.length() - 1);
            needsAppend = true;
            if (sb.length() == 1) break;
        }
        if (needsAppend) {
            while (gc.textExtent((String)sb.toString()).x + appendWidth > maxWidth) {
                sb.deleteCharAt(sb.length() - 1);
                needsAppend = true;
                if (sb.length() == 1) break;
            }
            sb.append(append);
        }
        if (cache) {
            TruncatedTextResult ttR = new TruncatedTextResult();
            ttR.text = sb.toString();
            ttR.maxWidth = maxWidth;
            truncatedTextCache.put(text, ttR);
        }
        return sb.toString();
    }

    public static String toColorHexString(Color color) {
        return HTMLUtils.toColorHexString(color.getRed(), color.getRed(), color.getBlue(), color.getAlpha());
    }

    private static void twoHex(StringBuffer sb, int h) {
        if (h <= 15) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(h));
    }

    public static String getWidgetBGColorURLParam() {
        Color bg = Utils.findAnyShell().getDisplay().getSystemColor(22);
        byte[] color = new byte[]{(byte)bg.getRed(), (byte)bg.getGreen(), (byte)bg.getBlue()};
        return "bg_color=" + ByteFormatter.nicePrint(color);
    }

    public static void reportError(Throwable e) {
        MessageBoxShell mb = new MessageBoxShell(MessageText.getString("ConfigView.section.security.op.error.title"), MessageText.getString("ConfigView.section.security.op.error", new String[]{Debug.getNestedExceptionMessage(e)}), new String[]{MessageText.getString("Button.ok")}, 0);
        mb.open(null);
    }

    public static void getOffOfSWTThread(final Runnable runnable) {
        if (Utils.isSWTThread()) {
            AERunnable r = runnable instanceof AERunnable ? (AERunnable)runnable : new AERunnable(){

                @Override
                public void runSupport() {
                    runnable.run();
                }
            };
            tp.run(r);
        } else {
            runnable.run();
        }
    }

    public static void getOffOfSWTThread(AERunnable runnable) {
        tp.run(runnable);
    }

    public static boolean runIfNotSWTThread(Runnable code) {
        if (!Utils.isSWTThread()) {
            Utils.execSWTThread(code);
            return true;
        }
        return false;
    }

    public static void runWhenCoreOperationsIdle(Core core, Runnable r) {
        Utils.getOffOfSWTThread(() -> {
            try {
                long start = SystemTime.getMonotonousTime();
                boolean waiting = true;
                while (waiting && SystemTime.getMonotonousTime() - start <= 60000L) {
                    waiting = false;
                    List<CoreOperation> ops = core.getOperations();
                    for (CoreOperation op : ops) {
                        int state;
                        CoreOperationTask.ProgressCallback cb;
                        CoreOperationTask task2;
                        int type;
                        if (op.isRemoved() || (type = op.getOperationType()) != 6 && type != 7 && type != 4 && type != 2 || (task2 = op.getTask()) != null && (cb = task2.getProgressCallback()) != null && (state = cb.getTaskState()) == 4) continue;
                        waiting = true;
                        break;
                    }
                    if (!waiting) continue;
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            r.run();
        });
    }

    public static BrowserWrapper createSafeBrowser(Composite parent, int style) {
        try {
            final BrowserWrapper browser = BrowserWrapper.createBrowser(parent, style);
            browser.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event2) {
                    try {
                        browser.setUrl("about:blank");
                        browser.setVisible(false);
                        final boolean[] done = new boolean[1];
                        long start = SystemTime.getMonotonousTime();
                        Utils.execSWTThreadLater(250, new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                boolean[] blArray = done;
                                synchronized (done) {
                                    done[0] = true;
                                    // ** MonitorExit[var1_1] (shouldn't be in output)
                                    return;
                                }
                            }
                        });
                        Utils.readAndDispatchUntilIdleOr(() -> {
                            boolean[] blArray2 = done;
                            synchronized (done) {
                                // ** MonitorExit[var3_2] (shouldn't be in output)
                                return done[0] || SystemTime.getMonotonousTime() - start > 500L;
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            return browser;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Point getLocationRelativeToShell(Control control) {
        Point controlLocation = control.toDisplay(0, 0);
        Point shellLocation = control.getShell().getLocation();
        return new Point(controlLocation.x - shellLocation.x, controlLocation.y - shellLocation.y);
    }

    public static boolean isQuickViewSupported(com.biglybt.core.disk.DiskManagerFileInfo file) {
        String ext = file.getExtension();
        if (ext == null) {
            return false;
        }
        if ((ext = ext.toLowerCase()).startsWith(".")) {
            ext = ext.substring(1);
        }
        if (ext.equals("rar")) {
            return true;
        }
        return qv_exts.contains(ext) && file.getLength() <= (long)qv_max_bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isQuickViewActive(com.biglybt.core.disk.DiskManagerFileInfo file) {
        Set<com.biglybt.core.disk.DiskManagerFileInfo> set = quick_view_active;
        synchronized (set) {
            return quick_view_active.contains(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setQuickViewActive(com.biglybt.core.disk.DiskManagerFileInfo file, boolean active) {
        Set<com.biglybt.core.disk.DiskManagerFileInfo> set = quick_view_active;
        synchronized (set) {
            boolean file_complete;
            if (!active) {
                quick_view_active.remove(file);
                return;
            }
            if (quick_view_active.contains(file)) {
                return;
            }
            String ext = file.getExtension().toLowerCase();
            boolean bl = file_complete = file.getDownloaded() == file.getLength();
            if (ext.equals(".rar")) {
                quick_view_active.add(file);
                Utils.quickViewRAR(file);
            } else if (file_complete) {
                Utils.quickView(file);
            } else {
                com.biglybt.core.disk.DiskManagerFileInfo[] all_files;
                quick_view_active.add(file);
                if (file.isSkipped()) {
                    file.setSkipped(false);
                }
                file.setPriority(1);
                com.biglybt.core.disk.DiskManagerFileInfo[] diskManagerFileInfoArray = all_files = file.getDownloadManager().getDiskManagerFileInfoSet().getFiles();
                int n = all_files.length;
                int n2 = 0;
                while (n2 < n) {
                    com.biglybt.core.disk.DiskManagerFileInfo f = diskManagerFileInfoArray[n2];
                    if (!quick_view_active.contains(f)) {
                        f.setPriority(0);
                    }
                    ++n2;
                }
                if (quick_view_event == null) {
                    quick_view_event = SimpleTimer.addPeriodicEvent("qv_checker", 5000L, new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void perform(TimerEvent event2) {
                            Set set = quick_view_active;
                            synchronized (set) {
                                Iterator it = quick_view_active.iterator();
                                while (it.hasNext()) {
                                    com.biglybt.core.disk.DiskManagerFileInfo file = (com.biglybt.core.disk.DiskManagerFileInfo)it.next();
                                    if (file.getDownloadManager().isDestroyed()) {
                                        it.remove();
                                        continue;
                                    }
                                    if (file.getDownloaded() != file.getLength()) continue;
                                    Utils.quickView(file);
                                    it.remove();
                                }
                                if (quick_view_active.isEmpty()) {
                                    quick_view_event.cancel();
                                    quick_view_event = null;
                                }
                            }
                        }
                    });
                }
            }
            if (!file_complete) {
                Utils.execSWTThreadLater(10, new Runnable(){

                    @Override
                    public void run() {
                        MessageBoxShell mb = new MessageBoxShell(32, MessageText.getString("quick.view.scheduled.title"), MessageText.getString("quick.view.scheduled.text"));
                        mb.setDefaultButtonUsingStyle(32);
                        mb.setRemember("quick.view.inform.activated.id", false, MessageText.getString("label.dont.show.again"));
                        mb.setLeftImage(2);
                        mb.open(null);
                    }
                });
            }
        }
    }

    private static void quickView(final com.biglybt.core.disk.DiskManagerFileInfo file) {
        try {
            final File target_file = file.getFile(true);
            final String contents = FileUtil.readFileAsString(target_file, qv_max_bytes);
            Utils.execSWTThread(new Runnable(){

                @Override
                public void run() {
                    if (Utils.getExplicitLauncher(target_file.getName()) != null) {
                        Utils.launch(target_file.getAbsolutePath());
                    } else {
                        org.eclipse.swt.graphics.Image image;
                        DownloadManager dm = file.getDownloadManager();
                        try (FileInputStream is = null;){
                            is = new FileInputStream(target_file);
                            image = new org.eclipse.swt.graphics.Image((Device)Utils.getDisplay(), (InputStream)is);
                        }
                        catch (Throwable e) {
                            image = null;
                        }
                        if (image != null) {
                            new ImageViewerWindow(String.valueOf(MessageText.getString("MainWindow.menu.quick_view")) + ": " + target_file.getName(), MessageText.getString("MainWindow.menu.quick_view.msg", new String[]{target_file.getName(), dm.getDisplayName()}), image);
                        } else {
                            new TextViewerWindow(String.valueOf(MessageText.getString("MainWindow.menu.quick_view")) + ": " + target_file.getName(), MessageText.getString("MainWindow.menu.quick_view.msg", new String[]{target_file.getName(), dm.getDisplayName()}), contents, false);
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void quickViewRAR(final com.biglybt.core.disk.DiskManagerFileInfo file) {
        block16: {
            boolean went_async = false;
            try {
                try {
                    final DiskManagerFileInfo plugin_file = PluginCoreUtils.wrap(file);
                    final RARTOCDecoder decoder = new RARTOCDecoder(new RARTOCDecoder.DataProvider(file){
                        private long file_position;
                        private long file_size;
                        {
                            this.file_size = diskManagerFileInfo.getLength();
                        }

                        @Override
                        public int read(final byte[] buffer) throws IOException {
                            long read_from = this.file_position;
                            int read_length = buffer.length;
                            long read_to = Math.min(this.file_size, read_from + (long)read_length);
                            if ((read_length = (int)(read_to - read_from)) <= 0) {
                                return -1;
                            }
                            final int f_read_length = read_length;
                            try {
                                final AESemaphore sem = new AESemaphore("rarwait");
                                final Object[] result = new Object[1];
                                plugin_file.createRandomReadRequest(read_from, read_length, false, new DiskManagerListener(){
                                    private int buffer_pos;

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Override
                                    public void eventOccurred(DiskManagerEvent event2) {
                                        int event_type = event2.getType();
                                        if (event_type == 1) {
                                            PooledByteBuffer pooled_buffer = event2.getBuffer();
                                            try {
                                                byte[] data = pooled_buffer.toByteArray();
                                                System.arraycopy(data, 0, buffer, this.buffer_pos, data.length);
                                                this.buffer_pos += data.length;
                                                if (this.buffer_pos != f_read_length) return;
                                                sem.release();
                                                return;
                                            }
                                            finally {
                                                pooled_buffer.returnToPool();
                                            }
                                        } else {
                                            if (event_type != 2) return;
                                            result[0] = event2.getFailure();
                                            sem.release();
                                        }
                                    }
                                });
                                sem.reserve();
                                if (result[0] instanceof Throwable) {
                                    throw (Throwable)result[0];
                                }
                                this.file_position += (long)read_length;
                                return read_length;
                            }
                            catch (Throwable e) {
                                throw new IOException("read failed: " + Debug.getNestedExceptionMessage(e));
                            }
                        }

                        @Override
                        public void skip(long bytes) throws IOException {
                            this.file_position += bytes;
                        }
                    });
                    new AEThread2("rardecoder"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            block14: {
                                try {
                                    try {
                                        decoder.analyse(new RARTOCDecoder.TOCResultHandler(){
                                            private TextViewerWindow viewer;
                                            private List<String> lines = new ArrayList<String>();
                                            private int pw_entries = 0;
                                            private int pw_text = 0;
                                            private volatile boolean abandon = false;

                                            @Override
                                            public void entryRead(String name, long size, boolean password) throws IOException {
                                                if (this.abandon) {
                                                    throw new IOException("Operation abandoned");
                                                }
                                                String line = String.valueOf(name) + ":    " + DisplayFormatters.formatByteCountToKiBEtc(size);
                                                if (password) {
                                                    line = String.valueOf(line) + "    **** password protected ****";
                                                    ++this.pw_entries;
                                                }
                                                if (password || name.toLowerCase().contains("password")) {
                                                    line = "*\t" + line;
                                                    ++this.pw_text;
                                                } else {
                                                    line = " \t" + line;
                                                }
                                                this.appendLine(line, false);
                                            }

                                            @Override
                                            public void complete() {
                                                this.appendLine("Done", true);
                                            }

                                            @Override
                                            public void failed(IOException error) {
                                                this.appendLine("Failed: " + Debug.getNestedExceptionMessage(error), true);
                                            }

                                            private String getInfo() {
                                                if (this.pw_entries > 0) {
                                                    return String.valueOf(this.pw_entries) + " password protected file(s) found";
                                                }
                                                if (this.pw_text > 0) {
                                                    return String.valueOf(this.pw_text) + " file(s) mentioning 'password' found";
                                                }
                                                return "";
                                            }

                                            private void appendLine(final String line, final boolean complete) {
                                                Utils.execSWTThread(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        lines.add(line);
                                                        StringBuilder content = new StringBuilder();
                                                        for (String l : lines) {
                                                            content.append(l).append("\r\n");
                                                        }
                                                        if (!complete) {
                                                            content.append("processing...");
                                                        } else {
                                                            String info = this.getInfo();
                                                            if (info.length() > 0) {
                                                                content.append(info).append("\r\n");
                                                            }
                                                        }
                                                        if (viewer == null) {
                                                            File target_file = file.getFile(true);
                                                            DownloadManager dm = file.getDownloadManager();
                                                            viewer = new TextViewerWindow(String.valueOf(MessageText.getString("MainWindow.menu.quick_view")) + ": " + target_file.getName(), MessageText.getString("MainWindow.menu.quick_view.msg", new String[]{target_file.getName(), dm.getDisplayName()}), content.toString(), false);
                                                        } else if (viewer.isDisposed()) {
                                                            abandon = true;
                                                        } else {
                                                            viewer.setText(content.toString());
                                                        }
                                                    }
                                                });
                                            }
                                        });
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                        Set set = quick_view_active;
                                        synchronized (set) {
                                            quick_view_active.remove(file);
                                            break block14;
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    Set set = quick_view_active;
                                    synchronized (set) {
                                        quick_view_active.remove(file);
                                    }
                                    throw throwable;
                                }
                                Set set = quick_view_active;
                                synchronized (set) {
                                    quick_view_active.remove(file);
                                }
                            }
                        }
                    }.start();
                    went_async = true;
                }
                catch (Throwable e) {
                    Debug.out(e);
                    if (went_async) break block16;
                    Set<com.biglybt.core.disk.DiskManagerFileInfo> set = quick_view_active;
                    synchronized (set) {
                        quick_view_active.remove(file);
                        break block16;
                    }
                }
            }
            catch (Throwable throwable) {
                if (!went_async) {
                    Set<com.biglybt.core.disk.DiskManagerFileInfo> set = quick_view_active;
                    synchronized (set) {
                        quick_view_active.remove(file);
                    }
                }
                throw throwable;
            }
            if (!went_async) {
                Set<com.biglybt.core.disk.DiskManagerFileInfo> set = quick_view_active;
                synchronized (set) {
                    quick_view_active.remove(file);
                }
            }
        }
    }

    public static Sash createSash(Composite form, int SASH_WIDTH) {
        return Utils.createSash(form, SASH_WIDTH, 256);
    }

    public static Sash createSash(Composite form, int SASH_WIDTH, int style) {
        final Sash sash = new Sash(form, style);
        if (Utils.isDarkAppearanceNative()) {
            sash.setBackground(ColorCache.getColor((Device)sash.getDisplay(), 81, 86, 88));
        } else {
            org.eclipse.swt.graphics.Image image = new org.eclipse.swt.graphics.Image((Device)sash.getDisplay(), 9, SASH_WIDTH);
            ImageData imageData = image.getImageData();
            int[] row = new int[imageData.width];
            int i = 0;
            while (i < row.length) {
                if (imageData.depth == 16) {
                    row[i] = i % 3 != 0 ? 2078209981 : -554189333;
                } else {
                    int n = row[i] = i % 3 != 0 ? 0xE0E0E0 : 0x808080;
                    if (imageData.depth == 32) {
                        row[i] = (row[i] & 0xFF) + (row[i] << 8);
                    }
                }
                ++i;
            }
            int y = 1;
            while (y < imageData.height - 1) {
                imageData.setPixels(0, y, row.length, row, 0);
                ++y;
            }
            Arrays.fill(row, imageData.depth == 16 ? 2078209981 : -522133280);
            imageData.setPixels(0, 0, row.length, row, 0);
            imageData.setPixels(0, imageData.height - 1, row.length, row, 0);
            image.dispose();
            image = new org.eclipse.swt.graphics.Image((Device)sash.getDisplay(), imageData);
            sash.setBackgroundImage(image);
            sash.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    sash.getBackgroundImage().dispose();
                }
            });
        }
        return sash;
    }

    public static SashWrapper createSashWrapper(Composite parent, String config_key, int def_pct) {
        return new SashWrapper(parent, config_key, def_pct);
    }

    public static SashWrapper2 createSashWrapper2(Composite parent, String config_key) {
        return new SashWrapper2(parent, config_key);
    }

    public static Control getCursorControl() {
        Display d = Utils.getDisplay();
        Point cursorLocation = d.getCursorLocation();
        Control cursorControl = d.getCursorControl();
        if (cursorControl instanceof Composite) {
            return Utils.getCursorControl((Composite)cursorControl, cursorLocation);
        }
        return cursorControl;
    }

    public static Control getCursorControl(Composite parent, Point cursorLocation) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control con = controlArray[n2];
            Rectangle bounds = con.getBounds();
            Point displayLoc = con.toDisplay(0, 0);
            bounds.x = displayLoc.x;
            bounds.y = displayLoc.y;
            boolean found = bounds.contains(cursorLocation);
            if (found) {
                if (con instanceof Composite) {
                    return Utils.getCursorControl((Composite)con, cursorLocation);
                }
                return con;
            }
            ++n2;
        }
        return parent;
    }

    public static void relayoutUp(Composite c) {
        while (c != null && !c.isDisposed()) {
            Composite newParent;
            if (c instanceof ScrolledComposite) {
                Utils.updateScrolledComposite((ScrolledComposite)c, c.getStyle());
            }
            if ((newParent = c.getParent()) == null || newParent.getData(RELAYOUT_UP_STOP_HERE) != null) break;
            try {
                newParent.layout(new Control[]{c});
            }
            catch (SWTException sWTException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            c = newParent;
        }
    }

    public static Composite createScrolledComposite(Composite parent) {
        return Utils.createScrolledComposite(parent, 512, null);
    }

    public static Composite createScrolledComposite(Composite parent, int style) {
        return Utils.createScrolledComposite(parent, style, null);
    }

    public static Composite createScrolledComposite(Composite parent, Control mega_parent) {
        return Utils.createScrolledComposite(parent, 512, mega_parent);
    }

    private static Composite createScrolledComposite(Composite parent, int style, final Control mega_parent) {
        Layout currentParentLayout = parent.getLayout();
        if (!(currentParentLayout instanceof GridLayout)) {
            GridLayout parentLayout = new GridLayout(1, true);
            parentLayout.marginWidth = 0;
            parentLayout.marginHeight = 0;
            parent.setLayout((Layout)parentLayout);
        }
        ScrolledComposite sc = new ScrolledComposite(parent, style);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        sc.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        sc.setLayoutData((Object)gridData);
        Composite result = new Composite((Composite)sc, 0);
        sc.setContent((Control)result);
        sc.addListener(11, e -> Utils.updateScrolledComposite(sc, style));
        if (mega_parent == null) {
            return result;
        }
        final Runnable hack = () -> {
            boolean bl = Utils.execSWTThreadLater(1, () -> {
                Point existing;
                if (mega_parent.isDisposed()) {
                    return;
                }
                Rectangle mp = mega_parent.getBounds();
                Point sc_size = sc.computeSize(-1, -1);
                Rectangle sc_bounds = sc.getBounds();
                int mp_y = control.toDisplay((int)mp.x, (int)mp.y).y;
                int sc_y = scrolledComposite.toDisplay((int)sc_bounds.x, (int)sc_bounds.y).y;
                int req_h = -1;
                if (sc_y >= mp_y && sc_y < mp_y + mp.height && sc_y + sc_size.y >= mp_y + mp.height) {
                    req_h = mp_y + mp.height - sc_y;
                }
                sc_size.x = sc_bounds.width;
                if (req_h >= 0) {
                    if (Utils.isDarkAppearanceNativeWindows()) {
                        req_h -= 2;
                    }
                    sc_size.y = req_h;
                }
                if (!(existing = sc.getSize()).equals((Object)sc_size)) {
                    sc.setSize(sc_size);
                }
            });
        };
        Utils.execSWTThreadLater(1000, new Runnable(){

            @Override
            public void run() {
                hack.run();
                if (!mega_parent.isDisposed()) {
                    Utils.execSWTThreadLater(1000, this);
                }
            }
        });
        mega_parent.addListener(11, e -> hack.run());
        return result;
    }

    public static void updateScrolledComposite(ScrolledComposite sc) {
        Utils.updateScrolledComposite(sc, 512);
    }

    protected static void updateScrolledComposite(ScrolledComposite sc, int style) {
        Control content = sc.getContent();
        if (content != null && !content.isDisposed()) {
            Object min;
            boolean do_h;
            boolean do_v = (style & 0x200) != 0;
            boolean bl = do_h = (style & 0x100) != 0;
            if (do_v && do_h) {
                min = content.computeSize(-1, -1);
            } else {
                Rectangle r = sc.getClientArea();
                min = do_v ? content.computeSize(r.width, -1) : (do_h ? content.computeSize(-1, r.height) : null);
            }
            if (min != null) {
                sc.setMinSize(min);
            }
        }
    }

    public static void maintainSashPanelWidth(final SashForm sash, final Composite comp2, int[] default_weights, final String config_key) {
        final boolean is_lhs = comp2 == sash.getChildren()[0];
        String str = COConfigurationManager.getStringParameter(config_key, String.valueOf(default_weights[0]) + "," + default_weights[1]);
        try {
            String[] bits = str.split(",");
            sash.setWeights(new int[]{Integer.parseInt(bits[0]), Integer.parseInt(bits[1])});
        }
        catch (Throwable e) {
            sash.setWeights(default_weights);
        }
        Listener sash_listener = new Listener(){
            private int comp_weight;
            private int comp_width;

            public void handleEvent(Event ev) {
                if (ev.widget == comp2) {
                    int[] weights = sash.getWeights();
                    int current_weight = weights[is_lhs ? 0 : 1];
                    if (this.comp_weight != current_weight) {
                        COConfigurationManager.setParameter(config_key, String.valueOf(weights[0]) + "," + weights[1]);
                        this.comp_weight = current_weight;
                        this.comp_width = comp2.getBounds().width;
                    }
                } else if (this.comp_width > 0) {
                    int width = sash.getClientArea().width;
                    if (width < 20) {
                        width = 20;
                    }
                    double ratio = (double)this.comp_width / (double)width;
                    this.comp_weight = (int)(ratio * 1000.0);
                    if (this.comp_weight < 20) {
                        this.comp_weight = 20;
                    } else if (this.comp_weight > 980) {
                        this.comp_weight = 980;
                    }
                    if (is_lhs) {
                        sash.setWeights(new int[]{this.comp_weight, 1000 - this.comp_weight});
                    } else {
                        sash.setWeights(new int[]{1000 - this.comp_weight, this.comp_weight});
                    }
                }
            }
        };
        comp2.addListener(11, sash_listener);
        sash.addListener(11, sash_listener);
    }

    public static void setClipping(GC gc, Rectangle r) {
        if (r == null) {
            if (isGTK3) {
                gc.setClipping(null);
            } else {
                gc.setClipping(null);
            }
            return;
        }
        gc.setClipping(r.x, r.y, r.width, r.height);
    }

    public static void addAndFireParameterListener(Map<String, ParameterListener> mapConfigListeners, boolean requiresSWTThread, String parameter, final ParameterListener listener) {
        ParameterListener realListener = requiresSWTThread ? new ParameterListener(){

            @Override
            public void parameterChanged(final String parameterName) {
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        listener.parameterChanged(parameterName);
                    }
                });
            }
        } : listener;
        if (mapConfigListeners != null) {
            mapConfigListeners.put(parameter, realListener);
        }
        COConfigurationManager.addAndFireParameterListener(parameter, realListener);
    }

    public static void removeParameterListeners(Map<String, ParameterListener> mapListeners) {
        for (String parameterName : mapListeners.keySet()) {
            COConfigurationManager.removeParameterListener(parameterName, mapListeners.get(parameterName));
        }
        mapListeners.clear();
    }

    public static boolean setPeronalShare(Map<String, String> properties) {
        UIFunctions uif = UIFunctionsManager.getUIFunctions();
        if (uif != null) {
            UIFunctionsUserPrompter prompter = uif.getUserPrompter(MessageText.getString("personal.share.prompt.title"), MessageText.getString("personal.share.prompt.text"), new String[]{MessageText.getString("Button.ok"), MessageText.getString("Button.cancel")}, 0);
            prompter.setRemember("personal.share.info", false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
            prompter.setAutoCloseInMS(0);
            prompter.open(null);
            int result = prompter.waitUntilClosed();
            if (result != 0) {
                return false;
            }
        }
        properties.put("personal", "true");
        return true;
    }

    public static boolean getTTEnabled() {
        return tt_enabled;
    }

    public static void setTT(Control c, String text) {
        text = tt_enabled ? text : null;
        String old = c.getToolTipText();
        if (!(old == text || old != null && text != null && text.equals(old))) {
            c.setToolTipText(text);
        }
    }

    public static void setTT(BufferedTruncatedLabel c, String text) {
        c.setToolTipText(tt_enabled ? text : null);
    }

    public static void setTT(CTabItem c, String text) {
        c.setToolTipText(tt_enabled ? text : null);
    }

    public static void setTT(UISWTStatusEntry c, String text) {
        c.setTooltipText(tt_enabled ? text : null);
    }

    public static void setTT(TableColumn c, String text) {
        c.setToolTipText(tt_enabled ? text : null);
    }

    public static void setTT(ToolItem c, String text) {
        c.setToolTipText(tt_enabled ? text : null);
    }

    public static void setTT(TrayItem c, String text) {
        c.setToolTipText(tt_enabled ? text : null);
    }

    public static void setTT(TrayItemDelegate c, String text) {
        c.setToolTipText(tt_enabled ? text : null);
    }

    public static void dispose() {
        shellIcons = null;
        icon128 = null;
        AEDiagnostics.removeEvidenceGenerator(evidenceGenerator);
        evidenceGenerator = null;
        COConfigurationManager.removeParameterListener("User Mode", configUserModeListener);
        COConfigurationManager.removeParameterListener("ui", configUIListener);
        COConfigurationManager.removeParameterListener("quick.view.exts", pconfigQuickViewListeners);
        COConfigurationManager.removeParameterListener("quick.view.maxkb", pconfigQuickViewListeners);
        COConfigurationManager.removeParameterListeners(new String[]{"Dark Misc Colors", "Gradient Fill Selection", "GUI Refresh Disable When Minimized"}, configOtherListener);
    }

    public static String createSubViewID(String base, String sub) {
        return TableColumnManager.createSubViewID(base, sub);
    }

    public static String getBaseViewID(String id) {
        return TableColumnManager.getBaseViewID(id);
    }

    public static boolean isDarkAppearanceNativeWindows() {
        return Constants.isWindows && Utils.isDarkAppearanceNative();
    }

    public static boolean isDarkAppearanceNative() {
        if (force_dark_appearance) {
            return true;
        }
        if (is_dark_appearance == null) {
            if (Constants.isOSX) {
                try {
                    Class<?> enhancerClass = Class.forName("com.biglybt.ui.swt.osx.CocoaUIEnhancer");
                    Method method = enhancerClass.getMethod("isAppDarkAppearance", new Class[0]);
                    is_dark_appearance = (Boolean)method.invoke(null, new Object[0]);
                }
                catch (Throwable e) {
                    Debug.out(e);
                    is_dark_appearance = false;
                }
            } else if (Constants.isWindows) {
                is_dark_appearance = UI.useSystemTheme();
            } else {
                boolean is_system_dark_theme = COConfigurationManager.getBooleanParameter("Force Dark Theme");
                if (!is_system_dark_theme) {
                    try {
                        Class<?> displayClass = Class.forName("org.eclipse.swt.widgets.Display");
                        Method method = displayClass.getMethod("isSystemDarkTheme", new Class[0]);
                        is_system_dark_theme = (Boolean)method.invoke(null, new Object[0]);
                    }
                    catch (NoSuchMethodException displayClass) {
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                is_dark_appearance = is_system_dark_theme;
            }
        }
        return is_dark_appearance;
    }

    public static boolean isDarkAppearancePartial() {
        if (Constants.isOSX) {
            return false;
        }
        if (!dark_misc_things) {
            return false;
        }
        boolean is_system_dark_theme = COConfigurationManager.getBooleanParameter("Force Dark Theme");
        if (!is_system_dark_theme) {
            try {
                Class<?> displayClass = Class.forName("org.eclipse.swt.widgets.Display");
                Method method = displayClass.getMethod("isSystemDarkTheme", new Class[0]);
                is_system_dark_theme = (Boolean)method.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException displayClass) {
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return is_system_dark_theme;
    }

    public static void editSpeedLimitHandlerConfig(final SpeedLimitHandler slh) {
        Utils.execSWTThreadLater(1, new Runnable(){

            @Override
            public void run() {
                List<String> lines = slh.getSchedule();
                StringBuilder text = new StringBuilder(80 * lines.size());
                for (String s : lines) {
                    if (text.length() > 0) {
                        text.append("\n");
                    }
                    text.append(s);
                }
                final TextViewerWindow viewer = new TextViewerWindow("MainWindow.menu.speed_limits.schedule.title", "MainWindow.menu.speed_limits.schedule.msg", text.toString(), false);
                viewer.setEditable(true);
                viewer.addListener(new TextViewerWindow.TextViewerWindowListener(){

                    @Override
                    public void closed() {
                        String text;
                        String[] lines;
                        ArrayList<String> updated_lines;
                        List<String> result;
                        if (viewer.getOKPressed() && (result = slh.setSchedule(updated_lines = new ArrayList<String>(Arrays.asList(lines = (text = viewer.getText()).split("\n"))))) != null && result.size() > 0) {
                            Utils.showText("MainWindow.menu.speed_limits.schedule.title", "MainWindow.menu.speed_limits.schedule.err", result, () -> Utils.editSpeedLimitHandlerConfig(slh));
                        }
                    }
                });
            }
        });
    }

    public static void showText(String title, String message, List<String> lines) {
        Utils.showText(title, message, lines, null);
    }

    public static void showText(final String title, final String message, final List<String> lines, final Runnable callback) {
        Utils.execSWTThreadLater(1, new Runnable(){

            @Override
            public void run() {
                StringBuilder text = new StringBuilder(lines.size() * 80);
                for (String s : lines) {
                    if (text.length() > 0) {
                        text.append("\n");
                    }
                    text.append(s);
                }
                TextViewerWindow viewer = new TextViewerWindow(title, message, text.toString(), false);
                viewer.setEditable(false);
                viewer.addListener(() -> {
                    if (callback != null) {
                        callback.run();
                    }
                });
            }
        });
    }

    public static void setTextWithURLs(StyledText text, String value, boolean allow_focus) {
        Listener old_listener = (Listener)text.getData("Utils.setTextWithURLs");
        if (old_listener != null) {
            text.removeListener(5, old_listener);
            text.removeListener(32, old_listener);
            text.removeListener(4, old_listener);
            text.removeListener(15, old_listener);
            text.removeListener(35, old_listener);
        }
        Matcher a_matcher = a_pattern.matcher(value);
        StringBuffer result = new StringBuffer(value.length());
        int pos = 0;
        ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
        while (a_matcher.find()) {
            String a;
            Matcher href_matcher;
            int p = a_matcher.start();
            if (p > pos) {
                result.append(value.substring(pos, p));
            }
            if ((href_matcher = href_pattern.matcher(a = a_matcher.group(1))).find()) {
                String url = href_matcher.group(1);
                if (url.startsWith("\"") || url.startsWith("'")) {
                    url = url.substring(1, url.length() - 1);
                }
                String t = a_matcher.group(2);
                StyleRange range = new StyleRange();
                range.start = result.length();
                range.length = t.length();
                range.foreground = text.getDisplay().getSystemColor(36);
                range.data = url;
                ranges.add(range);
                result.append(t);
            }
            pos = a_matcher.end();
        }
        if (pos < value.length()) {
            result.append(value.substring(pos));
        }
        StyleRange[] styles = ranges.toArray(new StyleRange[0]);
        Menu menu = new Menu((Control)text);
        text.setMenu(menu);
        Listener listener = event2 -> {
            String url = null;
            Point location = new Point(event2.x, event2.y);
            if (event2.type == 35) {
                location = text.getDisplay().map(null, (Control)text, location);
            }
            try {
                int offset = text.getOffsetAtPoint(location);
                if (offset >= 0) {
                    int i = 0;
                    while (i < styles.length) {
                        StyleRange sr = styles[i];
                        Object data = sr.data;
                        if (data != null && offset >= sr.start && offset < sr.start + sr.length) {
                            url = (String)data;
                        }
                        ++i;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            switch (event2.type) {
                case 5: {
                    text.setCursor(url == null ? null : text.getDisplay().getSystemCursor(21));
                    break;
                }
                case 32: {
                    Utils.setTT((Control)text, url);
                    break;
                }
                case 4: {
                    if (event2.button != 1 || url == null) break;
                    Utils.launch(url);
                    break;
                }
                case 35: {
                    if (url != null) {
                        ClipboardCopy.addCopyToClipMenu(menu, url);
                        break;
                    }
                    event2.doit = false;
                    break;
                }
                case 15: {
                    text.traverse(16);
                }
            }
        };
        text.addListener(5, listener);
        text.addListener(32, listener);
        text.addListener(4, listener);
        if (!allow_focus) {
            text.addListener(15, listener);
        }
        text.addListener(35, listener);
        text.setData("Utils.setTextWithURLs", (Object)listener);
        text.setText(result.toString());
        text.setStyleRanges(styles);
    }

    public static String escapeAccelerators(String str) {
        return str == null ? null : str.replace("&", "&&");
    }

    public static void addSafeMouseUpListener(Control control, Listener mouseUpListener) {
        Utils.addSafeMouseUpListener(control, null, mouseUpListener);
    }

    public static void addSafeMouseUpListener(Control control, final Listener mouseDownListener, final Listener mouseUpListener) {
        Listener l = new Listener(){
            boolean isMouseDown = false;

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 3: {
                        this.isMouseDown = true;
                        if (mouseDownListener == null) break;
                        mouseDownListener.handleEvent(e);
                        break;
                    }
                    case 7: {
                        this.isMouseDown = false;
                        break;
                    }
                    case 4: {
                        if (!this.isMouseDown) {
                            return;
                        }
                        if (e.widget instanceof Control) {
                            Point size = ((Control)e.widget).getSize();
                            Rectangle bounds = new Rectangle(0, 0, size.x, size.y);
                            if (!bounds.contains(e.x, e.y)) {
                                return;
                            }
                        }
                        mouseUpListener.handleEvent(e);
                    }
                }
            }
        };
        control.addListener(3, l);
        control.addListener(4, l);
        control.addListener(7, l);
    }

    public static StyledText createStyledText(Composite parent, int style) {
        StyledText st = new StyledText(parent, style);
        ScrollBar vbar = st.getVerticalBar();
        vbar.setData("ScrollOnMouseOver", () -> {
            Listener[] listeners = vbar.getListeners(13);
            Event event2 = new Event();
            event2.display = vbar.getDisplay();
            event2.widget = vbar;
            event2.y = vbar.getSelection();
            Listener[] listenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Listener l = listenerArray[n2];
                try {
                    l.handleEvent(event2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++n2;
            }
        });
        return st;
    }

    public static void clearMenu(Menu menu) {
        MenuItem[] items = menu.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
    }

    public static List<Control> getAllChildren(Composite c) {
        ArrayList<Control> list = new ArrayList<Control>();
        Utils.getAllChildren((Control)c, list);
        return list.subList(1, list.size());
    }

    private static void getAllChildren(Control c, List<Control> kids) {
        kids.add(c);
        if (c instanceof Composite) {
            Control[] controlArray = ((Composite)c).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control x = controlArray[n2];
                Utils.getAllChildren(x, kids);
                ++n2;
            }
        }
    }

    public static String getCCString(String cc) {
        String str = cc;
        try {
            Locale country_locale = new Locale("", cc);
            country_locale.getISO3Country();
            String name = country_locale.getDisplayCountry(Locale.getDefault());
            if (name != null && !name.isEmpty()) {
                str = String.valueOf(name) + " (" + cc + ")";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return str;
    }

    public static org.eclipse.swt.graphics.Image resizeImage(org.eclipse.swt.graphics.Image image, int newWidth, int newHeight) {
        int oldwidth = image.getBounds().width;
        BufferedImage img = Utils.convertToAWT(image.getImageData());
        int mode = newWidth < oldwidth ? 16 : 4;
        Image scaledImage = img.getScaledInstance(newWidth, newHeight, mode);
        img = new BufferedImage(newWidth, newHeight, 2);
        img.getGraphics().drawImage(scaledImage, 0, 0, null);
        ImageData imageData = Utils.convertToSWT(img);
        return new org.eclipse.swt.graphics.Image(image.getDevice(), imageData);
    }

    private static BufferedImage convertToAWT(ImageData data) {
        IndexColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            ImageData transparencyMask = data.getTransparencyType() != 1 ? data.getTransparencyMask() : null;
            BufferedImage bufferedImage = new BufferedImage(data.width, data.height, 2);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int mask;
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    int alpha = data.getAlpha(x, y);
                    if (transparencyMask != null && (mask = transparencyMask.getPixel(x, y)) == 0) {
                        alpha = 0;
                    }
                    bufferedImage.setRGB(x, y, alpha << 24 | rgb.red << 16 | rgb.green << 8 | rgb.blue);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, ((ColorModel)colorModel).createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    private static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int rgb = bufferedImage.getRGB(x, y);
                    int pixel = palette.getPixel(new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF));
                    data.setPixel(x, y, pixel);
                    if (colorModel.hasAlpha()) {
                        data.setAlpha(x, y, rgb >> 24 & 0xFF);
                    }
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }

    public static boolean gradientFillSelection() {
        return gradient_fill;
    }

    public static void ensureDisplayUpdated() {
        Utils.readAndDispatchUntilIdleFor(5000L);
    }

    public static void readAndDispatchUntilIdle() {
        Utils.readAndDispatchUntilIdleFor(-1L);
    }

    public static void readAndDispatchLoop(Control owner) {
        Utils.readAndDispatchLoop(owner, false);
    }

    public static void readAndDispatchLoop(Control owner, boolean check_visible) {
        if (owner == null) {
            return;
        }
        Utils.readAndDispatchLoop(() -> {
            if (!(owner.isDisposed() || check_visible && !owner.isVisible())) {
                return false;
            }
            return true;
        });
    }

    public static void readAndDispatchUntilIdleFor(long millis) {
        long start = SystemTime.getMonotonousTime();
        Utils.readAndDispatchUntilIdleOr(() -> millis >= 0L && SystemTime.getMonotonousTime() - start > millis);
    }

    public static void readAndDispatchUntilIdleOr(Supplier<Boolean> done) {
        while (!SWTThread.getInstance().isTerminated() && !done.get().booleanValue() && !display.isDisposed() && display.readAndDispatch()) {
        }
    }

    public static int getDispatchLoopDepth() {
        return dl_depth.get();
    }

    public static boolean readAndDispatchLoop(Supplier<Boolean> done) {
        try {
            dl_depth.incrementAndGet();
            while (!(SWTThread.getInstance().isTerminated() || done.get().booleanValue() || display.isDisposed())) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            boolean bl = display.isDisposed();
            return bl;
        }
        finally {
            dl_depth.decrementAndGet();
        }
    }

    public static void setFilterPathWithTimeout(FileDialog dialog, String path) {
        try {
            if (path != null) {
                path = FileUtil.getCanonicalPathWithTimeout(FileUtil.newFile(path, new String[0]), 20000L);
            }
            dialog.setFilterPath(path);
        }
        catch (Throwable e) {
            Debug.out("Failed to set filter path '" + path + "'");
        }
    }

    public static void setFilterPathWithTimeout(DirectoryDialog dialog, String path) {
        try {
            if (path != null) {
                path = FileUtil.getCanonicalPathWithTimeout(FileUtil.newFile(path, new String[0]), 20000L);
            }
            dialog.setFilterPath(path);
        }
        catch (Throwable e) {
            Debug.out("Failed to set filter path '" + path + "'");
        }
    }

    public static boolean isFileResponding(File file) {
        return FileUtil.isResponding(file, 250L);
    }

    public static boolean fileExistsWithTimeout(String path) {
        return Utils.fileExistsWithTimeout(new File(path));
    }

    public static boolean fileExistsWithTimeout(File file) {
        return FileUtil.existsWithTimeout(file, 250L);
    }

    public static boolean isDirectoryWithTimeout(File dir) {
        return FileUtil.isDirectoryWithTimeout(dir, 250L);
    }

    public static boolean canReadFileWithTimeout(File dir) {
        return FileUtil.canReadWithTimeout(dir, 250L);
    }

    public static long fileLengthWithTimeout(File file) {
        return FileUtil.lengthWithTimeout(file, 250L);
    }

    public static String getCanonicalPathWithTimeout(File file) throws IOException {
        return FileUtil.getCanonicalPathWithTimeout(file, 250L);
    }

    public static File[] listFileRootsWithTimeout() {
        return FileUtil.listRootsWithTimeout(250L);
    }

    public static void numberPrompt(final String title_resource, final String text_resource, final Integer def, final Consumer<Integer> cons) {
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow(title_resource, text_resource);
        if (def != null) {
            entryWindow.setPreenteredText(String.valueOf(def), false);
            entryWindow.selectPreenteredText(true);
        }
        entryWindow.prompt(new UIInputReceiverListener(){

            @Override
            public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                if (!entryWindow.hasSubmittedInput()) {
                    return;
                }
                String sReturn = entryWindow.getSubmittedInput();
                if (sReturn == null) {
                    return;
                }
                try {
                    int num = Integer.valueOf(sReturn);
                    cons.accept(num);
                }
                catch (Throwable e) {
                    new MessageBoxShell(33, MessageText.getString("value.invalid.title"), MessageText.getString("value.invalid.text", new String[]{sReturn})).open(n2 -> Utils.execSWTThreadLater(1, () -> Utils.numberPrompt(title_resource, text_resource, def, cons)));
                }
            }
        });
    }

    public static boolean canDisplayCharacters(Font font, char character1, char character2) {
        String str1 = String.valueOf(character1);
        String str2 = String.valueOf(character2);
        org.eclipse.swt.graphics.Image newImage1 = null;
        org.eclipse.swt.graphics.Image newImage2 = null;
        GC gc1 = null;
        GC gc2 = null;
        try {
            newImage1 = new org.eclipse.swt.graphics.Image((Device)Utils.getDisplay(), 100, 100);
            newImage2 = new org.eclipse.swt.graphics.Image((Device)Utils.getDisplay(), 100, 100);
            gc1 = new GC((Drawable)newImage1);
            gc2 = new GC((Drawable)newImage2);
            gc1.setFont(font);
            gc2.setFont(font);
            Point p1 = GCStringPrinter.stringExtent(gc1, str1);
            Point p2 = GCStringPrinter.stringExtent(gc2, str2);
            boolean same = p1.equals((Object)p2);
            if (same) {
                Rectangle rect = new Rectangle(0, 0, p1.x + 10, p1.y + 10);
                GCStringPrinter.printString(gc1, str1, rect);
                GCStringPrinter.printString(gc2, str2, rect);
                gc1.dispose();
                gc1 = null;
                gc2.dispose();
                gc2 = null;
                ImageData id1 = newImage1.getImageData();
                ImageData id2 = newImage2.getImageData();
                int x = 0;
                while (x < p1.x && same) {
                    int y = 0;
                    while (y < p1.y) {
                        if (id1.getPixel(x, y) != id2.getPixel(x, y)) {
                            same = false;
                            break;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            boolean bl = !same;
            return bl;
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
        finally {
            if (gc1 != null) {
                gc1.dispose();
            }
            if (gc2 != null) {
                gc2.dispose();
            }
            if (newImage1 != null) {
                newImage1.dispose();
            }
            if (newImage2 != null) {
                newImage2.dispose();
            }
        }
    }

    public static interface ColorButton {
        public Button getButton();

        public void setColor(int[] var1);
    }

    public static class SashWrapper {
        private Composite parent;
        private Sash sash;
        private Composite form;
        private Composite child1;
        private Composite child2;
        private FormData child1Data;
        private FormData child2Data;
        private boolean bottomHidden;
        private Double savedPCT;

        private SashWrapper(Composite _parent, final String config_key, int ref_pct) {
            COConfigurationManager.setFloatDefault(config_key, 7500.0f);
            this.parent = _parent;
            this.form = new Composite(this.parent, 0);
            FormLayout flayout = new FormLayout();
            flayout.marginHeight = 0;
            flayout.marginWidth = 0;
            this.form.setLayout((Layout)flayout);
            this.form.setLayoutData((Object)Utils.getFilledFormData());
            this.child1 = new Composite(this.form, 0);
            flayout = new FormLayout();
            flayout.marginHeight = 0;
            flayout.marginWidth = 0;
            this.child1.setLayout((Layout)flayout);
            final int SASH_WIDTH = 3;
            this.sash = Utils.createSash(this.form, SASH_WIDTH, 256);
            int weight = (int)COConfigurationManager.getFloatParameter(config_key);
            if (weight > 10000) {
                weight = 10000;
            } else if (weight < 100) {
                weight *= 100;
            }
            if (weight < 500) {
                weight = 500;
            } else if (weight > 9000) {
                weight = 9000;
            }
            double pct = (float)weight / 10000.0f;
            this.sash.setData("PCT", (Object)new Double(pct));
            this.child2 = new Composite(this.form, 0);
            flayout = new FormLayout();
            flayout.marginHeight = 0;
            flayout.marginWidth = 0;
            this.child2.setLayout((Layout)flayout);
            FormData formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment((int)(pct * 100.0), 0);
            this.child1.setLayoutData((Object)formData);
            this.child1Data = formData;
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)this.child1);
            formData.height = SASH_WIDTH;
            this.sash.setLayoutData((Object)formData);
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)this.sash);
            this.child2.setLayoutData((Object)formData);
            this.child2Data = formData;
            this.sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean FASTDRAG = true;
                    if (e.detail == 1) {
                        return;
                    }
                    ((SashWrapper)this).child1Data.height = e.y + e.height - SASH_WIDTH;
                    form.layout();
                    Double l = new Double((double)((SashWrapper)this).child1.getBounds().height / (double)((SashWrapper)this).form.getBounds().height);
                    sash.setData("PCT", (Object)l);
                    if (e.detail != 1) {
                        float f = (float)(l * 10000.0);
                        COConfigurationManager.setParameter(config_key, f);
                    }
                }
            });
            this.form.addListener(11, (Listener)new DelayedListenerMultiCombiner(){

                @Override
                public void handleDelayedEvent(Event e) {
                    if (sash.isDisposed()) {
                        return;
                    }
                    Double l = (Double)sash.getData("PCT");
                    if (l == null) {
                        return;
                    }
                    int newHeight = (int)((double)((SashWrapper)this).form.getBounds().height * l);
                    if (((SashWrapper)this).child1Data.height != newHeight || ((SashWrapper)this).child1Data.bottom != null) {
                        ((SashWrapper)this).child1Data.bottom = null;
                        ((SashWrapper)this).child1Data.height = newHeight;
                        form.layout();
                    }
                }
            });
        }

        public void setBottomVisible(boolean vis) {
            Utils.execSWTThread(() -> {
                if (this.sash.isDisposed()) {
                    return;
                }
                if (vis) {
                    if (this.bottomHidden) {
                        this.bottomHidden = false;
                        this.sash.setVisible(true);
                        this.child2.setVisible(true);
                        if (this.savedPCT != null) {
                            this.sash.setData("PCT", (Object)this.savedPCT);
                            int newHeight = (int)((double)this.form.getBounds().height * this.savedPCT);
                            if (this.child1Data.height != newHeight || this.child1Data.bottom != null) {
                                this.child1Data.bottom = null;
                                this.child1Data.height = newHeight;
                            }
                        }
                        this.form.layout();
                        this.parent.layout(true, true);
                    }
                } else if (!this.bottomHidden) {
                    this.bottomHidden = true;
                    this.savedPCT = (Double)this.sash.getData("PCT");
                    this.child1Data.height = this.parent.getSize().y;
                    this.sash.setData("PCT", (Object)1.0);
                    this.form.layout();
                    this.sash.setVisible(false);
                    this.child2.setVisible(false);
                    this.parent.layout(true, true);
                }
            });
        }

        public Composite[] getChildren() {
            return new Composite[]{this.child1, this.child2};
        }
    }

    public static class SashWrapper2 {
        final int SASH_WIDTH = 3;
        int MIN_BOTTOM_HEIGHT = 10;
        private Composite parent;
        private String config_key;
        private Sash sash;
        private Composite form;
        private Composite child1;
        private Composite child2;
        private FormData child1Data;
        private FormData child2Data;

        private SashWrapper2(Composite _parent, String _config_key) {
            this.parent = _parent;
            this.config_key = _config_key;
            this.form = new Composite(this.parent, 0);
            FormLayout flayout = new FormLayout();
            flayout.marginHeight = 0;
            flayout.marginWidth = 0;
            this.form.setLayout((Layout)flayout);
            this.form.setLayoutData((Object)Utils.getFilledFormData());
            this.child1 = new Composite(this.form, 0);
            flayout = new FormLayout();
            flayout.marginHeight = 0;
            flayout.marginWidth = 0;
            this.child1.setLayout((Layout)flayout);
            this.sash = new Sash(this.form, 256);
            this.child2 = new Composite(this.form, 0);
            flayout = new FormLayout();
            flayout.marginHeight = 0;
            flayout.marginWidth = 0;
            this.child2.setLayout((Layout)flayout);
            FormData formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(100, 0);
            this.child1.setLayoutData((Object)formData);
            this.child1Data = formData;
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)this.child1);
            formData.height = 3;
            this.sash.setLayoutData((Object)formData);
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)this.sash);
            this.child2.setLayoutData((Object)formData);
            this.child2Data = formData;
            this.sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean FASTDRAG = true;
                    if (e.detail == 1) {
                        return;
                    }
                    int newTopHeight = e.y + e.height - 3;
                    int maxNewTopHeight = ((SashWrapper2)this).form.getBounds().height - MIN_BOTTOM_HEIGHT - 3;
                    ((SashWrapper2)this).child1Data.height = newTopHeight = Math.min(newTopHeight, maxNewTopHeight);
                    form.layout();
                    int newBottomHeight = ((SashWrapper2)this).child2.getBounds().height;
                    newBottomHeight = Math.max(MIN_BOTTOM_HEIGHT, newBottomHeight);
                    sash.setData("BH", (Object)newBottomHeight);
                    if (e.detail != 1) {
                        COConfigurationManager.setParameter(config_key, newBottomHeight);
                    }
                }
            });
            this.form.addListener(11, (Listener)new DelayedListenerMultiCombiner(){

                @Override
                public void handleDelayedEvent(Event e) {
                    this.resize();
                }
            });
        }

        private void resize() {
            if (this.sash.isDisposed()) {
                return;
            }
            Integer height = (Integer)this.sash.getData("BH");
            if (height == null) {
                return;
            }
            int newTopHeight = this.form.getBounds().height - height - 3;
            int maxNewTopHeight = this.form.getBounds().height - this.MIN_BOTTOM_HEIGHT - 3;
            if (this.child1Data.height != (newTopHeight = Math.min(newTopHeight, maxNewTopHeight)) || this.child1Data.bottom != null) {
                this.child1Data.bottom = null;
                this.child1Data.height = newTopHeight;
                this.form.layout();
            }
        }

        public void setDefaultBottomHeight(int height) {
            this.MIN_BOTTOM_HEIGHT = Math.max(10, height);
            COConfigurationManager.setIntDefault(this.config_key, this.MIN_BOTTOM_HEIGHT);
            height = COConfigurationManager.getIntParameter(this.config_key);
            height = Math.max(10, height);
            this.sash.setData("BH", (Object)height);
            this.resize();
        }

        public Composite[] getChildren() {
            return new Composite[]{this.child1, this.child2};
        }
    }

    private static class ShellMetricsResizeListener
    implements Listener {
        private final String sConfigPrefix;
        private int currentState = -1;
        private Rectangle currentBounds = null;
        private int savedState;
        private Rectangle savedBounds;

        ShellMetricsResizeListener(Shell shell, String sConfigPrefix) {
            this.sConfigPrefix = sConfigPrefix;
            this.currentState = this.calcState(shell);
            if (this.currentState == 0) {
                this.currentBounds = shell.getBounds();
            }
            if (this.currentBounds == null) {
                this.currentBounds = new Rectangle(0, 0, 0, 0);
            }
            this.savedState = this.currentState;
            this.savedBounds = this.currentBounds;
            shell.addListener(11, (Listener)this);
            shell.addListener(10, (Listener)this);
            shell.addListener(12, (Listener)this);
        }

        private int calcState(Shell shell) {
            return shell.getMinimized() ? 128 : (shell.getMaximized() ? 1024 : 0);
        }

        public void handleEvent(Event event2) {
            Shell shell = (Shell)event2.widget;
            if (shell.getData(SHELL_METRICS_DISABLED_KEY) != null) {
                return;
            }
            this.currentState = this.calcState(shell);
            if (event2.type != 12 && this.currentState == 0) {
                this.currentBounds = shell.getBounds();
                if (this.currentBounds == null) {
                    this.currentBounds = new Rectangle(0, 0, 0, 0);
                }
            }
            String rectStr = String.valueOf(this.currentBounds.x) + "," + this.currentBounds.y + "," + this.currentBounds.width + "," + this.currentBounds.height;
            boolean changed = false;
            if (this.currentState != this.savedState) {
                COConfigurationManager.setParameter(String.valueOf(this.sConfigPrefix) + ".maximized", this.currentState == 1024);
                this.savedState = this.currentState;
                changed = true;
            }
            if (!this.currentBounds.equals((Object)this.savedBounds) && this.currentBounds.width > 0 && this.currentBounds.height > 0) {
                COConfigurationManager.setParameter(String.valueOf(this.sConfigPrefix) + ".rectangle", rectStr);
                this.savedBounds = this.currentBounds;
                changed = true;
            }
            if (changed) {
                COConfigurationManager.setDirty();
            }
        }
    }

    private static class Skinner {
        final Color widget_fg;
        final Color widget_bg;
        final Color list_bg;

        Skinner(Display display) {
            this.widget_fg = Colors.getWindowsDarkSystemColor((Device)display, 21);
            this.widget_bg = Colors.getWindowsDarkSystemColor((Device)display, 22);
            this.list_bg = Colors.getWindowsDarkSystemColor((Device)display, 25);
            display.addFilter(45, e -> {
                Widget widget = e.widget;
                skinner.handleSkinning(widget);
            });
        }

        void handleSkinning(Widget widget) {
            Control control;
            int sct;
            if (skinning_enabled <= 0) {
                return;
            }
            Integer _sct = (Integer)widget.getData("utils:skinned-ct");
            int n = sct = _sct == null ? 0 : _sct;
            if (sct == -1) {
                return;
            }
            if (!(widget instanceof ExpandBar) && widget instanceof Control) {
                control = (Control)widget;
                Utils.setSkinnedForegroundDefault(control, this.widget_fg);
                Utils.setSkinnedBackgroundDefault(control, this.widget_bg);
            }
            if (widget instanceof CTabFolder) {
                control = (CTabFolder)widget;
                control.setSelectionForeground(this.widget_fg);
                control.setHighlightEnabled(false);
            }
            if (widget instanceof Text) {
                control = (Text)widget;
                if (sct == 1) {
                    Utils.setSkinnedBackgroundDefault(control, Colors.black);
                }
            }
            if (widget instanceof Label) {
                control = (Label)widget;
                if (sct == 2) {
                    Utils.setSkinnedForegroundDefault(control, Colors.white);
                }
            }
            if (widget instanceof CTabItem) {
                CTabItem item = (CTabItem)widget;
                Utils.setSkinnedForegroundDefault(item, this.widget_fg);
            }
            if (widget instanceof Tree) {
                Tree tree = (Tree)widget;
                tree.setLinesVisible(false);
                tree.setHeaderForeground(this.widget_fg);
                tree.setHeaderBackground(this.list_bg);
            }
            if (widget instanceof Table) {
                Table table = (Table)widget;
                table.setLinesVisible(false);
                table.setHeaderForeground(this.widget_fg);
                table.setHeaderBackground(this.list_bg);
            }
        }
    }

    public static interface TerminateListener {
        public void terminated();
    }

    private static class TruncatedTextResult {
        String text;
        int maxWidth;
    }
}

