/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.auth;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.security.SECertificateListener;
import com.biglybt.core.security.SESecurityManager;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import java.security.cert.X509Certificate;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class CertificateTrustWindow
implements SECertificateListener {
    public CertificateTrustWindow() {
        SESecurityManager.addCertificateListener(this);
    }

    @Override
    public boolean trustCertificate(String _resource, final X509Certificate cert) {
        final Display display = Utils.getDisplay();
        if (display.isDisposed()) {
            return false;
        }
        TOTorrent torrent = TorrentUtils.getTLSTorrent();
        final String resource = torrent != null ? String.valueOf(TorrentUtils.getLocalisedName(torrent)) + "\n" + _resource : _resource;
        final trustDialog[] dialog = new trustDialog[1];
        try {
            Utils.execSWTThread((Runnable)new AERunnable(){

                @Override
                public void runSupport() {
                    dialog[0] = new trustDialog(display, resource, cert);
                }
            }, false);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
        return dialog[0].getTrusted();
    }

    protected static class trustDialog {
        protected Shell shell;
        protected boolean trusted;

        protected trustDialog(Display display, String resource, X509Certificate cert) {
            if (display.isDisposed()) {
                return;
            }
            this.shell = ShellFactory.createMainShell(67680);
            Utils.setShellIcon(this.shell);
            this.shell.setText(MessageText.getString("security.certtruster.title"));
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            this.shell.setLayout((Layout)layout);
            Label info_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)info_label, "security.certtruster.intro");
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 3;
            info_label.setLayoutData((Object)gridData);
            Label resource_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)resource_label, "security.certtruster.resource");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            resource_label.setLayoutData((Object)gridData);
            Label resource_value = new Label((Composite)this.shell, 64);
            resource_value.setText(resource.replaceAll("&", "&&"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            resource_value.setLayoutData((Object)gridData);
            Label issued_by_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)issued_by_label, "security.certtruster.issuedby");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            issued_by_label.setLayoutData((Object)gridData);
            Label issued_by_value = new Label((Composite)this.shell, 0);
            issued_by_value.setText(this.extractCN(cert.getIssuerX500Principal().getName()).replaceAll("&", "&&"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            issued_by_value.setLayoutData((Object)gridData);
            Label issued_to_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)issued_to_label, "security.certtruster.issuedto");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            issued_to_label.setLayoutData((Object)gridData);
            Label issued_to_value = new Label((Composite)this.shell, 0);
            issued_to_value.setText(this.extractCN(cert.getSubjectX500Principal().getName()).replaceAll("&", "&&"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            issued_to_value.setLayoutData((Object)gridData);
            Label prompt_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)prompt_label, "security.certtruster.prompt");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 3;
            prompt_label.setLayoutData((Object)gridData);
            Control labelSeparator = Utils.createSkinnedLabelSeparator((Composite)this.shell, 256);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            labelSeparator.setLayoutData((Object)gridData);
            new Label((Composite)this.shell, 0);
            Composite comp2 = new Composite((Composite)this.shell, 0);
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 2;
            comp2.setLayoutData((Object)gridData);
            GridLayout layoutButtons = new GridLayout();
            layoutButtons.numColumns = 2;
            comp2.setLayout((Layout)layoutButtons);
            Button bYes = new Button(comp2, 8);
            bYes.setText(MessageText.getString("security.certtruster.yes"));
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            bYes.setLayoutData((Object)gridData);
            bYes.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.close(true);
                }
            });
            Button bNo = new Button(comp2, 8);
            bNo.setText(MessageText.getString("security.certtruster.no"));
            gridData = new GridData(128);
            gridData.grabExcessHorizontalSpace = false;
            gridData.widthHint = 70;
            bNo.setLayoutData((Object)gridData);
            bNo.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.close(false);
                }
            });
            this.shell.setDefaultButton(bYes);
            this.shell.addListener(31, new Listener(){

                public void handleEvent(Event e) {
                    if (e.character == '\u001b') {
                        this.close(false);
                    }
                }
            });
            this.shell.pack();
            Utils.centreWindow(this.shell);
            this.shell.open();
            Utils.readAndDispatchLoop((Control)this.shell);
        }

        protected void close(boolean ok) {
            this.trusted = ok;
            this.shell.dispose();
        }

        protected String extractCN(String dn) {
            int p1 = dn.indexOf("CN=");
            if (p1 == -1) {
                return dn;
            }
            int p2 = dn.indexOf(",", p1);
            if (p2 == -1) {
                return dn.substring(p1 + 3).trim();
            }
            return dn.substring(p1 + 3, p2).trim();
        }

        public boolean getTrusted() {
            return this.trusted;
        }
    }
}

