/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.auth;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.security.CryptoManagerFactory;
import com.biglybt.core.security.CryptoManagerPasswordHandler;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import java.util.Arrays;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CryptoWindow
implements CryptoManagerPasswordHandler {
    private static final int DAY = 86400;

    public CryptoWindow() {
        this(false);
    }

    public CryptoWindow(boolean stand_alone) {
        if (!stand_alone) {
            CryptoManagerFactory.getSingleton().addPasswordHandler(this);
        }
    }

    @Override
    public int getHandlerType() {
        return 1;
    }

    @Override
    public CryptoManagerPasswordHandler.passwordDetails getPassword(final int handler_type, final int action_type, final boolean last_pw_incorrect, final String reason) {
        AESemaphore sem;
        cryptoDialog[] dialog;
        Display display;
        block6: {
            display = Utils.getDisplay();
            if (display.isDisposed()) {
                return null;
            }
            dialog = new cryptoDialog[1];
            sem = new AESemaphore("CryptoWindowSem");
            try {
                if (display.getThread() != Thread.currentThread()) break block6;
                dialog[0] = new cryptoDialog(sem, display, handler_type, action_type, last_pw_incorrect, reason);
                if (Utils.readAndDispatchLoop(() -> sem.isReleasedForever())) {
                    return null;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return null;
            }
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                dialog[0] = new cryptoDialog(sem, display, handler_type, action_type, last_pw_incorrect, reason);
            }
        });
        sem.reserve();
        final char[] pw = dialog[0].getPassword();
        final int persist_for = dialog[0].getPersistForSeconds();
        if (pw == null) {
            return null;
        }
        return new CryptoManagerPasswordHandler.passwordDetails(){

            @Override
            public char[] getPassword() {
                return pw;
            }

            @Override
            public int getPersistForSeconds() {
                return persist_for;
            }
        };
    }

    @Override
    public void passwordOK(int handler_type, CryptoManagerPasswordHandler.passwordDetails details) {
    }

    protected static class cryptoDialog {
        private AESemaphore sem;
        private Shell shell;
        private char[] password;
        private char[] password2;
        private int persist_for_secs;
        private boolean verify_password;

        protected cryptoDialog(AESemaphore _sem, Display display, int handler_type, int action_type, boolean last_pw_incorrect, String reason) {
            GridData gridData;
            this.sem = _sem;
            if (display.isDisposed()) {
                this.sem.releaseForever();
                return;
            }
            this.shell = ShellFactory.createMainShell(67680);
            Utils.setShellIcon(this.shell);
            boolean set_password = action_type == 3;
            Messages.setLanguageText((Widget)this.shell, set_password ? "security.crypto.pw.title" : "security.crypto.title");
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            this.shell.setLayout((Layout)layout);
            if (action_type == 1) {
                Label reason_label = new Label((Composite)this.shell, 64);
                Messages.setLanguageText((Widget)reason_label, "security.crypto.encrypt");
                gridData = new GridData(1808);
                gridData.horizontalSpan = 3;
                gridData.widthHint = 300;
                reason_label.setLayoutData((Object)gridData);
            } else if (action_type == 2) {
                Label decrypt_label = new Label((Composite)this.shell, 64);
                Messages.setLanguageText((Widget)decrypt_label, "security.crypto.decrypt");
                gridData = new GridData(1808);
                gridData.horizontalSpan = 3;
                gridData.widthHint = 300;
                decrypt_label.setLayoutData((Object)gridData);
                Label reason_label = new Label((Composite)this.shell, 0);
                Messages.setLanguageText((Widget)reason_label, "security.crypto.reason");
                gridData = new GridData(1808);
                gridData.horizontalSpan = 1;
                reason_label.setLayoutData((Object)gridData);
                Label reason_value = new Label((Composite)this.shell, 0);
                reason_value.setText(reason.replaceAll("&", "&&"));
                gridData = new GridData(1808);
                gridData.horizontalSpan = 2;
                reason_value.setLayoutData((Object)gridData);
                if (last_pw_incorrect) {
                    Label pw_wrong_label = new Label((Composite)this.shell, 64);
                    Messages.setLanguageText((Widget)pw_wrong_label, "security.crypto.badpw");
                    gridData = new GridData(1808);
                    gridData.horizontalSpan = 3;
                    pw_wrong_label.setLayoutData((Object)gridData);
                    pw_wrong_label.setForeground(Colors.red);
                }
            }
            Label password_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)password_label, "security.crypto.password");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            password_label.setLayoutData((Object)gridData);
            final Text password_value = new Text((Composite)this.shell, 2048);
            password_value.setEchoChar('*');
            password_value.setText("");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            password_value.setLayoutData((Object)gridData);
            password_value.addListener(24, new Listener(){

                public void handleEvent(Event event2) {
                    password = password_value.getText().toCharArray();
                }
            });
            if (action_type == 1 || set_password) {
                this.verify_password = true;
                Label password2_label = new Label((Composite)this.shell, 0);
                Messages.setLanguageText((Widget)password2_label, "security.crypto.password2");
                gridData = new GridData(1808);
                gridData.horizontalSpan = 1;
                password2_label.setLayoutData((Object)gridData);
                final Text password2_value = new Text((Composite)this.shell, 2048);
                password2_value.setEchoChar('*');
                password2_value.setText("");
                gridData = new GridData(1808);
                gridData.horizontalSpan = 2;
                password2_value.setLayoutData((Object)gridData);
                password2_value.addListener(24, new Listener(){

                    public void handleEvent(Event event2) {
                        password2 = password2_value.getText().toCharArray();
                    }
                });
            }
            if (!set_password) {
                Label strength_label = new Label((Composite)this.shell, 0);
                Messages.setLanguageText((Widget)strength_label, "security.crypto.persist_for");
                gridData = new GridData(1808);
                gridData.horizontalSpan = 1;
                strength_label.setLayoutData((Object)gridData);
                String[] duration_keys = new String[]{"dont_save", "session", "day", "week", "30days", "forever"};
                int[] nArray = new int[6];
                nArray[1] = -1;
                nArray[2] = 86400;
                nArray[3] = 604800;
                nArray[4] = 2592000;
                nArray[5] = Integer.MAX_VALUE;
                final int[] duration_secs = nArray;
                final Combo durations_combo = new Combo((Composite)this.shell, 12);
                int i = 0;
                while (i < duration_keys.length) {
                    String text = MessageText.getString("security.crypto.persist_for." + duration_keys[i]);
                    durations_combo.add(text);
                    ++i;
                }
                durations_combo.select(4);
                this.persist_for_secs = duration_secs[4];
                durations_combo.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        persist_for_secs = duration_secs[durations_combo.getSelectionIndex()];
                    }
                });
                gridData = new GridData(1808);
                gridData.horizontalSpan = 1;
                durations_combo.setLayoutData((Object)gridData);
                new Label((Composite)this.shell, 0);
                Label linkLabel = new Label((Composite)this.shell, 0);
                linkLabel.setText(MessageText.getString("ConfigView.label.please.visit.here"));
                linkLabel.setData((Object)"https://wiki.biglybt.com/w/Public_Private_Keys");
                linkLabel.setCursor(display.getSystemCursor(21));
                Utils.setLinkForeground((Control)linkLabel);
                gridData = new GridData();
                gridData.horizontalSpan = 3;
                linkLabel.setLayoutData((Object)gridData);
                linkLabel.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDoubleClick(MouseEvent arg0) {
                        Utils.launch(arg0.widget.getData());
                    }

                    public void mouseDown(MouseEvent arg0) {
                        Utils.launch(arg0.widget.getData());
                    }
                });
                ClipboardCopy.addCopyToClipMenu((Control)linkLabel);
            }
            Control labelSeparator = Utils.createSkinnedLabelSeparator((Composite)this.shell, 256);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            labelSeparator.setLayoutData((Object)gridData);
            new Label((Composite)this.shell, 0);
            Button bOk = new Button((Composite)this.shell, 8);
            Messages.setLanguageText((Widget)bOk, "Button.ok");
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            bOk.setLayoutData((Object)gridData);
            bOk.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.close(true);
                }
            });
            Button bCancel = new Button((Composite)this.shell, 8);
            Messages.setLanguageText((Widget)bCancel, "Button.cancel");
            gridData = new GridData(128);
            gridData.grabExcessHorizontalSpace = false;
            gridData.widthHint = 70;
            bCancel.setLayoutData((Object)gridData);
            bCancel.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.close(false);
                }
            });
            this.shell.setDefaultButton(bOk);
            this.shell.addListener(31, new Listener(){

                public void handleEvent(Event e) {
                    if (e.character == '\u001b') {
                        this.close(false);
                    }
                }
            });
            this.shell.pack();
            Utils.centreWindow(this.shell);
            this.shell.open();
        }

        protected void close(boolean ok) {
            try {
                if (ok) {
                    if (this.password == null) {
                        this.password = new char[0];
                    }
                    if (this.password2 == null) {
                        this.password2 = new char[0];
                    }
                    if (this.verify_password && !Arrays.equals(this.password, this.password2)) {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setText(MessageText.getString("security.crypto.password.mismatch.title"));
                        mb.setMessage(MessageText.getString("security.crypto.password.mismatch"));
                        mb.open();
                        return;
                    }
                } else {
                    this.password = null;
                }
                this.shell.dispose();
            }
            finally {
                this.sem.releaseForever();
            }
        }

        protected char[] getPassword() {
            return this.password;
        }

        protected int getPersistForSeconds() {
            return this.persist_for_secs;
        }
    }
}

