/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.browser.listener;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.messenger.browser.BrowserMessage;
import com.biglybt.core.messenger.browser.listeners.AbstractBrowserMessageListener;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsLogger;
import com.biglybt.net.magneturi.MagnetURIHandler;
import com.biglybt.ui.swt.BrowserWrapper;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.update.UpdateMonitor;
import com.biglybt.util.ConstantsVuze;
import com.biglybt.util.MapUtils;
import java.util.Map;

public class ConfigListener
extends AbstractBrowserMessageListener {
    public static final String DEFAULT_LISTENER_ID = "config";
    public static final String OP_GET_VERSION = "get-version";
    public static final String OP_NEW_INSTALL = "is-new-install";
    public static final String OP_CHECK_FOR_UPDATES = "check-for-updates";
    public static final String OP_GET_MAGNET_PORT = "get-magnet-port";
    public static final String OP_LOG_DIAGS = "log-diags";
    public static final String OP_LOG = "log";

    public ConfigListener(String id, BrowserWrapper browser) {
        super(id);
    }

    public ConfigListener(BrowserWrapper browser) {
        this(DEFAULT_LISTENER_ID, browser);
    }

    @Override
    public void handleMessage(BrowserMessage message) {
        try {
            String opid = message.getOperationId();
            if (OP_GET_VERSION.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                String callback = MapUtils.getMapString(decodedMap, "callback", null);
                if (callback != null) {
                    this.context.executeInBrowser(String.valueOf(callback) + "('" + "3.9.0.0" + "')");
                } else {
                    message.debug("bad or no callback param");
                }
            } else if (OP_NEW_INSTALL.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                String callback = MapUtils.getMapString(decodedMap, "callback", null);
                if (callback != null) {
                    this.context.executeInBrowser(String.valueOf(callback) + "(" + COConfigurationManager.isNewInstall() + ")");
                } else {
                    message.debug("bad or no callback param");
                }
            } else if (OP_CHECK_FOR_UPDATES.equals(opid)) {
                ConfigListener.checkForUpdates();
            } else if (OP_GET_MAGNET_PORT.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                String callback = MapUtils.getMapString(decodedMap, "callback", null);
                if (callback != null) {
                    this.context.executeInBrowser(String.valueOf(callback) + "('" + MagnetURIHandler.getSingleton().getPort() + "')");
                } else {
                    message.debug("bad or no callback param");
                }
            } else if (OP_LOG_DIAGS.equals(opid)) {
                ConfigListener.logDiagnostics();
            } else if (OP_LOG.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                String loggerName = MapUtils.getMapString(decodedMap, "log-name", "browser");
                String text = MapUtils.getMapString(decodedMap, "text", "");
                AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger(loggerName);
                diag_logger.log(text);
                if (ConstantsVuze.DIAG_TO_STDOUT) {
                    System.out.println(String.valueOf(Thread.currentThread().getName()) + "|" + System.currentTimeMillis() + "] " + text);
                }
            }
        }
        catch (Throwable t) {
            message.debug("handle Config message", t);
        }
    }

    public static void logDiagnostics() {
        AEDiagnostics.dumpThreads();
    }

    public static void checkForUpdates() {
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null) {
            uiFunctions.bringToFront();
        }
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                UpdateMonitor.getSingleton(core).performCheck(true, false, false, null);
            }
        });
    }
}

