/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.browser.msg;

import com.biglybt.core.messenger.ClientMessageContext;
import com.biglybt.core.messenger.browser.BrowserMessage;
import com.biglybt.core.messenger.browser.BrowserMessageDispatcher;
import com.biglybt.core.messenger.browser.listeners.BrowserMessageListener;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.BrowserWrapper;
import com.biglybt.ui.swt.Utils;
import com.biglybt.util.JSONUtils;
import com.biglybt.util.UrlFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MessageDispatcherSWT
implements BrowserMessageDispatcher {
    private ClientMessageContext context;
    private Map<String, BrowserMessageListener> listeners = new HashMap<String, BrowserMessageListener>();
    private BrowserWrapper browser;
    private BrowserWrapper.BrowserFunction browserFunction;

    public MessageDispatcherSWT(ClientMessageContext context2) {
        this.context = context2;
    }

    public void registerBrowser(final BrowserWrapper browser) {
        this.browser = browser;
        try {
            this.browserFunction = browser.addBrowserFunction("sendMessageToAZ", new BrowserWrapper.BrowserFunction(){

                @Override
                public Object function(Object[] args) {
                    if (args == null) {
                        MessageDispatcherSWT.this.context.debug("sendMessageToAZ: arguments null on " + browser.getUrl());
                        return null;
                    }
                    if (args.length != 3 && args.length != 2) {
                        MessageDispatcherSWT.this.context.debug("sendMessageToAZ: # arguments not 2 or 3 (" + args.length + ") on " + browser.getUrl());
                        return null;
                    }
                    if (!(args[0] instanceof String)) {
                        MessageDispatcherSWT.this.context.debug("sendMessageToAZ: Param 1 not String");
                        return null;
                    }
                    if (!(args[1] instanceof String)) {
                        MessageDispatcherSWT.this.context.debug("sendMessageToAZ: Param 2 not String");
                        return null;
                    }
                    Map params = Collections.EMPTY_MAP;
                    if (args.length == 3) {
                        if (!(args[2] instanceof String)) {
                            MessageDispatcherSWT.this.context.debug("sendMessageToAZ: Param 3 not String");
                            return null;
                        }
                        params = JSONUtils.decodeJSON((String)args[2]);
                    }
                    BrowserMessage message = new BrowserMessage((String)args[0], (String)args[1], params);
                    message.setReferer(browser.getUrl());
                    MessageDispatcherSWT.this.dispatch(message);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            Debug.out(t);
        }
    }

    public void deregisterBrowser(BrowserWrapper browser) {
        if (this.browserFunction != null && !this.browserFunction.isDisposed()) {
            this.browserFunction.dispose();
        }
    }

    @Override
    public synchronized void addListener(BrowserMessageListener listener) {
        String id = listener.getId();
        BrowserMessageListener registered = this.listeners.get(id);
        if (registered != null) {
            if (registered != listener) {
                throw new IllegalStateException("Listener " + registered.getClass().getName() + " already registered for ID " + id);
            }
        } else {
            listener.setContext(this.context);
            this.listeners.put(id, listener);
        }
    }

    @Override
    public synchronized void removeListener(BrowserMessageListener listener) {
        this.removeListener(listener.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeListener(String id) {
        BrowserMessageListener removed;
        MessageDispatcherSWT messageDispatcherSWT = this;
        synchronized (messageDispatcherSWT) {
            removed = this.listeners.remove(id);
        }
        if (removed != null) {
            removed.setContext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrowserMessageListener getListener(String id) {
        MessageDispatcherSWT messageDispatcherSWT = this;
        synchronized (messageDispatcherSWT) {
            return this.listeners.get(id);
        }
    }

    @Override
    public void dispatch(BrowserMessage message) {
        BrowserMessageListener listener;
        String listenerId;
        if (message == null) {
            return;
        }
        String referer = message.getReferer();
        if (referer != null && !UrlFilter.getInstance().urlCanRPC(referer)) {
            this.context.debug("blocked " + message + "\n  " + referer);
            return;
        }
        this.context.debug("Received " + message);
        if (this.browser != null && !this.browser.isDisposed() && Utils.isThisThreadSWT()) {
            this.context.debug("   browser url: " + this.browser.getUrl());
        }
        if ("lightbox-browser".equals(listenerId = message.getListenerId())) {
            listenerId = "display";
        }
        if ((listener = this.getListener(listenerId)) == null) {
            this.context.debug("No listener registered with ID " + listenerId);
        } else {
            listener.handleMessage(message);
            message.complete(true, true, null);
        }
    }
}

