/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns;

import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.common.table.TableCellCore;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.pif.UISWTGraphic;
import com.biglybt.ui.swt.pifimpl.UISWTGraphicImpl;
import org.eclipse.swt.graphics.Rectangle;

public abstract class ColumnCheckBox
implements TableCellRefreshListener,
TableColumnExtraInfoListener,
TableCellMouseListener {
    private final UISWTGraphic tick_icon;
    private final UISWTGraphic tick_ro_icon;
    private final UISWTGraphic cross_icon;
    private boolean read_only;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnCheckBox(TableColumn column, int width, boolean read_only) {
        this.read_only = read_only;
        column.setWidth(width);
        column.setType(2);
        column.addListeners(this);
        if (read_only) {
            column.removeCellMouseListener(this);
        }
        this.tick_icon = new UISWTGraphicImpl(ImageLoader.getInstance().getImage("check_yes"));
        this.tick_ro_icon = new UISWTGraphicImpl(ImageLoader.getInstance().getImage("check_ro_yes"));
        this.cross_icon = new UISWTGraphicImpl(ImageLoader.getInstance().getImage("check_no"));
    }

    public ColumnCheckBox(TableColumn column) {
        this(column, 40, false);
    }

    public ColumnCheckBox(TableColumn column, int width) {
        this(column, width, false);
    }

    protected abstract Boolean getCheckBoxState(Object var1);

    protected abstract void setCheckBoxState(Object var1, boolean var2);

    protected boolean isReadOnly(Object datasource) {
        return false;
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        if (event2.eventType == 1) {
            Boolean state;
            Object datasource;
            TableCell cell = event2.cell;
            int event_x = event2.x;
            int event_y = event2.y;
            int cell_width = cell.getWidth();
            int cell_height = cell.getHeight();
            Rectangle icon_bounds = this.tick_icon.getImage().getBounds();
            int x_pad = (cell_width - icon_bounds.width) / 2;
            int y_pad = (cell_height - icon_bounds.height) / 2;
            if (event_x >= x_pad && event_x <= cell_width - x_pad && event_y >= y_pad && event_y <= cell_height - y_pad && !this.isReadOnly(datasource = cell.getDataSource()) && (state = this.getCheckBoxState(datasource)) != null) {
                this.setCheckBoxState(datasource, state == false);
                cell.invalidate();
                if (cell instanceof TableCellCore) {
                    ((TableCellCore)cell).refresh(true);
                }
            }
        }
    }

    @Override
    public void refresh(TableCell cell) {
        Object dataSource = cell.getDataSource();
        Boolean state = this.getCheckBoxState(dataSource);
        long sortVal = 0L;
        UISWTGraphic icon = null;
        if (state != null) {
            boolean ds_read_only;
            boolean bl = ds_read_only = this.read_only || this.isReadOnly(dataSource);
            if (state.booleanValue()) {
                sortVal = 2L;
                icon = ds_read_only ? this.tick_ro_icon : this.tick_icon;
            } else {
                sortVal = 1L;
                UISWTGraphic uISWTGraphic = icon = ds_read_only ? null : this.cross_icon;
            }
        }
        if (!cell.setSortValue(sortVal = this.adjustSortVal(dataSource, sortVal)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        if (cell.getGraphic() != icon) {
            cell.setGraphic(icon);
        }
        boolean value = state != null && state != false;
        cell.setTextEquivalent(value ? "1" : "0");
    }

    public long adjustSortVal(Object ds, long sortVal) {
        return sortVal;
    }
}

