/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.alltrackers;

import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.skin.SBC_AllTrackersView;
import java.net.URL;

public class ColumnAllTrackersDNSPrefs
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "alltrackers.dnsprefs";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnAllTrackersDNSPrefs(TableColumn column) {
        column.setPosition(-2);
        column.setWidth(100);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        SBC_AllTrackersView.AllTrackersViewEntry tr = (SBC_AllTrackersView.AllTrackersViewEntry)cell.getDataSource();
        String prefs = null;
        if (tr != null) {
            try {
                TorrentUtils.DNSTXTEntry entry = TorrentUtils.getDNSTXTEntry(new URL(tr.getTrackerName()));
                if (entry.hasRecords()) {
                    prefs = entry.getString();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (prefs == null) {
            prefs = "";
        }
        if (!cell.setSortValue((Comparable)((Object)prefs)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(prefs);
    }
}

