/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.dlhistory;

import com.biglybt.core.history.DownloadHistory;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import java.math.BigInteger;

public class ColumnDLHistoryHash
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "hash";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnDLHistoryHash(TableColumn column) {
        column.setWidth(200);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        BigInteger sort;
        DownloadHistory dl = (DownloadHistory)cell.getDataSource();
        byte[] hash = null;
        if (dl != null) {
            hash = dl.getTorrentHash();
        }
        BigInteger bigInteger = sort = hash == null ? new BigInteger(-1, new byte[0]) : new BigInteger(1, hash);
        if (!cell.setSortValue(sort) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        String str = hash == null ? "" : ByteFormatter.encodeString(hash);
        cell.setText(str);
    }
}

