/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.peer;

import com.biglybt.pif.download.Download;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.plugin.net.buddy.BuddyPlugin;
import com.biglybt.plugin.net.buddy.BuddyPluginUtils;
import com.biglybt.ui.swt.columns.ColumnCheckBox;

public class ColumnPeerBoost
extends ColumnCheckBox {
    public static String COLUMN_ID = "boost";
    private static volatile BuddyPlugin buddy_plugin;

    public ColumnPeerBoost(TableColumn column) {
        super(column);
    }

    @Override
    protected Boolean getCheckBoxState(Object datasource) {
        BuddyPlugin bp = ColumnPeerBoost.getBuddyPlugin();
        Peer peer = (Peer)datasource;
        if (peer != null && bp != null) {
            if (bp.isFullBuddy(peer)) {
                return true;
            }
            try {
                Download download = peer.getManager().getDownload();
                if (download != null) {
                    return bp.isPartialBuddy(download, peer);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected boolean isReadOnly(Object datasource) {
        BuddyPlugin bp = ColumnPeerBoost.getBuddyPlugin();
        Peer peer = (Peer)datasource;
        if (peer != null) {
            if (peer.isMyPeer()) {
                return true;
            }
            if (bp != null) {
                if (peer.getState() == 30) {
                    return bp.isFullBuddy(peer);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected void setCheckBoxState(Object datasource, boolean set) {
        BuddyPlugin bp = ColumnPeerBoost.getBuddyPlugin();
        Peer peer = (Peer)datasource;
        if (peer != null && bp != null) {
            try {
                Download download = peer.getManager().getDownload();
                if (download != null) {
                    bp.setPartialBuddy(download, peer, set, true);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static BuddyPlugin getBuddyPlugin() {
        if (buddy_plugin == null) {
            buddy_plugin = BuddyPluginUtils.getPlugin();
        }
        return buddy_plugin;
    }
}

