/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.search;

import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.ui.swt.search.SBC_SearchResult;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnSearchResultSite
implements TableCellSWTPaintListener,
TableCellAddedListener,
TableCellRefreshListener {
    public static final String COLUMN_ID = "site";
    private static final int WIDTH = 38;

    public ColumnSearchResultSite(TableColumn column) {
        column.initialize(3, -2, 38);
        column.addListeners(this);
        column.setRefreshInterval(-3);
        column.setType(2);
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        SBC_SearchResult entry = (SBC_SearchResult)cell.getDataSource();
        Rectangle cellBounds = cell.getBounds();
        entry.getIcon(img -> {
            if (img != null && !img.isDisposed()) {
                gc.fillRectangle(cellBounds);
                Rectangle imgBounds = img.getBounds();
                if (rectangle.width < imgBounds.width || rectangle.height < imgBounds.height) {
                    float dx = (float)rectangle.width / (float)imgBounds.width;
                    float dy = (float)rectangle.height / (float)imgBounds.height;
                    float d = Math.min(dx, dy);
                    int newWidth = (int)((float)imgBounds.width * d);
                    int newHeight = (int)((float)imgBounds.height * d);
                    gc.drawImage(img, 0, 0, imgBounds.width, imgBounds.height, rectangle.x + (rectangle.width - newWidth) / 2, rectangle.y + (rectangle.height - newHeight) / 2, newWidth, newHeight);
                } else {
                    gc.drawImage(img, rectangle.x + (rectangle.width - imgBounds.width) / 2, rectangle.y + (rectangle.height - imgBounds.height) / 2);
                }
            }
        });
    }

    @Override
    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    @Override
    public void refresh(TableCell cell) {
        SBC_SearchResult entry = (SBC_SearchResult)cell.getDataSource();
        if (entry != null) {
            long sortVal = entry.getEngine().getId();
            if (!cell.setSortValue(sortVal) && cell.isValid()) {
                return;
            }
            String name = entry.getEngine().getName();
            entry.getIcon(img -> {
                cell.setText(img == null || img.isDisposed() ? name : null);
                String tt = entry.getDescription();
                if (tt == null || tt.isEmpty()) {
                    tt = name;
                }
                cell.setToolTip(tt);
            });
        }
    }
}

