/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.subscriptions;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionDownloadListener;
import com.biglybt.core.subs.SubscriptionException;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseMoveListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.skin.SWTSkinFactory;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import com.biglybt.util.StringCompareUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ColumnSubscriptionActions
extends CoreTableColumnSWT
implements TableCellSWTPaintListener,
TableCellRefreshListener,
TableCellMouseMoveListener,
TableCellAddedListener {
    public static final String COLUMN_ID = "actions";
    private static final Object UPDATING_KEY = new Object();
    private Color colorLinkNormal;
    private Color colorLinkHover;
    private static Font font = null;
    boolean bMouseDowned = false;

    public ColumnSubscriptionActions(String sTableID) {
        super(COLUMN_ID, -2, 100, sTableID);
        this.setRefreshInterval(-3);
        this.setAlignment(1);
        this.addListeners(this);
        this.setType(2);
        this.setUseCoreDataSource(true);
        SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
        this.colorLinkNormal = skinProperties.getColor("color.links.normal");
        this.colorLinkHover = skinProperties.getColor("color.links.hover");
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        TableRow row = cell.getTableRow();
        if (row == null) {
            return;
        }
        String text = (String)row.getData("text");
        if (text != null && text.length() > 0) {
            if (font == null) {
                FontData[] fontData = gc.getFont().getFontData();
                fontData[0].setStyle(1);
                font = new Font(gc.getDevice(), fontData);
            }
            gc.setFont(font);
            Rectangle bounds = this.getDrawBounds(cell);
            GCStringPrinter sp = new GCStringPrinter(gc, text, bounds, true, true, 0x1000040);
            sp.calculateMetrics();
            if (sp.hasHitUrl()) {
                GCStringPrinter.URLInfo[] hitUrlInfo = sp.getHitUrlInfo();
                int i = 0;
                while (i < hitUrlInfo.length) {
                    GCStringPrinter.URLInfo info = hitUrlInfo[i];
                    info.urlUnderline = cell.getTableRow() == null || cell.getTableRow().isSelected();
                    info.urlColor = info.urlUnderline ? null : this.colorLinkNormal;
                    ++i;
                }
                int[] mouseOfs = cell.getMouseOffset();
                if (mouseOfs != null) {
                    Rectangle realBounds = cell.getBounds();
                    GCStringPrinter.URLInfo hitUrl = sp.getHitUrl(mouseOfs[0] + realBounds.x, mouseOfs[1] + realBounds.y);
                    if (hitUrl != null) {
                        hitUrl.urlColor = this.colorLinkHover;
                    }
                }
            }
            sp.printString();
            Point p = sp.getCalculatedPreferredSize();
            int pref = p.x + 10;
            TableColumn tableColumn = cell.getTableColumn();
            if (tableColumn != null && tableColumn.getPreferredWidth() < pref) {
                tableColumn.setPreferredWidth(pref);
            }
        }
    }

    @Override
    public void cellAdded(TableCell cell) {
        cell.setMarginHeight(0);
    }

    @Override
    public void refresh(TableCell cell) {
        boolean canUpdate;
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub == null) {
            return;
        }
        boolean canView = !sub.isSearchTemplate();
        int sort = (canView ? 2 : 0) + ((canUpdate = !sub.isSearchTemplate() && !sub.isSubscriptionTemplate()) ? 1 : 0);
        if (!cell.setSortValue(sort) && cell.isValid()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (canView) {
            sb.append("<A HREF=\"view\">" + MessageText.getString("label.view") + "</A>");
        }
        if (canUpdate) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (sub.getUserData(UPDATING_KEY) == null) {
                sb.append("<A HREF=\"update\">" + MessageText.getString("UpdateWindow.ok") + "</A>");
            } else {
                sb.append(MessageText.getString("UpdateWindow.ok"));
            }
        }
        cell.getTableRow().setData("text", sb.toString());
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        String oldTooltip;
        Object o;
        GCStringPrinter sp;
        Rectangle bounds;
        boolean invalidateAndRefresh;
        String tooltip;
        Subscription sub;
        TableCellSWT cell;
        block25: {
            cell = (TableCellSWT)event2.cell;
            sub = (Subscription)cell.getDataSource();
            tooltip = null;
            invalidateAndRefresh = false;
            bounds = cell.getBounds();
            String text = (String)event2.cell.getTableRow().getData("text");
            if (text == null) {
                return;
            }
            sp = null;
            GC gc = new GC((Drawable)Display.getDefault());
            try {
                try {
                    if (font != null) {
                        gc.setFont(font);
                    }
                    Rectangle drawBounds = this.getDrawBounds(cell);
                    sp = new GCStringPrinter(gc, text, drawBounds, true, true, 0x1000040);
                    sp.calculateMetrics();
                }
                catch (Exception e) {
                    Debug.out(e);
                    gc.dispose();
                    break block25;
                }
            }
            catch (Throwable throwable) {
                gc.dispose();
                throw throwable;
            }
            gc.dispose();
        }
        if (sp != null) {
            int newCursor;
            GCStringPrinter.URLInfo hitUrl = sp.getHitUrl(event2.x + bounds.x, event2.y + bounds.y);
            if (hitUrl != null) {
                if (event2.eventType == 1 && event2.button == 1) {
                    if (hitUrl.url.equals("view")) {
                        String key = "Subscription_" + ByteFormatter.encodeString(sub.getPublicKey());
                        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                        if (mdi != null) {
                            mdi.showEntryByID(key);
                        }
                    } else if (hitUrl.url.equals("update")) {
                        if (sub.getUserData(UPDATING_KEY) != null) {
                            return;
                        }
                        try {
                            sub.setUserData(UPDATING_KEY, true);
                            cell.getTableRowSWT().invalidate(true);
                            sub.getManager().getScheduler().download(sub, true, new SubscriptionDownloadListener(){

                                @Override
                                public void complete(Subscription subs) {
                                    this.done();
                                }

                                @Override
                                public void failed(Subscription subs, SubscriptionException error) {
                                    this.done();
                                }

                                private void done() {
                                    sub.setUserData(UPDATING_KEY, null);
                                    cell.getTableRowSWT().invalidate(true);
                                }
                            });
                        }
                        catch (Throwable e) {
                            sub.setUserData(UPDATING_KEY, null);
                            cell.getTableRowSWT().invalidate(true);
                            Debug.out(e);
                        }
                    }
                } else if (hitUrl.url.equals("view")) {
                    tooltip = "";
                } else if (hitUrl.url.equals("update")) {
                    tooltip = "";
                }
                newCursor = 21;
            } else {
                newCursor = 0;
            }
            int oldCursor = ((TableCellSWT)event2.cell).getCursorID();
            if (oldCursor != newCursor) {
                invalidateAndRefresh = true;
                ((TableCellSWT)event2.cell).setCursorID(newCursor);
            }
        }
        if (((o = event2.cell.getToolTip()) == null || o instanceof String) && !StringCompareUtils.equals(oldTooltip = (String)o, tooltip)) {
            invalidateAndRefresh = true;
            event2.cell.setToolTip(tooltip);
        }
        if (invalidateAndRefresh) {
            event2.cell.invalidate();
            ((TableCellSWT)event2.cell).redraw();
        }
    }

    private Rectangle getDrawBounds(TableCellSWT cell) {
        Rectangle bounds = cell.getBounds();
        bounds.height -= 12;
        bounds.y += 6;
        bounds.x += 4;
        bounds.width -= 4;
        return bounds;
    }
}

