/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.subscriptions;

import com.biglybt.core.metasearch.Engine;
import com.biglybt.core.metasearch.impl.web.WebEngine;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class ColumnSubscriptionURL
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static String COLUMN_ID = "url";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)1);
    }

    public ColumnSubscriptionURL(String sTableID) {
        super(COLUMN_ID, -1, 350, sTableID);
        this.setRefreshInterval(-2);
        this.setAlignment(1);
    }

    @Override
    public void refresh(TableCell cell) {
        String str = "";
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub != null && !sub.isRemoved()) {
            if (sub.isSearchTemplate() || sub.isSubscriptionTemplate()) {
                str = "";
            } else {
                try {
                    Engine engine = sub.getEngine();
                    if (engine instanceof WebEngine) {
                        str = ((WebEngine)engine).getSearchUrl();
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        if (!cell.setSortValue((Comparable)((Object)str)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(str);
    }
}

