/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.tag;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagGroup;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.tag.Taggable;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnTagGroupIcons
implements TableCellRefreshListener,
TableCellSWTPaintListener,
TableColumnExtraInfoListener {
    private static Object KEY_TAG_MUT = new Object();
    private static Object KEY_IMAGE_FILES = new Object();
    private static TagManager tag_manager = TagManagerFactory.getTagManager();
    public static final Class DATASOURCE_TYPE = Download.class;
    private static int[] interesting_tts = new int[]{3, 1};
    private TagGroup tag_group;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)0);
    }

    public ColumnTagGroupIcons(TableColumn column, TagGroup tg) {
        column.initialize(1, -1, 70);
        column.addListeners(this);
        column.setRefreshInterval(-2);
        column.setType(3);
        column.setIconReference("image.tag.column", false);
        this.tag_group = tg;
    }

    @Override
    public void refresh(TableCell cell) {
        String sTags = null;
        Download dm = (Download)cell.getDataSource();
        if (dm != null) {
            DownloadManager core_dm = PluginCoreUtils.unwrap(dm);
            long mut = core_dm.getTagMutationCount();
            Long data = (Long)cell.getData(KEY_TAG_MUT);
            if (data != null && data == mut) {
                return;
            }
            cell.setData(KEY_TAG_MUT, mut);
            List<Tag> tags = tag_manager.getTagsForTaggable(interesting_tts, (Taggable)core_dm);
            if (tags.size() > 0) {
                for (Tag t : tags) {
                    String file;
                    if (t.getGroupContainer() != this.tag_group || (file = t.getImageFile()) == null) continue;
                    String str = t.getTagName(true);
                    sTags = sTags == null ? String.valueOf(this.tag_group.getName()) + ": " + str : String.valueOf(sTags) + ", " + str;
                }
            }
        }
        cell.setSortValue((Comparable)((Object)(sTags == null ? " " : sTags)));
        cell.setToolTip(sTags == null ? "" : sTags);
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        String[] files;
        String[] file;
        Download dm = (Download)cell.getDataSource();
        if (dm != null) {
            DownloadManager core_dm = PluginCoreUtils.unwrap(dm);
            long mut = core_dm.getTagMutationCount();
            Object[] data = (Object[])cell.getData(KEY_IMAGE_FILES);
            if (data == null || (Long)data[0] != mut) {
                List<Tag> tags = tag_manager.getTagsForTaggable(interesting_tts, (Taggable)core_dm);
                tags = TagUtils.sortTagIcons(tags);
                ArrayList<String[]> f = new ArrayList<String[]>(tags.size());
                for (Tag tag : tags) {
                    if (tag.getGroupContainer() != this.tag_group || (file = tag.getImageFile()) == null) continue;
                    f.add(file);
                }
                files = f.toArray(new String[f.size()]);
                cell.setData(KEY_IMAGE_FILES, new Object[]{mut, files});
            } else {
                files = (String[])data[1];
            }
        } else {
            files = new String[]{};
        }
        int num_files = files.length;
        if (num_files > 0) {
            TableColumn tableColumn;
            Rectangle bounds = cell.getBounds();
            ++bounds.x;
            ++bounds.y;
            --bounds.width;
            bounds.height -= 2;
            int w = bounds.width / num_files;
            final ArrayList images = new ArrayList();
            final ArrayList keys = new ArrayList();
            file = files;
            int n = files.length;
            int tag = 0;
            while (tag < n) {
                String file2 = file[tag];
                try {
                    ImageLoader.getInstance().getFileImage(new File(file2), new Point(w - 1, bounds.height), new ImageLoader.ImageDownloaderListener(){

                        @Override
                        public void imageDownloaded(Image image, String key, boolean returnedImmediately) {
                            if (image != null && returnedImmediately) {
                                images.add(image);
                                keys.add(key);
                            }
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++tag;
            }
            int prefWidth = 0;
            if (images.size() > 0) {
                int width_per_image = bounds.width / images.size();
                int i = 0;
                while (i < images.size()) {
                    Image image = (Image)images.get(i);
                    int iw = image.getBounds().width;
                    prefWidth += iw;
                    gc.drawImage(image, bounds.x + (width_per_image - iw) / 2, bounds.y);
                    bounds.x += width_per_image;
                    ImageLoader.getInstance().releaseImage((String)keys.get(i));
                    ++i;
                }
            }
            if ((tableColumn = cell.getTableColumn()) != null && tableColumn.getPreferredWidth() < prefWidth) {
                prefWidth = Math.max(16, prefWidth);
                prefWidth = Math.min(256, prefWidth);
                tableColumn.setPreferredWidth(prefWidth);
            }
        }
    }
}

