/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.tag;

import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagDownload;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;

public class ColumnTagSortAutoApply
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "tag_sort_auto";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time"});
        info.setProficiency((byte)1);
    }

    public ColumnTagSortAutoApply(TableColumn column) {
        column.setWidth(60);
        column.setRefreshInterval(-2);
        column.setAlignment(2);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        Tag tag = (Tag)cell.getDataSource();
        if (tag instanceof TagDownload) {
            TagDownload td = (TagDownload)tag;
            int i = td.getAutoApplySortInterval();
            if (!cell.setSortValue(i) && cell.isValid()) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            cell.setText(i == 0 ? "" : String.valueOf(i));
        }
    }
}

