/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.torrent;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellClipboardListener;
import com.biglybt.pif.ui.tables.TableCellDisposeListener;
import com.biglybt.pif.ui.tables.TableCellLightRefreshListener;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseMoveListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.ui.common.table.TableCellCore;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.swt.ImageRepository;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.debug.ObfuscateCellText;
import com.biglybt.ui.swt.debug.UIDebugGenerator;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.utils.TorrentUIUtilsV3;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import java.io.File;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnThumbAndName
extends CoreTableColumnSWT
implements TableCellLightRefreshListener,
ObfuscateCellText,
TableCellDisposeListener,
TableCellSWTPaintListener,
TableCellClipboardListener,
TableCellMouseMoveListener {
    public static final Class<?>[] DATASOURCE_TYPES = new Class[]{Download.class, DiskManagerFileInfo.class};
    public static final String COLUMN_ID = "name";
    private static final String ID_EXPANDOHITAREASHOW = "expandoHitAreaShow";
    private static final Object KEY_PATH_ICON = new Object();
    private static final boolean NEVER_SHOW_TWISTY = !COConfigurationManager.getBooleanParameter("Table.useTree");
    private final ParameterListener configShowProgramIconListener;
    private boolean showIcon;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential", "content"});
        info.setProficiency((byte)0);
    }

    public ColumnThumbAndName(String sTableID) {
        super(COLUMN_ID, 250, sTableID);
        this.setAlignment(1);
        this.addDataSourceTypes(DATASOURCE_TYPES);
        this.setObfuscation(true);
        this.setRefreshInterval(-2);
        this.initializeAsGraphic(250);
        this.setMinWidth(100);
        TableContextMenuItem menuItem = this.addContextMenuItem("MyTorrentsView.menu.rename.displayed");
        menuItem.setHeaderCategory("Control");
        menuItem.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                Object[] o;
                if (target == null) {
                    return;
                }
                Object[] objectArray = o = (Object[])target;
                int n = o.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof TableRowCore) {
                        TableRowCore row = (TableRowCore)object;
                        object = row.getDataSource(true);
                    }
                    if (object instanceof DownloadManager) {
                        final DownloadManager dm = (DownloadManager)object;
                        String msg_key_prefix = "MyTorrentsView.menu.rename.displayed.enter.";
                        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow(String.valueOf(msg_key_prefix) + "title", String.valueOf(msg_key_prefix) + "message");
                        entryWindow.setPreenteredText(dm.getDisplayName(), false);
                        entryWindow.maintainWhitespace(true);
                        entryWindow.prompt(new UIInputReceiverListener(){

                            @Override
                            public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                                if (!entryWindow.hasSubmittedInput()) {
                                    return;
                                }
                                String value = entryWindow.getSubmittedInput();
                                if (value != null && value.length() > 0) {
                                    dm.getDownloadState().setDisplayName(value);
                                }
                            }
                        });
                    }
                    ++n2;
                }
            }
        });
        TableContextMenuItem menuShowIcon = this.addContextMenuItem("ConfigView.section.style.showProgramIcon", 1);
        menuShowIcon.setStyle(2);
        menuShowIcon.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(ColumnThumbAndName.this.showIcon);
            }
        });
        final String CFG_SHOWPROGRAMICON = "NameColumn.showProgramIcon." + this.getTableID();
        menuShowIcon.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                COConfigurationManager.setParameter(CFG_SHOWPROGRAMICON, (Boolean)menu.getData());
            }
        });
        this.configShowProgramIconListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                ColumnThumbAndName.this.setShowIcon(COConfigurationManager.getBooleanParameter(CFG_SHOWPROGRAMICON, COConfigurationManager.getBooleanParameter("NameColumn.showProgramIcon")));
            }
        };
        COConfigurationManager.addWeakParameterListener(this.configShowProgramIconListener, true, CFG_SHOWPROGRAMICON);
    }

    @Override
    public void reset() {
        super.reset();
        COConfigurationManager.removeParameter("NameColumn.showProgramIcon." + this.getTableID());
    }

    @Override
    public void remove() {
        super.remove();
        String CFG_SHOWPROGRAMICON = "NameColumn.showProgramIcon." + this.getTableID();
        COConfigurationManager.removeWeakParameterListener(this.configShowProgramIconListener, CFG_SHOWPROGRAMICON);
    }

    @Override
    public void refresh(TableCell cell) {
        this.refresh(cell, false);
    }

    @Override
    public void refresh(TableCell cell, boolean sortOnlyRefresh) {
        String name = null;
        Object ds = cell.getDataSource();
        if (ds instanceof com.biglybt.core.disk.DiskManagerFileInfo) {
            com.biglybt.core.disk.DiskManagerFileInfo fileInfo2 = (com.biglybt.core.disk.DiskManagerFileInfo)ds;
            cell.setSortValue((Comparable)((Object)this.getDisplayName(fileInfo2)));
            return;
        }
        DownloadManager dm = (DownloadManager)ds;
        if (dm != null) {
            name = dm.getDisplayName();
        }
        if (name == null) {
            name = "";
        }
        cell.setSortValue((Comparable)((Object)name));
    }

    @Override
    public void cellPaint(GC gc, final TableCellSWT cell) {
        int originalBoundxsX;
        Object ds = cell.getDataSource();
        if (ds instanceof com.biglybt.core.disk.DiskManagerFileInfo) {
            this.cellPaintFileInfo(gc, cell, (com.biglybt.core.disk.DiskManagerFileInfo)ds);
            return;
        }
        Rectangle cellBounds = cell.getBounds();
        int textX = originalBoundxsX = cellBounds.x;
        TableRowCore rowCore = cell.getTableRowCore();
        if (rowCore != null) {
            boolean show_twisty;
            int numSubItems = rowCore.getSubItemCount();
            int paddingX = 3;
            int width = 7;
            if (NEVER_SHOW_TWISTY) {
                show_twisty = false;
            } else if (numSubItems > 1) {
                show_twisty = true;
            } else {
                Boolean show = (Boolean)rowCore.getData(ID_EXPANDOHITAREASHOW);
                if (show == null) {
                    DownloadManager dm = (DownloadManager)ds;
                    TOTorrent torrent = dm.getTorrent();
                    show_twisty = torrent != null && !dm.getTorrent().isSimpleTorrent();
                    rowCore.setData(ID_EXPANDOHITAREASHOW, show_twisty);
                } else {
                    show_twisty = show;
                }
            }
            if (show_twisty) {
                int middleY = cellBounds.y + cellBounds.height / 2 - 1;
                int startX = cellBounds.x + paddingX;
                int halfHeight = 2;
                Color bg = gc.getBackground();
                gc.setBackground(gc.getForeground());
                gc.setAntialias(1);
                gc.setAdvanced(true);
                if (rowCore.isExpanded()) {
                    gc.fillPolygon(new int[]{startX, middleY - halfHeight, startX + width, middleY - halfHeight, startX + width / 2, middleY + halfHeight * 2 + 1});
                } else {
                    gc.fillPolygon(new int[]{startX, middleY - halfHeight, startX + width, middleY + halfHeight, startX, middleY + halfHeight * 2 + 1});
                }
                gc.setBackground(bg);
                Rectangle hitArea = new Rectangle(0, 0, width + paddingX * 2, cellBounds.height);
                rowCore.setData("expandoHitArea", hitArea);
                rowCore.setData("expandoHitColumn", this.getName());
            }
            if (!NEVER_SHOW_TWISTY) {
                cellBounds.x += paddingX * 2 + width;
                cellBounds.width -= paddingX * 2 + width;
            }
        }
        if (!this.showIcon) {
            cellBounds.x += 2;
            cellBounds.width -= 4;
            this.cellPaintName(cell, gc, cellBounds, cellBounds.x, originalBoundxsX);
            return;
        }
        Image[] imgThumbnail = TorrentUIUtilsV3.getContentImage(ds, cellBounds.height >= 20, new TorrentUIUtilsV3.ContentImageLoadedListener(){

            @Override
            public void contentImageLoaded(Image image, boolean wasReturned) {
                if (!wasReturned) {
                    cell.invalidate();
                }
            }
        });
        if (imgThumbnail != null && ImageLoader.isRealImage(imgThumbnail[0])) {
            try {
                block39: {
                    int dstWidth;
                    int dstHeight;
                    if (cellBounds.height > 30) {
                        ++cellBounds.y;
                        cellBounds.height -= 3;
                    }
                    Rectangle imgBounds = imgThumbnail[0].getBounds();
                    if (imgBounds.height > cellBounds.height) {
                        dstHeight = cellBounds.height;
                        dstWidth = imgBounds.width * cellBounds.height / imgBounds.height;
                    } else if (imgBounds.width > cellBounds.width) {
                        dstWidth = cellBounds.width - 4;
                        dstHeight = imgBounds.height * cellBounds.width / imgBounds.width;
                    } else {
                        dstWidth = imgBounds.width;
                        dstHeight = imgBounds.height;
                    }
                    if (cellBounds.height <= 18) {
                        dstWidth = Math.min(dstWidth, cellBounds.height);
                        dstHeight = Math.min(dstHeight, cellBounds.height);
                        if (imgBounds.width > 16) {
                            ++cellBounds.y;
                            dstHeight -= 2;
                        }
                    }
                    try {
                        gc.setAdvanced(true);
                        gc.setInterpolation(2);
                    }
                    catch (Exception middleY) {
                        // empty catch block
                    }
                    int x = cellBounds.x;
                    textX = x + dstWidth + 3;
                    int imgPad = 0;
                    if (cellBounds.width - dstWidth - imgPad * 2 < 100 && dstHeight > 18) {
                        dstWidth = Math.min(32, dstHeight);
                        x = cellBounds.x + (32 - dstWidth + 1) / 2;
                        dstHeight = imgBounds.height * dstWidth / imgBounds.width;
                        textX = cellBounds.x + dstWidth + 3;
                    }
                    int y = cellBounds.y + (cellBounds.height - dstHeight + 1) / 2;
                    if (dstWidth > 0 && dstHeight > 0 && !imgBounds.isEmpty()) {
                        Rectangle lastClipping = gc.getClipping();
                        try {
                            try {
                                boolean hack_adv;
                                Utils.setClipping(gc, cellBounds);
                                boolean bl = hack_adv = Constants.isWindows8OrHigher && gc.getAdvanced();
                                if (hack_adv) {
                                    gc.setAdvanced(false);
                                }
                                int i = 0;
                                while (i < imgThumbnail.length) {
                                    Image image = imgThumbnail[i];
                                    if (image != null && !image.isDisposed()) {
                                        int h;
                                        int w;
                                        Rectangle srcBounds = image.getBounds();
                                        if (i == 0) {
                                            w = dstWidth;
                                            h = dstHeight;
                                            if (imgThumbnail.length > 1) {
                                                w = w * 9 / 10;
                                                h = h * 9 / 10;
                                            }
                                            Utils.drawResizedImage(gc, image, srcBounds.x, srcBounds.y, srcBounds.width, srcBounds.height, x, y, w, h);
                                        } else {
                                            w = dstWidth * 3 / 8;
                                            h = dstHeight * 3 / 8;
                                            Utils.drawResizedImage(gc, image, srcBounds.x, srcBounds.y, srcBounds.width, srcBounds.height, x + dstWidth - w, y + dstHeight - h, w, h);
                                        }
                                    }
                                    ++i;
                                }
                                if (hack_adv) {
                                    gc.setAdvanced(true);
                                }
                            }
                            catch (Exception e) {
                                Debug.out(e);
                                Utils.setClipping(gc, lastClipping);
                                break block39;
                            }
                        }
                        catch (Throwable throwable) {
                            Utils.setClipping(gc, lastClipping);
                            throw throwable;
                        }
                        Utils.setClipping(gc, lastClipping);
                    }
                }
                TorrentUIUtilsV3.releaseContentImage(ds);
            }
            catch (Throwable t) {
                Debug.out(t);
            }
        }
        this.cellPaintName(cell, gc, cell.getBounds(), textX, originalBoundxsX);
    }

    private void cellPaintFileInfo(GC gc, TableCellSWT cell, com.biglybt.core.disk.DiskManagerFileInfo fileInfo2) {
        int textX;
        int originalBoundxsX;
        Rectangle cellBounds;
        block28: {
            cellBounds = cell.getBounds();
            originalBoundxsX = cellBounds.x;
            int padding = 5 + Math.min(32, cellBounds.height);
            cellBounds.x += padding;
            cellBounds.width -= padding;
            textX = cellBounds.x;
            Image[] imgThumbnail = null;
            if (this.showIcon && fileInfo2 != null) {
                Object[] temp;
                File file = fileInfo2.getFile(true);
                Object piCache = cell.getData(KEY_PATH_ICON);
                if (piCache != null && FileUtil.areFilePathsIdentical((File)(temp = (Object[])piCache)[0], file)) {
                    imgThumbnail = (Image[])temp[1];
                }
                if (imgThumbnail == null) {
                    imgThumbnail = new Image[]{ImageRepository.getPathIcon(file.getPath(), cellBounds.height >= 20, false)};
                    cell.setData(KEY_PATH_ICON, new Object[]{file, imgThumbnail});
                }
            }
            if (imgThumbnail != null && ImageLoader.isRealImage((Image)imgThumbnail[0])) {
                try {
                    int dstWidth;
                    int dstHeight;
                    if (cellBounds.height > 30) {
                        ++cellBounds.y;
                        cellBounds.height -= 3;
                    }
                    Rectangle imgBounds = imgThumbnail[0].getBounds();
                    if (imgBounds.height > cellBounds.height) {
                        dstHeight = cellBounds.height;
                        dstWidth = imgBounds.width * cellBounds.height / imgBounds.height;
                    } else if (imgBounds.width > cellBounds.width) {
                        dstWidth = cellBounds.width - 4;
                        dstHeight = imgBounds.height * cellBounds.width / imgBounds.width;
                    } else {
                        dstWidth = imgBounds.width;
                        dstHeight = imgBounds.height;
                    }
                    if (cellBounds.height <= 18) {
                        dstWidth = Math.min(dstWidth, cellBounds.height);
                        dstHeight = Math.min(dstHeight, cellBounds.height);
                        if (imgBounds.width > 16) {
                            ++cellBounds.y;
                            dstHeight -= 2;
                        }
                    }
                    try {
                        gc.setAdvanced(true);
                        gc.setInterpolation(2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int x = cellBounds.x;
                    textX = x + dstWidth + 3;
                    int minWidth = dstHeight;
                    int imgPad = 0;
                    if (cellBounds.width - dstWidth - imgPad * 2 < 100 && dstHeight > 18) {
                        dstWidth = Math.min(32, dstHeight);
                        x = cellBounds.x + (32 - dstWidth + 1) / 2;
                        dstHeight = imgBounds.height * dstWidth / imgBounds.width;
                        textX = cellBounds.x + dstWidth + 3;
                    }
                    int y = cellBounds.y + (cellBounds.height - dstHeight + 1) / 2;
                    if (dstWidth <= 0 || dstHeight <= 0 || imgBounds.isEmpty()) break block28;
                    Rectangle lastClipping = gc.getClipping();
                    try {
                        try {
                            boolean hack_adv;
                            Utils.setClipping(gc, cellBounds);
                            boolean bl = hack_adv = Constants.isWindows8OrHigher && gc.getAdvanced();
                            if (hack_adv) {
                                gc.setAdvanced(false);
                            }
                            int i = 0;
                            while (i < imgThumbnail.length) {
                                Image image = imgThumbnail[i];
                                if (image != null && !image.isDisposed()) {
                                    int h;
                                    int w;
                                    Rectangle srcBounds = image.getBounds();
                                    if (i == 0) {
                                        w = dstWidth;
                                        h = dstHeight;
                                        if (imgThumbnail.length > 1) {
                                            w = w * 9 / 10;
                                            h = h * 9 / 10;
                                        }
                                        Utils.drawResizedImage(gc, image, srcBounds.x, srcBounds.y, srcBounds.width, srcBounds.height, x, y, w, h);
                                    } else {
                                        w = dstWidth * 3 / 8;
                                        h = dstHeight * 3 / 8;
                                        Utils.drawResizedImage(gc, image, srcBounds.x, srcBounds.y, srcBounds.width, srcBounds.height, x + dstWidth - w, y + dstHeight - h, w, h);
                                    }
                                }
                                ++i;
                            }
                            if (hack_adv) {
                                gc.setAdvanced(true);
                            }
                        }
                        catch (Exception e) {
                            Debug.out(e);
                            Utils.setClipping(gc, lastClipping);
                            break block28;
                        }
                    }
                    catch (Throwable throwable) {
                        Utils.setClipping(gc, lastClipping);
                        throw throwable;
                    }
                    Utils.setClipping(gc, lastClipping);
                }
                catch (Throwable t) {
                    Debug.out(t);
                }
            }
        }
        String s = this.getDisplayName(fileInfo2);
        cellBounds.width -= textX - cellBounds.x;
        cellBounds.x = textX;
        GCStringPrinter sp = new GCStringPrinter(gc, s, cellBounds, true, false, 16448);
        boolean over = sp.printString();
        Point p = sp.getCalculatedPreferredSize();
        int pref = textX - originalBoundxsX + p.x + 10;
        TableColumn tableColumn = cell.getTableColumn();
        if (tableColumn != null && tableColumn.getPreferredWidth() < pref) {
            tableColumn.setPreferredWidth(pref);
        }
        cell.setToolTip(over ? null : s);
    }

    private String getDisplayName(com.biglybt.core.disk.DiskManagerFileInfo fileInfo2) {
        String prefix = String.valueOf(fileInfo2.getDownloadManager().getSaveLocation().toString()) + File.separator;
        String s = fileInfo2.getFile(true).toString();
        if (s.startsWith(prefix)) {
            s = s.substring(prefix.length());
        }
        return s;
    }

    private void cellPaintName(TableCell cell, GC gc, Rectangle cellBounds, int textX, int originalBoundxsX) {
        String tooltip;
        String name = null;
        Object ds = cell.getDataSource();
        if (ds instanceof com.biglybt.core.disk.DiskManagerFileInfo) {
            return;
        }
        DownloadManager dm = (DownloadManager)ds;
        if (dm != null) {
            name = dm.getDisplayName();
        }
        if (name == null) {
            name = "";
        }
        GCStringPrinter sp = new GCStringPrinter(gc, name, new Rectangle(textX, cellBounds.y, cellBounds.x + cellBounds.width - textX, cellBounds.height), true, true, cell.getMaxLines() == 1 ? 16384 : 16448);
        boolean fit = sp.printString();
        Point p = sp.getCalculatedPreferredSize();
        int pref = textX - originalBoundxsX + p.x + 10;
        TableColumn tableColumn = cell.getTableColumn();
        if (tableColumn != null && tableColumn.getPreferredWidth() < pref) {
            tableColumn.setPreferredWidth(pref);
        }
        String string = tooltip = fit ? "" : name;
        if (dm != null) {
            try {
                String desc = PlatformTorrentUtils.getContentDescription(dm.getTorrent());
                if (desc != null && desc.length() > 0) {
                    tooltip = String.valueOf(tooltip) + (tooltip.length() == 0 ? "" : "\r\n") + desc;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        cell.setToolTip(tooltip.length() == 0 ? null : tooltip);
    }

    @Override
    public String getObfuscatedText(TableCell cell) {
        Object ds = cell.getDataSource();
        if (ds instanceof com.biglybt.core.disk.DiskManagerFileInfo) {
            return UIDebugGenerator.obfuscateFileName((com.biglybt.core.disk.DiskManagerFileInfo)ds);
        }
        return UIDebugGenerator.obfuscateDownloadName(ds);
    }

    @Override
    public void dispose(TableCell cell) {
    }

    public void setShowIcon(boolean showIcon) {
        this.showIcon = showIcon;
        this.invalidateCells();
    }

    public boolean isShowIcon() {
        return this.showIcon;
    }

    @Override
    public String getClipboardText(TableCell cell) {
        String name = null;
        Object ds = cell.getDataSource();
        if (ds instanceof com.biglybt.core.disk.DiskManagerFileInfo) {
            com.biglybt.core.disk.DiskManagerFileInfo fileInfo2 = (com.biglybt.core.disk.DiskManagerFileInfo)ds;
            return fileInfo2.getFile(true).getName();
        }
        DownloadManager dm = (DownloadManager)ds;
        if (dm != null) {
            name = dm.getDisplayName();
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        if (event2.eventType == 3 || event2.eventType == 0) {
            TableRow row = event2.cell.getTableRow();
            if (row == null) {
                return;
            }
            Object data = row.getData("expandoHitArea");
            if (data instanceof Rectangle) {
                Rectangle hitArea = (Rectangle)data;
                boolean inExpando = hitArea.contains(event2.x, event2.y);
                if (event2.eventType == 3) {
                    ((TableCellCore)event2.cell).setCursorID(inExpando ? 21 : 0);
                } else if (inExpando && row instanceof TableRowCore) {
                    TableRowCore rowCore;
                    rowCore.setExpanded(!(rowCore = (TableRowCore)row).isExpanded());
                }
            }
        }
    }
}

