/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.components;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Constants;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.utils.FontUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BubbleTextBox
implements PaintListener {
    public static final String REGEX_BUTTON_TEXT = ".\u2731";
    private static final int REGEX_BUTTON_PADDING = 4;
    private static final int BUTTON_NONE = 0;
    private static final int BUTTON_REGEX = 2;
    private static final int BUTTON_CLEAR = 1;
    private static Font FONT_REGEX_BUTTON;
    private static Color COLOR_FILTER_REGEX;
    private static Color COLOR_FILTER_NO_REGEX;
    private Font FONT_NO_REGEX;
    private Font FONT_REGEX;
    private Font FONT_REGEX_ERROR;
    private final Text textWidget;
    private final Composite cBubble;
    private static final int TEXTBOX_VPADDING;
    private final int INDENT_OVAL;
    private final int WIDTH_CLEAR;
    private final int WIDTH_PADDING;
    private String text = "";
    private boolean allowRegex;
    private boolean regexEnabled = false;
    private boolean regexIsError = false;
    private int mouseOverButton = 0;
    private String regexError = null;
    private String tooltip = null;
    List<BubbleTextBoxChangeListener> bubbleTextBoxChangeListeners = new ArrayList<BubbleTextBoxChangeListener>();
    private KeyListener keyListener;

    static {
        TEXTBOX_VPADDING = Utils.isGTK3 ? 1 : 3;
        COConfigurationManager.addWeakParameterListener(n -> {
            COLOR_FILTER_NO_REGEX = Utils.getConfigColor("table.filter.active.colour", Colors.fadedBlue);
            COLOR_FILTER_REGEX = Utils.getConfigColor("table.filter.regex.colour", Colors.fadedYellow);
        }, true, "table.filter.active.colour", "table.filter.regex.colour");
    }

    public BubbleTextBox(Composite parent, int style) {
        this.cBubble = new Composite(parent, 0x20000000);
        FormLayout layout = new FormLayout();
        this.cBubble.setLayout((Layout)layout);
        int textStyle = Constants.isOSX && Utils.isDarkAppearanceNative() ? (style | 0x800) & 0xFFFFFF7F : style & 0xFFFFF77F;
        this.textWidget = new Text(this.cBubble, textStyle){
            {
                Utils.setSkinnedControlType((Control)this, 1);
            }

            protected void checkSubclass() {
            }

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point point = super.computeSize(wHint, hHint, changed);
                if (Utils.isGTK3 || Constants.isOSX && Utils.isDarkAppearanceNative()) {
                    Rectangle area = this.getParent().getClientArea();
                    int diff = TEXTBOX_VPADDING * 2;
                    if (area.height > diff) {
                        point.y = area.height - diff;
                    }
                }
                return point;
            }
        };
        this.cBubble.addListener(11, e -> this.setupTextWidgetLayoutData());
        this.textWidget.setData("BubbleTextBox", (Object)this);
        Runnable runOnFontSizeChange = () -> {
            boolean existingFont;
            boolean bl = existingFont = FONT_REGEX_BUTTON != null;
            if (existingFont) {
                FontUtils.uncache(FONT_REGEX_BUTTON);
            }
            FONT_REGEX_BUTTON = FontUtils.cache(FontUtils.getFontWithStyle(this.textWidget.getFont(), 0, 1.0f));
            if (existingFont) {
                this.cBubble.redraw();
            }
        };
        runOnFontSizeChange.run();
        FontUtils.fontToWidgetHeight(this.textWidget, runOnFontSizeChange);
        this.textWidget.addDisposeListener(e -> {
            if (FONT_REGEX_BUTTON != null) {
                FontUtils.uncache(FONT_REGEX_BUTTON);
                FONT_REGEX_BUTTON = null;
            }
        });
        if (Utils.isGTK3) {
            Display display = this.textWidget.getDisplay();
            this.textWidget.setBackground(Colors.getSystemColor((Device)display, 25));
            this.textWidget.setForeground(Colors.getSystemColor((Device)display, 24));
        }
        this.INDENT_OVAL = 6;
        this.WIDTH_CLEAR = 7;
        this.WIDTH_PADDING = 6;
        this.setupTextWidgetLayoutData();
        this.cBubble.addPaintListener((PaintListener)this);
        this.cBubble.addListener(3, event2 -> {
            switch (this.mouseOverButton) {
                case 1: {
                    this.textWidget.setText("");
                    break;
                }
                case 2: {
                    this.setRegexEnabled(!this.regexEnabled);
                }
            }
        });
        this.cBubble.addListener(7, event2 -> {
            if (this.mouseOverButton != 0) {
                this.mouseOverButton = 0;
                this.cBubble.redraw();
            }
        });
        this.cBubble.addListener(5, event2 -> {
            int mouseNowOverButton = 0;
            Rectangle r = (Rectangle)event2.widget.getData("XArea");
            if (r != null && r.contains(event2.x, event2.y) && !this.text.isEmpty()) {
                mouseNowOverButton = 1;
            } else {
                r = (Rectangle)event2.widget.getData("RegexArea");
                if (r != null && r.contains(event2.x, event2.y)) {
                    mouseNowOverButton = 2;
                }
            }
            if (this.mouseOverButton != mouseNowOverButton) {
                this.mouseOverButton = mouseNowOverButton;
                this.cBubble.redraw();
            }
        });
        Listener listenerMouseHover = event2 -> {
            String tt = null;
            switch (this.mouseOverButton) {
                case 0: {
                    tt = this.regexIsError ? this.regexError : (this.text.isEmpty() ? this.tooltip : null);
                    break;
                }
                case 2: {
                    tt = this.regexIsError ? this.regexError : MessageText.getString("label.regexps");
                    break;
                }
                case 1: {
                    tt = MessageText.getString("MyTorrentsView.clearFilter.tooltip");
                }
            }
            this.cBubble.setToolTipText(tt);
            this.textWidget.setToolTipText(tt);
        };
        this.cBubble.addListener(32, listenerMouseHover);
        this.textWidget.addListener(32, listenerMouseHover);
        this.textWidget.addPaintListener(new PaintListener(){
            private Color existing_bg;

            public void paintControl(PaintEvent arg0) {
                Color current_bg = BubbleTextBox.this.textWidget.getBackground();
                if (!current_bg.equals((Object)this.existing_bg)) {
                    this.existing_bg = current_bg;
                    BubbleTextBox.this.cBubble.redraw();
                }
            }
        });
        this.textWidget.addModifyListener(e -> {
            boolean textWasBlank = this.text.length() == 0;
            this.text = this.textWidget.getText();
            boolean textIsBlank = this.text.length() == 0;
            this.validateFilterRegex();
            if (textWasBlank != textIsBlank) {
                this.setupTextWidgetLayoutData();
                this.cBubble.redraw();
            }
            this.textWidget.setData("BubbleTextBox::hasContent", (Object)(textIsBlank ? null : "1"));
            this.refilter();
        });
        this.textWidget.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!e.doit) {
                    return;
                }
                if (BubbleTextBox.this.allowRegex) {
                    int key = e.character;
                    if (key <= 26 && key > 0) {
                        key += 96;
                    }
                    if (e.stateMask == SWT.MOD1) {
                        switch (key) {
                            case 120: {
                                BubbleTextBox.this.setRegexEnabled(!BubbleTextBox.this.regexEnabled);
                                e.doit = false;
                                return;
                            }
                        }
                    }
                }
                if (BubbleTextBox.this.keyListener != null && !this.ignoreListener(e)) {
                    BubbleTextBox.this.keyListener.keyPressed(e);
                    if (!e.doit) {
                        return;
                    }
                }
                super.keyPressed(e);
            }

            public void keyReleased(KeyEvent e) {
                if (!e.doit) {
                    return;
                }
                if (BubbleTextBox.this.keyListener != null && !this.ignoreListener(e)) {
                    BubbleTextBox.this.keyListener.keyReleased(e);
                    if (!e.doit) {
                        return;
                    }
                }
                super.keyReleased(e);
            }

            private boolean ignoreListener(KeyEvent e) {
                int keyCode;
                return e.stateMask == SWT.MOD1 && ((keyCode = e.keyCode) == 99 || keyCode == 118);
            }
        });
    }

    private int getBubbleLayoutHeight() {
        float fontHeight = FontUtils.getFontHeightInPX(this.textWidget.getFont());
        if (Constants.isOSX && Utils.isDarkAppearanceNative()) {
            return (int)((double)fontHeight * 2.0);
        }
        return (int)((double)fontHeight * 1.4);
    }

    public void setMessageAndLayout(String msg, GridData gridData) {
        this.textWidget.setMessage(msg);
        gridData.heightHint = this.getBubbleLayoutHeight();
        this.cBubble.setLayoutData((Object)gridData);
    }

    public void setMessageAndLayout(String msg, FormData formData) {
        this.textWidget.setMessage(msg);
        formData.height = this.getBubbleLayoutHeight();
        this.cBubble.setLayoutData((Object)formData);
    }

    public void paintControl(PaintEvent e) {
        float heightOval;
        Rectangle clientArea = this.cBubble.getClientArea();
        e.gc.setBackground(this.textWidget.getBackground());
        e.gc.setAdvanced(true);
        e.gc.setAntialias(1);
        e.gc.fillRoundRectangle(clientArea.x, clientArea.y, clientArea.width - 1, clientArea.height - 1, clientArea.height, clientArea.height);
        if (!Utils.isDarkAppearanceNative()) {
            e.gc.setAlpha(127);
            e.gc.drawRoundRectangle(clientArea.x, clientArea.y, clientArea.width - 1, clientArea.height - 1, clientArea.height, clientArea.height);
            e.gc.setAlpha(255);
        }
        e.gc.setLineCap(1);
        int fontHeight = FontUtils.getFontHeightInPX(this.textWidget.getFont());
        if (fontHeight > 17 - this.INDENT_OVAL - 1) {
            fontHeight = 17 - this.INDENT_OVAL - 1;
        }
        float widthOval = heightOval = (float)fontHeight * 0.7f;
        Color colorFadedText = Utils.isGTK3 && Utils.isDarkAppearanceNative() ? Colors.light_grey : (Utils.isDarkAppearanceNativeWindows() ? Colors.grey : Colors.getSystemColor((Device)e.display, 18));
        e.gc.setForeground(colorFadedText);
        int iconY = clientArea.y + (clientArea.height - fontHeight + 1) / 2;
        e.gc.setLineWidth(2);
        e.gc.drawOval(clientArea.x + this.INDENT_OVAL, iconY, (int)widthOval, (int)heightOval);
        e.gc.drawPolyline(new int[]{(int)((float)(clientArea.x + this.INDENT_OVAL) + widthOval - 1.0f), (int)((float)iconY + heightOval - 1.0f), clientArea.x + this.INDENT_OVAL + fontHeight, iconY + fontHeight});
        int endPosX = clientArea.x + clientArea.width - this.WIDTH_PADDING;
        boolean textIsBlank = this.textWidget.getText().isEmpty();
        if (!textIsBlank) {
            int YADJ = (clientArea.height - (this.WIDTH_CLEAR + this.WIDTH_PADDING + this.WIDTH_PADDING)) / 2;
            e.gc.setLineCap(2);
            endPosX = clientArea.x + clientArea.width - (this.WIDTH_CLEAR + this.WIDTH_PADDING + this.WIDTH_PADDING / 2);
            Rectangle rXArea = new Rectangle(endPosX, clientArea.y + this.WIDTH_PADDING / 2, this.WIDTH_CLEAR + this.WIDTH_PADDING, clientArea.height - this.WIDTH_PADDING);
            this.cBubble.setData("XArea", (Object)rXArea);
            if (this.mouseOverButton == 1) {
                e.gc.fillOval(rXArea.x, rXArea.y, rXArea.width, rXArea.height);
                e.gc.setForeground(this.textWidget.getForeground());
            }
            e.gc.drawPolyline(new int[]{clientArea.x + clientArea.width - this.WIDTH_PADDING, clientArea.y + this.WIDTH_PADDING + YADJ, clientArea.x + clientArea.width - (this.WIDTH_PADDING + this.WIDTH_CLEAR), clientArea.y + this.WIDTH_PADDING + this.WIDTH_CLEAR + YADJ});
            e.gc.drawPolyline(new int[]{clientArea.x + clientArea.width - this.WIDTH_PADDING, clientArea.y + this.WIDTH_PADDING + this.WIDTH_CLEAR + YADJ, clientArea.x + clientArea.width - (this.WIDTH_PADDING + this.WIDTH_CLEAR), clientArea.y + this.WIDTH_PADDING + YADJ});
        }
        if (this.allowRegex) {
            e.gc.setFont(FONT_REGEX_BUTTON);
            Point regexTextSize = e.gc.textExtent(REGEX_BUTTON_TEXT);
            Rectangle regexArea = new Rectangle(endPosX - regexTextSize.x - this.WIDTH_PADDING / 2 - 4, clientArea.y + 1, regexTextSize.x + this.WIDTH_PADDING / 2 + 4, clientArea.height - 2);
            this.cBubble.setData("RegexArea", (Object)regexArea);
            if (this.regexEnabled) {
                if (this.mouseOverButton != 2) {
                    if (this.regexIsError) {
                        e.gc.setBackground(Colors.fadedRed);
                    }
                    e.gc.fillRoundRectangle(regexArea.x, clientArea.y, regexArea.width - 2, clientArea.height - 1, 5, 5);
                    e.gc.setForeground(colorFadedText);
                } else if (this.regexIsError) {
                    e.gc.setForeground(Colors.colorError);
                } else {
                    e.gc.setForeground(colorFadedText);
                }
                e.gc.setLineWidth(1);
                e.gc.drawRoundRectangle(regexArea.x, clientArea.y, regexArea.width - 2, clientArea.height - 1, 5, 5);
            }
            e.gc.setForeground(this.regexEnabled || this.mouseOverButton == 2 ? this.textWidget.getForeground() : colorFadedText);
            int xOfs = regexTextSize.x - regexArea.width / 2;
            int yPos = regexArea.y + (regexArea.height - regexTextSize.y) / 2 + 1;
            e.gc.drawText(REGEX_BUTTON_TEXT.substring(0, 1), regexArea.x + xOfs, yPos, true);
            e.gc.drawText(REGEX_BUTTON_TEXT.substring(1), regexArea.x + e.gc.textExtent((String)".").x + xOfs, yPos - 2, true);
        }
    }

    private void setupTextWidgetLayoutData() {
        int right;
        boolean isClearButtonVisible;
        int bubbleHeight = this.cBubble.getClientArea().height;
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, TEXTBOX_VPADDING);
        fd.bottom = new FormAttachment(100, -TEXTBOX_VPADDING);
        if (bubbleHeight > 0) {
            fd.height = Math.max(1, bubbleHeight - TEXTBOX_VPADDING * 2);
        }
        fd.left = new FormAttachment(0, 17);
        boolean bl = isClearButtonVisible = !this.textWidget.getText().isEmpty();
        if (!this.allowRegex && !isClearButtonVisible && bubbleHeight > 0) {
            right = -(bubbleHeight / 2);
        } else {
            right = -this.WIDTH_PADDING;
            if (isClearButtonVisible) {
                right -= this.WIDTH_PADDING + this.WIDTH_CLEAR + this.WIDTH_PADDING / 2;
            }
            if (this.allowRegex) {
                GC gc = new GC((Drawable)this.textWidget);
                gc.setFont(FONT_REGEX_BUTTON);
                Point regexTextSize = gc.textExtent(REGEX_BUTTON_TEXT);
                gc.dispose();
                right -= regexTextSize.x + 4;
                right = isClearButtonVisible ? (right -= this.WIDTH_PADDING) : (right -= this.WIDTH_PADDING / 2);
            }
        }
        fd.right = new FormAttachment(100, right);
        this.textWidget.setLayoutData((Object)fd);
        this.cBubble.layout();
    }

    public Composite getMainWidget() {
        return this.cBubble;
    }

    public Text getTextWidget() {
        return this.textWidget;
    }

    public boolean isOurWidget(Widget widget) {
        return widget == this.textWidget || widget == this.cBubble;
    }

    public boolean isDisposed() {
        return this.textWidget.isDisposed() || this.cBubble.isDisposed();
    }

    public void setFocus() {
        this.textWidget.setFocus();
    }

    public void setAllowRegex(boolean allowRegex) {
        if (this.allowRegex == allowRegex) {
            return;
        }
        this.allowRegex = allowRegex;
        this.cBubble.redraw();
        this.setupTextWidgetLayoutData();
        this.validateFilterRegex();
        this.refilter();
    }

    public boolean allowRegex() {
        return this.allowRegex;
    }

    private void setRegexEnabled(boolean enabled) {
        if (this.regexEnabled == enabled) {
            return;
        }
        this.regexEnabled = enabled;
        this.cBubble.redraw();
        this.setupTextWidgetLayoutData();
        this.validateFilterRegex();
        this.refilter();
    }

    private void refilter() {
        BubbleTextBoxChangeListener[] listeners;
        BubbleTextBoxChangeListener[] bubbleTextBoxChangeListenerArray = listeners = this.bubbleTextBoxChangeListeners.toArray(new BubbleTextBoxChangeListener[0]);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            BubbleTextBoxChangeListener listener = bubbleTextBoxChangeListenerArray[n2];
            listener.bubbleTextBoxChanged(this);
            ++n2;
        }
    }

    public boolean isRegexEnabled() {
        return this.regexEnabled;
    }

    public void addBubbleTextBoxChangeListener(BubbleTextBoxChangeListener listener) {
        if (this.bubbleTextBoxChangeListeners.contains(listener)) {
            return;
        }
        this.bubbleTextBoxChangeListeners.add(listener);
        listener.bubbleTextBoxChanged(this);
    }

    public void removeBubbleTextBoxChangeListenener(BubbleTextBoxChangeListener listener) {
        this.bubbleTextBoxChangeListeners.remove(listener);
    }

    public void validateFilterRegex() {
        Color old_fg;
        Color old_bg = (Color)this.textWidget.getData("TVSWTC:filter.bg");
        if (old_bg == null) {
            old_bg = Utils.getSkinnedBackground((Control)this.textWidget);
            this.textWidget.setData("TVSWTC:filter.bg", (Object)old_bg);
        }
        if ((old_fg = (Color)this.textWidget.getData("TVSWTC:filter.fg")) == null) {
            old_fg = Utils.getSkinnedForeground((Control)this.textWidget);
            this.textWidget.setData("TVSWTC:filter.fg", (Object)old_fg);
        }
        boolean old = this.regexIsError;
        if (this.regexEnabled) {
            if (this.FONT_NO_REGEX == null) {
                Font font = this.textWidget.getFont();
                Display display = this.textWidget.getDisplay();
                FontData[] fd = font.getFontData();
                int i = 0;
                while (i < fd.length) {
                    fd[i].setStyle(0);
                    ++i;
                }
                this.FONT_NO_REGEX = new Font((Device)display, fd);
                fd = this.FONT_NO_REGEX.getFontData();
                i = 0;
                while (i < fd.length) {
                    fd[i].setStyle(1);
                    ++i;
                }
                this.FONT_REGEX = new Font((Device)display, fd);
                Font monospaceFont = FontUtils.getMonospaceFont((Device)display, fd[0].getHeight());
                if (monospaceFont == null) {
                    int i2 = 0;
                    while (i2 < fd.length) {
                        fd[i2].setStyle(2);
                        ++i2;
                    }
                    this.FONT_REGEX_ERROR = new Font((Device)display, fd);
                } else {
                    this.FONT_REGEX_ERROR = monospaceFont;
                }
                this.textWidget.addDisposeListener(e -> {
                    this.FONT_NO_REGEX.dispose();
                    this.FONT_REGEX.dispose();
                    this.FONT_REGEX_ERROR.dispose();
                });
            }
            try {
                Pattern.compile(this.text, 66);
                this.regexIsError = false;
                this.textWidget.setBackground(COLOR_FILTER_REGEX);
                this.textWidget.setForeground(Colors.getInstance().getReadableColor(COLOR_FILTER_REGEX));
                this.textWidget.setFont(this.FONT_REGEX);
            }
            catch (Exception e2) {
                this.regexIsError = true;
                this.regexError = e2.getMessage();
                this.textWidget.setBackground(old_bg);
                this.textWidget.setForeground(old_fg);
                this.textWidget.setFont(this.FONT_REGEX_ERROR);
            }
        } else {
            this.regexIsError = false;
            Color bg = this.text == null || this.text.isEmpty() ? old_bg : COLOR_FILTER_NO_REGEX;
            Color fg = bg == COLOR_FILTER_NO_REGEX ? Colors.getInstance().getReadableColor(bg) : old_fg;
            this.textWidget.setBackground(bg);
            this.textWidget.setForeground(fg);
            if (this.FONT_NO_REGEX != null) {
                this.textWidget.setFont(this.FONT_NO_REGEX);
            }
        }
        if (old != this.regexIsError) {
            this.cBubble.redraw();
        }
        if (!this.text.isEmpty() && !this.regexIsError) {
            this.cBubble.setToolTipText(null);
            this.textWidget.setToolTipText(null);
        }
    }

    public void setState(String s, boolean r) {
        Utils.execSWTThread(() -> {
            boolean changed = false;
            if (this.allowRegex && this.regexEnabled != r) {
                this.regexEnabled = r;
                changed = true;
            }
            if (!s.equals(this.getText())) {
                this.textWidget.setData("TextWithHistory::popup.disable", (Object)"");
                this.textWidget.setText(s);
                this.textWidget.setData("TextWithHistory::popup.disable", null);
                changed = true;
            }
            if (changed) {
                this.cBubble.redraw();
                this.setupTextWidgetLayoutData();
                this.validateFilterRegex();
                this.refilter();
            }
        });
    }

    public void setText(String s) {
        if (s.equals(this.text)) {
            return;
        }
        this.textWidget.setText(s);
    }

    public String getText() {
        return this.text;
    }

    public void setSelection(int start) {
        this.textWidget.setSelection(start);
    }

    public void setKeyListener(KeyListener keyListener) {
        this.keyListener = keyListener;
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    public void setMessage(String message) {
        this.textWidget.setMessage(message);
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public static interface BubbleTextBoxChangeListener {
        public void bubbleTextBoxChanged(BubbleTextBox var1);
    }
}

