/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.components;

import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class DoubleBufferedLabel
extends Canvas
implements PaintListener {
    private String text = "";
    private int style;

    public DoubleBufferedLabel(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.style = style;
        GridData gridData = new GridData(80);
        this.setLayoutData(gridData);
        this.addPaintListener(this);
    }

    public void setLayoutData(Object ld) {
        if (ld instanceof GridData) {
            GridData gd = (GridData)ld;
            gd.verticalAlignment = 4;
        }
        super.setLayoutData(ld);
    }

    public void paintControl(PaintEvent e) {
        e.gc.setAdvanced(true);
        Rectangle clientArea = this.getClientArea();
        GCStringPrinter sp = new GCStringPrinter(e.gc, this.getText(), clientArea, true, true, this.style);
        sp.printString(e.gc, clientArea, this.style);
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        try {
            Point pt = this.computeSize(wHint, hHint, changed, false);
            return pt;
        }
        catch (Throwable t) {
            Debug.out("Error while computing size for DoubleBufferedLabel with text:" + this.getText() + "; " + t.toString());
            return new Point(0, 0);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed, boolean realWidth) {
        if (wHint != -1 && hHint != -1) {
            return new Point(wHint, hHint);
        }
        Point pt = new Point(wHint, hHint);
        Point lastSize = new Point(0, 0);
        GC gc = new GC((Drawable)this);
        GCStringPrinter sp = new GCStringPrinter(gc, this.getText(), new Rectangle(0, 0, 10000, 20), true, true, 16384);
        sp.calculateMetrics();
        Point lastTextSize = sp.getCalculatedSize();
        gc.dispose();
        lastSize.x += lastTextSize.x + 10;
        lastSize.y = Math.max(lastSize.y, lastTextSize.y);
        if (wHint == -1) {
            pt.x = lastSize.x;
        }
        if (hHint == -1) {
            pt.y = lastSize.y;
        }
        return pt;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (text.equals(this.getText())) {
            return;
        }
        this.text = text;
        if (this.getBounds().height == 0) {
            this.getParent().layout(true);
        }
        this.redraw();
    }
}

