/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.components.graphics;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.ui.swt.components.graphics.Scale;
import com.biglybt.ui.swt.components.graphics.ScaledGraphic;
import com.biglybt.ui.swt.components.graphics.ValueFormater;
import com.biglybt.ui.swt.mainwindow.Colors;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class PingGraphic
extends ScaledGraphic
implements ParameterListener {
    private static final int ENTRIES = 2000;
    private static final int COLOR_AVERAGE = 0;
    public static Color[] defaultColors = new Color[]{Colors.grey, Colors.blues[7], Colors.fadedGreen, Colors.fadedRed};
    private int internalLoop;
    private int graphicsUpdate;
    private Point oldSize;
    protected Image bufferImage;
    private int nbValues = 0;
    private int[][] all_values = new int[1][2000];
    private int currentPosition = 0;
    private boolean externalAverage;
    private Color[] colors = defaultColors;

    private PingGraphic(Scale scale, ValueFormater formater) {
        super(scale, formater);
        COConfigurationManager.addParameterListener("Graphics Update", (ParameterListener)this);
        this.parameterChanged("Graphics Update");
    }

    public static PingGraphic getInstance() {
        return new PingGraphic(new Scale(false), new ValueFormater(){

            @Override
            public String format(int value) {
                return String.valueOf(value) + TimeFormatter.MS_SUFFIX;
            }
        });
    }

    public void setColors(Color[] _colors) {
        this.colors = _colors;
    }

    public void setExternalAverage(boolean b) {
        this.externalAverage = b;
    }

    @Override
    protected void addMenuItems(Menu menu) {
        new MenuItem(menu, 2);
        MenuItem mi_reset = new MenuItem(menu, 8);
        mi_reset.setText(MessageText.getString("label.clear.history"));
        mi_reset.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    PingGraphic.this.this_mon.enter();
                    PingGraphic.this.nbValues = 0;
                    PingGraphic.this.currentPosition = 0;
                    int i = 0;
                    while (i < PingGraphic.this.all_values.length) {
                        ((PingGraphic)PingGraphic.this).all_values[i] = new int[PingGraphic.this.all_values[i].length];
                        ++i;
                    }
                }
                finally {
                    PingGraphic.this.this_mon.exit();
                }
                PingGraphic.this.refresh(true);
            }
        });
    }

    public void addIntsValue(int[] new_values) {
        try {
            this.this_mon.enter();
            if (this.all_values.length < new_values.length) {
                int[][] new_all_values = new int[new_values.length][];
                System.arraycopy(this.all_values, 0, new_all_values, 0, this.all_values.length);
                int i = this.all_values.length;
                while (i < new_all_values.length) {
                    new_all_values[i] = new int[2000];
                    ++i;
                }
                this.all_values = new_all_values;
            }
            int i = 0;
            while (i < new_values.length) {
                this.all_values[i][this.currentPosition] = new_values[i];
                ++i;
            }
            ++this.currentPosition;
            if (this.nbValues < 2000) {
                ++this.nbValues;
            }
            if (this.currentPosition >= 2000) {
                this.currentPosition = 0;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void initialize(Canvas canvas) {
        super.initialize(canvas);
        this.drawCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (PingGraphic.this.bufferImage != null && !PingGraphic.this.bufferImage.isDisposed()) {
                    Rectangle bounds = PingGraphic.this.bufferImage.getBounds();
                    if (bounds.width >= e.width + e.x && bounds.height >= e.height + e.y) {
                        e.gc.drawImage(PingGraphic.this.bufferImage, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
                    }
                }
            }
        });
        this.drawCanvas.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                PingGraphic.this.drawChart(true);
            }
        });
    }

    @Override
    public void refresh(boolean force) {
        this.refresh();
    }

    public void refresh() {
        if (this.drawCanvas == null || this.drawCanvas.isDisposed()) {
            return;
        }
        Rectangle bounds = this.drawCanvas.getClientArea();
        if (bounds.height < 30 || bounds.width < 100 || bounds.width > 2000 || bounds.height > 2000) {
            return;
        }
        boolean sizeChanged = this.oldSize == null || this.oldSize.x != bounds.width || this.oldSize.y != bounds.height;
        this.oldSize = new Point(bounds.width, bounds.height);
        ++this.internalLoop;
        if (this.internalLoop > this.graphicsUpdate) {
            this.internalLoop = 0;
        }
        if (this.internalLoop == 0 || sizeChanged) {
            this.drawChart(sizeChanged);
        }
        this.drawCanvas.redraw();
        this.drawCanvas.update();
    }

    protected void drawChart(boolean sizeChanged) {
        if (this.drawCanvas == null || this.drawCanvas.isDisposed() || !this.drawCanvas.isVisible()) {
            return;
        }
        try {
            this.this_mon.enter();
            if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
                this.bufferImage.dispose();
            }
            this.bufferImage = null;
            Rectangle bounds = this.drawCanvas.getClientArea();
            if (bounds.isEmpty()) {
                return;
            }
            int oldAverage = 0;
            int[] oldTargetValues = new int[this.all_values.length];
            int[] maxs = new int[this.all_values.length];
            int x = 0;
            while (x < bounds.width - 71) {
                int position = this.currentPosition - x - 1;
                if (position < 0) {
                    position += 2000;
                }
                int z = 0;
                while (z < this.all_values.length) {
                    int value = this.all_values[z][position];
                    if (value > maxs[z]) {
                        maxs[z] = value;
                    }
                    ++z;
                }
                ++x;
            }
            int max = 0;
            int i = 0;
            while (i < maxs.length) {
                if (maxs[i] > max) {
                    max = maxs[i];
                }
                ++i;
            }
            this.scale.setMax(max);
            this.drawScale(sizeChanged);
            if (this.bufferScale == null || this.bufferScale.isDisposed()) {
                return;
            }
            this.bufferImage = new Image((Device)this.drawCanvas.getDisplay(), bounds);
            GC gcImage = new GC((Drawable)this.bufferImage);
            gcImage.drawImage(this.bufferScale, 0, 0);
            gcImage.setAntialias(1);
            int lastAverage = -1;
            int x2 = 0;
            while (x2 < bounds.width - 71) {
                int position = this.currentPosition - x2 - 1;
                if (position < 0) {
                    position += 2000;
                }
                int xDraw = bounds.width - 71 - x2;
                gcImage.setLineWidth(1);
                int z = this.externalAverage ? 1 : 0;
                while (z < this.all_values.length) {
                    int targetValue = this.all_values[z][position];
                    int oldTargetValue = oldTargetValues[z];
                    if (x2 > 1) {
                        int h1 = bounds.height - this.scale.getScaledValue(targetValue) - 2;
                        int h2 = bounds.height - this.scale.getScaledValue(oldTargetValue) - 2;
                        gcImage.setForeground(this.externalAverage ? this.colors[z] : (z <= 2 ? this.colors[z + 1] : this.colors[3]));
                        gcImage.drawLine(xDraw, h1, xDraw + 1, h2);
                    }
                    oldTargetValues[z] = this.all_values[z][position];
                    ++z;
                }
                int average = this.computeAverage(position);
                if (x2 > 6) {
                    int h1 = bounds.height - this.scale.getScaledValue(average) - 2;
                    int h2 = bounds.height - this.scale.getScaledValue(oldAverage) - 2;
                    gcImage.setForeground(this.colors[0]);
                    gcImage.setLineWidth(2);
                    gcImage.drawLine(xDraw, h1, xDraw + 1, h2);
                    if (lastAverage == -1) {
                        lastAverage = oldAverage;
                    }
                }
                oldAverage = average;
                ++x2;
            }
            if (lastAverage >= 0) {
                int height = bounds.height - this.scale.getScaledValue(lastAverage) - 2;
                gcImage.setForeground(this.colors[0]);
                gcImage.drawText(this.formater.format(lastAverage), bounds.width - 65, height - 12, true);
            }
            gcImage.dispose();
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected int computeAverage(int position) {
        int sum = 0;
        int nbItems = 0;
        int i = -5;
        while (i < 6) {
            int pos = position + i;
            if (pos < 0) {
                pos += 2000;
            }
            if (pos >= 2000) {
                pos -= 2000;
            }
            int z = 0;
            while (z < (this.externalAverage ? 1 : this.all_values.length)) {
                sum += this.all_values[z][pos];
                ++nbItems;
                ++z;
            }
            ++i;
        }
        return sum / nbItems;
    }

    @Override
    public void parameterChanged(String parameter) {
        this.graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
            this.bufferImage.dispose();
        }
        COConfigurationManager.removeParameterListener("Graphics Update", this);
    }
}

