/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.components.graphics;

import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.components.graphics.BackGroundGraphic;
import com.biglybt.ui.swt.components.graphics.Scale;
import com.biglybt.ui.swt.components.graphics.ValueFormater;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ScaledGraphic
extends BackGroundGraphic {
    protected Scale scale;
    protected ValueFormater formater;
    protected Image bufferScale;
    private int lastMax;
    private int update_divider_width = 0;

    public ScaledGraphic(Scale scale, ValueFormater formater) {
        this.scale = scale;
        this.formater = formater;
        this.setSIIECSensitive(scale.isSIIECSensitive());
    }

    public void setUpdateDividerWidth(int width) {
        this.update_divider_width = width;
    }

    protected void drawScale(boolean sizeChanged) {
        if (this.drawCanvas == null || this.drawCanvas.isDisposed() || !this.drawCanvas.isVisible()) {
            return;
        }
        this.drawBackGround(sizeChanged);
        if (this.bufferBackground == null || this.bufferBackground.isDisposed()) {
            return;
        }
        int max = this.scale.getMax();
        boolean scaleChanged = this.lastMax != max;
        this.lastMax = max;
        if (sizeChanged || scaleChanged || this.bufferScale == null) {
            Rectangle bounds = this.drawCanvas.getClientArea();
            if (bounds.height < 1 || bounds.width < 1) {
                return;
            }
            if (this.bufferScale != null && !this.bufferScale.isDisposed()) {
                this.bufferScale.dispose();
            }
            this.bufferScale = new Image((Device)this.drawCanvas.getDisplay(), bounds);
            GC gcBuffer = new GC((Drawable)this.bufferScale);
            try {
                try {
                    gcBuffer.drawImage(this.bufferBackground, 0, 0);
                    gcBuffer.setForeground(this.colorBlack);
                    this.scale.setNbPixels(bounds.height - 16);
                    int[] levels = this.scale.getScaleValues();
                    int i = 0;
                    while (i < levels.length) {
                        int height = bounds.height - this.scale.getScaledValue(levels[i]) - 2;
                        gcBuffer.drawLine(1, height, bounds.width - 70, height);
                        gcBuffer.drawText(this.formater.format(levels[i]), bounds.width - 65, height - 12, true);
                        ++i;
                    }
                    if (this.update_divider_width > 0) {
                        i = bounds.width - 70;
                        while (i > 0) {
                            gcBuffer.setForeground(this.colorGrey);
                            gcBuffer.drawLine(i, 0, i, bounds.height);
                            i -= this.update_divider_width;
                        }
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                    gcBuffer.dispose();
                }
            }
            finally {
                gcBuffer.dispose();
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.bufferScale != null && !this.bufferScale.isDisposed()) {
            this.bufferScale.dispose();
        }
        if (this.scale != null) {
            this.scale.dispose();
        }
    }
}

