/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.components.graphics;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SystemTime;
import com.biglybt.ui.swt.components.graphics.Scale;
import com.biglybt.ui.swt.components.graphics.ScaledGraphic;
import com.biglybt.ui.swt.components.graphics.ValueFormater;
import com.biglybt.ui.swt.mainwindow.Colors;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SpeedGraphic
extends ScaledGraphic
implements ParameterListener {
    private static final int DEFAULT_ENTRIES = 2000;
    public static final int COLOR_AVERAGE = 0;
    public static final int COLOR_MAINSPEED = 1;
    public static final int COLOR_OVERHEAD = 2;
    public static final int COLOR_LIMIT = 3;
    public static final int COLOR_OTHERS = 4;
    public static final int COLOR_TRIMMED = 5;
    public Color[] colors = new Color[]{Colors.red, Colors.blues[7], Colors.colorInverse, Colors.blue, Colors.grey, Colors.light_grey};
    private int internalLoop;
    private int graphicsUpdate;
    private Point oldSize;
    protected Image bufferImage;
    private int nbValues = 0;
    private int maxEntries = 2000;
    private int[][] all_values = new int[1][this.maxEntries];
    private long startTime = -1L;
    private int[] ages = new int[this.maxEntries];
    private int currentPosition = 0;
    private SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm", Locale.US);
    private Map<Integer, Integer> timePositions = new LinkedHashMap<Integer, Integer>(256, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, Integer> eldest) {
            return this.size() > 256;
        }
    };

    private SpeedGraphic(Scale scale, ValueFormater formater) {
        super(scale, formater);
        COConfigurationManager.addAndFireParameterListener("Graphics Update", this);
    }

    @Override
    public void initialize(Canvas canvas) {
        super.initialize(canvas);
        this.drawCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (SpeedGraphic.this.bufferImage != null && !SpeedGraphic.this.bufferImage.isDisposed()) {
                    Rectangle bounds = SpeedGraphic.this.bufferImage.getBounds();
                    if (bounds.width >= e.width + e.x && bounds.height >= e.height + e.y) {
                        e.gc.drawImage(SpeedGraphic.this.bufferImage, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
                    }
                }
            }
        });
        this.drawCanvas.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                SpeedGraphic.this.drawChart(true);
            }
        });
    }

    public static SpeedGraphic getInstance() {
        return new SpeedGraphic(new Scale(), new ValueFormater(){

            @Override
            public String format(int value) {
                return DisplayFormatters.formatByteCountToKiBEtcPerSec(value);
            }
        });
    }

    public static SpeedGraphic getInstance(ValueFormater formatter) {
        return new SpeedGraphic(new Scale(), formatter);
    }

    public static SpeedGraphic getInstance(Scale scale, ValueFormater formatter) {
        return new SpeedGraphic(scale, formatter);
    }

    @Override
    protected void addMenuItems(Menu menu) {
        new MenuItem(menu, 2);
        MenuItem mi_reset = new MenuItem(menu, 8);
        mi_reset.setText(MessageText.getString("label.clear.history"));
        mi_reset.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    SpeedGraphic.this.this_mon.enter();
                    SpeedGraphic.this.nbValues = 0;
                    SpeedGraphic.this.currentPosition = 0;
                    int i = 0;
                    while (i < SpeedGraphic.this.all_values.length) {
                        ((SpeedGraphic)SpeedGraphic.this).all_values[i] = new int[SpeedGraphic.this.all_values[i].length];
                        ++i;
                    }
                    SpeedGraphic.this.startTime = -1L;
                }
                finally {
                    SpeedGraphic.this.this_mon.exit();
                }
                SpeedGraphic.this.refresh(true);
            }
        });
    }

    public void addIntsValue(int[] new_values) {
        try {
            this.this_mon.enter();
            if (this.all_values.length < new_values.length) {
                int[][] new_all_values = new int[new_values.length][];
                System.arraycopy(this.all_values, 0, new_all_values, 0, this.all_values.length);
                int i = this.all_values.length;
                while (i < new_all_values.length) {
                    new_all_values[i] = new int[this.maxEntries];
                    ++i;
                }
                this.all_values = new_all_values;
            }
            int i = 0;
            while (i < new_values.length) {
                this.all_values[i][this.currentPosition] = new_values[i];
                ++i;
            }
            long now = SystemTime.getMonotonousTime();
            if (this.startTime == -1L) {
                this.startTime = now;
            }
            this.ages[this.currentPosition] = (int)((now - this.startTime) / 1000L);
            ++this.currentPosition;
            if (this.nbValues < this.maxEntries) {
                ++this.nbValues;
            }
            this.currentPosition %= this.maxEntries;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addIntValue(int value) {
        this.addIntsValue(new int[]{value});
    }

    @Override
    public void refresh(boolean force) {
        if (this.drawCanvas == null || this.drawCanvas.isDisposed()) {
            return;
        }
        Rectangle bounds = this.drawCanvas.getClientArea();
        if (bounds.height < 30 || bounds.width < 100 || bounds.width > 10000 || bounds.height > 10000) {
            return;
        }
        if (bounds.width > this.maxEntries) {
            try {
                this.this_mon.enter();
                while (this.maxEntries < bounds.width) {
                    this.maxEntries += 1000;
                }
                int i = 0;
                while (i < this.all_values.length) {
                    int[] newValues = new int[this.maxEntries];
                    System.arraycopy(this.all_values[i], 0, newValues, 0, this.all_values[i].length);
                    this.all_values[i] = newValues;
                    ++i;
                }
                int[] newAges = new int[this.maxEntries];
                System.arraycopy(this.ages, 0, newAges, 0, this.ages.length);
                this.ages = newAges;
            }
            finally {
                this.this_mon.exit();
            }
        }
        boolean sizeChanged = this.oldSize == null || this.oldSize.x != bounds.width || this.oldSize.y != bounds.height;
        this.oldSize = new Point(bounds.width, bounds.height);
        ++this.internalLoop;
        if (this.internalLoop > this.graphicsUpdate) {
            this.internalLoop = 0;
        }
        if (this.internalLoop == 0 || sizeChanged || force) {
            this.drawChart(sizeChanged);
            if (force) {
                this.drawChart(true);
            }
        }
        this.drawCanvas.redraw();
        this.drawCanvas.update();
    }

    protected void drawChart(boolean sizeChanged) {
        if (this.drawCanvas == null || this.drawCanvas.isDisposed() || !this.drawCanvas.isVisible()) {
            return;
        }
        GC gcImage = null;
        try {
            int max;
            this.this_mon.enter();
            if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
                this.bufferImage.dispose();
            }
            this.bufferImage = null;
            Rectangle bounds = this.drawCanvas.getClientArea();
            if (bounds.isEmpty()) {
                return;
            }
            int oldAverage = 0;
            int[] oldTargetValues = new int[this.all_values.length];
            int[] maxs = new int[this.all_values.length];
            int x = 0;
            while (x < bounds.width - 71) {
                int position = this.currentPosition - x - 1;
                if (position < 0 && (position += this.maxEntries) < 0) {
                    position = 0;
                }
                int chartIdx = 0;
                while (chartIdx < this.all_values.length) {
                    int value = this.all_values[chartIdx][position];
                    if (value > maxs[chartIdx]) {
                        maxs[chartIdx] = value;
                    }
                    ++chartIdx;
                }
                ++x;
            }
            int max_primary = max = maxs[0];
            int i = 1;
            while (i < maxs.length) {
                int m = maxs[i];
                if (i == 1) {
                    if (max < m) {
                        max_primary = max = m;
                    }
                } else if (max < m) {
                    if (m <= 2 * max_primary) {
                        max = m;
                    } else {
                        max = 2 * max_primary;
                        break;
                    }
                }
                ++i;
            }
            this.scale.setMax(max);
            this.drawScale(sizeChanged);
            if (this.bufferScale == null || this.bufferScale.isDisposed()) {
                return;
            }
            try {
                this.bufferImage = new Image((Device)this.drawCanvas.getDisplay(), bounds);
                gcImage = new GC((Drawable)this.bufferImage);
                gcImage.drawImage(this.bufferScale, 0, 0);
                gcImage.setAntialias(1);
                long now = SystemTime.getCurrentTime();
                int mono_secs = (int)((SystemTime.getMonotonousTime() - this.startTime) / 1000L);
                int next_secs = 60;
                int timestamp_num = 0;
                int last_xpos = -1;
                int lastAverage = -1;
                int x2 = 0;
                while (x2 < bounds.width - 71) {
                    int offset;
                    int position = this.currentPosition - x2 - 1;
                    if (position < 0 && (position += this.maxEntries) < 0) {
                        position = 0;
                    }
                    int xDraw = bounds.width - 71 - x2;
                    int height = this.scale.getScaledValue(this.all_values[0][position]);
                    int this_age = this.ages[position];
                    if (this_age > 0 && (offset = mono_secs - this_age) >= next_secs) {
                        next_secs += 60;
                        long time = now - (long)(offset * 1000);
                        String str = this.timeFormatter.format(new Date(time));
                        Point p = gcImage.stringExtent(str);
                        int xPos = xDraw - p.x / 2;
                        if (xPos >= 0 && (last_xpos < 0 || xPos + p.x < last_xpos)) {
                            Integer old_pos = this.timePositions.get(timestamp_num);
                            if (old_pos != null && Math.abs(old_pos - xPos) <= 2) {
                                xPos = old_pos;
                            }
                            gcImage.setForeground(this.colorGrey);
                            gcImage.drawText(str, xPos, 0, true);
                            last_xpos = xPos;
                            this.timePositions.put(timestamp_num, xPos);
                            ++timestamp_num;
                        }
                    }
                    gcImage.setForeground(this.colors[1]);
                    gcImage.drawLine(xDraw, bounds.height - 1 - height, xDraw, bounds.height);
                    if (this.all_values.length > 1) {
                        gcImage.setForeground(this.colors[2]);
                        height = this.scale.getScaledValue(this.all_values[1][position]);
                        gcImage.drawLine(xDraw, bounds.height - 1 - height, xDraw, bounds.height);
                    }
                    int chartIdx = 2;
                    while (chartIdx < this.all_values.length) {
                        int targetValue = this.all_values[chartIdx][position];
                        int oldTargetValue = oldTargetValues[chartIdx];
                        if (x2 > 1 && (chartIdx == 2 && targetValue > 0 && oldTargetValue > 0 || chartIdx > 2 && (targetValue > 0 || oldTargetValue > 0))) {
                            int trimmed = 0;
                            if (targetValue > max) {
                                targetValue = max;
                                ++trimmed;
                            }
                            if (oldTargetValue > max) {
                                oldTargetValue = max;
                                ++trimmed;
                            }
                            if (trimmed < 2 || trimmed == 2 && position % 3 == 0) {
                                int h1 = bounds.height - this.scale.getScaledValue(targetValue) - 2;
                                int h2 = bounds.height - this.scale.getScaledValue(oldTargetValue) - 2;
                                gcImage.setForeground(chartIdx == 2 ? this.colors[3] : (trimmed > 0 ? this.colors[5] : this.colors[4]));
                                gcImage.drawLine(xDraw, h1, xDraw + 1, h2);
                            }
                        }
                        oldTargetValues[chartIdx] = this.all_values[chartIdx][position];
                        ++chartIdx;
                    }
                    int average = this.computeAverage(position);
                    if (x2 > 6) {
                        int h1 = bounds.height - this.scale.getScaledValue(average) - 2;
                        int h2 = bounds.height - this.scale.getScaledValue(oldAverage) - 2;
                        gcImage.setForeground(this.colors[0]);
                        gcImage.drawLine(xDraw, h1, xDraw + 1, h2);
                        if (lastAverage == -1) {
                            lastAverage = oldAverage;
                        }
                    }
                    oldAverage = average;
                    ++x2;
                }
                if (lastAverage >= 0) {
                    int height = bounds.height - this.scale.getScaledValue(lastAverage) - 2;
                    gcImage.setForeground(this.colors[0]);
                    gcImage.drawText(this.formater.format(lastAverage), bounds.width - 65, height - 12, true);
                }
            }
            catch (Exception e) {
                Debug.out("Warning", e);
            }
        }
        finally {
            if (gcImage != null) {
                gcImage.dispose();
            }
            this.this_mon.exit();
        }
    }

    protected int computeAverage(int position) {
        long sum = 0L;
        int i = -5;
        while (i < 6) {
            int pos = position + i;
            if ((pos %= this.maxEntries) < 0) {
                pos += this.maxEntries;
            }
            sum += (long)this.all_values[0][pos];
            ++i;
        }
        return (int)(sum / 11L);
    }

    @Override
    public void parameterChanged(String parameter) {
        this.graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
            this.bufferImage.dispose();
        }
        COConfigurationManager.removeParameterListener("Graphics Update", this);
    }

    public void setLineColors(Color average, Color speed, Color overhead, Color limit, Color others, Color trimmed) {
        if (average != null) {
            this.colors[0] = average;
        }
        if (speed != null) {
            this.colors[1] = speed;
        }
        if (overhead != null) {
            this.colors[2] = overhead;
        }
        if (limit != null) {
            this.colors[3] = limit;
        }
        if (others != null) {
            this.colors[4] = others;
        }
        if (trimmed != null) {
            this.colors[5] = trimmed;
        }
        if (this.drawCanvas != null && !this.drawCanvas.isDisposed()) {
            this.drawCanvas.redraw();
        }
    }

    public void setLineColors(Color[] newChangeableColorSet) {
        this.colors = newChangeableColorSet;
        if (this.drawCanvas != null && !this.drawCanvas.isDisposed()) {
            this.drawCanvas.redraw();
        }
    }
}

