/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterValidator;
import com.biglybt.pif.ui.config.ParameterWithSuffix;
import com.biglybt.pifimpl.local.ui.config.ParameterImpl;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.ParameterChangeListener;
import com.biglybt.ui.swt.config.SwtConfigParameterValueProcessor;
import com.biglybt.ui.swt.config.SwtParameter;
import com.biglybt.ui.swt.config.SwtParameterValidator;
import com.biglybt.ui.swt.config.SwtParameterValueProcessor;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.views.ConfigView;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public abstract class BaseSwtParameter<PARAMTYPE extends SwtParameter<VALUETYPE>, VALUETYPE>
implements SwtParameter<VALUETYPE> {
    protected final String paramID;
    private Control relatedControl;
    protected SwtParameterValueProcessor<PARAMTYPE, VALUETYPE> valueProcessor;
    protected List<ParameterChangeListener<PARAMTYPE>> change_listeners;
    private final List<SwtParameterValidator<PARAMTYPE, VALUETYPE>> validators = new ArrayList<SwtParameterValidator<PARAMTYPE, VALUETYPE>>();
    private static final AEMonitor class_mon = new AEMonitor("Parameter:class");
    private final PARAMTYPE thisTyped = this;
    private String oldTooltip = null;
    protected Parameter pluginParam;
    private IndentPaintListener fancyPaintListener = null;
    private ParameterValidator.ValidationInfo lastValidationInfo;
    private boolean enabled = true;
    private int indent;
    private Control mainControl;
    private boolean disposed;
    boolean validating = false;

    public BaseSwtParameter(String paramID) {
        this.paramID = paramID;
    }

    @Override
    public String getParamID() {
        return this.paramID;
    }

    public void setMainControl(Control mainControl) {
        this.mainControl = mainControl;
        if (mainControl != null) {
            mainControl.addDisposeListener(e -> this.dispose());
        }
    }

    @Override
    public final Control getMainControl() {
        return this.mainControl;
    }

    @Override
    public Control[] getControls() {
        ArrayList<Control> list = new ArrayList<Control>();
        if (this.mainControl != null) {
            list.add(this.mainControl);
        }
        if (this.relatedControl != null && this.relatedControl != this.mainControl) {
            list.add(this.relatedControl);
        }
        return list.toArray(new Control[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValidator(SwtParameterValidator<PARAMTYPE, VALUETYPE> validator) {
        List<SwtParameterValidator<PARAMTYPE, VALUETYPE>> list = this.validators;
        synchronized (list) {
            if (!this.validators.contains(validator)) {
                this.validators.add(validator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValidator(SwtParameterValidator<PARAMTYPE, VALUETYPE> validator) {
        List<SwtParameterValidator<PARAMTYPE, VALUETYPE>> list = this.validators;
        synchronized (list) {
            this.validators.remove(validator);
        }
    }

    public ParameterValidator.ValidationInfo validate(VALUETYPE newValue) {
        if (this.validating) {
            return new ParameterValidator.ValidationInfo(true);
        }
        ParameterValidator.ValidationInfo resultValidation = new ParameterValidator.ValidationInfo(true);
        try {
            SwtParameterValidator[] validators;
            this.validating = true;
            SwtParameterValidator[] swtParameterValidatorArray = validators = this.validators.toArray(new SwtParameterValidator[0]);
            int n = validators.length;
            int n2 = 0;
            while (n2 < n) {
                SwtParameterValidator validator = swtParameterValidatorArray[n2];
                ParameterValidator.ValidationInfo validationInfo = validator.isValidParameterValue(this.thisTyped, newValue);
                if (validationInfo != null) {
                    if (!validationInfo.valid) {
                        resultValidation = validationInfo;
                        break;
                    }
                    if (validationInfo.info != null) {
                        resultValidation.info = resultValidation.info == null ? validationInfo.info : String.valueOf(resultValidation.info) + "\n" + validationInfo.info;
                    }
                }
                ++n2;
            }
        }
        finally {
            this.validating = false;
        }
        this.updateControl(resultValidation);
        return resultValidation;
    }

    protected void updateControl(ParameterValidator.ValidationInfo validationInfo) {
        if (this.lastValidationInfo == validationInfo) {
            return;
        }
        if (validationInfo == null) {
            this.lastValidationInfo = null;
            return;
        }
        boolean changed = this.lastValidationInfo == null || validationInfo.valid != this.lastValidationInfo.valid || !Objects.equals(validationInfo.info, this.lastValidationInfo.info);
        this.lastValidationInfo = validationInfo;
        if (!changed) {
            return;
        }
        if (this.mainControl == null || this.mainControl.isDisposed()) {
            return;
        }
        if (!validationInfo.valid) {
            if (validationInfo.info != null) {
                Utils.execSWTThread(() -> {
                    if (this.mainControl.isDisposed()) {
                        return;
                    }
                    String curTooltip = this.mainControl.getToolTipText();
                    if (this.oldTooltip == null) {
                        this.oldTooltip = curTooltip == null ? "" : curTooltip;
                    }
                    this.mainControl.setToolTipText(validationInfo.info);
                });
            }
        } else if (this.oldTooltip != null) {
            String tooltip = this.oldTooltip;
            this.oldTooltip = null;
            Utils.execSWTThread(() -> {
                if (this.mainControl.isDisposed()) {
                    return;
                }
                this.mainControl.setToolTipText(tooltip);
            });
        }
        Utils.execSWTThread(() -> {
            if (this.mainControl.isDisposed()) {
                return;
            }
            Utils.setSkinnedForeground(this.mainControl, validationInfo.valid ? null : Colors.colorError);
            Utils.setSkinnedBackground(this.mainControl, validationInfo.valid ? null : Colors.colorErrorBG);
        });
    }

    public void addAndFireChangeListener(ParameterChangeListener<PARAMTYPE> l) {
        this.addChangeListener(l);
        try {
            class_mon.enter();
            try {
                l.parameterChanged(this.thisTyped);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public void addChangeListener(ParameterChangeListener<PARAMTYPE> l) {
        try {
            class_mon.enter();
            if (this.change_listeners == null) {
                this.change_listeners = new ArrayList<ParameterChangeListener<PARAMTYPE>>(1);
            }
            this.change_listeners.add(l);
        }
        finally {
            class_mon.exit();
        }
    }

    public void removeChangeListener(ParameterChangeListener<PARAMTYPE> l) {
        try {
            class_mon.enter();
            if (this.change_listeners == null) {
                return;
            }
            this.change_listeners.remove(l);
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (this.pluginParam != null) {
            this.pluginParam.setEnabled(enabled);
        }
        Utils.execSWTThread(() -> {
            Control[] controlArray = this.getControls();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                if (c == null) {
                    this.getControls();
                }
                if (!c.isDisposed()) {
                    c.setEnabled(enabled);
                }
                if (this.fancyPaintListener != null) {
                    this.fancyPaintListener.redraw();
                }
                ++n2;
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return this.mainControl == null || this.mainControl.isDisposed();
    }

    @Override
    public final void setValue(VALUETYPE value) {
        ParameterValidator.ValidationInfo validationInfo = this.validate(value);
        if (validationInfo != null && !validationInfo.valid) {
            return;
        }
        if (this.valueProcessor == null || this.valueProcessor.setValue(this.thisTyped, value)) {
            this.triggerChangeListeners(true);
        }
    }

    protected boolean doGridData(Composite composite) {
        if (composite == null) {
            return false;
        }
        Layout layout = composite.getLayout();
        return layout instanceof GridLayout && ((GridLayout)layout).numColumns > 1;
    }

    public void refreshControl() {
        Utils.execSWTThread(() -> {
            if (this.pluginParam != null) {
                if (this.relatedControl != null && !this.relatedControl.isDisposed()) {
                    Messages.updateLanguageKey((Widget)this.relatedControl, this.pluginParam.getLabelKey(), new String[0]);
                }
                this.setVisible(this.pluginParam.isVisible());
                this.setEnabled(this.pluginParam.isEnabled());
            }
        });
    }

    protected void refreshSuffixControl(Control suffixControl) {
        if (suffixControl == null || suffixControl.isDisposed()) {
            return;
        }
        if (this.pluginParam instanceof ParameterWithSuffix) {
            Messages.updateLanguageKey((Widget)suffixControl, ((ParameterWithSuffix)this.pluginParam).getSuffixLabelKey(), new String[0]);
        }
    }

    @Override
    @Deprecated
    public void setLayoutData(Object layoutData) {
        if (this.mainControl != null && !this.mainControl.isDisposed()) {
            this.mainControl.setLayoutData(layoutData);
        }
    }

    @Override
    public VALUETYPE getValue() {
        if (this.valueProcessor == null) {
            return null;
        }
        return this.valueProcessor.getValue(this.thisTyped);
    }

    @Override
    public void informChanged() {
        this.triggerChangeListeners(true);
    }

    protected final void triggerChangeListeners(boolean doRefresh) {
        if (Utils.isThisThreadSWT()) {
            Utils.getOffOfSWTThread(() -> this.triggerChangeListeners(doRefresh));
            return;
        }
        try {
            class_mon.enter();
            if (this.change_listeners != null) {
                for (ParameterChangeListener<PARAMTYPE> listener : this.change_listeners) {
                    try {
                        listener.parameterChanged(this.thisTyped);
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                }
            }
        }
        finally {
            class_mon.exit();
        }
        this.triggerSubClassChangeListeners();
        if (doRefresh) {
            this.refreshControl();
        }
    }

    protected void triggerSubClassChangeListeners() {
    }

    public Control getRelatedControl() {
        return this.relatedControl;
    }

    protected void setRelatedControl(Control control) {
        if (this.relatedControl == control) {
            return;
        }
        this.relatedControl = control;
        if (control == null || control.isDisposed()) {
            return;
        }
        control.addMenuDetectListener(e -> {
            Control curControl = (Control)e.widget;
            if (curControl == null || curControl.isDisposed()) {
                return;
            }
            Menu menu = new Menu(curControl);
            this.addLabelContextMenus(curControl, menu);
            if (menu.getItemCount() > 0) {
                menu.addListener(23, event2 -> event2.display.asyncExec(() -> ((Menu)menu).dispose()));
                menu.setVisible(true);
            } else {
                menu.dispose();
            }
        });
        control.addListener(32, e -> {
            String tt;
            if (this.pluginParam != null && (tt = control.getToolTipText()) == null) {
                String[] modeKeys = new String[]{"ConfigView.section.mode.beginner", "ConfigView.section.mode.intermediate", "ConfigView.section.mode.advanced"};
                control.setToolTipText(String.valueOf(MessageText.getString("ConfigView.section.mode")) + ": " + MessageText.getString(modeKeys[this.pluginParam.getMinimumRequiredUserMode()]));
            }
        });
    }

    protected void addLabelContextMenus(Control curControl, Menu menu) {
        String message;
        if (this.mainControl != null && this.mainControl.isFocusControl()) {
            curControl.forceFocus();
        }
        if (this.valueProcessor != null) {
            if (!this.valueProcessor.isDefaultValue(this.thisTyped)) {
                VALUETYPE defaultValue = this.valueProcessor.getDefaultValue(this.thisTyped);
                MenuItem item = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)item, "menu.config.reset.to.default");
                if (defaultValue instanceof String || defaultValue instanceof Number) {
                    item.setToolTipText(defaultValue.toString());
                }
                item.addListener(13, event2 -> {
                    boolean bl = this.resetToDefault();
                });
            } else if (this.valueProcessor.getDefaultValue(this.thisTyped) != null) {
                MenuItem item = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)item, "menu.config.is.default");
                item.setEnabled(false);
            }
        }
        if ((message = Messages.getLanguageForControl((Widget)curControl)) != null && !message.trim().isEmpty()) {
            if (menu.getItemCount() > 0) {
                new MenuItem(menu, 2);
            }
            message = message.trim();
            String context2 = ConfigView.getSectionContext(curControl);
            if (context2 != null) {
                message = String.valueOf(context2) + ": " + message;
            }
            String f_message = message;
            ClipboardCopy.addCopyToClipMenu(menu, "copy.config.param.name", () -> f_message);
        }
    }

    public boolean resetToDefault() {
        if (this.valueProcessor == null || this.valueProcessor.resetToDefault(this.thisTyped)) {
            this.informChanged();
            return true;
        }
        return false;
    }

    public boolean isDefaultValue() {
        return this.valueProcessor != null && this.valueProcessor.isDefaultValue(this.thisTyped);
    }

    protected void setPluginParameter(Parameter pluginParam) {
        this.pluginParam = pluginParam;
        if (pluginParam == null) {
            return;
        }
        if (pluginParam instanceof ParameterImpl) {
            this.addValidator((p, toValue) -> ((ParameterImpl)this.pluginParam).validate(toValue));
        }
    }

    public void setValueProcessor(SwtParameterValueProcessor<PARAMTYPE, VALUETYPE> valueProcessor) {
        this.valueProcessor = valueProcessor;
        this.refreshControl();
    }

    protected void setConfigValueProcessor(Class<VALUETYPE> type) {
        this.valueProcessor = new SwtConfigParameterValueProcessor(this, this.paramID, type);
        this.refreshControl();
    }

    public SwtParameterValueProcessor<PARAMTYPE, VALUETYPE> getValueProcessor() {
        return this.valueProcessor;
    }

    @Override
    public void setVisible(boolean visible) {
        Control[] controls;
        if (Utils.runIfNotSWTThread(() -> this.setVisible(visible))) {
            return;
        }
        if (this.mainControl == null || this.mainControl.isDisposed()) {
            return;
        }
        Control[] controlArray = controls = this.getControls();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control con = controlArray[n2];
            Object layoutData = con.getLayoutData();
            if (layoutData instanceof GridData) {
                boolean oldVisible;
                boolean bl = oldVisible = !((GridData)layoutData).exclude;
                if (oldVisible != visible) {
                    ((GridData)layoutData).exclude = !visible;
                    con.setLayoutData(layoutData);
                    try {
                        con.requestLayout();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            con.setVisible(visible);
            ++n2;
        }
    }

    @Override
    public void debug(String s) {
        System.out.println(String.valueOf(Thread.currentThread().getName()) + "|" + this + ": " + this.paramID + "] " + s + "; " + Debug.getCompressedStackTraceSkipFrames(1));
    }

    public int getIndent() {
        return this.indent;
    }

    public boolean isIndentFancy() {
        return this.fancyPaintListener != null;
    }

    public void setIndent(int i, boolean fancy) {
        int width;
        Control firstControl;
        if (Utils.runIfNotSWTThread(() -> this.setIndent(i, fancy))) {
            return;
        }
        this.indent = i;
        Control control = firstControl = this.relatedControl == null ? this.mainControl : this.relatedControl;
        if (firstControl == null || firstControl.isDisposed()) {
            return;
        }
        Object data = firstControl.getLayoutData();
        int n = i == 0 ? 0 : (width = fancy ? 35 + 25 * (i - 1) : i * 18);
        if (data instanceof GridData) {
            ((GridData)data).horizontalIndent = width;
            firstControl.setLayoutData(data);
        } else if (this.doGridData(firstControl.getParent())) {
            GridData gridData = new GridData();
            gridData.horizontalIndent = width;
            firstControl.setLayoutData((Object)gridData);
        }
        if (i == 0) {
            return;
        }
        if (fancy && this.fancyPaintListener == null) {
            this.fancyPaintListener = new IndentPaintListener(firstControl, width);
        } else if (!fancy && this.fancyPaintListener != null) {
            this.fancyPaintListener.dispose();
            this.fancyPaintListener = null;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.validators.clear();
        this.change_listeners = null;
        if (this.valueProcessor != null) {
            this.valueProcessor.dispose(this.thisTyped);
            this.valueProcessor = null;
        }
        Utils.disposeSWTObjects(this.getControls());
    }

    Control createStandardLabel(Composite parent, String labelKey) {
        Label label;
        if (labelKey == null) {
            return null;
        }
        String text = MessageText.getString(labelKey);
        if (text.contains("<a ")) {
            Link link = new Link(parent, 0);
            label = link;
            link.addListener(13, event2 -> Utils.launch(event2.text));
            ClipboardCopy.addCopyToClipMenu((Control)link);
        } else {
            label = new Label(parent, 0);
        }
        if (parent.getLayout() instanceof GridLayout) {
            label.setLayoutData((Object)new GridData());
        }
        Messages.setLanguageText((Widget)label, labelKey);
        this.setRelatedControl((Control)label);
        return label;
    }

    public void setLabelKey(String labelKey) {
        Utils.execSWTThread(() -> {
            Control relatedControl = this.getRelatedControl();
            Messages.updateLanguageKey((Widget)relatedControl, labelKey, new String[0]);
        });
    }

    public void setLabelText(String text) {
        Utils.execSWTThread(() -> {
            Control relatedControl = this.getRelatedControl();
            Messages.updateLanguageKey((Widget)relatedControl, "!" + text + "!", new String[0]);
        });
    }

    protected class IndentPaintListener
    implements Listener {
        private final Control control;
        private final int width;
        private final Composite parent;

        public IndentPaintListener(Control control, int width) {
            this.control = control;
            this.width = width;
            this.parent = control.getParent();
            if (this.parent == null) {
                return;
            }
            this.parent.addListener(9, (Listener)this);
        }

        public void dispose() {
            if (this.parent == null) {
                return;
            }
            Utils.execSWTThread(() -> this.parent.removeListener(9, (Listener)this));
        }

        protected void redraw() {
            if (!this.parent.isDisposed()) {
                this.parent.redraw();
            }
        }

        public void handleEvent(Event event2) {
            if (this.parent == null || this.control.isDisposed()) {
                return;
            }
            Rectangle boundsInParent = this.control.getBounds();
            if (boundsInParent.width == 0 || boundsInParent.height == 0) {
                return;
            }
            Rectangle bounds = this.control.getBounds();
            GC gc = event2.gc;
            Display display = event2.display;
            if (gc == null || display == null) {
                return;
            }
            int x = boundsInParent.x - this.width + 18;
            int x2 = x + this.width - 22;
            int y = boundsInParent.y;
            int y2 = boundsInParent.y + bounds.height / 2;
            gc.setLineStyle(2);
            gc.setLineDash(new int[]{3, 2});
            boolean enabled = BaseSwtParameter.this.isEnabled();
            if (Utils.isDarkAppearanceNativeWindows()) {
                gc.setForeground(display.getSystemColor(enabled ? 19 : 21));
            } else {
                gc.setForeground(display.getSystemColor(enabled ? 21 : (Utils.isDarkAppearanceNative() ? 39 : 19)));
            }
            gc.drawLine(x, y, x, y2);
            gc.drawLine(x, y2, x2, y2);
            gc.setForeground(display.getSystemColor(18));
            gc.drawLine(++x, ++y, x, ++y2);
            gc.drawLine(x, y2, ++x2, y2);
        }
    }
}

