/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.config.impl.ConfigurationDefaults;
import com.biglybt.core.config.impl.ConfigurationParameterNotFoundException;
import com.biglybt.core.html.HTMLUtils;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.ui.config.ColorParameter;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.config.SwtParameter;
import com.biglybt.ui.swt.config.SwtParameterValueProcessor;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.widgets.ButtonWithMinWidth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class ColorSwtParameter
extends BaseSwtParameter<ColorSwtParameter, int[]> {
    private final Button colorChooser;
    private Button resetButton;
    private Label lblSuffix;
    private Image img;

    public ColorSwtParameter(Composite composite, ColorParameter param) {
        this(composite, param.getConfigKeyName(), param.getLabelKey(), param.getSuffixLabelKey(), true, null);
        this.setPluginParameter(param);
    }

    public ColorSwtParameter(Composite composite, String paramID, String labelKey, String suffixLabelKey, boolean showResetButton, SwtParameterValueProcessor<ColorSwtParameter, int[]> valueProcessor) {
        super(paramID);
        Composite parent;
        this.createStandardLabel(composite, labelKey);
        if (suffixLabelKey == null && !showResetButton) {
            parent = composite;
        } else {
            parent = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout(showResetButton ? 3 : 2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            parent.setLayout((Layout)gridLayout);
            if (this.doGridData(composite)) {
                parent.setLayoutData((Object)new GridData(768));
            }
        }
        this.colorChooser = new ButtonWithMinWidth(parent, 8, 40);
        this.setMainControl((Control)this.colorChooser);
        if (this.doGridData(composite)) {
            GridData gridData = new GridData();
            this.colorChooser.setLayoutData((Object)gridData);
        }
        if (showResetButton) {
            this.resetButton = new Button(parent, 8);
            Messages.setLanguageText((Widget)this.resetButton, "ConfigView.section.style.colorOverrides.reset");
            this.resetButton.addListener(13, event2 -> {
                boolean bl = this.resetToDefault();
            });
            if (paramID != null) {
                this.resetButton.setEnabled(COConfigurationManager.getBooleanParameter(String.valueOf(paramID) + ".override"));
            }
        }
        if (suffixLabelKey != null) {
            this.lblSuffix = new Label(parent, 64);
            Messages.setLanguageText((Widget)this.lblSuffix, suffixLabelKey);
            this.lblSuffix.setLayoutData((Object)Utils.getWrappableLabelGridData(1, 768));
            ClipboardCopy.addCopyToClipMenu((Control)this.lblSuffix);
        }
        if (valueProcessor != null) {
            this.setValueProcessor(valueProcessor);
        } else if (this.paramID != null) {
            this.setValueProcessor(new ColorValueProcessor(this));
        }
        Menu menu = new Menu((Control)this.colorChooser);
        this.colorChooser.setMenu(menu);
        MenuItem miCopy = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)miCopy, "label.copy");
        miCopy.addListener(13, e -> {
            int[] value = (int[])this.getValue();
            if (value != null) {
                ClipboardCopy.copyToClipBoard(HTMLUtils.toColorHexString(value[0], value[1], value[2], 255));
            }
        });
        MenuItem miPaste = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)miPaste, "label.paste");
        miPaste.addListener(13, e -> {
            String clip = ClipboardCopy.copyFromClipboard();
            try {
                clip = clip.trim();
                if (clip.startsWith("#")) {
                    clip = clip.substring(1);
                }
                long l = Long.parseLong(clip, 16);
                this.setValue(new int[]{(int)(l & 0xFF0000L) >> 16, (int)(l & 0xFF00L) >> 8, (int)(l & 0xFFL)});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        new MenuItem(menu, 2);
        final MenuItem miReset = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)miReset, "ConfigView.section.style.colorOverrides.reset");
        miReset.addListener(13, e -> {
            boolean bl = this.resetToDefault();
        });
        try {
            menu.addMenuListener(MenuListener.menuShownAdapter(e -> {
                miCopy.setEnabled(this.getValue() != null);
                String clip = ClipboardCopy.copyFromClipboard();
                boolean paste_ok = false;
                try {
                    long l;
                    clip = clip.trim();
                    if (clip.startsWith("#")) {
                        clip = clip.substring(1);
                    }
                    paste_ok = (l = Long.parseLong(clip, 16)) <= 0xFFFFFFL;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                miPaste.setEnabled(paste_ok);
                miReset.setEnabled(!this.isDefaultValue());
            }));
        }
        catch (Throwable e2) {
            menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    miReset.setEnabled(!ColorSwtParameter.this.isDefaultValue());
                }
            });
        }
        this.colorChooser.addListener(12, e -> {
            if (this.img != null && !this.img.isDisposed()) {
                this.img.dispose();
            }
        });
        this.colorChooser.addListener(13, e -> {
            ColorDialog cd = new ColorDialog(composite.getShell());
            List<RGB> custom_colours = Utils.getCustomColors();
            int[] value = (int[])this.getValue();
            if (value != null && value.length == 3) {
                RGB colour = new RGB(value[0], value[1], value[2]);
                custom_colours.remove(colour);
                custom_colours.add(0, colour);
                cd.setRGB(colour);
            }
            cd.setRGBs(custom_colours.toArray(new RGB[0]));
            RGB newColor = cd.open();
            if (newColor == null) {
                return;
            }
            Utils.updateCustomColors(cd.getRGBs());
            int[] newColorInts = new int[]{newColor.red, newColor.green, newColor.blue};
            this.setValue(newColorInts);
        });
    }

    @Override
    public void refreshControl() {
        super.refreshControl();
        Utils.execSWTThread(() -> {
            if (this.colorChooser.isDisposed()) {
                return;
            }
            int[] value = (int[])this.getValue();
            this.updateButtonColor(this.colorChooser.getDisplay(), value);
            this.refreshSuffixControl((Control)this.lblSuffix);
            if (this.valueProcessor != null && this.resetButton != null) {
                this.resetButton.setEnabled(!this.valueProcessor.isDefaultValue(this));
            }
        });
    }

    private void updateButtonColor(Display display, int[] rgb) {
        boolean needRelayout;
        Image oldImg = this.img;
        if (rgb != null && rgb.length > 2 && rgb[0] >= 0 && rgb[1] >= 0 && rgb[2] >= 0) {
            needRelayout = oldImg == null;
            boolean showHexCode = Utils.getUserMode() > 0;
            int h = FontUtils.getFontHeightInPX(this.colorChooser.getFont());
            int w = showHexCode ? h : 25;
            this.img = new Image((Device)display, w, h);
            GC gc = new GC((Drawable)this.img);
            try {
                Color color = ColorCache.getColor((Device)display, rgb[0], rgb[1], rgb[2]);
                if (color != null) {
                    gc.setBackground(color);
                    gc.fillRectangle(0, 0, w, h);
                }
            }
            finally {
                gc.dispose();
            }
            this.colorChooser.setImage(this.img);
            String hexCode = "#" + HTMLUtils.toColorHexString(rgb[0], rgb[1], rgb[2], 255);
            if (showHexCode) {
                this.colorChooser.setText(hexCode);
            } else {
                this.colorChooser.setToolTipText(hexCode);
            }
        } else {
            needRelayout = oldImg != null;
            this.img = null;
            this.colorChooser.setImage(this.img);
            this.colorChooser.setText(MessageText.getString("Button.set"));
        }
        if (oldImg != null && !oldImg.isDisposed()) {
            oldImg.dispose();
        }
        if (needRelayout) {
            try {
                this.colorChooser.requestLayout();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public Control[] getControls() {
        if (this.lblSuffix == null) {
            return super.getControls();
        }
        ArrayList<Control> list = new ArrayList<Control>(Arrays.asList(super.getControls()));
        list.add((Control)this.lblSuffix);
        return list.toArray(new Control[0]);
    }

    public void setColor(int _r, int _g, int _b) {
        this.setValue(new int[]{_r, _g, _b});
    }

    private static class ColorValueProcessor
    implements SwtParameterValueProcessor<ColorSwtParameter, int[]>,
    ParameterListener {
        private final SwtParameter owner;
        private boolean changing;

        public ColorValueProcessor(SwtParameter owner) {
            this.owner = owner;
            String configID = owner.getParamID();
            COConfigurationManager.addWeakParameterListener(this, false, String.valueOf(configID) + ".red");
            COConfigurationManager.addWeakParameterListener(this, false, String.valueOf(configID) + ".green");
            COConfigurationManager.addWeakParameterListener(this, false, String.valueOf(configID) + ".blue");
            COConfigurationManager.addWeakParameterListener(this, false, String.valueOf(configID) + ".override");
        }

        @Override
        public void parameterChanged(String parameterName) {
            try {
                if (this.owner.isDisposed()) {
                    COConfigurationManager.removeParameterListener(parameterName, this);
                    return;
                }
                if (this.changing) {
                    return;
                }
                SimpleTimer.addEvent("Color.Update", SystemTime.getOffsetTime(300L), event2 -> {
                    this.changing = false;
                    this.owner.informChanged();
                });
            }
            catch (Exception e) {
                Debug.out("parameterChanged trigger from ConfigParamAdapter " + parameterName, e);
            }
        }

        @Override
        public int[] getValue(ColorSwtParameter p) {
            String key = p.getParamID();
            return new int[]{COConfigurationManager.getIntParameter(String.valueOf(key) + ".red"), COConfigurationManager.getIntParameter(String.valueOf(key) + ".green"), COConfigurationManager.getIntParameter(String.valueOf(key) + ".blue")};
        }

        @Override
        public boolean setValue(ColorSwtParameter p, int[] value) {
            String key = p.getParamID();
            return COConfigurationManager.setRGBParameter(key, value, true);
        }

        @Override
        public boolean isDefaultValue(ColorSwtParameter p) {
            return !COConfigurationManager.getBooleanParameter(String.valueOf(p.getParamID()) + ".override");
        }

        @Override
        public int[] getDefaultValue(ColorSwtParameter p) {
            String key = p.getParamID();
            ConfigurationDefaults defaults = ConfigurationDefaults.getInstance();
            try {
                return new int[]{defaults.getIntParameter(String.valueOf(key) + ".red"), defaults.getIntParameter(String.valueOf(key) + ".green"), defaults.getIntParameter(String.valueOf(key) + ".blue")};
            }
            catch (ConfigurationParameterNotFoundException e) {
                e.printStackTrace();
                return new int[]{80, 80, 80};
            }
        }

        @Override
        public boolean resetToDefault(ColorSwtParameter p) {
            return COConfigurationManager.removeRGBParameter(p.getParamID());
        }
    }
}

