/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pifimpl.local.ui.config.DateTimeParameterImpl;
import com.biglybt.ui.swt.DateWindow;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.config.SwtParameterValueProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DateTimeSwtParameter
extends BaseSwtParameter<DateTimeSwtParameter, Long> {
    private Composite area;
    private Label valueLabel;
    private Button setButton;
    private Button clearButton;
    protected String keyDialogTitle = null;
    protected String keyDialogMessage = null;

    public DateTimeSwtParameter(Composite composite, DateTimeParameterImpl param) {
        this(composite, param.getConfigKeyName(), param.getLabelKey(), null);
        this.keyDialogTitle = param.getKeyDialogTitle();
        this.keyDialogMessage = param.getKeyDialogMessage();
    }

    private DateTimeSwtParameter(Composite composite, String paramID, String labelKey, SwtParameterValueProcessor<DateTimeSwtParameter, Long> valueProcessor) {
        super(paramID);
        this.createStandardLabel(composite, labelKey);
        this.area = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.area.setLayout((Layout)gridLayout);
        if (this.doGridData(composite)) {
            this.area.setLayoutData((Object)new GridData(768));
        }
        this.valueLabel = new Label(this.area, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 150;
        this.valueLabel.setLayoutData((Object)gridData);
        this.setButton = new Button(this.area, 8);
        Messages.setLanguageText((Widget)this.setButton, "Button.set");
        this.clearButton = new Button(this.area, 8);
        Messages.setLanguageText((Widget)this.clearButton, "Button.clear");
        this.setButton.addListener(13, event2 -> this.openDialog(composite.getShell()));
        this.clearButton.addListener(13, event2 -> this.setValue(0L));
        Utils.makeButtonsEqualWidth(Arrays.asList(this.setButton, this.clearButton), 0);
        Label pad = new Label(this.area, 0);
        gridData = new GridData(768);
        pad.setLayoutData((Object)gridData);
        if (valueProcessor == null) {
            this.setConfigValueProcessor(Long.class);
        } else {
            this.setValueProcessor(valueProcessor);
        }
        this.addChangeListener(p -> this.setValueLabel((Long)this.getValue()));
        this.setValueLabel((Long)this.getValue());
    }

    private void setValueLabel(Long time) {
        Utils.execSWTThread(() -> {
            if (time == null || time <= 0L) {
                this.clearButton.setEnabled(false);
                this.valueLabel.setText(MessageText.getString("label.none"));
            } else {
                this.clearButton.setEnabled(true);
                this.valueLabel.setText(DisplayFormatters.formatDateYMDHMS(time));
            }
        });
    }

    @Override
    public void setLayoutData(Object layoutData) {
    }

    @Override
    public Control[] getControls() {
        ArrayList<Control> list = new ArrayList<Control>(Arrays.asList(super.getControls()));
        list.add((Control)this.valueLabel);
        list.add((Control)this.clearButton);
        list.add((Control)this.setButton);
        list.add((Control)this.area);
        return list.toArray(new Control[0]);
    }

    private void openDialog(Shell shell) {
        long time = (Long)this.getValue();
        if (time <= 0L) {
            time = SystemTime.getCurrentTime();
        }
        new DateWindow(this.keyDialogTitle, time, true, v -> this.setValue(v));
    }

    public void setKeyDialogTitle(String keyDialogTitle) {
        this.keyDialogTitle = keyDialogTitle;
    }

    public void setKeyDialogMessage(String keyDialogMessage) {
        this.keyDialogMessage = keyDialogMessage;
    }
}

