/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.config.ParameterValidator;
import com.biglybt.pifimpl.local.ui.config.FloatParameterImpl;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.config.SwtParameterValueProcessor;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.utils.FontUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FloatSwtParameter
extends BaseSwtParameter<FloatSwtParameter, Float> {
    private final DecimalFormat df;
    private final Text inputField;
    private Label lblSuffix;
    private float fMinValue;
    private float fMaxValue;
    private boolean allowZero;

    public FloatSwtParameter(Composite composite, FloatParameterImpl pluginParam) {
        this(composite, pluginParam.getConfigKeyName(), pluginParam.getLabelKey(), pluginParam.getSuffixLabelKey(), pluginParam.getMinValue(), pluginParam.getMaxValue(), pluginParam.isAllowZero(), pluginParam.getNumDigitsAfterDecimal(), null);
        this.setPluginParameter(pluginParam);
    }

    public FloatSwtParameter(Composite composite, String paramID, String labelKey, String suffixLabelKey, float minValue, float maxValue, boolean allowZero, int digitsAfterDecimal, SwtParameterValueProcessor<FloatSwtParameter, Float> valueProcessor) {
        super(paramID);
        Composite parent;
        this.fMinValue = minValue;
        this.fMaxValue = maxValue;
        this.allowZero = allowZero;
        this.df = new DecimalFormat(digitsAfterDecimal > 0 ? "0.000000000000" : "0");
        this.df.setGroupingUsed(false);
        this.df.setMaximumFractionDigits(digitsAfterDecimal);
        this.createStandardLabel(composite, labelKey);
        if (suffixLabelKey == null) {
            parent = composite;
        } else {
            parent = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            parent.setLayout((Layout)gridLayout);
            if (this.doGridData(composite)) {
                parent.setLayoutData((Object)new GridData(768));
            }
        }
        this.inputField = new Text(parent, 133120);
        this.setMainControl((Control)this.inputField);
        int maxLen = this.df.format(this.fMaxValue > 0.0f && this.fMaxValue != Float.MAX_VALUE ? this.fMaxValue : 9999.0f).length();
        int w = (int)(FontUtils.getCharacterWidth(this.inputField.getFont()) * (double)maxLen);
        if (this.doGridData(composite)) {
            GridData gridData = new GridData();
            gridData.widthHint = w;
            this.inputField.setLayoutData((Object)gridData);
        } else if (composite.getLayout() instanceof RowLayout) {
            RowData rowData = new RowData();
            rowData.width = w;
            this.inputField.setLayoutData((Object)rowData);
        }
        if (suffixLabelKey != null) {
            this.lblSuffix = new Label(parent, 64);
            Messages.setLanguageText((Widget)this.lblSuffix, suffixLabelKey);
            this.lblSuffix.setLayoutData((Object)Utils.getWrappableLabelGridData(1, 768));
            ClipboardCopy.addCopyToClipMenu((Control)this.lblSuffix);
        }
        if (valueProcessor == null) {
            this.setConfigValueProcessor(Float.class);
        } else {
            this.setValueProcessor(valueProcessor);
        }
        this.inputField.addListener(25, e -> {
            if (e.text == null || e.text.isEmpty()) {
                return;
            }
            char[] chars = new char[e.text.length()];
            e.text.getChars(0, chars.length, chars, 0);
            char[] cArray = chars;
            int n = chars.length;
            int n2 = 0;
            while (n2 < n) {
                char aChar = cArray[n2];
                if ((aChar < '0' || aChar > '9') && aChar != DecimalFormatSymbols.getInstance().getDecimalSeparator()) {
                    e.doit = false;
                    return;
                }
                ++n2;
            }
        });
        this.inputField.addListener(24, event2 -> {
            try {
                this.validate(Float.valueOf(DisplayFormatters.parseFloat(this.df, this.inputField.getText())));
            }
            catch (Throwable ignore) {
                ParameterValidator.ValidationInfo validationInfo = new ParameterValidator.ValidationInfo(false, MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                this.updateControl(validationInfo);
            }
        });
        this.inputField.addListener(16, event2 -> {
            try {
                this.setValue(Float.valueOf(DisplayFormatters.parseFloat(this.df, this.inputField.getText())));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    @Override
    public ParameterValidator.ValidationInfo validate(Float newValue) {
        ParameterValidator.ValidationInfo validationInfo = null;
        if (!this.allowZero && newValue.floatValue() == 0.0f) {
            validationInfo = new ParameterValidator.ValidationInfo(false, MessageText.getString("warning.zero.not.allowed"));
        }
        if (newValue.floatValue() < this.fMinValue) {
            validationInfo = new ParameterValidator.ValidationInfo(false, MessageText.getString("warning.min", new String[]{this.df.format(this.fMinValue)}));
        }
        if (newValue.floatValue() > this.fMaxValue && this.fMaxValue > -1.0f) {
            validationInfo = new ParameterValidator.ValidationInfo(false, MessageText.getString("warning.max", new String[]{this.df.format(this.fMaxValue)}));
        }
        if (validationInfo == null) {
            return super.validate(newValue);
        }
        this.updateControl(validationInfo);
        return validationInfo;
    }

    @Override
    public void refreshControl() {
        super.refreshControl();
        Utils.execSWTThread(() -> {
            if (this.inputField.isDisposed()) {
                return;
            }
            this.refreshSuffixControl((Control)this.lblSuffix);
            Float value = (Float)this.getValue();
            if (value == null) {
                this.inputField.setText("");
                return;
            }
            String correctText = this.df.format(value);
            if (!this.inputField.getText().equals(correctText)) {
                this.inputField.setText(correctText);
            }
        });
    }

    @Override
    public Control[] getControls() {
        if (this.lblSuffix == null) {
            return super.getControls();
        }
        ArrayList<Control> list = new ArrayList<Control>(Arrays.asList(super.getControls()));
        list.add((Control)this.lblSuffix);
        return list.toArray(new Control[0]);
    }

    public static interface ValueProcessor
    extends SwtParameterValueProcessor<FloatSwtParameter, Float> {
        @Override
        default public Float getValue(List<Float> values) {
            if (values.isEmpty()) {
                return null;
            }
            float result = values.get(0).floatValue();
            for (float v : values.subList(1, values.size())) {
                if (v == result) continue;
                return null;
            }
            return Float.valueOf(result);
        }
    }
}

