/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.core.internat.MessageText;
import com.biglybt.pif.ui.config.InfoParameter;
import com.biglybt.pif.ui.config.LabelParameter;
import com.biglybt.pifimpl.local.ui.config.InfoParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import java.util.Locale;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class InfoSwtParameter
extends BaseSwtParameter<InfoSwtParameter, String> {
    private final Control control;
    private String labelKey;
    private String infoVal;

    public InfoSwtParameter(Composite parent, LabelParameterImpl labelParameter) {
        this(parent, null, null, MessageText.getString(labelParameter.getLabelKey()), false);
        this.setPluginParameter(labelParameter);
    }

    public InfoSwtParameter(Composite parent, InfoParameterImpl infoParameter) {
        this(parent, infoParameter.getConfigKeyName(), infoParameter.getLabelKey(), infoParameter.getValue(), infoParameter.isTextSelectable());
        this.setPluginParameter(infoParameter);
        infoParameter.addListener(n -> this.setInfoVal(infoParameter.getValue()));
    }

    public InfoSwtParameter(Composite parent, String configID, String labelKey, String infoVal, boolean isSelectable) {
        super(configID);
        boolean doLabel;
        this.labelKey = labelKey;
        this.infoVal = infoVal;
        boolean bl = doLabel = labelKey != null && (configID != null || infoVal != null);
        if (doLabel) {
            this.createStandardLabel(parent, labelKey);
        }
        if (isSelectable) {
            Text textWidget;
            if (infoVal != null && infoVal.toLowerCase(Locale.US).contains("<a ")) {
                textWidget = new StyledText(parent, 10);
                this.control = textWidget;
                textWidget.setTabs(8);
                textWidget.setEditable(false);
                textWidget.setBackground(parent.getBackground());
            } else {
                textWidget = new Text(parent, 10);
                this.control = textWidget;
                textWidget.setTabs(8);
            }
        } else if (infoVal != null && infoVal.toLowerCase(Locale.US).contains("<a ")) {
            Link link = new Link(parent, 64);
            this.control = link;
            link.addListener(13, event2 -> Utils.launch(event2.text));
        } else {
            this.control = new Label(parent, 64);
            ClipboardCopy.addCopyToClipMenu(this.control);
        }
        this.setMainControl(this.control);
        if (this.doGridData(parent)) {
            if (isSelectable) {
                GridData gridData = new GridData(768);
                gridData.horizontalSpan = doLabel ? 1 : 2;
                this.control.setLayoutData((Object)gridData);
            } else {
                GridLayout parentLayout = (GridLayout)parent.getLayout();
                this.control.setLayoutData((Object)(parentLayout.numColumns > 2 ? Utils.getHSpanGridData(doLabel ? 1 : 2, 0) : Utils.getWrappableLabelGridData(doLabel ? 1 : 2, 768)));
            }
        }
        if (configID != null) {
            this.setConfigValueProcessor(String.class);
        } else {
            this.refreshControl();
        }
    }

    @Override
    protected boolean doGridData(Composite composite) {
        Layout layout = composite.getLayout();
        return layout instanceof GridLayout;
    }

    @Override
    public void refreshControl() {
        super.refreshControl();
        Utils.execSWTThread(() -> {
            if (this.control.isDisposed()) {
                return;
            }
            if (this.pluginParam instanceof LabelParameter) {
                this.infoVal = MessageText.getString(this.pluginParam.getLabelKey());
            } else if (this.pluginParam instanceof InfoParameter) {
                this.infoVal = ((InfoParameter)this.pluginParam).getValue();
                this.labelKey = this.pluginParam.getLabelKey();
            }
            String value = this.getValue();
            if (value == null) {
                return;
            }
            if (this.control instanceof Label) {
                ((Label)this.control).setText(value);
            } else if (this.control instanceof Link) {
                ((Link)this.control).setText(value);
            } else if (this.control instanceof Text) {
                ((Text)this.control).setText(value);
            } else if (this.control instanceof StyledText) {
                Utils.setTextWithURLs((StyledText)this.control, value, true);
            }
            if (value.contains("\n") && !(this.control instanceof Text)) {
                Utils.relayoutUp(this.control.getParent());
            }
        });
    }

    @Override
    public String getValue() {
        return this.paramID == null ? (this.infoVal == null ? MessageText.getString(this.labelKey) : this.infoVal) : (String)super.getValue();
    }

    private void setInfoVal(String infoVal) {
        this.infoVal = infoVal;
        this.refreshControl();
    }
}

