/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.pifimpl.local.ui.config.StringListParameterImpl;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.config.SwtParameterValueProcessor;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class StringListSwtParameter
extends BaseSwtParameter<StringListSwtParameter, String> {
    private Label lblSuffix;
    private final Control list;
    private final String[] values;
    private final boolean useCombo;

    public StringListSwtParameter(Composite parent, StringListParameterImpl param) {
        this(parent, param.getConfigKeyName(), param.getLabelKey(), param.getSuffixLabelKey(), param.getValues(), param.getLabels(), param.getListType() == 0, null);
        this.setPluginParameter(param);
    }

    public StringListSwtParameter(Composite composite, String paramID, String labelKey, String suffixLabelKey, String[] values, String[] displayStrings, boolean bUseCombo, SwtParameterValueProcessor<StringListSwtParameter, String> valueProcessor) {
        super(paramID);
        Composite parent;
        this.values = values;
        this.useCombo = bUseCombo;
        boolean doGridData = this.doGridData(composite);
        Control label = this.createStandardLabel(composite, labelKey);
        if (label != null && doGridData) {
            GridData gridData = new GridData();
            if (!bUseCombo) {
                gridData.horizontalSpan = 2;
            }
            label.setLayoutData((Object)gridData);
        }
        if (suffixLabelKey == null) {
            parent = composite;
        } else {
            parent = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            parent.setLayout((Layout)gridLayout);
            if (this.doGridData(composite)) {
                parent.setLayoutData((Object)new GridData(768));
            }
        }
        if (displayStrings.length != values.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (bUseCombo) {
            this.list = new Combo(parent, 12);
            this.list.addListener(37, event2 -> {
                boolean bl = event2.doit = false;
            });
        } else {
            this.list = new org.eclipse.swt.widgets.List(parent, 2820){

                public void checkSubclass() {
                }

                public Point computeSize(int wHint, int hHint, boolean changed) {
                    Object ld;
                    if (hHint == 0 && !this.isVisible()) {
                        return new Point(0, 0);
                    }
                    Point pt = super.computeSize(wHint, hHint, changed);
                    if (hHint == -1 && (ld = this.getLayoutData()) instanceof GridData && ((GridData)ld).grabExcessVerticalSpace) {
                        pt.y = 20;
                    }
                    return pt;
                }
            };
        }
        this.setMainControl(this.list);
        if (doGridData) {
            GridData gridData = new GridData(bUseCombo ? 0 : 768);
            if (!bUseCombo) {
                gridData.horizontalSpan = 2;
            }
            this.list.setLayoutData((Object)gridData);
        }
        String[] stringArray = displayStrings;
        int n = displayStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String displayString = stringArray[n2];
            if (Utils.isGTK) {
                displayString = String.valueOf(displayString) + " ";
            }
            if (bUseCombo) {
                ((Combo)this.list).add(displayString);
            } else {
                ((org.eclipse.swt.widgets.List)this.list).add(displayString);
            }
            ++n2;
        }
        if (suffixLabelKey != null) {
            this.lblSuffix = new Label(parent, 64);
            Messages.setLanguageText((Widget)this.lblSuffix, suffixLabelKey);
            this.lblSuffix.setLayoutData((Object)Utils.getWrappableLabelGridData(1, 768));
            ClipboardCopy.addCopyToClipMenu((Control)this.lblSuffix);
        }
        if (valueProcessor != null) {
            this.setValueProcessor(valueProcessor);
        } else if (paramID != null) {
            this.setConfigValueProcessor(String.class);
        } else {
            this.refreshControl();
        }
        this.list.addListener(13, e -> {
            int index = bUseCombo ? ((Combo)this.list).getSelectionIndex() : ((org.eclipse.swt.widgets.List)this.list).getSelectionIndex();
            this.setValue(values[index]);
        });
    }

    private static int findIndex(String value, String[] values) {
        int i = 0;
        while (i < values.length) {
            if (values[i].equals(value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void refreshControl() {
        super.refreshControl();
        Utils.execSWTThread(() -> {
            if (this.list.isDisposed()) {
                return;
            }
            this.refreshSuffixControl((Control)this.lblSuffix);
            int index = StringListSwtParameter.findIndex((String)this.getValue(), this.values);
            if (index < 0) {
                if (this.useCombo) {
                    if (((Combo)this.list).getSelectionIndex() != -1) {
                        ((Combo)this.list).deselectAll();
                    }
                } else if (((org.eclipse.swt.widgets.List)this.list).getSelectionIndex() != -1) {
                    ((org.eclipse.swt.widgets.List)this.list).deselectAll();
                }
                this.resetToDefault();
            } else if (this.useCombo) {
                if (((Combo)this.list).getSelectionIndex() != index) {
                    ((Combo)this.list).select(index);
                }
            } else if (((org.eclipse.swt.widgets.List)this.list).getSelectionIndex() != index) {
                ((org.eclipse.swt.widgets.List)this.list).select(index);
            }
        });
    }

    @Override
    public Control[] getControls() {
        if (this.lblSuffix == null) {
            return super.getControls();
        }
        ArrayList<Control> list = new ArrayList<Control>(Arrays.asList(super.getControls()));
        list.add((Control)this.lblSuffix);
        return list.toArray(new Control[0]);
    }

    public static interface ValueProcessor
    extends SwtParameterValueProcessor<StringListSwtParameter, String> {
        @Override
        default public String getValue(List<String> values) {
            if (values.isEmpty()) {
                return null;
            }
            String result = values.get(0);
            for (String v : values.subList(1, values.size())) {
                if (v.equals(result)) continue;
                return null;
            }
            return result;
        }
    }
}

