/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.core.proxy;

import com.biglybt.core.Core;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.proxy.impl.AEProxySelectorImpl;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.HostNameToIPResolver;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.pif.ui.UIManagerListener;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.updater.UIUpdater;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.pif.UISWTInstance;
import com.biglybt.ui.swt.pif.UISWTStatusEntry;
import com.biglybt.ui.swt.pif.UISWTStatusEntryListener;
import com.biglybt.ui.swt.views.stats.StatsView;
import java.net.InetAddress;
import java.net.Proxy;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class AEProxySelectorSWTImpl {
    private final Core core;
    private final AEProxySelectorImpl proxy_selector;
    private UISWTStatusEntry status;
    private Image icon_grey;
    private Image icon_green;
    private Image icon_yellow;
    private Image icon_red;
    private Image last_icon;
    private boolean flag_incoming;
    private UIUpdater.UIUpdaterListener uiUpdaterListener;
    private MenuItem mi_show;
    private MenuItem mi_sep;
    private MenuItem mi_options;
    private ParameterListener configSocksListener;
    private ParameterListener configIconFlagIncomingListener;
    private long last_bad_peer_update;
    private volatile boolean is_visible;

    public AEProxySelectorSWTImpl(Core _core, AEProxySelectorImpl _proxy_selector) {
        this.core = _core;
        this.proxy_selector = _proxy_selector;
        final PluginInterface default_pi = PluginInitializer.getDefaultInterface();
        default_pi.getUIManager().addUIListener(new UIManagerListener(){

            @Override
            public void UIAttached(final UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    AEProxySelectorSWTImpl.this.configIconFlagIncomingListener = new ParameterListener(){

                        @Override
                        public void parameterChanged(String name) {
                            AEProxySelectorSWTImpl.this.flag_incoming = COConfigurationManager.getBooleanParameter(name);
                        }
                    };
                    COConfigurationManager.addAndFireParameterListener("Proxy.SOCKS.ShowIcon.FlagIncoming", AEProxySelectorSWTImpl.this.configIconFlagIncomingListener);
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    if (uif != null) {
                        AEProxySelectorSWTImpl.this.uiUpdaterListener = new UIUpdater.UIUpdaterListener(){

                            @Override
                            public void updateComplete(int count) {
                                AEProxySelectorSWTImpl.this.updateStatus();
                            }
                        };
                        uif.getUIUpdater().addListener(AEProxySelectorSWTImpl.this.uiUpdaterListener);
                    }
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            ImageLoader imageLoader = ImageLoader.getInstance();
                            AEProxySelectorSWTImpl.this.icon_grey = imageLoader.getImage("grayled");
                            AEProxySelectorSWTImpl.this.icon_yellow = imageLoader.getImage("yellowled");
                            AEProxySelectorSWTImpl.this.icon_green = imageLoader.getImage("greenled");
                            AEProxySelectorSWTImpl.this.icon_red = imageLoader.getImage("redled");
                            UISWTInstance ui_instance = (UISWTInstance)instance;
                            AEProxySelectorSWTImpl.this.status = ui_instance.createStatusEntry();
                            AEProxySelectorSWTImpl.this.status.setText("SOCKS");
                            AEProxySelectorSWTImpl.this.status.setImageEnabled(true);
                            AEProxySelectorSWTImpl.this.status.setImage(AEProxySelectorSWTImpl.this.icon_grey);
                            String icon_param = "Proxy.SOCKS.ShowIcon";
                            boolean enable_proxy = COConfigurationManager.getBooleanParameter("Enable.Proxy");
                            boolean enable_socks = COConfigurationManager.getBooleanParameter("Enable.SOCKS");
                            AEProxySelectorSWTImpl.this.is_visible = enable_proxy && enable_socks && COConfigurationManager.getBooleanParameter("Proxy.SOCKS.ShowIcon");
                            AEProxySelectorSWTImpl.this.status.setVisible(AEProxySelectorSWTImpl.this.is_visible);
                            if (AEProxySelectorSWTImpl.this.is_visible) {
                                AEProxySelectorSWTImpl.this.updateStatus();
                            }
                            AEProxySelectorSWTImpl.this.mi_show = default_pi.getUIManager().getMenuManager().addMenuItem(AEProxySelectorSWTImpl.this.status.getMenuContext(), "pairing.ui.icon.show");
                            AEProxySelectorSWTImpl.this.mi_show.setStyle(2);
                            AEProxySelectorSWTImpl.this.mi_show.setData(AEProxySelectorSWTImpl.this.is_visible);
                            AEProxySelectorSWTImpl.this.mi_show.addListener(new MenuItemListener(){

                                @Override
                                public void selected(MenuItem menu, Object target) {
                                    COConfigurationManager.setParameter("Proxy.SOCKS.ShowIcon", false);
                                }
                            });
                            AEProxySelectorSWTImpl.this.configSocksListener = new ParameterListener(){

                                @Override
                                public void parameterChanged(String parameterName) {
                                    boolean enable_proxy = COConfigurationManager.getBooleanParameter("Enable.Proxy");
                                    boolean enable_socks = COConfigurationManager.getBooleanParameter("Enable.SOCKS");
                                    AEProxySelectorSWTImpl.this.is_visible = enable_proxy && enable_socks && COConfigurationManager.getBooleanParameter("Proxy.SOCKS.ShowIcon");
                                    AEProxySelectorSWTImpl.this.status.setVisible(AEProxySelectorSWTImpl.this.is_visible);
                                    AEProxySelectorSWTImpl.this.mi_show.setData(AEProxySelectorSWTImpl.this.is_visible);
                                    if (AEProxySelectorSWTImpl.this.is_visible) {
                                        AEProxySelectorSWTImpl.this.updateStatus();
                                    }
                                }
                            };
                            COConfigurationManager.addParameterListener(new String[]{"Enable.Proxy", "Enable.SOCKS", "Proxy.SOCKS.ShowIcon"}, AEProxySelectorSWTImpl.this.configSocksListener);
                            AEProxySelectorSWTImpl.this.mi_sep = default_pi.getUIManager().getMenuManager().addMenuItem(AEProxySelectorSWTImpl.this.status.getMenuContext(), "");
                            AEProxySelectorSWTImpl.this.mi_sep.setStyle(4);
                            AEProxySelectorSWTImpl.this.mi_options = default_pi.getUIManager().getMenuManager().addMenuItem(AEProxySelectorSWTImpl.this.status.getMenuContext(), "MainWindow.menu.view.configuration");
                            AEProxySelectorSWTImpl.this.mi_options.addListener(new MenuItemListener(){

                                @Override
                                public void selected(MenuItem menu, Object target) {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (uif != null) {
                                        uif.getMDI().showEntryByID("ConfigView", "proxy");
                                    }
                                }
                            });
                            UISWTStatusEntryListener click_listener = new UISWTStatusEntryListener(){

                                @Override
                                public void entryClicked(UISWTStatusEntry entry) {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (uif != null) {
                                        uif.getMDI().loadEntryByID(StatsView.VIEW_ID, true, false, "TransferStatsView");
                                    }
                                }
                            };
                            AEProxySelectorSWTImpl.this.status.setListener(click_listener);
                        }
                    });
                }
            }

            @Override
            public void UIDetached(UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    COConfigurationManager.removeParameterListener("Proxy.SOCKS.ShowIcon.FlagIncoming", AEProxySelectorSWTImpl.this.configIconFlagIncomingListener);
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    if (uif != null && AEProxySelectorSWTImpl.this.uiUpdaterListener != null) {
                        uif.getUIUpdater().removeListener(AEProxySelectorSWTImpl.this.uiUpdaterListener);
                        AEProxySelectorSWTImpl.this.uiUpdaterListener = null;
                    }
                    if (AEProxySelectorSWTImpl.this.status != null) {
                        AEProxySelectorSWTImpl.this.status.destroy();
                        AEProxySelectorSWTImpl.this.status = null;
                    }
                    if (AEProxySelectorSWTImpl.this.mi_options != null) {
                        AEProxySelectorSWTImpl.this.mi_options.remove();
                        AEProxySelectorSWTImpl.this.mi_options = null;
                    }
                    if (AEProxySelectorSWTImpl.this.mi_sep != null) {
                        AEProxySelectorSWTImpl.this.mi_sep.remove();
                        AEProxySelectorSWTImpl.this.mi_sep = null;
                    }
                    if (AEProxySelectorSWTImpl.this.mi_show != null) {
                        AEProxySelectorSWTImpl.this.mi_show.remove();
                        AEProxySelectorSWTImpl.this.mi_show = null;
                    }
                    if (AEProxySelectorSWTImpl.this.configSocksListener != null) {
                        COConfigurationManager.removeParameterListener("Enable.Proxy", AEProxySelectorSWTImpl.this.configSocksListener);
                        COConfigurationManager.removeParameterListener("Enable.SOCKS", AEProxySelectorSWTImpl.this.configSocksListener);
                        COConfigurationManager.removeParameterListener("Proxy.SOCKS.ShowIcon", AEProxySelectorSWTImpl.this.configSocksListener);
                        AEProxySelectorSWTImpl.this.configSocksListener = null;
                    }
                }
            }
        });
    }

    private void updateStatus() {
        String tip_key;
        Image icon;
        if (!this.is_visible) {
            return;
        }
        Proxy active_proxy = this.proxy_selector.getActiveProxy();
        long now = SystemTime.getMonotonousTime();
        if (active_proxy == null) {
            icon = this.icon_grey;
            tip_key = "label.inactive";
        } else {
            long last_con = this.proxy_selector.getLastConnectionTime();
            long last_fail = this.proxy_selector.getLastFailTime();
            long con_ago = now - last_con;
            long fail_ago = now - last_fail;
            if (last_fail < 0L) {
                icon = this.icon_green;
                tip_key = "PeerManager.status.ok";
            } else if (fail_ago > 60000L) {
                if (con_ago < fail_ago) {
                    icon = this.icon_green;
                    tip_key = "PeerManager.status.ok";
                } else {
                    icon = this.icon_grey;
                    tip_key = "PeersView.state.pending";
                }
            } else {
                icon = this.icon_yellow;
                tip_key = "label.con_prob";
            }
        }
        if (this.flag_incoming) {
            boolean bad_incoming = false;
            if (now - this.last_bad_peer_update > 15000L) {
                this.last_bad_peer_update = now;
                List<DownloadManager> dms = this.core.getGlobalManager().getDownloadManagers();
                for (DownloadManager dm : dms) {
                    PEPeerManager pm = dm.getPeerManager();
                    if (pm != null && pm.getNbRemoteTCPConnections() + pm.getNbRemoteUDPConnections() + pm.getNbRemoteUTPConnections() > 0) {
                        List<PEPeer> peers = pm.getPeers();
                        for (PEPeer peer : peers) {
                            if (!peer.isIncoming() || peer.isLANLocal()) continue;
                            try {
                                if (InetAddress.getByAddress(HostNameToIPResolver.hostAddressToBytes(peer.getIp())).isLoopbackAddress()) {
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            bad_incoming = true;
                            break;
                        }
                    }
                    if (!bad_incoming) {
                        continue;
                    }
                    break;
                }
            } else if (this.last_icon == this.icon_red) {
                bad_incoming = true;
            }
            if (bad_incoming) {
                icon = this.icon_red;
                tip_key = "proxy.socks.bad.incoming";
            }
        }
        if (this.last_icon != icon) {
            final Image f_icon = icon;
            final String f_key = tip_key;
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    AEProxySelectorSWTImpl.this.last_icon = f_icon;
                    AEProxySelectorSWTImpl.this.status.setImage(f_icon);
                    Utils.setTT(AEProxySelectorSWTImpl.this.status, MessageText.getString("proxy.socks.ui.icon.tip", new String[]{MessageText.getString(f_key)}));
                }
            });
        }
    }
}

