/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.devices.add;

import com.biglybt.core.devices.DeviceManager;
import com.biglybt.core.devices.DeviceTemplate;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.devices.TranscodeChooser;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinObjectText;
import com.biglybt.ui.swt.views.skin.SkinnedDialog;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DeviceTemplateChooser {
    DeviceTemplateClosedListener listener;
    SkinnedDialog skinnedDialog;
    DeviceTemplate selectedDeviceTemplate;
    private DeviceManager.DeviceManufacturer mf;

    public DeviceTemplateChooser(DeviceManager.DeviceManufacturer mf) {
        this.mf = mf;
    }

    public void open(DeviceTemplateClosedListener l) {
        this.listener = l;
        this.skinnedDialog = new SkinnedDialog("skin3_dlg_deviceadd_mfchooser", "shell", 2080);
        this.skinnedDialog.addCloseListener(new SkinnedDialog.SkinnedDialogClosedListener(){

            @Override
            public void skinDialogClosed(SkinnedDialog dialog) {
                if (DeviceTemplateChooser.this.listener != null) {
                    DeviceTemplateChooser.this.listener.deviceTemplateChooserClosed(DeviceTemplateChooser.this.selectedDeviceTemplate);
                }
            }
        });
        SWTSkin skin = this.skinnedDialog.getSkin();
        SWTSkinObject so = skin.getSkinObject("list");
        if (so instanceof SWTSkinObjectContainer) {
            SWTSkinObjectContainer soList = (SWTSkinObjectContainer)so;
            this.createDeviceTemplateList2(soList);
        }
        this.skinnedDialog.open();
    }

    private void createDeviceTemplateList2(SWTSkinObjectContainer soList) {
        SWTSkinObjectText soSubTitle;
        DeviceTemplate[] devices = this.mf.getDeviceTemplates();
        if (devices.length == 0) {
            this.noDevices();
            return;
        }
        Arrays.sort(devices, new Comparator<DeviceTemplate>(){

            @Override
            public int compare(DeviceTemplate o1, DeviceTemplate o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        Composite parent = soList.getComposite();
        if (parent.getChildren().length > 0) {
            Utils.disposeComposite(parent, false);
        }
        SWTSkin skin = this.skinnedDialog.getSkin();
        RowLayout layout = new RowLayout(256);
        layout.spacing = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.wrap = true;
        layout.justify = true;
        layout.fill = true;
        parent.setLayout((Layout)layout);
        Listener clickListener = new Listener(){
            boolean down = false;

            public void handleEvent(Event event2) {
                if (event2.type == 3) {
                    this.down = true;
                } else if (event2.type == 4 && this.down) {
                    Widget widget = event2.widget instanceof Label ? ((Label)event2.widget).getParent() : event2.widget;
                    DeviceTemplateChooser.this.selectedDeviceTemplate = (DeviceTemplate)widget.getData("obj");
                    if (DeviceTemplateChooser.this.selectedDeviceTemplate == null) {
                        Debug.out("selectedDeviceTemplate is null!");
                    }
                    DeviceTemplateChooser.this.skinnedDialog.close();
                    this.down = false;
                }
            }
        };
        DeviceTemplate[] deviceTemplateArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceTemplate deviceTemplate = deviceTemplateArray[n2];
            if (!deviceTemplate.isAuto()) {
                String iconURL = null;
                TranscodeChooser.addImageBox(parent, clickListener, null, deviceTemplate, iconURL, deviceTemplate.getName());
            }
            ++n2;
        }
        SWTSkinObjectText soTitle = (SWTSkinObjectText)skin.getSkinObject("title");
        if (soTitle != null) {
            soTitle.setTextID("devices.choose.device.title");
        }
        if ((soSubTitle = (SWTSkinObjectText)skin.getSkinObject("subtitle")) != null) {
            soSubTitle.setTextID("label.clickone");
        }
        Shell shell = this.skinnedDialog.getShell();
        Point computeSize = shell.computeSize(shell.getSize().x, -1, true);
        shell.setSize(computeSize);
        UIFunctionsSWT uiFunctionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctionsSWT != null) {
            Shell mainShell = uiFunctionsSWT.getMainShell();
            Utils.centerWindowRelativeTo(shell, (Control)mainShell);
        }
    }

    private void noDevices() {
        new MessageBoxShell(32, "No Devices Found", "We couldn't find any devices.  Maybe you didn't install the Vuze Transcoder Plugin?").open(null);
        this.skinnedDialog.close();
    }

    public static interface DeviceTemplateClosedListener {
        public void deviceTemplateChooserClosed(DeviceTemplate var1);
    }
}

