/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.help;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mainwindow.SWTThread;
import com.biglybt.ui.swt.mainwindow.SWTThreadAlreadyInstanciatedException;
import com.biglybt.update.CorePatchLevel;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AboutWindow {
    private static final String IMG_SPLASH = "logo_splash";
    static Image image;
    static AEMonitor class_mon;
    private static Shell instance;
    private static Image imgSrc;
    private static int paintColorTo;
    private static int paintColorDir;
    private static Image imageToDispose;

    static {
        class_mon = new AEMonitor("AboutWindow");
        paintColorTo = 0;
        paintColorDir = 2;
    }

    public static void show() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                AboutWindow._show();
            }
        });
    }

    private static void _show() {
        if (instance != null) {
            instance.open();
            return;
        }
        paintColorTo = 0;
        final Shell window = ShellFactory.createMainShell(2144);
        Utils.setShellIcon(window);
        final Display display = window.getDisplay();
        window.setText(String.valueOf(MessageText.getString("MainWindow.about.title")) + " " + Constants.getCurrentVersion());
        window.setLayout((Layout)new GridLayout(2, false));
        ImageLoader imageLoader = ImageLoader.getInstance();
        imgSrc = imageLoader.getImage(IMG_SPLASH);
        if (imgSrc != null) {
            int w = AboutWindow.imgSrc.getBounds().width;
            int h = AboutWindow.imgSrc.getBounds().height;
            Image imgGray = new Image((Device)display, imageLoader.getImage(IMG_SPLASH), 2);
            imageLoader.releaseImage(IMG_SPLASH);
            Image image2 = new Image((Device)display, w, h);
            GC gc = new GC((Drawable)image2);
            gc.setBackground(Utils.getSkinnedBackground((Control)window));
            gc.fillRectangle(image2.getBounds());
            gc.dispose();
            imageToDispose = image = Utils.renderTransparency(display, image2, imgGray, new Point(0, 0), 180);
            image2.dispose();
            imgGray.dispose();
        }
        final Canvas labelImage = new Canvas((Composite)window, 0x20000000);
        GridData gridData = new GridData(272);
        gridData.horizontalSpan = 2;
        gridData.verticalIndent = 0;
        gridData.horizontalIndent = 0;
        final Rectangle imgBounds = image.getBounds();
        final Rectangle boundsColor = imgSrc.getBounds();
        gridData.widthHint = 300;
        gridData.heightHint = imgBounds.height + imgBounds.y + 20;
        labelImage.setLayoutData((Object)gridData);
        labelImage.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                try {
                    Rectangle clipping = e.gc.getClipping();
                    int ofs = (labelImage.getSize().x - boundsColor.width) / 2;
                    if (paintColorTo > 0) {
                        e.gc.drawImage(imgSrc, 0, 0, paintColorTo, boundsColor.height, ofs, 10, paintColorTo, boundsColor.height);
                    }
                    if (clipping.x + clipping.width > ofs + paintColorTo && imgBounds.width - paintColorTo - 1 > 0) {
                        e.gc.drawImage(image, paintColorTo + 1, 0, imgBounds.width - paintColorTo - 1, imgBounds.height, paintColorTo + 1 + ofs, 10, imgBounds.width - paintColorTo - 1, imgBounds.height);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        Group gInternet = Utils.createSkinnedGroup((Composite)window, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gInternet.setLayout((Layout)gridLayout);
        Messages.setLanguageText((Widget)gInternet, "MainWindow.about.section.internet");
        gridData = new GridData(272);
        gInternet.setLayoutData((Object)gridData);
        Group gSys = Utils.createSkinnedGroup((Composite)window, 0);
        gSys.setLayout((Layout)new GridLayout());
        Messages.setLanguageText((Widget)gSys, "MainWindow.about.section.system");
        gridData = new GridData(272);
        gridData.verticalSpan = 1;
        gSys.setLayoutData((Object)gridData);
        String swt = "";
        if (Utils.isGTK) {
            try {
                swt = "/" + System.getProperty("org.eclipse.swt.internal.gtk.version");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Point dpi = Utils.getDisplay().getDPI();
        swt = String.valueOf(swt) + ", zoom=" + Utils.getDeviceZoom() + ", dpi=" + (dpi.x == dpi.y ? Integer.valueOf(dpi.x) : String.valueOf(dpi.x) + "x" + dpi.y);
        Text txtSysInfo = new Text((Composite)gSys, 74);
        txtSysInfo.setBackground(Colors.getSystemColor((Device)display, 22));
        String about_text = "Java " + System.getProperty("java.version") + " (" + (Constants.is64Bit ? 64 : 32) + " bit)\n  " + System.getProperty("java.vendor") + "\n" + System.getProperty("java.home") + "\n\n" + "SWT v" + Utils.getSWTVersionAndRevision() + ", " + SWT.getPlatform() + swt + "\n" + Constants.OSName + " v" + Constants.OSVersion + ", " + Constants.OSArch + " (" + (Constants.isOS64Bit ? 64 : 32) + " bit)\n" + Constants.APP_NAME.charAt(0) + Constants.getCurrentVersion() + ("".length() == 0 ? "" : "-") + "/" + CorePatchLevel.getCurrentPatchLevel() + " " + COConfigurationManager.getStringParameter("ui") + " " + MessageText.getCurrentLocale();
        txtSysInfo.setText(about_text);
        gridData = new GridData(1808);
        txtSysInfo.setLayoutData((Object)gridData);
        if (window.getCaret() != null) {
            window.getCaret().setVisible(false);
        }
        String[][] link = new String[][]{{"homepage", "bugreports", "forumdiscussion", "wiki", "!" + MessageText.getString("ConfigView.section.plugins"), "!" + MessageText.getString("ConfigView.section.plugins") + " (Tor)"}, {"https://www.biglybt.com/", "https://bugs.biglybt.com/", "https://forums.biglybt.com/", "https://wiki.biglybt.com/", "https://plugins.biglybt.com/", "https://xp5qetgwtj6w62sutz2xnjpx2l7j4z56mbt7xr7wmejerbg67g7nwfyd.onion"}};
        Button copy = new Button((Composite)gSys, 8);
        copy.setLayoutData((Object)new GridData(128));
        copy.setText(MessageText.getString("label.copy"));
        copy.addListener(13, ev -> ClipboardCopy.copyToClipBoard(about_text));
        int i = 0;
        while (i < link[0].length) {
            CLabel linkLabel = new CLabel((Composite)gInternet, 0);
            if (link[0][i].startsWith("!")) {
                linkLabel.setText(link[0][i].substring(1));
            } else {
                linkLabel.setText(MessageText.getString("MainWindow.about.internet." + link[0][i]));
            }
            linkLabel.setData((Object)link[1][i]);
            linkLabel.setCursor(display.getSystemCursor(21));
            Utils.setLinkForeground((Control)linkLabel);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            linkLabel.setLayoutData((Object)gridData);
            linkLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    Utils.launch((String)((CLabel)arg0.widget).getData());
                }

                public void mouseUp(MouseEvent arg0) {
                    Utils.launch((String)((CLabel)arg0.widget).getData());
                }
            });
            ClipboardCopy.addCopyToClipMenu((Control)linkLabel);
            ++i;
        }
        Listener keyListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    window.dispose();
                }
            }
        };
        window.addListener(2, keyListener);
        window.pack();
        txtSysInfo.setFocus();
        Utils.centreWindow(window);
        window.open();
        instance = window;
        window.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event2) {
                instance = null;
                AboutWindow.disposeImage();
            }
        });
        final int maxX = AboutWindow.image.getBounds().width;
        final int maxY = AboutWindow.image.getBounds().height;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (image == null || image.isDisposed() || labelImage.isDisposed()) {
                    return;
                }
                if (display.isDisposed()) {
                    return;
                }
                paintColorTo = paintColorTo + paintColorDir;
                Utils.execSWTThreadLater(7 * paintColorDir, this);
                int ofs = (labelImage.getSize().x - boundsColor.width) / 2;
                labelImage.redraw(paintColorTo - paintColorDir + ofs, 10, paintColorDir, maxY, true);
                if (paintColorTo >= maxX || paintColorTo <= 0) {
                    paintColorTo = 0;
                    Image tmp = image;
                    image = imgSrc;
                    imgSrc = tmp;
                }
            }
        });
    }

    public static void disposeImage() {
        try {
            class_mon.enter();
            Utils.disposeSWTObjects(imageToDispose);
            ImageLoader imageLoader = ImageLoader.getInstance();
            imageLoader.releaseImage(IMG_SPLASH);
            image = null;
            imgSrc = null;
        }
        finally {
            class_mon.exit();
        }
    }

    public static void main(String[] args) {
        try {
            Display display = new Display();
            Colors.getInstance();
            SWTThread.createInstance(null);
            AboutWindow.show();
            while (!display.isDisposed() && instance != null && !instance.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            if (!display.isDisposed()) {
                display.dispose();
            }
        }
        catch (SWTThreadAlreadyInstanciatedException e) {
            e.printStackTrace();
        }
    }
}

