/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.ipchecker;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.ipchecker.extipchecker.ExternalIPCheckerFactory;
import com.biglybt.core.ipchecker.extipchecker.ExternalIPCheckerService;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.ipchecker.IpCheckerWizard;
import com.biglybt.ui.swt.ipchecker.ProgressPanel;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.wizard.AbstractWizardPanel;
import com.biglybt.ui.swt.wizard.IWizardPanel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ChooseServicePanel
extends AbstractWizardPanel {
    private Combo servicesList;
    private ExternalIPCheckerService[] services;
    Label serviceDescription;
    Label serviceUrl;

    public ChooseServicePanel(IpCheckerWizard wizard, IWizardPanel previousPanel) {
        super(wizard, previousPanel);
    }

    @Override
    public void show() {
        this.wizard.setTitle(MessageText.getString("ipCheckerWizard.service"));
        this.wizard.setCurrentInfo(MessageText.getString("ipCheckerWizard.chooseService"));
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        rootPanel.setLayout((Layout)layout);
        Label label = new Label(rootPanel, 64);
        GridData gridData = new GridData();
        gridData.widthHint = 380;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(MessageText.getString("ipCheckerWizard.explanations"));
        this.servicesList = new Combo(rootPanel, 8);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.servicesList.setLayoutData((Object)gridData);
        this.services = ExternalIPCheckerFactory.create().getServices();
        int i = 0;
        while (i < this.services.length) {
            this.servicesList.add(this.services[i].getName());
            ++i;
        }
        label = new Label(rootPanel, 0);
        label.setText(MessageText.getString("ipCheckerWizard.service.url"));
        Cursor handCursor = new Cursor((Device)rootPanel.getDisplay(), 21);
        this.serviceUrl = new Label(rootPanel, 0);
        gridData = new GridData(768);
        this.serviceUrl.setLayoutData((Object)gridData);
        this.serviceUrl.setForeground(Colors.blue);
        this.serviceUrl.setCursor(handCursor);
        this.serviceUrl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                Utils.launch(((Label)arg0.widget).getText());
            }

            public void mouseDown(MouseEvent arg0) {
                Utils.launch(((Label)arg0.widget).getText());
            }
        });
        this.servicesList.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ChooseServicePanel.this.updateInfos();
            }
        });
        this.servicesList.select(0);
        label = new Label(rootPanel, 0);
        gridData = new GridData();
        gridData.heightHint = 50;
        gridData.verticalAlignment = 2;
        label.setLayoutData((Object)gridData);
        label.setText(MessageText.getString("ipCheckerWizard.service.description"));
        this.serviceDescription = new Label(rootPanel, 64);
        gridData = new GridData(768);
        gridData.heightHint = 50;
        gridData.verticalAlignment = 2;
        this.serviceDescription.setLayoutData((Object)gridData);
        this.updateInfos();
    }

    private void updateInfos() {
        int selection = this.servicesList.getSelectionIndex();
        this.serviceDescription.setText(this.services[selection].getDescription());
        this.serviceUrl.setText(this.services[selection].getURL());
        ((IpCheckerWizard)this.wizard).selectedService = this.services[selection];
        ((IpCheckerWizard)this.wizard).setFinishEnabled(this.services[selection].supportsCheck());
    }

    @Override
    public boolean isFinishEnabled() {
        return true;
    }

    @Override
    public IWizardPanel getFinishPanel() {
        return new ProgressPanel((IpCheckerWizard)this.wizard, (IWizardPanel)this);
    }
}

