/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.mainwindow;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.DebugMenuHelper;
import com.biglybt.ui.swt.mainwindow.IMainMenu;
import com.biglybt.ui.swt.mainwindow.MenuFactory;
import com.biglybt.ui.swt.mainwindow.PluginsMenuHelper;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class MainMenuV2
implements IMainMenu {
    private Menu menuBar;

    public MainMenuV2(Shell shell) {
        this.createMenus(shell);
    }

    private void createMenus(Shell parent) {
        this.menuBar = parent.getDisplay().getMenuBar();
        if (this.menuBar == null) {
            this.menuBar = new Menu((Decorations)parent, 2);
            parent.setMenuBar(this.menuBar);
        } else {
            Utils.disposeSWTObjects(this.menuBar.getItems());
        }
        this.addFileMenu();
        if (Constants.isOSX) {
            this.addViewMenu(parent);
            this.addTransferMenu();
            this.addTorrentMenu(parent);
        } else {
            this.addTransferMenu();
            this.addTorrentMenu(parent);
            this.addViewMenu(parent);
            this.addToolsMenu();
        }
        this.addPluginsMenu(parent);
        if (Constants.isOSX) {
            this.addWindowMenu(parent);
        }
        if (Constants.isCVSVersion()) {
            DebugMenuHelper.createDebugMenuItem(this.menuBar);
        }
        this.addCommunityMenu(parent);
        this.addV2HelpMenu(parent);
        MenuFactory.updateEnabledStates(this.menuBar);
    }

    private void addWindowMenu(Shell parent) {
        MenuItem menu_window = MenuFactory.createWindowMenuItem(this.menuBar);
        Menu windowMenu = menu_window.getMenu();
        MenuFactory.addMinimizeWindowMenuItem(windowMenu);
        MenuFactory.addZoomWindowMenuItem(windowMenu);
        MenuFactory.addSeparatorMenuItem(windowMenu);
        MenuFactory.addBlockedIPsMenuItem(windowMenu);
        MenuFactory.addSeparatorMenuItem(windowMenu);
        MenuFactory.addBringAllToFrontMenuItem(windowMenu);
        MenuFactory.addSeparatorMenuItem(windowMenu);
        MenuFactory.appendWindowMenuItems(windowMenu);
    }

    private void addFileMenu() {
        MenuItem fileItem = MenuFactory.createFileMenuItem(this.menuBar);
        Menu fileMenu = fileItem.getMenu();
        MenuFactory.addCreateMenuItem(fileMenu);
        MenuItem openMenuItem = MenuFactory.createOpenMenuItem(fileMenu);
        Menu openSubMenu = openMenuItem.getMenu();
        MenuFactory.addOpenTorrentMenuItem(openSubMenu);
        MenuFactory.addOpenURIMenuItem(openSubMenu);
        MenuFactory.addOpenTorrentForTrackingMenuItem(openSubMenu);
        MenuFactory.addOpenVuzeFileMenuItem(openSubMenu);
        MenuItem shareMenuItem = MenuFactory.createShareMenuItem(fileMenu);
        Menu shareSubMenu = shareMenuItem.getMenu();
        MenuFactory.addShareFileMenuItem(shareSubMenu);
        MenuFactory.addShareFolderMenuItem(shareSubMenu);
        MenuFactory.addShareFolderContentMenuItem(shareSubMenu);
        MenuFactory.addShareFolderContentRecursiveMenuItem(shareSubMenu);
        MenuFactory.addSearchMenuItem(fileMenu);
        MenuFactory.addSeparatorMenuItem(fileMenu);
        MenuFactory.addImportMenuItem(fileMenu);
        MenuFactory.addExportMenuItem(fileMenu);
        MenuFactory.addSeparatorMenuItem(fileMenu);
        MenuFactory.addCloseWindowMenuItem(fileMenu);
        MenuFactory.addCloseTabMenuItem(fileMenu);
        MenuFactory.addCloseDetailsMenuItem(fileMenu);
        MenuFactory.addCloseDownloadBarsToMenu(fileMenu);
        if (!Constants.isOSX) {
            MenuFactory.addSeparatorMenuItem(fileMenu);
            MenuFactory.addRestartMenuItem(fileMenu);
            MenuFactory.addExitMenuItem(fileMenu);
        }
    }

    private void addTransferMenu() {
        MenuFactory.createTransfersMenuItem(this.menuBar);
    }

    private void addViewMenu(Shell parent) {
        try {
            MenuItem viewItem = MenuFactory.createViewMenuItem(this.menuBar);
            final Menu viewMenu = viewItem.getMenu();
            viewMenu.addListener(22, new Listener(){

                public void handleEvent(Event event2) {
                    Utils.disposeSWTObjects(viewMenu.getItems());
                    MainMenuV2.this.buildSimpleViewMenu(viewMenu);
                }
            });
        }
        catch (Exception e) {
            Debug.out("Error creating View Menu", e);
        }
    }

    protected void buildSimpleViewMenu(Menu viewMenu) {
        try {
            MenuFactory.addMyTorrentsMenuItem(viewMenu);
            MenuFactory.addMyTrackerMenuItem(viewMenu);
            MenuFactory.addMySharesMenuItem(viewMenu);
            MenuFactory.addViewToolbarMenuItem(viewMenu);
            MenuFactory.addTransferBarToMenu(viewMenu);
            MenuFactory.addClientStatsMenuItem(viewMenu);
            MenuFactory.addPairingMenuItem(viewMenu);
            MenuFactory.addSubscriptionMenuItem(viewMenu);
            boolean enabled = COConfigurationManager.getBooleanParameter("Beta Programme Enabled");
            if (enabled) {
                MenuFactory.addSeparatorMenuItem(viewMenu);
                MenuFactory.addMenuItem(viewMenu, 32, "MainWindow.menu.view.beta", new Listener(){

                    public void handleEvent(Event event2) {
                        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                        MdiEntry entry = mdi.createEntryFromSkinRef(null, "BetaProgramme", "main.area.beta", "{Sidebar.beta.title}", null, null, true, "");
                        entry.setImageLeftID("image.sidebar.beta");
                        mdi.showEntry(entry);
                    }
                });
            }
            MenuFactory.addSeparatorMenuItem(viewMenu);
            if (PluginsMenuHelper.buildViewMenu(viewMenu) && Constants.isOSX) {
                MenuFactory.addSeparatorMenuItem(viewMenu);
            }
            if (Constants.isOSX) {
                MenuFactory.addConsoleMenuItem(viewMenu);
                MenuFactory.addStatisticsMenuItem(viewMenu);
                MenuFactory.addSpeedLimitsToMenu(viewMenu);
                PluginsMenuHelper.buildToolsMenu(viewMenu);
            }
        }
        catch (Exception e) {
            Debug.out("Error creating View Menu", e);
        }
    }

    private void addTorrentMenu(Shell parent) {
        if (COConfigurationManager.getBooleanParameter("show_torrents_menu")) {
            MenuFactory.createTorrentMenuItem(this.menuBar);
        }
    }

    private void addToolsMenu() {
        MenuItem item = MenuFactory.createToolsMenuItem(this.menuBar);
        MenuBuildUtils.addMaintenanceListenerForMenu(item.getMenu(), (toolsMenu, menuEvent) -> {
            MenuFactory.addBlockedIPsMenuItem(toolsMenu);
            MenuFactory.addConsoleMenuItem(toolsMenu);
            MenuFactory.addStatisticsMenuItem(toolsMenu);
            MenuFactory.addSpeedLimitsToMenu(toolsMenu);
            MenuFactory.addNatTestMenuItem(toolsMenu);
            MenuFactory.addSpeedTestMenuItem(toolsMenu);
            PluginsMenuHelper.buildToolsMenu(toolsMenu);
            MenuFactory.addSeparatorMenuItem(toolsMenu);
            MenuFactory.addConfigWizardMenuItem(toolsMenu);
            MenuFactory.addOptionsMenuItem(toolsMenu);
        }, true);
    }

    private void addPluginsMenu(Shell parent) {
        MenuFactory.createPluginsMenuItem(this.menuBar, true);
    }

    private void addCommunityMenu(Shell parent) {
        MenuFactory.createCommunityMenuItem(this.menuBar);
    }

    private void addV2HelpMenu(Shell parent) {
        MenuItem helpItem = MenuFactory.createHelpMenuItem(this.menuBar);
        Menu helpMenu = helpItem.getMenu();
        if (!Constants.isOSX) {
            MenuFactory.addAboutMenuItem(helpMenu);
            MenuFactory.addSeparatorMenuItem(helpMenu);
        }
        MenuFactory.addReleaseNotesMenuItem(helpMenu);
        MenuFactory.addWhatsNewMenuItem(helpMenu);
        MenuFactory.addWikiMenuItem(helpMenu);
        MenuFactory.addGetPluginsMenuItem(helpMenu);
        MenuFactory.addSeparatorMenuItem(helpMenu);
        if (!SystemProperties.isJavaWebStartInstance()) {
            MenuFactory.addCheckUpdateMenuItem(helpMenu);
            MenuFactory.addBetaMenuItem(helpMenu);
        }
        MenuFactory.addDonationMenuItem(helpMenu);
        MenuFactory.addSeparatorMenuItem(helpMenu);
        MenuFactory.addAdvancedHelpMenuItem(helpMenu);
        MenuFactory.addDebugHelpMenuItem(helpMenu);
    }

    @Override
    public Menu getMenu(String id) {
        if ("menu.bar".equals(id)) {
            return this.menuBar;
        }
        return MenuFactory.findMenu(this.menuBar, id);
    }
}

