/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.mainwindow;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.ui.swt.Alerts;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.utils.ColorCache;
import java.util.ArrayList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SystemWarningWindow {
    private int WIDTH = 230;
    private int BORDER_X = 12;
    private int BORDER_Y0 = 10;
    private int BORDER_Y1 = 6;
    private int GAP_Y = 5;
    private int GAP_BUTTON_Y = 20;
    private int GAP_Y_TITLE_COUNT = 3;
    private final LogAlert logAlert;
    private final Point ptBottomRight;
    private final Shell parent;
    private Shell shell;
    private Image imgClose;
    private Rectangle boundsClose;
    private GCStringPrinter spText;
    private GCStringPrinter spTitle;
    private GCStringPrinter spCount;
    private Point sizeTitle;
    private Point sizeText;
    private Point sizeCount;
    private Font fontTitle;
    private Font fontCount;
    private int height;
    private Rectangle rectX;
    private int historyPosition;
    private String title;
    private String text;
    public static int numWarningWindowsOpen = 0;

    public SystemWarningWindow(LogAlert logAlert, Point ptBottomRight, Shell parent, int historyPosition) {
        String amb_key_suffix;
        this.logAlert = logAlert;
        this.ptBottomRight = ptBottomRight;
        this.parent = parent;
        this.historyPosition = historyPosition;
        switch (logAlert.entryType) {
            case 3: {
                amb_key_suffix = "AlertMessageBox.error";
                break;
            }
            case 0: {
                amb_key_suffix = "AlertMessageBox.information";
                break;
            }
            case 1: {
                amb_key_suffix = "AlertMessageBox.warning";
                break;
            }
            default: {
                amb_key_suffix = null;
            }
        }
        this.title = amb_key_suffix == null ? Constants.APP_NAME : MessageText.getString(amb_key_suffix);
        this.text = logAlert.text.startsWith("{") ? MessageText.expandValue(logAlert.text) : logAlert.text;
        if (logAlert.err != null) {
            this.text = String.valueOf(this.text) + "\n" + Debug.getExceptionMessage(logAlert.err);
        }
        if (logAlert.details != null) {
            this.text = String.valueOf(this.text) + "\n<A HREF=\"details\">" + MessageText.getString("v3.MainWindow.button.viewdetails") + "</A>";
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                SystemWarningWindow.this.openWindow();
            }
        });
    }

    protected void openWindow() {
        Display display = this.parent.getDisplay();
        this.shell = new Shell(this.parent, 4);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setBackground(Colors.getSystemColor((Device)display, 29));
        this.shell.setForeground(Colors.getSystemColor((Device)display, 28));
        Menu menu = new Menu((Control)this.shell);
        MenuItem menuItem = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)menuItem, "MyTorrentsView.menu.thisColumn.toClipboard");
        menuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardCopy.copyToClipBoard(String.valueOf(((SystemWarningWindow)SystemWarningWindow.this).logAlert.text) + (((SystemWarningWindow)SystemWarningWindow.this).logAlert.details == null ? "" : "\n" + ((SystemWarningWindow)SystemWarningWindow.this).logAlert.details));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.shell.setMenu(menu);
        ImageLoader imageLoader = ImageLoader.getInstance();
        this.imgClose = imageLoader.getImage("image.systemwarning.closeitem");
        this.boundsClose = this.imgClose.getBounds();
        GC gc = new GC((Drawable)this.shell);
        FontData[] fontdata = gc.getFont().getFontData();
        fontdata[0].setHeight(fontdata[0].getHeight() + 1);
        fontdata[0].setStyle(1);
        this.fontTitle = new Font((Device)display, fontdata);
        fontdata = gc.getFont().getFontData();
        fontdata[0].setHeight(fontdata[0].getHeight() - 1);
        this.fontCount = new Font((Device)display, fontdata);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Utils.disposeSWTObjects(SystemWarningWindow.this.fontTitle, SystemWarningWindow.this.fontCount);
                --numWarningWindowsOpen;
            }
        });
        Rectangle printArea = new Rectangle(this.BORDER_X, 0, this.WIDTH - this.BORDER_X * 2, 5000);
        this.spText = new GCStringPrinter(gc, this.text, printArea, true, false, 64);
        this.spText.setUrlColor(Colors.blues[9]);
        this.spText.calculateMetrics();
        gc.setFont(this.fontCount);
        String sCountAndTime = MessageText.getString("label.xOfTotal", new String[]{"" + this.historyPosition + 1, "" + this.getWarningCount()});
        sCountAndTime = String.valueOf(sCountAndTime) + " " + DisplayFormatters.formatDateYMDHM(this.logAlert.when);
        this.spCount = new GCStringPrinter(gc, sCountAndTime, printArea, true, false, 64);
        this.spCount.calculateMetrics();
        gc.setFont(this.fontTitle);
        this.spTitle = new GCStringPrinter(gc, this.title, printArea, true, false, 64);
        this.spTitle.calculateMetrics();
        gc.dispose();
        this.sizeText = this.spText.getCalculatedSize();
        this.sizeTitle = this.spTitle.getCalculatedSize();
        this.sizeCount = this.spCount.getCalculatedSize();
        Button btnDismiss = new Button((Composite)this.shell, 8);
        Messages.setLanguageText((Widget)btnDismiss, "Button.dismiss");
        final int btnHeight = btnDismiss.computeSize((int)-1, (int)-1).y;
        Button btnPrev = new Button((Composite)this.shell, 8);
        btnPrev.setText("<");
        Button btnNext = new Button((Composite)this.shell, 8);
        btnNext.setText(">");
        FormData fd = new FormData();
        fd.bottom = new FormAttachment(100, -this.BORDER_Y1);
        fd.right = new FormAttachment(100, -this.BORDER_X);
        btnNext.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -this.BORDER_Y1);
        fd.right = new FormAttachment((Control)btnNext, -this.BORDER_X);
        btnPrev.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -this.BORDER_Y1);
        fd.right = new FormAttachment((Control)btnPrev, -this.BORDER_X);
        btnDismiss.setLayoutData((Object)fd);
        this.height = this.BORDER_Y0 + this.sizeTitle.y + this.GAP_Y + this.sizeText.y + this.GAP_Y_TITLE_COUNT + this.sizeCount.y + this.GAP_BUTTON_Y + btnHeight + this.BORDER_Y1;
        Rectangle area = this.shell.computeTrim(this.ptBottomRight.x - this.WIDTH, this.ptBottomRight.y - this.height, this.WIDTH, this.height);
        this.shell.setBounds(area);
        this.shell.setLocation(this.ptBottomRight.x - area.width, this.ptBottomRight.y - area.height - 2);
        this.rectX = new Rectangle(area.width - this.BORDER_X - this.boundsClose.width, this.BORDER_Y0, this.boundsClose.width, this.boundsClose.height);
        this.shell.addMouseMoveListener(new MouseMoveListener(){
            int lastCursor = 0;

            public void mouseMove(MouseEvent e) {
                int cursor;
                if (SystemWarningWindow.this.shell == null || SystemWarningWindow.this.shell.isDisposed()) {
                    return;
                }
                GCStringPrinter.URLInfo hitUrl = SystemWarningWindow.this.spText.getHitUrl(e.x, e.y);
                int n = cursor = SystemWarningWindow.this.rectX.contains(e.x, e.y) || hitUrl != null ? 21 : 0;
                if (cursor != this.lastCursor) {
                    this.lastCursor = cursor;
                    SystemWarningWindow.this.shell.setCursor(e.display.getSystemCursor(cursor));
                }
            }
        });
        this.shell.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                GCStringPrinter.URLInfo hitUrl;
                if (SystemWarningWindow.this.shell == null || SystemWarningWindow.this.shell.isDisposed()) {
                    return;
                }
                if (SystemWarningWindow.this.rectX.contains(e.x, e.y)) {
                    SystemWarningWindow.this.shell.dispose();
                }
                if ((hitUrl = SystemWarningWindow.this.spText.getHitUrl(e.x, e.y)) != null) {
                    if (hitUrl.url.equals("details")) {
                        MessageBoxShell mb = new MessageBoxShell(Constants.APP_NAME, ((SystemWarningWindow)SystemWarningWindow.this).logAlert.details, new String[]{MessageText.getString("Button.ok")}, 0);
                        mb.setUseTextBox(true);
                        mb.setParent(Utils.findAnyShell());
                        mb.open(null);
                    } else {
                        Utils.launch(hitUrl.url);
                    }
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawImage(SystemWarningWindow.this.imgClose, SystemWarningWindow.this.WIDTH - SystemWarningWindow.this.BORDER_X - ((SystemWarningWindow)SystemWarningWindow.this).boundsClose.width, SystemWarningWindow.this.BORDER_Y0);
                Rectangle printArea = new Rectangle(SystemWarningWindow.this.BORDER_X, SystemWarningWindow.this.BORDER_Y0 + ((SystemWarningWindow)SystemWarningWindow.this).sizeTitle.y + SystemWarningWindow.this.GAP_Y_TITLE_COUNT, SystemWarningWindow.this.WIDTH, 100);
                String sCountAndTime = MessageText.getString("label.xOfTotal", new String[]{"" + (SystemWarningWindow.this.historyPosition + 1), "" + SystemWarningWindow.this.getWarningCount()});
                sCountAndTime = String.valueOf(sCountAndTime) + " " + DisplayFormatters.formatDateYMDHM(((SystemWarningWindow)SystemWarningWindow.this).logAlert.when);
                e.gc.setAlpha(180);
                Font lastFont = e.gc.getFont();
                e.gc.setFont(SystemWarningWindow.this.fontCount);
                SystemWarningWindow.this.spCount = new GCStringPrinter(e.gc, sCountAndTime, printArea, true, false, 192);
                SystemWarningWindow.this.spCount.printString();
                e.gc.setAlpha(255);
                SystemWarningWindow.this.sizeCount = SystemWarningWindow.this.spCount.getCalculatedSize();
                e.gc.setFont(lastFont);
                SystemWarningWindow.this.spText.printString(e.gc, new Rectangle(SystemWarningWindow.this.BORDER_X, SystemWarningWindow.this.BORDER_Y0 + ((SystemWarningWindow)SystemWarningWindow.this).sizeTitle.y + SystemWarningWindow.this.GAP_Y_TITLE_COUNT + ((SystemWarningWindow)SystemWarningWindow.this).sizeCount.y + SystemWarningWindow.this.GAP_Y, SystemWarningWindow.this.WIDTH - SystemWarningWindow.this.BORDER_X - SystemWarningWindow.this.BORDER_X, 5000), 192);
                e.gc.setFont(SystemWarningWindow.this.fontTitle);
                e.gc.setForeground(ColorCache.getColor(e.gc.getDevice(), "#54728c"));
                SystemWarningWindow.this.spTitle.printString(e.gc, new Rectangle(SystemWarningWindow.this.BORDER_X, SystemWarningWindow.this.BORDER_Y0, SystemWarningWindow.this.WIDTH - SystemWarningWindow.this.BORDER_X - SystemWarningWindow.this.BORDER_X, 5000), 192);
                e.gc.setLineStyle(3);
                e.gc.setLineWidth(1);
                e.gc.setAlpha(180);
                e.gc.drawLine(SystemWarningWindow.this.BORDER_X, SystemWarningWindow.this.height - btnHeight - SystemWarningWindow.this.GAP_BUTTON_Y / 2 - SystemWarningWindow.this.BORDER_Y1, SystemWarningWindow.this.WIDTH - SystemWarningWindow.this.BORDER_X, SystemWarningWindow.this.height - btnHeight - SystemWarningWindow.this.GAP_BUTTON_Y / 2 - SystemWarningWindow.this.BORDER_Y1);
            }
        });
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    SystemWarningWindow.this.shell.dispose();
                    return;
                }
            }
        });
        btnPrev.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<LogAlert> alerts = Alerts.getUnviewedLogAlerts();
                int pos = SystemWarningWindow.this.historyPosition - 1;
                if (pos < 0 || pos >= alerts.size()) {
                    return;
                }
                new SystemWarningWindow(alerts.get(pos), SystemWarningWindow.this.ptBottomRight, SystemWarningWindow.this.parent, pos);
                SystemWarningWindow.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        btnPrev.setEnabled(this.historyPosition > 0);
        btnNext.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<LogAlert> alerts = Alerts.getUnviewedLogAlerts();
                int pos = SystemWarningWindow.this.historyPosition + 1;
                if (pos >= alerts.size()) {
                    return;
                }
                new SystemWarningWindow(alerts.get(pos), SystemWarningWindow.this.ptBottomRight, SystemWarningWindow.this.parent, pos);
                SystemWarningWindow.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ArrayList<LogAlert> alerts = Alerts.getUnviewedLogAlerts();
        btnNext.setEnabled(alerts.size() != this.historyPosition + 1);
        btnDismiss.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<LogAlert> alerts = Alerts.getUnviewedLogAlerts();
                int i = 0;
                while (i < alerts.size() && i <= SystemWarningWindow.this.historyPosition) {
                    Alerts.markAlertAsViewed(alerts.get(i));
                    ++i;
                }
                SystemWarningWindow.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.shell.open();
        ++numWarningWindowsOpen;
    }

    private int getWarningCount() {
        ArrayList<LogAlert> historyList = Alerts.getUnviewedLogAlerts();
        return historyList.size();
    }
}

