/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.maketorrent;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.TrackersUtil;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.maketorrent.MultiTrackerEditor;
import com.biglybt.ui.swt.maketorrent.NewTorrentWizard;
import com.biglybt.ui.swt.maketorrent.TrackerEditorListener;
import com.biglybt.ui.swt.maketorrent.WebSeedPanel;
import com.biglybt.ui.swt.wizard.AbstractWizardPanel;
import com.biglybt.ui.swt.wizard.IWizardPanel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class MultiTrackerPanel
extends AbstractWizardPanel<NewTorrentWizard>
implements TrackerEditorListener {
    private Combo configList;
    private Tree configDetails;
    private Button btnNew;
    private Button btnEdit;
    private Button btnDelete;

    public MultiTrackerPanel(NewTorrentWizard wizard, AbstractWizardPanel<NewTorrentWizard> previous) {
        super(wizard, previous);
    }

    @Override
    public void show() {
        ((NewTorrentWizard)this.wizard).setTitle(MessageText.getString("wizard.multitracker.title"));
        ((NewTorrentWizard)this.wizard).setCurrentInfo("");
        Composite rootPanel = ((NewTorrentWizard)this.wizard).getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        Label labelTitle = new Label(panel, 0);
        Messages.setLanguageText((Widget)labelTitle, "wizard.multitracker.configuration");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        labelTitle.setLayoutData((Object)gridData);
        this.configList = new Combo(panel, 8);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.configList.setLayoutData((Object)gridData);
        this.configList.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MultiTrackerPanel.this.updateTrackers();
                MultiTrackerPanel.this.refreshDetails();
            }
        });
        this.btnNew = new Button(panel, 8);
        Messages.setLanguageText((Widget)this.btnNew, "wizard.multitracker.new");
        gridData = new GridData();
        gridData.widthHint = 100;
        this.btnNew.setLayoutData((Object)gridData);
        this.btnNew.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ArrayList<List<String>> group = new ArrayList<List<String>>();
                ArrayList<String> tracker = new ArrayList<String>();
                tracker.add(((NewTorrentWizard)MultiTrackerPanel.this.wizard).getTrackerURL());
                group.add(tracker);
                new MultiTrackerEditor(((NewTorrentWizard)MultiTrackerPanel.this.wizard).getWizardWindow(), null, group, MultiTrackerPanel.this);
            }
        });
        this.btnEdit = new Button(panel, 8);
        Messages.setLanguageText((Widget)this.btnEdit, "wizard.multitracker.edit");
        gridData = new GridData();
        gridData.widthHint = 100;
        this.btnEdit.setLayoutData((Object)gridData);
        this.btnEdit.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int selection = MultiTrackerPanel.this.configList.getSelectionIndex();
                String selected = MultiTrackerPanel.this.configList.getItem(selection);
                Map<String, List<List<String>>> multiTrackers = TrackersUtil.getInstance().getMultiTrackers();
                new MultiTrackerEditor(((NewTorrentWizard)MultiTrackerPanel.this.wizard).getWizardWindow(), selected, multiTrackers.get(selected), MultiTrackerPanel.this);
            }
        });
        this.btnDelete = new Button(panel, 8);
        Messages.setLanguageText((Widget)this.btnDelete, "wizard.multitracker.delete");
        gridData = new GridData(128);
        gridData.widthHint = 100;
        this.btnDelete.setLayoutData((Object)gridData);
        this.btnDelete.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int selection = MultiTrackerPanel.this.configList.getSelectionIndex();
                String selected = MultiTrackerPanel.this.configList.getItem(selection);
                TrackersUtil.getInstance().removeMultiTracker(selected);
                MultiTrackerPanel.this.refreshList("");
                MultiTrackerPanel.this.refreshDetails();
                MultiTrackerPanel.this.setEditDeleteEnable();
            }
        });
        Control labelSeparator = Utils.createSkinnedLabelSeparator(panel, 256);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        labelSeparator.setLayoutData((Object)gridData);
        this.configDetails = new Tree(panel, 2048);
        gridData = new GridData(768);
        gridData.heightHint = 150;
        gridData.horizontalSpan = 3;
        this.configDetails.setLayoutData((Object)gridData);
        this.refreshList(((NewTorrentWizard)this.wizard).multiTrackerConfig);
        this.refreshDetails();
        this.setEditDeleteEnable();
    }

    @Override
    public IWizardPanel getNextPanel() {
        if (((NewTorrentWizard)this.wizard).useWebSeed) {
            return new WebSeedPanel((NewTorrentWizard)this.wizard, this);
        }
        return ((NewTorrentWizard)this.wizard).getNextPanelForMode(this);
    }

    @Override
    public boolean isNextEnabled() {
        return true;
    }

    void refreshDetails() {
        this.configDetails.removeAll();
        List trackers = ((NewTorrentWizard)this.wizard).trackers;
        for (List trackerGroup : trackers) {
            TreeItem itemRoot = new TreeItem(this.configDetails, 0);
            Messages.setLanguageText((Widget)itemRoot, "wizard.multitracker.group");
            for (String url : trackerGroup) {
                new TreeItem(itemRoot, 0).setText(url);
            }
            itemRoot.setExpanded(true);
        }
    }

    void setEditDeleteEnable() {
        if (this.configList.getItemCount() > 0) {
            this.btnEdit.setEnabled(true);
            this.btnDelete.setEnabled(true);
        } else {
            this.btnEdit.setEnabled(false);
            this.btnDelete.setEnabled(false);
        }
    }

    public void trackersChanged(String oldName, String newName, List trackers) {
        TrackersUtil util = TrackersUtil.getInstance();
        if (oldName != null && !oldName.equals(newName)) {
            util.removeMultiTracker(oldName);
        }
        util.addMultiTracker(newName, trackers);
        this.refreshList(newName);
        this.refreshDetails();
        this.setEditDeleteEnable();
    }

    private void refreshList(String toBeSelected) {
        Map<String, List<List<String>>> multiTrackers = TrackersUtil.getInstance().getMultiTrackers();
        this.configList.removeAll();
        Iterator<String> iter = multiTrackers.keySet().iterator();
        while (iter.hasNext()) {
            this.configList.add(iter.next());
        }
        int selection = this.configList.indexOf(toBeSelected);
        if (selection != -1) {
            this.configList.select(selection);
        } else if (this.configList.getItemCount() > 0) {
            this.configList.select(0);
        }
        this.updateTrackers();
    }

    private void updateTrackers() {
        String selected;
        int selection = this.configList.getSelectionIndex();
        if (selection == -1) {
            ArrayList group = new ArrayList();
            ArrayList<String> tracker = new ArrayList<String>();
            tracker.add(((NewTorrentWizard)this.wizard).getTrackerURL());
            group.add(tracker);
            ((NewTorrentWizard)this.wizard).trackers = group;
            ((NewTorrentWizard)this.wizard).multiTrackerConfig = "";
            this.setNext();
            return;
        }
        ((NewTorrentWizard)this.wizard).multiTrackerConfig = selected = this.configList.getItem(selection);
        Map<String, List<List<String>>> multiTrackers = TrackersUtil.getInstance().getMultiTrackers();
        ((NewTorrentWizard)this.wizard).trackers = multiTrackers.get(selected);
        this.setNext();
    }

    private void setNext() {
        String trackerUrl = ((NewTorrentWizard)this.wizard).getTrackerURL();
        List groups = ((NewTorrentWizard)this.wizard).trackers;
        for (List trackers : groups) {
            for (String tracker : trackers) {
                if (!trackerUrl.equals(tracker)) continue;
                ((NewTorrentWizard)this.wizard).setNextEnabled(true);
                ((NewTorrentWizard)this.wizard).setErrorMessage("");
                return;
            }
        }
        ((NewTorrentWizard)this.wizard).setNextEnabled(false);
        ((NewTorrentWizard)this.wizard).setErrorMessage(MessageText.getString("wizard.multitracker.noannounce"));
    }
}

