/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.maketorrent;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.torrent.TOTorrentCreator;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.ui.swt.FixedURLTransfer;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.maketorrent.BYOPanel;
import com.biglybt.ui.swt.maketorrent.DirectoryPanel;
import com.biglybt.ui.swt.maketorrent.ModePanel;
import com.biglybt.ui.swt.maketorrent.SingleFilePanel;
import com.biglybt.ui.swt.wizard.AbstractWizardPanel;
import com.biglybt.ui.swt.wizard.IWizardPanel;
import com.biglybt.ui.swt.wizard.Wizard;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class NewTorrentWizard
extends Wizard {
    static final int TT_LOCAL = 1;
    static final int TT_EXTERNAL = 2;
    static final int TT_DECENTRAL = 3;
    static final String TT_EXTERNAL_DEFAULT = "http://";
    static final String TT_DECENTRAL_DEFAULT = TorrentUtils.getDecentralisedEmptyURL().toString();
    private static String default_open_dir = COConfigurationManager.getStringParameter("CreateTorrent.default.open", "");
    private static String default_save_dir = COConfigurationManager.getStringParameter("CreateTorrent.default.save", "");
    private static String comment = COConfigurationManager.getStringParameter("CreateTorrent.default.comment", "");
    private static String source = COConfigurationManager.getStringParameter("CreateTorrent.default.source", "");
    private static int tracker_type = COConfigurationManager.getIntParameter("CreateTorrent.default.trackertype", 1);
    protected static final int MODE_SINGLE_FILE = 1;
    protected static final int MODE_DIRECTORY = 2;
    protected static final int MODE_BYO = 3;
    int create_mode = 3;
    String singlePath = "";
    String directoryPath = "";
    String savePath = "";
    File byo_desc_file;
    Map byo_map;
    private String _trackerURL = "http://";
    boolean computed_piece_size = true;
    long manual_piece_size;
    boolean useMultiTracker = false;
    boolean useWebSeed = false;
    private boolean addOtherHashes = COConfigurationManager.getBooleanParameter("CreateTorrent.default.addhashes", false);
    String multiTrackerConfig = "";
    List trackers = new ArrayList();
    String webSeedConfig = "";
    Map webseeds = new HashMap();
    boolean autoOpen = false;
    boolean autoHost = false;
    boolean forceStart = false;
    String initialTags = COConfigurationManager.getStringParameter("CreateTorrent.default.initialTags", "");
    boolean superseed = false;
    boolean permitDHT = true;
    int torrentVersion = 1;
    TOTorrentCreator creator = null;

    static {
        if (default_save_dir.length() == 0) {
            default_save_dir = COConfigurationManager.getStringParameter("General_sDefaultTorrent_Directory", "");
        }
    }

    public NewTorrentWizard(Display display) {
        super("wizard.maketorrent.title");
        this.cancel.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (NewTorrentWizard.this.creator != null) {
                    NewTorrentWizard.this.creator.cancel();
                }
            }
        });
        this.trackers.add(new ArrayList());
        String tracker = Utils.getLinkFromClipboard(display);
        if (!this.isValidTracker(tracker) && !this.isValidTracker(tracker = this.getLastTrackerUsed())) {
            tracker = TT_EXTERNAL_DEFAULT;
        }
        this.setTrackerURL(tracker);
        ModePanel panel = new ModePanel(this, null);
        this.createDropTarget((Control)this.getWizardWindow());
        this.setFirstPanel(panel);
    }

    protected int getTrackerType() {
        return tracker_type;
    }

    protected void setTrackerType(int type) {
        tracker_type = type;
        COConfigurationManager.setParameter("CreateTorrent.default.trackertype", tracker_type);
    }

    protected String getTrackerURL() {
        return this._trackerURL;
    }

    protected void setTrackerURL(String t) {
        t = t == null ? "" : t.trim();
        this._trackerURL = t;
        if (this.isValidTracker(t)) {
            COConfigurationManager.setParameter("CreateTorrent.tracker.last.used", t);
        }
    }

    protected boolean isValidTracker(String tracker) {
        try {
            URL url = new URL(tracker);
            String host = url.getHost();
            return !host.isEmpty();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected String getLastTrackerUsed() {
        return COConfigurationManager.getStringParameter("CreateTorrent.tracker.last.used", "");
    }

    protected String getDefaultOpenDir() {
        return default_open_dir;
    }

    protected void setDefaultOpenDir(String d) {
        default_open_dir = d;
        COConfigurationManager.setParameter("CreateTorrent.default.open", default_open_dir);
    }

    protected String getDefaultSaveDir() {
        return default_save_dir;
    }

    protected void setDefaultSaveDir(String d) {
        default_save_dir = d;
        COConfigurationManager.setParameter("CreateTorrent.default.save", default_save_dir);
    }

    protected String getInitialTags(boolean save) {
        if (save) {
            COConfigurationManager.setParameter("CreateTorrent.default.initialTags", this.initialTags);
        }
        return this.initialTags;
    }

    protected void setInitialTags(String tags) {
        this.initialTags = tags;
    }

    void setComment(String s) {
        comment = s;
        COConfigurationManager.setParameter("CreateTorrent.default.comment", comment);
    }

    String getComment() {
        return comment;
    }

    void setSource(String s) {
        source = s.trim();
        COConfigurationManager.setParameter("CreateTorrent.default.source", source);
    }

    String getSource() {
        return source;
    }

    private void createDropTarget(Control control) {
        DropTarget dropTarget = new DropTarget(control, 23);
        dropTarget.setTransfer(new Transfer[]{FixedURLTransfer.getInstance(), FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event2) {
                if (FixedURLTransfer.getInstance().isSupportedType(event2.currentDataType)) {
                    event2.detail = NewTorrentWizard.this.getCurrentPanel() instanceof ModePanel ? 4 : 0;
                }
            }

            public void drop(DropTargetEvent event2) {
                if (event2.data instanceof String[]) {
                    String[] sourceNames = (String[])event2.data;
                    if (sourceNames == null) {
                        event2.detail = 0;
                    }
                    if (event2.detail == 0) {
                        return;
                    }
                    String[] stringArray = sourceNames;
                    int n = sourceNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String droppedFileStr = stringArray[n2];
                        File droppedFile = new File(droppedFileStr);
                        if (NewTorrentWizard.this.getCurrentPanel() instanceof ModePanel) break;
                        if (NewTorrentWizard.this.getCurrentPanel() instanceof DirectoryPanel) {
                            if (droppedFile.isDirectory()) {
                                ((DirectoryPanel)NewTorrentWizard.this.getCurrentPanel()).setFilename(droppedFile.getAbsolutePath());
                            }
                        } else if (NewTorrentWizard.this.getCurrentPanel() instanceof SingleFilePanel) {
                            if (droppedFile.isFile()) {
                                ((SingleFilePanel)NewTorrentWizard.this.getCurrentPanel()).setFilename(droppedFile.getAbsolutePath());
                            }
                        } else if (NewTorrentWizard.this.getCurrentPanel() instanceof BYOPanel) {
                            ((BYOPanel)NewTorrentWizard.this.getCurrentPanel()).addFilename(droppedFile);
                            ++n2;
                            continue;
                        }
                        break;
                    }
                } else if (NewTorrentWizard.this.getCurrentPanel() instanceof ModePanel) {
                    NewTorrentWizard.this.setTrackerURL(((FixedURLTransfer.URLType)event2.data).linkURL);
                    ((ModePanel)NewTorrentWizard.this.getCurrentPanel()).updateTrackerURL();
                }
            }
        });
    }

    protected void setPieceSizeComputed() {
        this.computed_piece_size = true;
    }

    public boolean getPieceSizeComputed() {
        return this.computed_piece_size;
    }

    protected void setPieceSizeManual(long _value) {
        this.computed_piece_size = false;
        this.manual_piece_size = _value;
    }

    protected long getPieceSizeManual() {
        return this.manual_piece_size;
    }

    protected void setAddOtherHashes(boolean o) {
        this.addOtherHashes = o;
        COConfigurationManager.setParameter("CreateTorrent.default.addhashes", this.addOtherHashes);
    }

    protected boolean getPrivateTorrent() {
        return COConfigurationManager.getBooleanParameter("CreateTorrent.default.privatetorrent", false);
    }

    protected void setPrivateTorrent(boolean privateTorrent) {
        COConfigurationManager.setParameter("CreateTorrent.default.privatetorrent", privateTorrent);
    }

    protected boolean getAddOtherHashes() {
        return this.addOtherHashes;
    }

    protected IWizardPanel<NewTorrentWizard> getNextPanelForMode(AbstractWizardPanel<NewTorrentWizard> prev) {
        return new BYOPanel(this, (IWizardPanel<NewTorrentWizard>)prev);
    }
}

