/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.mdi;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.UIManagerListener;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.ui.config.ConfigSectionHolder;
import com.biglybt.pifimpl.local.ui.config.ConfigSectionRepository;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.common.util.MenuItemManager;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MdiEntryCreationListener;
import com.biglybt.ui.mdi.MdiEntryCreationListener2;
import com.biglybt.ui.mdi.MdiEntryLoadedListener;
import com.biglybt.ui.mdi.MdiListener;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mdi.BaseMdiEntry;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.mdi.MdiSWTMenuHackListener;
import com.biglybt.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.biglybt.ui.swt.pif.PluginUISWTSkinObject;
import com.biglybt.ui.swt.pif.UISWTInstance;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewBuilder;
import com.biglybt.ui.swt.pif.UISWTViewEventListener;
import com.biglybt.ui.swt.pifimpl.UISWTInstanceImpl;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.views.ViewManagerSWT;
import com.biglybt.ui.swt.views.skin.SkinView;
import com.biglybt.util.DataSourceUtils;
import com.biglybt.util.MapUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public abstract class BaseMDI
extends SkinView
implements MultipleDocumentInterfaceSWT,
UIUpdatable {
    public static final String CLOSEABLECONFIG_INITIALID = "InitialID";
    private final Class<?> pluginDataSourceType;
    private final String viewID;
    private final UISWTView parentView;
    private MdiEntrySWT currentEntry;
    private Map<String, MdiEntryCreationListener> mapIdToCreationListener = new LightHashMap<String, MdiEntryCreationListener>();
    private Map<String, MdiEntryCreationListener2> mapIdToCreationListener2 = new LightHashMap<String, MdiEntryCreationListener2>();
    private final Map<String, BaseMdiEntry> mapIdToEntry = new HashMap<String, BaseMdiEntry>(8);
    private final List<MdiListener> listeners = new ArrayList<MdiListener>();
    private final List<MdiEntryLoadedListener> listLoadListeners = new ArrayList<MdiEntryLoadedListener>();
    private List<MdiSWTMenuHackListener> listMenuHackListners;
    private final Object autoOpenLock = new Object();
    public static final String AUTOOPENINFO_TITLE = "title";
    public static final String AUTOOPENINFO_DS = "datasource";
    public static final String AUTOOPENINFO_PARENTID = "parentID";
    private LinkedHashMap<String, Map> mapAutoOpen = new LinkedHashMap();
    private volatile boolean mapAutoOpenLoaded = false;
    private TimerEvent autoOpenSaver;
    private String[] preferredOrder;
    private String closeableConfigFile = null;
    private UISWTInstanceImpl.SWTViewListener swtViewListener;
    private volatile boolean initialized;
    private volatile boolean closed;
    private String lastValidViewID = null;
    private String initialID;
    private volatile String initialDef;

    public BaseMDI(Class<?> pluginDataSourceType, String viewID, UISWTView parentView) {
        this.pluginDataSourceType = pluginDataSourceType;
        this.viewID = viewID;
        this.parentView = parentView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiListener l) {
        List<MdiListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(l)) {
                return;
            }
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiListener l) {
        List<MdiListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiEntryLoadedListener l) {
        MdiEntrySWT[] entries;
        List<MdiEntryLoadedListener> list = this.listLoadListeners;
        synchronized (list) {
            if (this.listLoadListeners.contains(l)) {
                return;
            }
            this.listLoadListeners.add(l);
        }
        MdiEntrySWT[] mdiEntrySWTArray = entries = this.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            MdiEntrySWT entry = mdiEntrySWTArray[n2];
            l.mdiEntryLoaded(entry);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiEntryLoadedListener l) {
        List<MdiEntryLoadedListener> list = this.listLoadListeners;
        synchronized (list) {
            this.listLoadListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerSelectionListener(MdiEntry newEntry, MdiEntry oldEntry) {
        MdiListener[] array;
        List<MdiListener> list = this.listeners;
        synchronized (list) {
            array = this.listeners.toArray(new MdiListener[0]);
        }
        MdiListener[] mdiListenerArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            MdiListener l = mdiListenerArray[n2];
            try {
                l.mdiEntrySelected(newEntry, oldEntry);
            }
            catch (Exception e) {
                Debug.out(e);
            }
            ++n2;
        }
        this.itemSelected(newEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerEntryLoadedListeners(MdiEntry entry) {
        MdiEntryLoadedListener[] array;
        List<MdiEntryLoadedListener> list = this.listLoadListeners;
        synchronized (list) {
            array = this.listLoadListeners.toArray(new MdiEntryLoadedListener[0]);
        }
        MdiEntryLoadedListener[] mdiEntryLoadedListenerArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            MdiEntryLoadedListener l = mdiEntryLoadedListenerArray[n2];
            try {
                l.mdiEntryLoaded(entry);
            }
            catch (Exception e) {
                Debug.out(e);
            }
            ++n2;
        }
    }

    @Override
    public final void closeEntry(String id) {
        this.closeEntryByID(id);
    }

    @Override
    public final BaseMdiEntry closeEntry(MdiEntry entry, boolean userInitiated) {
        if (entry == null) {
            return null;
        }
        if (entry instanceof BaseMdiEntry && !((BaseMdiEntry)entry).canClose(userInitiated)) {
            return null;
        }
        return this.closeEntryByID(entry.getViewID(), userInitiated);
    }

    @Override
    public BaseMdiEntry closeEntryByID(String id) {
        return this.closeEntryByID(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseMdiEntry closeEntryByID(String id, boolean userInitiated) {
        BaseMdiEntry removedItem;
        if (Utils.isDisplayDisposed()) {
            return null;
        }
        Map<String, BaseMdiEntry> map = this.mapIdToEntry;
        synchronized (map) {
            removedItem = this.mapIdToEntry.remove(id);
        }
        this.removeEntryAutoOpen(id);
        if (removedItem == null) {
            return null;
        }
        if (this.currentEntry == removedItem) {
            this.setSelectedEntry(null);
        }
        removedItem.closeView(userInitiated);
        return removedItem;
    }

    public String getMenuIdPrefix() {
        return "sidebar.";
    }

    @Override
    public final MdiEntry createEntryFromEventListener(final String parentID, final UISWTViewEventListener l, final String id, boolean closeable, Object datasource, String preferedAfterID) {
        UISWTViewBuilderCore builder = new UISWTViewBuilderCore(id, null).setInitialDatasource(datasource).setListenerInstantiator(new UISWTViewBuilder.UISWTViewEventListenerInstantiator(){

            @Override
            public boolean supportsMultipleViews() {
                return false;
            }

            @Override
            public UISWTViewEventListener createNewInstance(UISWTViewBuilder Builder2, UISWTView forView) throws Exception {
                return l;
            }

            @Override
            public String getUID() {
                return String.valueOf(parentID) + "::" + id;
            }
        }).setParentEntryID(parentID);
        return this.createEntry(builder, closeable);
    }

    @Override
    public abstract MdiEntry createEntryFromSkinRef(String var1, String var2, String var3, String var4, ViewTitleInfo var5, Object var6, boolean var7, String var8);

    @Override
    public MdiEntrySWT getSelectedEntry() {
        if (this.isDisposed()) {
            return null;
        }
        return this.currentEntry;
    }

    protected void setSelectedEntry(MdiEntrySWT entry) {
        this.currentEntry = entry;
        if (this.currentEntry != null) {
            this.lastValidViewID = this.currentEntry.getViewID();
        }
    }

    @Override
    public MdiEntrySWT[] getEntries() {
        return (MdiEntrySWT[])this.getEntries(new MdiEntrySWT[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends MdiEntry> T[] getEntries(T[] array) {
        Map<String, BaseMdiEntry> map = this.mapIdToEntry;
        synchronized (map) {
            return (MdiEntry[])this.mapIdToEntry.values().toArray(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MdiEntrySWT getEntry(String id) {
        Map<String, BaseMdiEntry> map = this.mapIdToEntry;
        synchronized (map) {
            return this.mapIdToEntry.get(id);
        }
    }

    @Override
    public MdiEntry getEntry(String id, Object datasource) {
        String hash;
        if (datasource != null && (hash = DataSourceUtils.getHash(datasource)) != null) {
            return this.getEntry(String.valueOf(id) + "_" + hash);
        }
        return this.getEntry(id);
    }

    @Override
    public MdiEntrySWT getEntryBySkinView(Object skinView) {
        SWTSkinObject so = ((SkinView)skinView).getMainSkinObject();
        BaseMdiEntry[] sideBarEntries = (BaseMdiEntry[])this.getEntries(new BaseMdiEntry[0]);
        int i = 0;
        while (i < sideBarEntries.length) {
            SWTSkinObject entrySOParent;
            BaseMdiEntry entry = sideBarEntries[i];
            SWTSkinObject entrySO = entry.getSkinObject();
            SWTSkinObject sWTSkinObject = entrySOParent = entrySO == null ? entrySO : entrySO.getParent();
            if (entrySO == so || entrySO == so.getParent() || entrySOParent == so) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getUpdateUIName() {
        if (this.currentEntry == null) {
            return "MDI";
        }
        return this.currentEntry.getViewID();
    }

    @Override
    public void registerEntry(String id, MdiEntryCreationListener2 l) {
        if (this.mapIdToCreationListener.containsKey(id)) {
            System.err.println("Warning: MDIEntry " + id + " Creation Listener being registered twice. " + Debug.getCompressedStackTrace());
        }
        this.mapIdToCreationListener2.put(id, l);
        this.createIfAutoOpen(id);
    }

    @Override
    public void deregisterEntry(String id, MdiEntryCreationListener2 l) {
        MdiEntryCreationListener2 l2 = this.mapIdToCreationListener2.get(id);
        if (l == l2) {
            this.mapIdToCreationListener2.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createIfAutoOpen(String id) {
        String[] autoOpenIDs;
        Map autoOpenInfo;
        Object object = this.autoOpenLock;
        synchronized (object) {
            autoOpenInfo = this.mapAutoOpen.get(id);
        }
        if (autoOpenInfo != null) {
            return this.createEntryByCreationListener(id, autoOpenInfo) != null;
        }
        boolean created = false;
        Object object2 = this.autoOpenLock;
        synchronized (object2) {
            autoOpenIDs = this.mapAutoOpen.keySet().toArray(new String[0]);
        }
        String[] stringArray = autoOpenIDs;
        int n = autoOpenIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String autoOpenID = stringArray[n2];
            if (Pattern.matches(id, autoOpenID)) {
                Object object3 = this.autoOpenLock;
                synchronized (object3) {
                    autoOpenInfo = this.mapAutoOpen.get(autoOpenID);
                }
                created |= this.createEntryByCreationListener(autoOpenID, autoOpenInfo) != null;
            }
            ++n2;
        }
        return created;
    }

    private boolean canCreateEntryByCreationListener(String id) {
        MdiEntryCreationListener mdiEntryCreationListener = null;
        for (String key : this.mapIdToCreationListener.keySet()) {
            if (!Pattern.matches(key, id)) continue;
            mdiEntryCreationListener = this.mapIdToCreationListener.get(key);
            break;
        }
        if (mdiEntryCreationListener != null) {
            return true;
        }
        MdiEntryCreationListener2 mdiEntryCreationListener2 = null;
        for (String key : this.mapIdToCreationListener2.keySet()) {
            if (!Pattern.matches(key, id)) continue;
            mdiEntryCreationListener2 = this.mapIdToCreationListener2.get(key);
            break;
        }
        return mdiEntryCreationListener2 != null;
    }

    protected MdiEntry createEntryByCreationListener(String id, Map<?, ?> autoOpenInfo) {
        Object ds = autoOpenInfo == null ? null : autoOpenInfo.get(AUTOOPENINFO_DS);
        MdiEntryCreationListener mdiEntryCreationListener = null;
        for (String key : this.mapIdToCreationListener.keySet()) {
            if (!Pattern.matches(key, id)) continue;
            mdiEntryCreationListener = this.mapIdToCreationListener.get(key);
            break;
        }
        if (mdiEntryCreationListener != null) {
            try {
                MdiEntry mdiEntry = mdiEntryCreationListener.createMDiEntry(id);
                if (mdiEntry != null && ds != null) {
                    mdiEntry.setDatasource(ds);
                }
                return mdiEntry;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        MdiEntryCreationListener2 mdiEntryCreationListener2 = null;
        for (String key : this.mapIdToCreationListener2.keySet()) {
            if (!Pattern.matches(key, id)) continue;
            mdiEntryCreationListener2 = this.mapIdToCreationListener2.get(key);
            break;
        }
        if (mdiEntryCreationListener2 != null) {
            try {
                MdiEntry mdiEntry = mdiEntryCreationListener2.createMDiEntry(this, id, ds, autoOpenInfo);
                if (mdiEntry == null) {
                    this.removeEntryAutoOpen(id);
                }
                return mdiEntry;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        this.setEntryAutoOpen(id, autoOpenInfo);
        return null;
    }

    @Override
    public void registerEntry(String id, MdiEntryCreationListener l) {
        if (this.mapIdToCreationListener.containsKey(id) || this.mapIdToCreationListener2.containsKey(id)) {
            System.err.println("Warning: MDIEntry " + id + " Creation Listener being registered twice. " + Debug.getCompressedStackTrace());
        }
        this.mapIdToCreationListener.put(id, l);
        this.createIfAutoOpen(id);
    }

    @Override
    public void deregisterEntry(String id, MdiEntryCreationListener l) {
        MdiEntryCreationListener l2 = this.mapIdToCreationListener.get(id);
        if (l == l2) {
            this.mapIdToCreationListener.remove(id);
        }
    }

    @Override
    public boolean showEntryByID(String id) {
        return this.loadEntryByID(id, true, false, null);
    }

    public boolean canShowEntryByID(String id) {
        if (id == null) {
            return false;
        }
        if (this.canCreateEntryByCreationListener(id)) {
            return true;
        }
        ViewManagerSWT vi = ViewManagerSWT.getInstance();
        UISWTViewBuilderCore builder = vi.getBuilder(this.viewID, id);
        if (builder == null) {
            builder = vi.getBuilder(this.getDataSourceType(), id);
        }
        return builder != null;
    }

    @Override
    public boolean showEntryByID(String id, Object datasource) {
        return this.loadEntryByID(id, true, false, datasource);
    }

    @Override
    public boolean popoutEntryByID(String id, Object datasource, Map<String, Object> options) {
        MdiEntry existing = this.getEntry(id, datasource);
        if (existing != null) {
            return this.popoutEntry(existing, options);
        }
        MdiEntry entry = this.loadAndGetEntryByID(id, false, false, datasource);
        if (entry != null) {
            try {
                boolean bl = this.popoutEntry(entry, options);
                return bl;
            }
            finally {
                entry.closeView();
            }
        }
        return false;
    }

    public abstract boolean popoutEntry(MdiEntry var1, Map<String, Object> var2);

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        if (this.closeableConfigFile != null) {
            final UIManager ui_manager = PluginInitializer.getDefaultInterface().getUIManager();
            ui_manager.addUIListener(new UIManagerListener(){

                @Override
                public void UIDetached(UIInstance instance) {
                }

                @Override
                public void UIAttached(UIInstance instance) {
                    if (instance instanceof UISWTInstance) {
                        ui_manager.removeUIListener(this);
                        final AESemaphore wait_sem = new AESemaphore("SideBar:wait");
                        Utils.execSWTThread(new AERunnable(){

                            @Override
                            public void runSupport() {
                                try {
                                    try {
                                        BaseMDI.this.loadCloseables();
                                    }
                                    catch (Throwable t) {
                                        Debug.out(t);
                                    }
                                    BaseMDI.this.setupPluginViews();
                                }
                                finally {
                                    BaseMDI.this.initialized = true;
                                    wait_sem.release();
                                }
                            }
                        });
                        if (!wait_sem.reserve(20000L)) {
                            Debug.out("eh?");
                        }
                    }
                }
            });
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        MdiListener[] array;
        super.skinObjectDestroyed(skinObject, params);
        List<MdiListener> list = this.listeners;
        synchronized (list) {
            array = this.listeners.toArray(new MdiListener[0]);
        }
        MdiListener[] mdiListenerArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            MdiListener l = mdiListenerArray[n2];
            try {
                l.mdiDisposed(this);
            }
            catch (Exception e) {
                Debug.out(e);
            }
            ++n2;
        }
        if (this.swtViewListener != null) {
            ViewManagerSWT.getInstance().removeSWTViewListener(this.swtViewListener);
        }
        return null;
    }

    @Override
    public void updateUI() {
        MdiEntrySWT currentEntry = this.getSelectedEntry();
        if (currentEntry != null) {
            currentEntry.updateUI(false);
        }
    }

    @Override
    public boolean loadEntryByID(String id, boolean activate) {
        return this.loadEntryByID(id, activate, false, null);
    }

    @Override
    public boolean loadEntryByID(String id, boolean activate, boolean onlyLoadOnce, Object datasource) {
        return this.loadAndGetEntryByID(id, activate, onlyLoadOnce, datasource) != null;
    }

    private MdiEntry loadAndGetEntryByID(String id, boolean activate, boolean onlyLoadOnce, Object datasource) {
        if (id == null) {
            return null;
        }
        boolean loadedOnce = this.wasEntryLoadedOnce(id);
        if (loadedOnce && onlyLoadOnce) {
            return null;
        }
        MdiEntrySWT entry = this.getEntry(id);
        if (entry != null) {
            if (datasource != null) {
                entry.setDatasource(datasource);
            }
            if (activate) {
                this.showEntry(entry);
            }
            return entry;
        }
        HashMap<String, Object> autoOpenInfo = new HashMap<String, Object>();
        autoOpenInfo.put(AUTOOPENINFO_DS, datasource);
        MdiEntry mdiEntry = this.createEntryByCreationListener(id, autoOpenInfo);
        if (mdiEntry == null) {
            ViewManagerSWT vi = ViewManagerSWT.getInstance();
            UISWTViewBuilderCore builder = vi.getBuilder(this.viewID, id);
            if (builder == null) {
                builder = vi.getBuilder(this.getDataSourceType(), id);
            }
            if (builder != null) {
                builder.setInitialDatasource(datasource);
                mdiEntry = this.createEntry(builder, true);
            }
        }
        if (mdiEntry != null) {
            if (onlyLoadOnce) {
                this.setEntryLoadedOnce(id);
            }
            if (activate) {
                this.showEntry(mdiEntry);
            }
            return mdiEntry;
        }
        return null;
    }

    protected abstract void setEntryLoadedOnce(String var1);

    protected abstract boolean wasEntryLoadedOnce(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean entryExists(String id) {
        Map<String, BaseMdiEntry> map = this.mapIdToEntry;
        synchronized (map) {
            return this.mapIdToEntry.containsKey(id);
        }
    }

    @Override
    public void setDefaultEntryID(String def) {
        this.initialDef = def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEntryAutoOpen(String id, Map autoOpenInfo) {
        Object object = this.autoOpenLock;
        synchronized (object) {
            this.mapAutoOpen.put(id, autoOpenInfo);
            this.autoOpenUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntryAutoOpen(String id) {
        Object object = this.autoOpenLock;
        synchronized (object) {
            this.mapAutoOpen.remove(id);
            this.autoOpenUpdated();
        }
    }

    @Override
    public boolean willEntryAutoOpen(String id) {
        return this.mapAutoOpen.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoOpenUpdated() {
        if (this.closed || !this.initialized) {
            return;
        }
        Object object = this.autoOpenLock;
        synchronized (object) {
            if (this.autoOpenSaver != null) {
                return;
            }
            this.autoOpenSaver = SimpleTimer.addEvent("autoopensaver", SystemTime.getOffsetTime(60000L), ev -> {
                Object object = this.autoOpenLock;
                synchronized (object) {
                    this.autoOpenSaver = null;
                }
                this.saveCloseables(true);
            });
        }
    }

    protected void setupPluginViews() {
        this.swtViewListener = (forDSTypeOrViewID, builder) -> {
            Map o;
            if (forDSTypeOrViewID != null && !forDSTypeOrViewID.equals("Main")) {
                return;
            }
            Object object = this.autoOpenLock;
            synchronized (object) {
                o = this.mapAutoOpen.get(builder.getViewID());
            }
            if (o instanceof Map) {
                this.processAutoOpenMap(builder.getViewID(), o, builder);
            }
        };
        ViewManagerSWT.getInstance().addSWTViewListener(this.swtViewListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCloseables() {
        if (this.closeableConfigFile == null) {
            return;
        }
        try {
            Map loadedMap = FileUtil.readResilientConfigFile(this.closeableConfigFile, true);
            if (loadedMap.isEmpty()) {
                return;
            }
            try {
                BDecoder.decodeStrings(loadedMap);
                List orderedEntries = (List)loadedMap.get("_entries_");
                if (orderedEntries == null) {
                    for (String id : loadedMap.keySet()) {
                        Map autoOpenInfo;
                        Object o = loadedMap.get(id);
                        if (!(o instanceof Map) || this.processAutoOpenMap(id, autoOpenInfo = (Map)o, null)) continue;
                        Object object = this.autoOpenLock;
                        synchronized (object) {
                            this.mapAutoOpen.put(id, autoOpenInfo);
                        }
                    }
                } else {
                    String sas = this.getShowIDAtStartup();
                    this.initialID = sas != null && !sas.isEmpty() ? sas : MapUtils.getMapString(loadedMap, CLOSEABLECONFIG_INITIALID, null);
                    if (this.initialID == null) {
                        String legacyStartTab = COConfigurationManager.getStringParameter("v3.StartTab", null);
                        if (legacyStartTab != null) {
                            this.initialID = legacyStartTab;
                            COConfigurationManager.removeParameter("v3.StartTab");
                        } else {
                            this.initialID = this.initialDef;
                        }
                    }
                    for (Map map : orderedEntries) {
                        Map autoOpenInfo;
                        String id = (String)map.get("id");
                        Object o = map.get("value");
                        if (!(o instanceof Map) || this.processAutoOpenMap(id, autoOpenInfo = (Map)o, null)) continue;
                        Object object = this.autoOpenLock;
                        synchronized (object) {
                            this.mapAutoOpen.put(id, autoOpenInfo);
                        }
                    }
                    if (this.currentEntry == null && (this.getEntry(this.initialID) != null || this.initialDef != null)) {
                        SimpleTimer.addEvent("ShowDefEntry", SystemTime.getOffsetTime(3000L), event2 -> {
                            if (this.currentEntry == null) {
                                if (this.getEntry(this.initialID) != null) {
                                    this.showEntryByID(this.initialID);
                                } else if (this.initialDef != null) {
                                    this.showEntryByID(this.initialDef);
                                }
                            }
                        });
                    }
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        finally {
            this.mapAutoOpenLoaded = true;
        }
    }

    protected String getShowIDAtStartup() {
        return null;
    }

    protected void saveCloseables() {
        this.saveCloseables(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCloseables(boolean interim) {
        if (this.closeableConfigFile == null) {
            return;
        }
        Object object = this.autoOpenLock;
        synchronized (object) {
            if (!this.mapAutoOpenLoaded) {
                return;
            }
            if (!this.initialized) {
                return;
            }
            try {
                if (this.closed) {
                    return;
                }
                if (!interim) {
                    this.closed = true;
                    for (String id : new ArrayList<String>(this.mapAutoOpen.keySet())) {
                        MdiEntrySWT mdiEntrySWT = this.getEntry(id);
                        if (mdiEntrySWT != null) {
                            this.mapAutoOpen.put(id, mdiEntrySWT.getAutoOpenInfo());
                            continue;
                        }
                        this.mapAutoOpen.remove(id);
                    }
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(CLOSEABLECONFIG_INITIALID, this.lastValidViewID);
                ArrayList list = new ArrayList(this.mapAutoOpen.size());
                map.put("_entries_", list);
                for (Map.Entry<String, Map> entry : this.mapAutoOpen.entrySet()) {
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    list.add(m);
                    String id = entry.getKey();
                    m.put("id", id);
                    m.put("value", entry.getValue());
                }
                FileUtil.writeResilientConfigFile(this.closeableConfigFile, map);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    private boolean processAutoOpenMap(String id, Map<?, ?> autoOpenInfo, UISWTViewBuilderCore builder) {
        MdiEntry entry;
        block10: {
            try {
                entry = this.getEntry(id);
                if (entry == null) break block10;
                return true;
            }
            catch (Throwable e) {
                Debug.out(e);
                return false;
            }
        }
        String title = MapUtils.getMapString(autoOpenInfo, AUTOOPENINFO_TITLE, "");
        Object datasource = autoOpenInfo.get(AUTOOPENINFO_DS);
        entry = this.createEntryByCreationListener(id, autoOpenInfo);
        if (entry != null && !title.isEmpty()) {
            entry.setTitle(title);
        }
        if (entry == null && builder != null && (entry = this.createEntry(builder, true)) != null) {
            if (!title.isEmpty()) {
                entry.setTitle(title);
            }
            entry.setDatasource(datasource);
        }
        if (entry != null && datasource == null) {
            final MdiEntry fEntry = entry;
            final String dmHash = MapUtils.getMapString(autoOpenInfo, "dm", null);
            if (dmHash != null) {
                CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                    @Override
                    public void coreRunning(Core core) {
                        HashWrapper hw;
                        GlobalManager gm = core.getGlobalManager();
                        DownloadManager dm = gm.getDownloadManager(hw = new HashWrapper(Base32.decode(dmHash)));
                        if (dm != null) {
                            fEntry.setDatasource(dm);
                        }
                    }
                });
            } else {
                final List listHashes = MapUtils.getMapList(autoOpenInfo, "dms", null);
                if (listHashes != null) {
                    CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                        @Override
                        public void coreRunning(Core core) {
                            ArrayList<DownloadManager> listDMS = new ArrayList<DownloadManager>(1);
                            GlobalManager gm = core.getGlobalManager();
                            for (Object oDM : listHashes) {
                                String hash;
                                DownloadManager dm;
                                if (oDM instanceof String && (dm = gm.getDownloadManager(new HashWrapper(Base32.decode(hash = (String)oDM)))) != null) {
                                    listDMS.add(dm);
                                }
                                fEntry.setDatasource(listDMS.toArray(new DownloadManager[0]));
                            }
                        }
                    });
                }
            }
        }
        return entry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(BaseMdiEntry entry) {
        String id = entry.getViewID();
        Map<String, BaseMdiEntry> map = this.mapIdToEntry;
        synchronized (map) {
            MdiEntry old = this.mapIdToEntry.put(id, entry);
            if (old != null && old != entry) {
                Debug.out("MDI entry " + id + " already added");
            }
        }
        this.setEntryAutoOpen(id, entry.getAutoOpenInfo());
        if (this.currentEntry == null && id.equals(this.initialID)) {
            this.showEntryByID(this.initialID);
        }
    }

    protected void itemSelected(MdiEntry entry) {
    }

    @Override
    public void removeItem(MdiEntry entry) {
        this.removeItem(entry, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeItem(MdiEntry entry, boolean removeChildren) {
        String id = entry.getViewID();
        Map<String, BaseMdiEntry> map = this.mapIdToEntry;
        synchronized (map) {
            this.mapIdToEntry.remove(id);
            if (removeChildren) {
                this.removeChildrenOf(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChildrenOf(String id) {
        if (id == null) {
            return;
        }
        Map<String, BaseMdiEntry> map = this.mapIdToEntry;
        synchronized (map) {
            MdiEntrySWT[] entriesSWT;
            MdiEntrySWT[] mdiEntrySWTArray = entriesSWT = this.getEntries();
            int n = entriesSWT.length;
            int n2 = 0;
            while (n2 < n) {
                MdiEntrySWT entry = mdiEntrySWTArray[n2];
                if (id.equals(entry.getParentID())) {
                    String kid_id = entry.getViewID();
                    this.mapIdToEntry.remove(kid_id);
                    this.removeChildrenOf(kid_id);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MdiEntry> getChildrenOf(String id) {
        if (id == null) {
            return Collections.emptyList();
        }
        ArrayList<MdiEntry> list = new ArrayList<MdiEntry>(1);
        Map<String, BaseMdiEntry> map = this.mapIdToEntry;
        synchronized (map) {
            MdiEntrySWT[] entriesSWT;
            MdiEntrySWT[] mdiEntrySWTArray = entriesSWT = this.getEntries();
            int n = entriesSWT.length;
            int n2 = 0;
            while (n2 < n) {
                MdiEntrySWT entry = mdiEntrySWTArray[n2];
                if (id.equals(entry.getParentID())) {
                    list.add(entry);
                }
                ++n2;
            }
        }
        return list;
    }

    @Override
    public Object updateLanguage(SWTSkinObject skinObject, Object params) {
        MdiEntrySWT[] entries;
        MdiEntrySWT[] mdiEntrySWTArray = entries = this.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            MdiEntrySWT entry = mdiEntrySWTArray[n2];
            if (entry instanceof BaseMdiEntry) {
                BaseMdiEntry baseEntry = (BaseMdiEntry)entry;
                baseEntry.updateLanguage();
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void setPreferredOrder(String[] preferredOrder) {
        this.preferredOrder = preferredOrder;
    }

    @Override
    public String[] getPreferredOrder() {
        return this.preferredOrder == null ? new String[]{} : this.preferredOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEntriesCount() {
        Map<String, BaseMdiEntry> map = this.mapIdToEntry;
        synchronized (map) {
            return this.mapIdToEntry.size();
        }
    }

    @Override
    public void setCloseableConfigFile(String closeableConfigFile) {
        this.closeableConfigFile = closeableConfigFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(MdiSWTMenuHackListener l) {
        BaseMDI baseMDI = this;
        synchronized (baseMDI) {
            if (this.listMenuHackListners == null) {
                this.listMenuHackListners = new ArrayList<MdiSWTMenuHackListener>(1);
            }
            if (!this.listMenuHackListners.contains(l)) {
                this.listMenuHackListners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(MdiSWTMenuHackListener l) {
        BaseMDI baseMDI = this;
        synchronized (baseMDI) {
            if (this.listMenuHackListners == null) {
                this.listMenuHackListners = new ArrayList<MdiSWTMenuHackListener>(1);
            }
            this.listMenuHackListners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdiSWTMenuHackListener[] getMenuHackListeners() {
        BaseMDI baseMDI = this;
        synchronized (baseMDI) {
            if (this.listMenuHackListners == null) {
                return new MdiSWTMenuHackListener[0];
            }
            return this.listMenuHackListners.toArray(new MdiSWTMenuHackListener[0]);
        }
    }

    public void fillMenu(Menu menu, MdiEntry entry, String menuID) {
        if (entry != null) {
            MdiSWTMenuHackListener l;
            MdiSWTMenuHackListener[] menuHackListeners;
            MdiSWTMenuHackListener[] mdiSWTMenuHackListenerArray = menuHackListeners = this.getMenuHackListeners();
            int n = menuHackListeners.length;
            int n2 = 0;
            while (n2 < n) {
                l = mdiSWTMenuHackListenerArray[n2];
                try {
                    l.menuWillBeShown(entry, menu);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                ++n2;
            }
            if (entry instanceof BaseMdiEntry) {
                mdiSWTMenuHackListenerArray = menuHackListeners = ((BaseMdiEntry)entry).getMenuHackListeners();
                n = menuHackListeners.length;
                n2 = 0;
                while (n2 < n) {
                    l = mdiSWTMenuHackListenerArray[n2];
                    try {
                        l.menuWillBeShown(entry, menu);
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                    ++n2;
                }
            }
        }
        MenuItem[] menu_items = MenuItemManager.getInstance().getAllAsArray(menuID);
        MenuBuildUtils.addPluginMenuItems(menu_items, menu, false, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(new Object[]{entry}));
        if (entry != null) {
            PluginInterface pi;
            menu_items = MenuItemManager.getInstance().getAllAsArray(String.valueOf(this.getMenuIdPrefix()) + entry.getViewID());
            if (menu_items.length == 0 && entry instanceof UISWTView && (pi = ((UISWTView)((Object)entry)).getPluginInterface()) != null && pi != pi.getPluginManager().getDefaultPluginInterface()) {
                final ArrayList<String> relevant_sections = new ArrayList<String>();
                ArrayList<ConfigSectionHolder> sections = ConfigSectionRepository.getInstance().getHolderList();
                for (ConfigSectionHolder cs : sections) {
                    if (pi != cs.getPluginInterface()) continue;
                    relevant_sections.add(cs.getConfigSectionID());
                }
                if (relevant_sections.size() > 0) {
                    MenuItem mi = pi.getUIManager().getMenuManager().addMenuItem(String.valueOf(this.getMenuIdPrefix()) + entry.getViewID(), "MainWindow.menu.view.configuration");
                    mi.setDisposeWithUIDetach("swt");
                    mi.addListener(new MenuItemListener(){

                        @Override
                        public void selected(MenuItem menu, Object target) {
                            UIFunctions uif = UIFunctionsManager.getUIFunctions();
                            if (uif != null) {
                                for (String s : relevant_sections) {
                                    uif.getMDI().showEntryByID("ConfigView", s);
                                }
                            }
                        }
                    });
                    menu_items = MenuItemManager.getInstance().getAllAsArray(String.valueOf(this.getMenuIdPrefix()) + entry.getViewID());
                }
            }
            MenuBuildUtils.addPluginMenuItems(menu_items, menu, false, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(new Object[]{entry}));
        }
        if ((menu_items = MenuItemManager.getInstance().getAllAsArray(String.valueOf(menuID) + "._end_")).length > 0) {
            MenuBuildUtils.addPluginMenuItems(menu_items, menu, false, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(new Object[]{entry}));
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public static BaseMdiEntry getEntryFromSkinObject(PluginUISWTSkinObject pluginSkinObject) {
        if (pluginSkinObject instanceof SWTSkinObject) {
            Control control = ((SWTSkinObject)pluginSkinObject).getControl();
            while (control != null && !control.isDisposed()) {
                Object entry = control.getData("BaseMDIEntry");
                if (entry instanceof BaseMdiEntry) {
                    BaseMdiEntry mdiEntry = (BaseMdiEntry)entry;
                    return mdiEntry;
                }
                control = control.getParent();
            }
        }
        return null;
    }

    public UISWTView getParentView() {
        return this.parentView;
    }

    @Override
    public String getViewID() {
        return this.viewID;
    }

    @Override
    public Class getDataSourceType() {
        return this.pluginDataSourceType;
    }
}

