/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.networks;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AENetworkClassifierListener;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SWTNetworkSelection
implements AENetworkClassifierListener {
    public SWTNetworkSelection() {
        AENetworkClassifier.addListener(this);
    }

    @Override
    public String[] selectNetworks(final String description, final String[] tracker_networks) {
        final Display display = Utils.getDisplay();
        if (display.isDisposed()) {
            return null;
        }
        final AESemaphore sem = new AESemaphore("NetworkClassifier");
        final classifierDialog[] dialog = new classifierDialog[1];
        try {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    dialog[0] = new classifierDialog(sem, display, description, tracker_networks);
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
        sem.reserve();
        return dialog[0].getSelection();
    }

    protected static class classifierDialog {
        protected Shell shell;
        protected AESemaphore sem;
        protected String[] selection;
        private Button[] checkboxes;

        protected classifierDialog(AESemaphore _sem, Display display, String description, String[] tracker_networks) {
            this.sem = _sem;
            if (display.isDisposed()) {
                this.sem.releaseForever();
                return;
            }
            this.shell = ShellFactory.createMainShell(67680);
            Utils.setShellIcon(this.shell);
            this.shell.setText(MessageText.getString("window.networkselection.title"));
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            this.shell.setLayout((Layout)layout);
            Label info_label = new Label((Composite)this.shell, 0);
            info_label.setText(MessageText.getString("window.networkselection.info"));
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 3;
            info_label.setLayoutData((Object)gridData);
            Control labelSeparator = Utils.createSkinnedLabelSeparator((Composite)this.shell, 256);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            labelSeparator.setLayoutData((Object)gridData);
            Label desc_label = new Label((Composite)this.shell, 0);
            desc_label.setText(MessageText.getString("window.networkselection.description"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            desc_label.setLayoutData((Object)gridData);
            Label desc_value = new Label((Composite)this.shell, 0);
            desc_value.setText(description);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            desc_value.setLayoutData((Object)gridData);
            this.checkboxes = new Button[AENetworkClassifier.AT_NETWORKS.length];
            int i = 0;
            while (i < AENetworkClassifier.AT_NETWORKS.length) {
                String network = AENetworkClassifier.AT_NETWORKS[i];
                String msg_text = "ConfigView.section.connection.networks." + network;
                Label label = new Label((Composite)this.shell, 0);
                gridData = new GridData(1808);
                gridData.horizontalSpan = 1;
                label.setLayoutData((Object)gridData);
                Messages.setLanguageText((Widget)label, msg_text);
                Button checkBox = new Button((Composite)this.shell, 32);
                checkBox.setSelection(false);
                gridData = new GridData(1808);
                gridData.horizontalSpan = 2;
                checkBox.setLayoutData((Object)gridData);
                this.checkboxes[i] = checkBox;
                int j = 0;
                while (j < tracker_networks.length) {
                    if (tracker_networks[j] == network) {
                        checkBox.setSelection(true);
                    }
                    ++j;
                }
                ++i;
            }
            labelSeparator = Utils.createSkinnedLabelSeparator((Composite)this.shell, 256);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            labelSeparator.setLayoutData((Object)gridData);
            new Label((Composite)this.shell, 0);
            Button bOk = new Button((Composite)this.shell, 8);
            bOk.setText(MessageText.getString("Button.ok"));
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            bOk.setLayoutData((Object)gridData);
            bOk.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.close(true);
                }
            });
            Button bCancel = new Button((Composite)this.shell, 8);
            bCancel.setText(MessageText.getString("Button.cancel"));
            gridData = new GridData(128);
            gridData.grabExcessHorizontalSpace = false;
            gridData.widthHint = 70;
            bCancel.setLayoutData((Object)gridData);
            bCancel.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.close(false);
                }
            });
            this.shell.setDefaultButton(bOk);
            this.shell.addListener(31, new Listener(){

                public void handleEvent(Event e) {
                    if (e.character == '\u001b') {
                        this.close(false);
                    }
                }
            });
            this.shell.pack();
            Utils.centreWindow(this.shell);
            this.shell.open();
            Utils.readAndDispatchLoop((Control)this.shell);
        }

        protected void close(boolean ok) {
            if (!ok) {
                this.selection = null;
            } else {
                ArrayList<String> l = new ArrayList<String>();
                int i = 0;
                while (i < AENetworkClassifier.AT_NETWORKS.length) {
                    if (this.checkboxes[i].getSelection()) {
                        l.add(AENetworkClassifier.AT_NETWORKS[i]);
                    }
                    ++i;
                }
                this.selection = new String[l.size()];
                l.toArray(this.selection);
            }
            this.shell.dispose();
            this.sem.releaseForever();
        }

        protected String[] getSelection() {
            return this.selection;
        }
    }
}

