/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.pifimpl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.util.AERunnable;
import com.biglybt.pif.ui.components.UIButton;
import com.biglybt.pif.ui.components.UIPropertyChangeEvent;
import com.biglybt.pif.ui.components.UIPropertyChangeListener;
import com.biglybt.pif.ui.model.BasicPluginViewModel;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BasicPluginViewImpl
implements UISWTViewCoreEventListener,
UIPropertyChangeListener {
    BasicPluginViewModel model;
    Display display;
    Composite panel;
    ProgressBar progress;
    BufferedLabel status;
    BufferedLabel task;
    StyledText log;
    Pattern inclusionFilter;
    Pattern exclusionFilter;
    boolean paused;
    boolean isCreated;

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                if (this.isCreated) {
                    return false;
                }
                this.isCreated = true;
                UISWTView swtView = event2.getView();
                if (swtView == null) break;
                this.model = (BasicPluginViewModel)swtView.getInitialDataSource();
                swtView.setTitle(this.model.getName());
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                UISWTView swtView = event2.getView();
                if (swtView == null) break;
                swtView.setTitle(this.model.getName());
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 7: {
                this.delete();
                this.isCreated = false;
                break;
            }
            case 3: {
                String text = this.model.getLogArea().getText().trim();
                if (this.log == null || this.log.isDisposed()) break;
                this.log.setText(text);
                this.log.setTopIndex(this.log.getLineCount());
                break;
            }
            case 4: {
                if (this.log == null || this.log.isDisposed()) break;
                this.log.setText("");
            }
        }
        return true;
    }

    private void initialize(Composite composite) {
        String sConfigSectionID = this.model.getConfigSectionID();
        this.display = composite.getDisplay();
        this.panel = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.panel.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        this.panel.setLayoutData((Object)gridData);
        Composite topSection = new Composite(this.panel, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        topSection.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        if (sConfigSectionID == null) {
            gridData.horizontalSpan = 2;
        }
        topSection.setLayoutData((Object)gridData);
        if (this.model.getStatus().getVisible()) {
            Label statusTitle = new Label(topSection, 0);
            Messages.setLanguageText((Widget)statusTitle, "plugins.basicview.status");
            this.status = new BufferedLabel(topSection, 0);
            gridData = new GridData(768);
            this.status.setLayoutData(gridData);
        }
        if (this.model.getActivity().getVisible()) {
            Label activityTitle = new Label(topSection, 0);
            Messages.setLanguageText((Widget)activityTitle, "plugins.basicview.activity");
            this.task = new BufferedLabel(topSection, 0);
            gridData = new GridData(768);
            this.task.setLayoutData(gridData);
        }
        if (this.model.getProgress().getVisible()) {
            Label progressTitle = new Label(topSection, 0);
            Messages.setLanguageText((Widget)progressTitle, "plugins.basicview.progress");
            this.progress = new ProgressBar(topSection, 0);
            this.progress.setMaximum(100);
            this.progress.setMinimum(0);
            gridData = new GridData(768);
            this.progress.setLayoutData((Object)gridData);
        }
        ArrayList<Button> all_buttons = new ArrayList<Button>();
        List<UIButton> buttons = this.model.getButtons();
        if (!buttons.isEmpty()) {
            for (final UIButton b : buttons) {
                Label buttonTitle = new Label(topSection, 0);
                Messages.setLanguageText((Widget)buttonTitle, b.getLabel());
                Button button = new Button(topSection, 8);
                Messages.setLanguageText((Widget)button, b.getName());
                all_buttons.add(button);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        b.setProperty("selected", true);
                    }
                });
            }
        }
        if (sConfigSectionID != null) {
            Composite configSection = new Composite(this.panel, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 2;
            configSection.setLayout((Layout)gridLayout);
            gridData = new GridData(11);
            configSection.setLayoutData((Object)gridData);
            Button btnConfig = new Button(configSection, 8);
            Messages.setLanguageText((Widget)btnConfig, "plugins.basicview.config");
            btnConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        uiFunctions.getMDI().showEntryByID("ConfigView", BasicPluginViewImpl.this.model.getConfigSectionID());
                    }
                }
            });
            btnConfig.setLayoutData((Object)new GridData());
        }
        if (this.model.getLogArea().getVisible()) {
            Label logTitle = new Label(topSection, 0);
            Messages.setLanguageText((Widget)logTitle, "plugins.basicview.log");
            Button button = new Button(topSection, 8);
            Messages.setLanguageText((Widget)button, "plugins.basicview.clear");
            all_buttons.add(button);
            button.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    BasicPluginViewImpl.this.model.getLogArea().setText("");
                }
            });
            this.log = new StyledText(this.panel, 2824);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            this.log.setLayoutData((Object)gridData);
            ClipboardCopy.addCopyToClipMenu((Control)this.log, new ClipboardCopy.copyToClipProvider(){

                @Override
                public String getText() {
                    return BasicPluginViewImpl.this.log.getText().trim();
                }
            });
            this.log.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event2) {
                    int key = event2.character;
                    if (key <= 26 && key > 0) {
                        key += 96;
                    }
                    if (key == 97 && event2.stateMask == SWT.MOD1) {
                        event2.doit = false;
                        BasicPluginViewImpl.this.log.selectAll();
                    }
                }
            });
            this.model.getLogArea().addPropertyChangeListener(this);
            Composite bottomSection = new Composite(this.panel, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            bottomSection.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            bottomSection.setLayoutData((Object)gridData);
            Label label = new Label(bottomSection, 0);
            label.setLayoutData((Object)new GridData());
            Messages.setLanguageText((Widget)label, "LoggerView.includeOnly");
            final Text inclText = new Text(bottomSection, 2048);
            gridData = new GridData();
            gridData.widthHint = 200;
            inclText.setLayoutData((Object)gridData);
            inclText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String newExpression = inclText.getText();
                    Color bg = null;
                    if (newExpression.length() == 0) {
                        BasicPluginViewImpl.this.inclusionFilter = null;
                    } else {
                        try {
                            BasicPluginViewImpl.this.inclusionFilter = Pattern.compile(newExpression, 66);
                        }
                        catch (PatternSyntaxException e1) {
                            bg = Colors.colorErrorBG;
                        }
                    }
                    Utils.setSkinnedBackground((Control)inclText, bg);
                }
            });
            label = new Label(bottomSection, 0);
            label = new Label(bottomSection, 0);
            label.setLayoutData((Object)new GridData());
            Messages.setLanguageText((Widget)label, "LoggerView.excludeAll");
            final Text exclText = new Text(bottomSection, 2048);
            gridData = new GridData();
            gridData.widthHint = 200;
            exclText.setLayoutData((Object)gridData);
            exclText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String newExpression = exclText.getText();
                    Color bg = null;
                    if (newExpression.length() == 0) {
                        BasicPluginViewImpl.this.exclusionFilter = null;
                    } else {
                        try {
                            BasicPluginViewImpl.this.exclusionFilter = Pattern.compile(newExpression, 66);
                        }
                        catch (PatternSyntaxException e1) {
                            bg = Colors.colorErrorBG;
                        }
                    }
                    Utils.setSkinnedBackground((Control)exclText, bg);
                }
            });
            label = new Label(bottomSection, 0);
            final String config_key = String.valueOf(this.model.getName()) + ".LoggerView.pause";
            final Button buttonPause = new Button(bottomSection, 32);
            Messages.setLanguageText((Widget)buttonPause, "LoggerView.pause");
            gridData = new GridData();
            buttonPause.setLayoutData((Object)gridData);
            buttonPause.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.widget == null || !(e.widget instanceof Button)) {
                        return;
                    }
                    Button btn = (Button)e.widget;
                    boolean sel = btn.getSelection();
                    Object o = BasicPluginViewImpl.this.model.getProperty(1);
                    boolean external_pause_control = false;
                    if (o instanceof Boolean) {
                        external_pause_control = (Boolean)o;
                    }
                    if (!external_pause_control) {
                        BasicPluginViewImpl.this.paused = sel;
                    }
                    COConfigurationManager.setParameter(config_key, sel);
                }
            });
            COConfigurationManager.addAndFireParameterListener(config_key, new ParameterListener(){

                @Override
                public void parameterChanged(String name) {
                    if (buttonPause.isDisposed()) {
                        COConfigurationManager.removeParameterListener(name, this);
                    } else {
                        boolean paused = COConfigurationManager.getBooleanParameter(name, false);
                        buttonPause.setSelection(paused);
                    }
                }
            });
        }
        if (all_buttons.size() > 1) {
            Utils.makeButtonsEqualWidth(all_buttons);
        }
    }

    private void refresh() {
        if (this.status != null) {
            this.status.setText(this.model.getStatus().getText());
        }
        if (this.task != null) {
            this.task.setText(this.model.getActivity().getText());
        }
        if (this.progress != null) {
            this.progress.setSelection(this.model.getProgress().getPercentageComplete());
        }
        if (this.model != null) {
            this.model.getLogArea().refresh();
        }
    }

    @Override
    public void propertyChanged(final UIPropertyChangeEvent ev) {
        if (ev.getSource() != this.model.getLogArea()) {
            return;
        }
        if (this.display == null || this.display.isDisposed() || this.log == null || this.paused) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            @Override
            public void runSupport() {
                if (BasicPluginViewImpl.this.log.isDisposed()) {
                    return;
                }
                if (!BasicPluginViewImpl.this.log.isVisible()) {
                    return;
                }
                String old_value = (String)ev.getOldPropertyValue();
                String new_value = (String)ev.getNewPropertyValue();
                ScrollBar bar = BasicPluginViewImpl.this.log.getVerticalBar();
                boolean max = bar.getSelection() == bar.getMaximum() - bar.getThumb();
                int lineOffset = BasicPluginViewImpl.this.log.getLineCount() - BasicPluginViewImpl.this.log.getTopIndex();
                if (new_value.startsWith(old_value)) {
                    String toAppend = new_value.substring(old_value.length());
                    if (toAppend.length() == 0) {
                        return;
                    }
                    StringBuilder builder = new StringBuilder(toAppend.length());
                    String[] lines = toAppend.split("\n");
                    int i = 0;
                    while (i < lines.length) {
                        String line = lines[i];
                        if (!(BasicPluginViewImpl.this.inclusionFilter != null && !BasicPluginViewImpl.this.inclusionFilter.matcher(line).find() || BasicPluginViewImpl.this.exclusionFilter != null && BasicPluginViewImpl.this.exclusionFilter.matcher(line).find())) {
                            builder.append("\n");
                            builder.append(line);
                        }
                        ++i;
                    }
                    BasicPluginViewImpl.this.log.append(builder.toString());
                } else {
                    StringBuilder builder = new StringBuilder(new_value.length());
                    String[] lines = new_value.split("\n");
                    int i = 0;
                    while (i < lines.length) {
                        String line = lines[i];
                        if (!(BasicPluginViewImpl.this.inclusionFilter != null && !BasicPluginViewImpl.this.inclusionFilter.matcher(line).find() || BasicPluginViewImpl.this.exclusionFilter != null && BasicPluginViewImpl.this.exclusionFilter.matcher(line).find())) {
                            if (line != lines[0]) {
                                builder.append("\n");
                            }
                            builder.append(line);
                        }
                        ++i;
                    }
                    BasicPluginViewImpl.this.log.setText(builder.toString());
                }
                if (max) {
                    bar.setSelection(bar.getMaximum() - bar.getThumb());
                    BasicPluginViewImpl.this.log.setTopIndex(BasicPluginViewImpl.this.log.getLineCount() - lineOffset);
                    BasicPluginViewImpl.this.log.redraw();
                }
            }
        });
    }

    private void delete() {
        this.model.getLogArea().removePropertyChangeListener(this);
    }
}

